(********************************************************

Programm zur messung der geschwindigkeit von modellflugzeugen
anhand des dopplereffekts im motor/fluggrrusch beim vorbeiflug

(C) Bredendiek (sprut) 1998/1999/2000/2006
                              
********************************************************)

(*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *)

unit FFT_d;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, Outline, DirOutln, ExtCtrls, 
  MmSystem, MPlayer, ComCtrls, ToolWin, ImgList, Spin, Math, Gauges;

const
I   = 0;        (*in phase  - cos*)
S   = 0;        (*sinus*)
Q   = 1;        (*quadratur - sin*)
C   = 1;        (*cosinus*)


//max Anzahl der Soundsample
//max 15 Sekunden bei 44kHz
SoundEnde = 700000;

//Voreinstellungen fr die FFT
c_256  = 1024;
c_255  = 1023;
c_7    = 9;
c_8    = 10;
c_9    = 11;


type
  TWAVEosSCOPE = class(TForm)
    OpenDialog1: TOpenDialog;
    PrintDialog1: TPrintDialog;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ImageList1: TImageList;
    ToolButton6: TToolButton;
    StatusBar1: TStatusBar;
    Label1: TLabel;
    MediaPlayer1: TMediaPlayer;
    ToolButton8: TToolButton;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    Image1: TImage;
    KanalRadioGroup: TRadioGroup;
    GenauRadioGroup: TRadioGroup;
    PCheckbox: TCheckBox;
    GrafikRadio: TRadioGroup;
    CFARCheckBox: TCheckBox;
    Timer1: TTimer;
    GroupBox1: TGroupBox;
    LimTrackBar: TTrackBar;
    LimLabel: TLabel;
    GroupBox2: TGroupBox;
    CFARTrackBar: TTrackBar;
    CFARLabel: TLabel;
    GroupBox3: TGroupBox;
    TrackBar1: TTrackBar;
    FFTLabel: TLabel;
    Gauge1: TGauge;
    function ZWEIpower(oben:integer):integer;
    Procedure OpenWavefile;
    procedure FrequenzMarke(XPos:integer;col:Tcolor);
    function Quersumme(zahl:integer):integer;
    procedure FFTinit;
    function Optimum:longint;
    procedure Speed;
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ToolButton8Click(Sender: TObject);
    procedure KanalRadioGroupClick(Sender: TObject);
    procedure GenauRadioGroupClick(Sender: TObject);
    procedure PCheckboxClick(Sender: TObject);
    procedure GrafikRadioClick(Sender: TObject);
    procedure OptimalClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure grafik;
    procedure LimTrackBarChange(Sender: TObject);
    procedure CFARCheckBoxClick(Sender: TObject);
    procedure CFARTrackBarChange(Sender: TObject);
    procedure trigger;
    procedure Timer1Timer(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);

  private
    { Private-Deklarationen }
    Bitmap : TBitmap;
  public
    { Public-Deklarationen }
  end;

  TZeile = array[0..c_255,I..Q] of real;



var
sound     : array[0..1,0..SoundEnde] of byte;  //0-liks, 1-rechts
// a, b zum Rechnen    // T sind sin&cos-Werte   //P phase und Magnitude
a,b,T,P   : TZeile;    // T=sin-cos-tabelle in 1/256-tel
Block     : array[0..250] of TZeile;  // alle FFT-Ergebnisse
filter    : array[0..c_255] of integer;
(*3. frequenzfilternummer*)
F         : array[0..c_255,1..c_8,0..2] of integer;
(*0. zeile: s2;
  1. zeile: 1=negativ, 0=positiv
  2. zeile: phasendreh in 1/256 abstufungen = PI/128*)
ar_re,frequenz  : real;
FFTstep,                       (*1..8 fr aktuellen FFT-Step*)
FFTend,                        (*letzter filter/samplewert -1*)
wide,                          (*schrittweite der addition*)
korr,                          (*korrekturfaktor fuer filter,8-point*)
k,l,m,n,dreh,alt_dreh,qs,
GrafikMode               : integer;
shift,
MaxSample,
SoundStep,
SoundPointer             : longint;
FileEnde                 : boolean;
Kanal                    : integer=0; //0-links, 1-rechts
Mode                     : integer=0; //0-links, 1-rechts, 2-beide
Th                       : integer=20; // laufenbder Threshould fr CFAR

  hscale                 : real = 1;
  vscale                 : real = 1;
  ur                     : integer = 250;  (*unterer Bildrand*)
  lr                     : integer = 10;   (*linker Bildrand*)
  altezeile, neuezeile   : integer;


var
  WAVEosSCOPE    : TWAVEosSCOPE;
  Fname          : string;
  WaveFlag,
  LimitFlag,
  FileFlag,
  OptimumFlag    : Boolean;
  offset         : longint;
  Ton            : file of byte;
  SampleZahl,                (*zahl der Samples in wav-Datei*)
  SampleFrequenz,
  ByteZahl       : longint;  (*zahl der Datenbytes in wav-Datei*)
  Links,                     (*mausklickposition*)
  Rechts,
  FFTtype        : integer;  (*1..10 fr 1..8-point FFT (2..1024)*)

    wname                      : string;
    wlaenge, fmtlaenge         : longint;
    wformat                    : byte;   (* 1=PCM *)
    wms                        : byte;   (* 1=Mono, 2=Stereo *)
    byps                       : longint; (* byte/sekunde *)
    walign                     : byte; (* block-align = bytes/sample *)
    bips                       : byte; (* bit/sample 8/16 *)


implementation



{$R *.DFM}

function SmallFonts : boolean;
var dc : hdc;
begin
  dc:=GetDC(0);
  Result:=(GetDeviceCaps(dc, LOGPIXELSX) =96);
  ReleaseDC(0, DC);
end;

(*==============================================================
 stellt filterergebnis grafisch dar
*)
procedure TWAVEosSCOPE.grafik;(*  b  *)
var
  k, l       : integer;
  ar_i       : longint;
  olp,urp    : TPoint;
  rechteck   : TRect;
begin
  Image1.visible:=true;

  //linien rahmen marken
  if offset=0 then case grafikmode of
  1:begin  (* 3-D Darstellung*)
      Bitmap.canvas.Pen.Color:=clGreen;
      Bitmap.canvas.moveto(lr,ur);
      Bitmap.canvas.lineto(round(lr+512*hscale),ur);
      for k:=0 to 14 do begin
        Bitmap.canvas.moveto(round(lr+k*37*hscale),ur);
        Bitmap.canvas.lineto(round(lr+k*37*hscale+100),round(ur-200*vscale));
      end;
      FrequenzMarke(lr,clBlack);
      FrequenzMarke(round(lr+512*hscale),clBlack);
    end;
  2:begin (* 2-D Darstellung*)
      FrequenzMarke(lr,clBlack);
      FrequenzMarke(round(lr+512*hscale),clBlack);
    end;
  3:begin (* 1-D Darstellung*)
      Gauge1.Visible:=true;
      Gauge1.progress:=0;
    end;
  end; (*offset=0*)

  Bitmap.canvas.Pen.Color:=clBlack;

  if WaveFlag then case grafikmode of
  1:begin (* 3-D Darstellung*)
      k:=0;
      Bitmap.canvas.moveto(round(lr+k*korr*hscale+shift), round(ur-(b[k,i] +shift*2)*vscale));
      for k:=0 to (((FFTend+1) div 2)-2) do
        Bitmap.canvas.lineto(round(lr+(k+1)*korr*hscale+shift), round(ur-(b[k+1,i]+shift*2)*vscale));
    end;
  2:begin  (* 2-D Darstellung*)
      neuezeile:=round(ur-shift*vscale);
      if (shift<>0) and (altezeile-neuezeile>1) then begin
        //zeilenkopieren
        for k:=altezeile-1 downto neuezeile+1 do for l:=lr to round(lr + 512*hscale) do
          Bitmap.canvas.pixels[l,k]:=Bitmap.canvas.pixels[l,k+1];
      end;
      altezeile:=neuezeile;
      (*linker ausgangspunkt*)
      //ein FFT ergebnis wird als aneinanderhngende folge horizontaler Linien ausgegeben
      //dadurch treten keine Lcken auf, wenn weniger Filter als Pixel sind
      //and Funktion mu benutzt werden, bei Kanal=1
      k:=0;
      if kanal=0 then Bitmap.canvas.pen.mode:=pmCopy;
      if kanal=1 then Bitmap.canvas.pen.mode:=pmMask;
      Bitmap.canvas.moveto(round(lr+k*korr*hscale), round(ur-shift*vscale));
      for k:=0 to (((FFTend+1) div 2)-2) do begin
        (*farbe bestimmen*)
        ar_i:=trunc(b[k+1,i]+0.5);
        if ar_i=0 then Bitmap.canvas.pen.color:=$00FFFFFF  //weiss
        else begin
          ar_i:=ar_i shl 7; (* x128*)
          ar_i:=(255-ar_i);
          ar_i:=ar_i and $FF; //rot
          if Kanal=1 then ar_i:=ar_i*256;
          if PCheckBox.checked then ar_i:= round( (sin(P[k+1,q])*127+127) + $100*(cos(P[k+1,q])*127+127) );
          Bitmap.canvas.pen.color:=ar_i;
        end; (*else if*)
        (*zeichnen*)
        Bitmap.canvas.lineto(round(lr+(k+1)*korr*hscale), round(ur-shift*vscale));
      end; (*for*)
      // Bild bertragen alle 25 Zeilen
      if Shift mod 25=0 then begin
        Image1.Canvas.Draw(0,0,Bitmap);
        Image1.Update;
      end;
    end;
  3:begin    (* 1-D Darstellung*)
      olp.x:=0;
      olp.y:=0;
      urp.x:=Bitmap.Width;
      urp.y:=Bitmap.Height;
      Rechteck.TopLeft:=olp;
      Rechteck.BottomRight:=urp;
      Bitmap.canvas.FillRect(Rechteck);
      Bitmap.canvas.Pen.Color:=clBlack;
      k:=0;
      Bitmap.canvas.moveto(round(lr+k*korr*hscale), ur-round(b[k,i]));
      for k:=0 to (((FFTend+1) div 2)-2) do
        Bitmap.canvas.lineto(round(lr+(k+1)*korr*hscale), ur-round(5*b[k+1,i]));
      FrequenzMarke(lr,clBlack);
      FrequenzMarke(round(lr+512*hscale),clBlack);
      gauge1.progress:=shift*2;
      Sleep(50);
    end;
  end;(*CASE*)
end;


//Berechnen des optimalen Versatzes zwischen dem Beginn zweier FFTs
// 2D: angezeigt werden 250 Zeilen
// bentigt werden jeweils FFTend Samples
Function TWAVEosSCOPE.Optimum;
begin
  case GrafikMode of
    1:Optimum:=(SampleZahl-FFTend) div (4*100); //3D  bentigte samples x linienzahl
    2:Optimum:=(SampleZahl-FFTend) div (4*200); //2D
    3:Optimum:=(SampleZahl-FFTend) div (4*50); //1D
    else Optimum:=SampleZahl div (4*200);       //sicherheitshalber
  end;
end;


(*=================================================================
  quersumme*)
function TWAVEosSCOPE.Quersumme(zahl:integer):integer;
var m,n,l : integer;
begin
  m:=zahl;
  n:=0;
  for l:= 1 to c_8 do begin
    if ((m mod 2)=1) then inc(n);
    m:=m div 2;
  end;
quersumme:=n;
end;


(*=================================================================
  berechnet die nummer des letzten samples/filters
  belegt die modifikationstabelle
  berechnet alle ntigen sin/cos
  belegt die filternummertabelle*)
procedure TWAVEosSCOPE.FFTinit;
var k, l, m :integer;
begin

(*nummer des letzten samples,
  korr=verhaeltnis von 256 zur filterbreite
*)
FFTend:=ZWEIpower(FFTtype);
korr:=c_256 div FFTend;
dec(FFTend);

(*berechne sin-cos-Tabelle
*)
for k:=0 to c_255 do begin
  ar_re:=2*pi*k/c_256;
  T[k,s]:=sin(ar_re);
  T[k,c]:=cos(ar_re);
end;

(*modetabelle belegen
*)
(*alles loeschen
*)
for k:=0 to c_255 do
for l:=1 to c_8 do
for m:=0 to 2 do F[k,l,m]:=0;

(*adresse des 2. summanden berechnen
  add/sub festlegen
*)
for k:=1 to c_8 do begin
  wide := ZWEIpower(c_8-k);
  for l:=0 to c_255 do begin
    if (((l div wide) mod 2)=0) then begin
      F[l,k,0]:=l+wide;
      F[l,k,1]:=0; 		(*addition*)
    end else begin
      F[l,k,0]:=l-wide;
      F[l,k,1]:=1; 		(*subtraktion*)
    end;(*if*)
  end;
end;

(*Filternummern errechnen auf 8-bit basis,
  bei kleinerer FFT-weite ist die wirkliche filternummer
       spaeter mit "Filter[k] div korr" zu ermitteln
*)
for k:= 0 to c_255 do begin
  m:=k;
  n:=0;
  for l:= 1 to c_8 do begin
    if ((m mod 2)=1) then inc(n);
    m:=m div 2;
    n:=n * 2;
  end;
  Filter[k]:=n div 2;
end;

(*phasendrehung ermitteln, soweit moeglich
*)
for k:=0 to c_255 do begin    (*k=samplenummer*)
  qs:=quersumme(k);
  dreh:=(k*filter[k]+((qs mod 2) * (c_256 div 2) )) mod c_256;
  alt_dreh:=0;
  for l:=1 to c_7 do alt_dreh:=(alt_dreh+F[k,l,2]) mod c_256;
  while alt_dreh>dreh do dreh:=dreh+c_256;
  dreh:=dreh-alt_dreh;
  F[k,c_8,2]:=dreh;
  for l:=2 to c_7 do
    for m:=0 to c_255 do
      case l+(10-c_8) of
        2: if ((m>=256*k) and (m<256*(k+1))) then F[m,l,2]:=dreh;
        3: if ((m>=128*k) and (m<128*(k+1))) then F[m,l,2]:=dreh;
        4: if ((m>=64*k)  and (m<64*(k+1)))  then F[m,l,2]:=dreh;
        5: if ((m>=32*k)  and (m<32*(k+1)))  then F[m,l,2]:=dreh;
        6: if ((m>=16*k)  and (m<16*(k+1)))  then F[m,l,2]:=dreh;
        7: if ((m>=8*k)   and (m<8*(k+1)))   then F[m,l,2]:=dreh;
        8: if ((m>=4*k)   and (m<4*(k+1)))   then F[m,l,2]:=dreh;
        9: if ((m>=2*k)   and (m<2*(k+1)))   then F[m,l,2]:=dreh;
      end;(*case*)
  end;(*for*)
end; (*initialisierung*)




(*=================================================================
  2er potenzen bis 2@15*)
function TWAVEosSCOPE.ZWEIpower(oben:integer):integer;
var ZWEIpower_l, ZWEIpower_k : integer;
begin
  ZWEIpower_l:=1;
  for ZWEIpower_k:=1 to oben do ZWEIpower_l:=ZWEIpower_l*2;
  ZWEIpower:=ZWEIpower_l;
end;


// Berechnung und Anzeige der Grafik
procedure TWAVEosSCOPE.ToolButton3Click(Sender: TObject);
var
    olp,urp   : TPoint;
    rechteck  : TRect;

procedure truFFT;

(*=================================================================
  phasenschiebung von b nach a
*)
procedure FFTmul;
var
  k :integer;
begin
  a:=b;
  for k:=0 to FFTend do begin
    dreh:=F[k,FFTstep,2];
    if dreh>0 then begin
      a[k,i]:=b[k,i]*T[dreh,c]+b[k,q]*T[dreh,s];
      (*i2 = i1 cos n + q1 sin n*)
      a[k,q]:=b[k,q]*T[dreh,c]-b[k,i]*T[dreh,s];
      (*q2 = q1 cos n - i1 sin n*)
    end;
  end;
end;

(*=================================================================
  fhrt die additionen/subtraktionen von a nach b durch
  bercksichtigt FFTend und FFTstep*)
procedure FFTadd;
var
  addition      :  boolean;
  s1,                            (*1. summand=counter*)
  s2            :  integer;      (*2. summand=counter +- wide*)
begin
  for s1:=0 to FFTend do begin
    s2:=F[s1,FFTstep,0];
    addition:=F[s1,FFTstep,1]=0;
    if addition then begin
      b[s1,i]:=a[s1,i]+a[s2,i];
      b[s1,q]:=a[s1,q]+a[s2,q];
    end else begin
      b[s1,i]:=-a[s1,i]+a[s2,i];
      b[s1,q]:=-a[s1,q]+a[s2,q];
    end;
  end;
end;

(*=================================================================
 FFT von a nach a
*)
Procedure FFT; (*a->b*)
var power, k : integer;
begin

  (*FFT butterfly  a->b *)
  FFTstep:=c_9-FFTtype;
  repeat
    if FFTstep>c_9-FFTtype then FFTmul;    (*b->a*)
    FFTadd;    (*a->b*)
    inc(FFTstep);
  until FFTstep>c_8;

  case GenauRadioGroup.Itemindex of
  0:begin
      (*Vektorsummation b->a*)
      // mit vereinfachtem Pytagoras
      power:=FFTend+1;
      for k:=0 to FFTend do begin
        b[k,i]:=abs(b[k,i]);
        b[k,q]:=abs(b[k,q]);
        if b[k,i]<b[k,q] then a[(Filter[k] div korr),i]:=(b[k,q]+(b[k,i]*0.33))/Power
                         else a[(Filter[k] div korr),i]:=(b[k,i]+(b[k,q]*0.33))/Power;
      end;
    end;
  1:begin
      //richtige Vektorsummation  b->P
      power:=FFTend+1;
      for k:=0 to FFTend do begin
        P[Filter[k] div korr,i]:=sqrt(sqr(b[k,i])+sqr(b[k,q]))/Power;   //Magnitude
        if b[k,q]<>0 then P[Filter[k] div korr,q]:=arctan2(b[k,i],b[k,q])
                     else P[Filter[k] div korr,q]:=0;
      end;
      a:=P;
    end;
  end; // case

  (*WAVE-seitenbandkorrektur nach b
  *)
  b[0,i]:=a[0,i];
  for k:=1 to ((FFTend+1) div 2)-1 do b[k,i]:=a[FFTend+1-k,i]+a[k,i]; (*normal*)

end; (* FFT *)


//=============================================================
//liest ein wave file in a
procedure Wavefile;
var
    k                : integer;
    OldPointer       : longint;
begin
  OldPointer:=SoundPointer;
  k:=0;
  repeat
    a[k,i]:=Sound[Kanal,SoundPointer]-128;
    inc(SoundPointer);
    a[k,q]:=(a[k,i]+Sound[Kanal,SoundPointer]-128) / 2;    (*Echos*)
    inc(k);
  until (((MaxSample-SoundPointer)<2) or (k>FFTEnd));

  if k<(FFTEnd+1) then for k:=k to FFTEnd do begin
    a[k,i]:=0;
    a[k,q]:=0;
  end;

  FileEnde:=(MaxSample-SoundPointer)<2;
  SoundPointer:=OldPointer+SoundStep*4;
end;

(*===========================================================
  normalisiert a auf +-100
  *)
procedure normal;
var max,neu : real;
    k       : integer;
begin
  max := 0;
  for k:=0 to FFTend do begin
   neu:=abs(a[k,i])+abs(a[k,q]);
   if neu>max then max :=neu;
  end;
  If max=0 then neu:=1 else neu:=100/max;
  for k:=0 to FFTend do begin
    a[k,i]:=a[k,i]*neu;
    a[k,q]:=a[k,q]*neu;
  end;
end;

(*===========================================================
  highpass
  entfernt auch DC-offset
  *)
procedure highpass;
var k : integer;
begin
  for k:=0 to FFTend-1 do begin
   a[k,i]:=a[k,i]-a[k+1,i];
   a[k,q]:=a[k,q]-a[k+1,q];
  end;
  a[FFTend,i]:=0;
  a[FFTend,q]:=0;
end;

(*===========================================================
  Summ-filter
  *)
procedure summfilter;
var k: integer;
begin
  for k:=1 to ((FFTend+1) div 2)-1 do b[k,i]:=(b[k,i]+b[k-1,i])/2;
end;


// Filterausgnge auf durchschnittlich gleichen Betrag verstrken, b->b
Procedure outnorm;
var aver, neu : real;
    k         : integer;
    lowend    : integer;
    ende      : integer;
begin
  if WaveFlag then begin
    lowend:=20;
    ende:=((FFTend+1) div 2)-1;

    aver := 0;
    for k:=lowend to ende do aver:=aver+b[k,i];
    aver:= aver /(ende+1-lowend);

    (*duchschnitt-Amplitude auf 1 einstellen*)
    (*max kann im Extremfall 0 sein, dann keine division/0 erlauben*)
    if aver>0 then neu:=1/aver else neu :=1;
    for k:=0 to ende do b[k,i]:=b[k,i]*neu;
  end;
end;


(*===========================================================
  thresholding  in b
  *)
procedure limit;
var max,limit,neu : real;
    ende      : integer;
    lowend    : integer;
    k, l      : integer;
    Fenster   : integer;
    Loop      : integer;
    CFAR      : integer;
    CFARMin, CFARMax : integer;
begin
if WaveFlag then begin
  lowend:=20;
  ende:=((FFTend+1) div 2)-1;

  //limit mit gleitendem Durchschnitt

  Fenster:=10; // +- 10
  if not CFARCheckBox.Checked then Th:=LimTrackBar.Position;
  LimLabel.caption:='Limit : '+inttostr(Th);
  loop:=0;

  CFARMax:=Round(CFARTrackBar.Position*2);
  CFARMin:=Round(CFARTrackBar.Position*0.5);
  CFARLabel.Caption:='CFAR : '+inttostr(CFARMin)+' .. '+inttostr(CFARMax);
  repeat
    CFAR:=0;
    inc(Loop);
    for k:=Fenster to ende-Fenster do begin
      limit:=0;
      for l:=k-Fenster to k+Fenster do limit:=limit+b[l,i]/Fenster/2;
      limit:=Limit*(Th/10);
      if b[k,i]<limit then b[k,q]:=0 else begin
        b[k,q]:=b[k,i];
        inc(CFAR);
      end;
    end;
    if  CFAR>CFARMax then inc(Th);
    if CFAR<CFARMin then dec(Th);
  until ((CFAR>CFARMin) and (CFAR<CFARMax)) or (Loop>20) or (not CFARCheckBox.Checked);

  for k:=0 to Fenster-1 do b[k,i]:=0;
  for k:=ende-Fenster+1 to ende do b[k,i]:=0;
  for k:=Fenster to ende-Fenster do b[k,i]:=b[k,q];
end;  //if
end;



(*======MAIN==TruFFT===========================================*)
begin
  FFTstep:=c_9-FFTtype;
  frequenz:=0;
  Offset:=0;
  shift:=0;
  SoundPointer:=1;
  //max 250 Zeilen
  repeat
    offset:=shift * 50;
    inc(shift);
    FFTstep:=c_9-FFTtype;
    wavefile;(*laden der Sample-bytes*)     // -> a
    if not fileende then begin
      normal;  // Amplitudennormalisation
      highpass;  //a -> a
      FFT;                                  //a -> b
      // summfilter;
      outnorm;   //hat fast keinen effekt    b -> b
      if LimitFlag then limit;              //b -> b
      (***FERTIG******)
      Block[Shift]:=b;
      grafik;
    end;
  until (frequenz<0) or fileende or (shift>=250);
  gauge1.visible:=false;
end;   (* procedure truFF *********************************)

begin   (*ToolButton3Click*********************************)
  if FileFlag then begin
    Image1.ShowHint:=false;
    olp.x:=0;
    olp.y:=0;
    urp.x:=Bitmap.Width;
    urp.y:=Bitmap.Height;
    Rechteck.TopLeft:=olp;
    Rechteck.BottomRight:=urp;
    Bitmap.canvas.FillRect(Rechteck); //lschen

    //links oder stereo
    if (Mode=0) or (Mode=2) then begin
      Kanal:=0;
      Bitmap.canvas.Pen.Color:=clBlue;//clBlack;
      links:=0;
      rechts:=0;
      Label1.Caption:='';
      speed;
      truFFT;
    end;

    //rechts oder stereo
    if (Mode=1) or (Mode=2) then begin
      Kanal:=1;
      Bitmap.canvas.Pen.Color:=clRed;//clBlack;
      links:=0;
      rechts:=0;
      Label1.Caption:='';
      speed;
      truFFT;
    end;

    Image1.ShowHint:=Grafikmode=2;
    Image1.Canvas.Draw(0,0,Bitmap);
    Image1.Update;
  end;
end;

// einlesen eines WAV-Files
procedure TWAVEosSCOPE.OpenWavefile;
var
    ar_b,a_b,b_b,c_b,d_b       : byte;
    lang_li,a_li,b_li,c_li,d_li: longint;
    k                          : integer;
    str1                       : string;

  function vierbyte:longint;
  begin
    read(ton,a_b,b_b,c_b,d_b);
    a_li:=a_b;(*         1 /         *)
    b_li:=b_b;(*       256 /         *)
    c_li:=c_b;(*    65 536 / 5,94 sec*)
    d_li:=d_b;(*16 777 216 /         *)
    lang_li:=a_li+(b_li*256)+(c_li*256*256)+(d_li*256*256*256);
    vierbyte:=lang_li;
  end;

  (*lesen einer 4-Byte-Strings aus dem header der wav-datei nach wname
    dann 32-Bit Lngenangabe nach wlaenge lesen*)
  procedure wheader(var wname:string; var wlaenge:longint);
  begin
    read(ton,a_b,b_b,c_b,d_b);
    wname:=chr(a_b)+chr(b_b)+chr(c_b)+chr(d_b);
    wlaenge:=vierbyte;
  end;

  (*lesen eines 16Bit Datenworts*)
  function zweibyte:byte;
  begin
    read(ton,a_b,b_b);
    if b_B>127 then zweibyte:=b_b-128 else zweibyte:=b_b+128;
  end;

  (*lesen eines 8Bit Datenworts*)
  function einbyte:byte;
  begin
    read(ton,a_b);
    einbyte:=a_b;
  end;

begin   (*Openwavefile*)
WaveFlag:=true;

AssignFile(ton,Fname);
reset(ton);

//Beschreibung des WAV-Formates
//Das "canonical WAVE format" beginnt mit dem RIFF-header:
//  Offset  Length   Contents
//  0       4 bytes  'RIFF'
//  4       4 bytes  <file length - 8>
//  8       4 bytes  'WAVE'

wheader(wname, wlaenge);       (* 'RIFF', Gesamtlnge-8 *)
read(ton, a_b, b_b, c_b, d_b); (* 'WAVE' *)

//Next, the fmt chunk describes the sample format:
//  Offset  Length   Contents
//  12      4 bytes  'fmt '
//  16      4 bytes  0x00000010     // Length of the fmt data (16 bytes)
//  20      2 bytes  0x0001         // Format tag: 1 = PCM
//  22      2 bytes  <channels>     // Channels: 1 = mono, 2 = stereo
//  24      4 bytes  <sample rate>  // Samples per second: e.g., 44100
//  28      4 bytes  <bytes/second> // sample rate * block align
//  32      2 bytes  <block align>  // channels * bits/sample / 8
//  34      2 bytes  <bits/sample>  // 8 or 16

wheader(wname, fmtlaenge);         (* 'fmt ', fmt-data-lnge-8 *)
read(ton, wformat, b_b, wms, d_b); (* Format, M/S *)

(*Samplerate bestimmen*)
SampleFrequenz:=vierbyte;
StatusBar1.Panels[1].Text:=IntToStr(SampleFrequenz)+' Hz Samplerate';

byps:=vierbyte;
read(ton,walign,b_b,bips,d_b);  (* align= bytes/sample *)
fmtlaenge:=fmtlaenge-16;

for k:=1 to fmtlaenge do begin
  read(ton, ar_b);
end;

//Finally, the data chunk contains the sample data:
//  Offset  Length   Contents
//  36      4 bytes  'data'
//  40      4 bytes  <length of the data block>
//  44        bytes  <sample data>
//
//The sample data must end on an even byte boundary.
//All numeric data fields are in the Intel format of low-high byte ordering.
//8-bit samples are stored as unsigned bytes, ranging from 0 to 255.
//16-bit samples are stored as 2's-complement signed integers, ranging from -32768 to 32767.

(*nach data suchen*)
repeat
  wheader(wname, wlaenge); (* '????', lnge-8 *)
  if wname<>'data' then 
  for k:=1 to wlaenge do begin
    read(ton, ar_b);
  end;
until wname='data';

(*Anzahl der samples bestimmen*)
ByteZahl:=wlaenge;
Samplezahl:=ByteZahl div walign;
StatusBar1.Panels[2].Text:=IntToStr(SampleZahl)+' Samples';
str(SampleZahl/SampleFrequenz:4:1,str1);
StatusBar1.Panels[3].Text:=str1+' s';

MaxSample:=SampleZahl;
if MaxSample>SoundEnde then MaxSample:=SoundEnde;
(*Sound einlesen*)
for lang_li:=1 to MaxSample do begin
  // ersten Kanal (links) einlesen
  if bips=8 then Sound[0,lang_li]:=einbyte else Sound[0,lang_li]:=zweibyte;
  if wms=2 then begin
    // Stereo 2. Kanal (rechts) einlesen
    if bips=8 then Sound[1,lang_li]:=einbyte else Sound[1,lang_li]:=zweibyte;
    KanalRadioGroup.Enabled:=true;
  end else begin
    Sound[1,lang_li]:=127; // mono
    KanalRadioGroup.Itemindex:=0;
    KanalRadioGroup.Enabled:=false;
  end;
end;

if OptimumFlag then SoundStep:=Optimum;

closefile(ton);
end;(*proc*)

procedure TWAVEosSCOPE.ToolButton1Click(Sender: TObject);
var
  Fehler : integer;
begin
  OpenDialog1.Filter:='*.wav';
  OpenDialog1.Title:='Sounddatei';
  OpenDialog1.FileName:='*.wav';
  if OpenDialog1.Execute then   { Dialog zum Dateiffnen anzeigen }
    FName:=OpenDialog1.FileName;    { Datei ausgewhlt }

  waveosscope.caption:='WAVEosSCOPE  '+FName;
  StatusBar1.Panels[0].Text:=FName;
  StatusBar1.update;

  if FName<>'' then begin
    filemode:=0; (*nur lesen*)
    assignFile(ton, FName);
    (*$I-*)
    reset(ton);
    (*$I+*)
    Fehler:=IOResult;
    if (Fehler=0) then begin 
      closefile(ton);
      FileFlag:=true;
      OpenWavefile;(*anschlieend schlieen*)
      WAVEosSCOPE.ToolButton3Click(Sender);
    end else begin
      FileFlag:=False;
      StatusBar1.Panels[0].Text:='!! file load ERROR !!';
      StatusBar1.update;
    end;
    ToolButton2.Enabled:=Fileflag;
    ToolButton3.Enabled:=Fileflag;
    ToolButton4.Enabled:=Fileflag;
  end;   (*fname<>''*)
end;

procedure TWAVEosSCOPE.ToolButton2Click(Sender: TObject);
begin
if FileFlag then begin
  Mediaplayer1.FileName:=Fname;
  Mediaplayer1.Open;
  Mediaplayer1.Wait:=true;
  Mediaplayer1.Play;
  Mediaplayer1.Close;
end;
end;

procedure TWAVEosSCOPE.ToolButton5Click(Sender: TObject);
begin
  halt;
end;

procedure TWAVEosSCOPE.ToolButton4Click(Sender: TObject);
begin
  Waveosscope.PrintDialog1.Execute;
  print;
end;

procedure TWAVEosSCOPE.FormCreate(Sender: TObject);
var k : longint;
    dc : HDC;
begin
  //groe fonts kompensieren
  if not SmallFonts then begin
    DC:=GetDC(0);
    Self.ScaleBy(96,GetDeviceCaps(DC, LOGPIXELSX));
    ReleaseDC(0, DC);
    Refresh;
  end;

  //in die Bildschirmmitte
  left:=(screen.width-Width) div 2;
  top:=(screen.height-Height) div 2;

  Bitmap:=TBitmap.Create;
  Bitmap.Width := Image1.Width;
  Bitmap.Height:= Image1.Height;

  Image1.Canvas.Draw(0,0,Bitmap);
  Image1.Update;

  Gauge1.visible:=false;

  Grafikmode:=2; (*1=3D  2=2D*)
  Grafikradio.Itemindex:=Grafikmode-1;
  OptimumFlag:=true;(*FFT-step fr 200 grafikzeilen*)
  LimitFlag:=true;
  FileFlag:=false; (******)
  FFTtype:=10; (*7=128 8=256 9=512 10=1024*)
  TrackBar1.Position:=FFTtype;
  CFARCheckBox.Checked:=false;
  CFARCheckBox.Checked:=true;
  SoundStep:=k;
  FFTinit;

  ToolButton1Click(nil);
end;


procedure TWAVEosSCOPE.FrequenzMarke(XPos:integer;col:Tcolor);
var ar_str : string;
begin
  Bitmap.canvas.Font.Color:=col;
  str((SampleFrequenz/2)/512*(XPos-lr)/hscale+0.4:1:0,ar_str);
  Bitmap.canvas.textout(XPos,ur,ar_str +' Hz');
  Image1.Canvas.Draw(0,0,Bitmap);
  Image1.Update;
end;


//Berechnung der Geschwindigkeit anhand der Marken
procedure TWAVEosSCOPE.Speed;
//const schall=1234; (*km/h*)
var delta, fd, f1, f2, f0, vd :real;
    ar_str                    :string;
    schall : real;
begin
  //Schallgeschwindigkeit je nach Temperatur
  schall:=20.03*sqrt(SpinEdit1.Value+273.15); (*m/s*)
  schall:=schall*3.6; (*km/h*)
  if ((links>0) and (rechts>0)) then begin
    delta:=SampleFrequenz /2 / c_256;  (*Filterbreite*)
    fd:=abs(links-rechts)/hscale *delta/2;     (*Dopplerverschiebung*)
    f1:=(links -lr)/hscale;
    f2:=(rechts-lr)/hscale;
    f0:=(f1+f2)/2 *delta;              (*mittenfrequenz*)
    vd:=fd*schall/f0;                  (*geschwindigkeit*)
    str(vd:5:2,ar_str);
    Label1.Caption:='Geschwindigkeit: '+ar_str+' km/h ';
    vd:=delta*schall/f0/2;             (*geschwindigkeitsstufe*)
    str(vd:5:2,ar_str);
    Label1.Caption:=Label1.Caption+'('+ar_str+' km/h) ';
    Label1.Update;
  end;
end;


procedure TWAVEosSCOPE.Image1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if ((GrafikMode=2) and (SampleFrequenz>0)) then case Button of
  mbLeft :begin
          if links<>0 then  begin
            Bitmap.canvas.Pen.Color:=clwhite;
            Bitmap.canvas.moveto(links,ur);
            Bitmap.canvas.lineto(links,20);
            FrequenzMarke(links,clWhite);
          end;
          links:=X;
          Bitmap.canvas.Pen.Color:=clGreen;
          Bitmap.canvas.moveto(x,ur);
          Bitmap.canvas.lineto(x,20);
          FrequenzMarke(links,clGreen);
          speed;
        end;
  mbright:begin
          if rechts<>0 then  begin
            Bitmap.canvas.Pen.Color:=clwhite;
            Bitmap.canvas.moveto(rechts,ur);
            Bitmap.canvas.lineto(rechts,20);
            FrequenzMarke(rechts,clWhite);
          end;
          rechts:=X;
          Bitmap.canvas.Pen.Color:=clRed;
          Bitmap.canvas.moveto(x,ur);
          Bitmap.canvas.lineto(x,20);
          FrequenzMarke(rechts,clRed);
          speed;
         end;
  end;
end;

procedure TWAVEosSCOPE.ToolButton8Click(Sender: TObject);
begin
  ShowMessage('                               WaveOsScope         '   +chr($0d)+
              '        Geschwindigkeitsmessung fr Modellflugzeuge'   +chr($0d)+
              '                                   Version 2.1     '   +chr($0d)+
              'neueste Version unter www.sprut.de/electronic/soft/'   +chr($0d)+chr($0d)+
              '                                      sprut       ');
end;


procedure TWAVEosSCOPE.KanalRadioGroupClick(Sender: TObject);
begin
  Mode:=KanalRadioGroup.Itemindex;
  WAVEosSCOPE.ToolButton3Click(Sender);
end;


procedure TWAVEosSCOPE.GenauRadioGroupClick(Sender: TObject);
begin
  WAVEosSCOPE.ToolButton3Click(Sender);
end;


procedure TWAVEosSCOPE.PCheckboxClick(Sender: TObject);
begin
  Trigger;
end;


procedure TWAVEosSCOPE.GrafikRadioClick(Sender: TObject);
begin
  if Fileflag then begin
    GrafikMode :=GrafikRadio.Itemindex+1;;
    Soundstep:=WAVEosSCOPE.Optimum;
  end;
  WAVEosSCOPE.ToolButton3Click(Sender);
end;


procedure TWAVEosSCOPE.OptimalClick(Sender: TObject);
begin
  if Fileflag then soundstep:=WAVEosSCOPE.Optimum;
  OptimumFlag :=true;
end;


//Zahl der FFT-Filter einstellen
procedure TWAVEosSCOPE.TrackBar1Change(Sender: TObject);
var oldk : integer;
begin
  oldk:=k;
  k:=WAVEosSCOPE.ZweiPower(TrackBar1.Position);
  FFTLabel.Caption:=IntToStr(k)+' FFT-Filter';
  StatusBar1.Panels[0].Text:=IntToStr(k)+' Filter';
  if k= oldk then exit;

  FFTType:=TrackBar1.Position;
  FFTend:=WAVEosScope.ZWEIpower(FFTtype);
  korr:=c_256 div FFTend;
  dec(FFTend);

  WAVEosScope.StatusBar1.Panels[4].Text:=IntToStr(WAVEosSCOPE.ZweiPower(FFTType))+' Filter';
  Trigger;
end;


procedure TWAVEosSCOPE.LimTrackBarChange(Sender: TObject);
begin
  Trigger;
end;

procedure TWAVEosSCOPE.CFARCheckBoxClick(Sender: TObject);
begin
  GroupBox1.Visible:= not CFARCheckBox.Checked;
  GroupBox2.Visible:= CFARCheckBox.Checked;
  Trigger;
end;

procedure TWAVEosSCOPE.CFARTrackBarChange(Sender: TObject);
begin
  Trigger;
end;

//Neuberechnung anstoen in 250 ms
procedure TWAVEosSCOPE.trigger;
begin
  Timer1.Enabled:=false;
  Timer1.Enabled:=true;
  Timer1.Interval:=250;
end;

//nun neu berechnen
procedure TWAVEosSCOPE.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled:=false;
  WAVEosSCOPE.ToolButton3Click(Sender);
end;

// Anpassung der Grafikgroesse nach veraenderung der Fenstergroesse
procedure TWAVEosSCOPE.FormResize(Sender: TObject);
begin
  // orig.: 271 x 615
  // ur orig. : 250
  if width>231  then Image1.picture.Bitmap.width :=width  - 231 else Image1.picture.Bitmap.width :=1;
  if height>167 then Image1.picture.Bitmap.height:=height - 167 else Image1.picture.Bitmap.height:=1;

  Image1.width :=Image1.picture.Bitmap.width;
  Image1.height:=Image1.picture.Bitmap.height;
  Bitmap.Width := Image1.Width;
  Bitmap.Height:= Image1.Height;
  hscale:= (Image1.width-lr)/(615-lr);
  gauge1.left:=width-342;
//  Toolbar1.width:=width-8;
//  ToolButton6.width:=Toolbar1.width-6*ToolButton1.width-20;
  ur:=Image1.height-21;
  vscale:= (ur)/(250);

  Trigger;
end;

procedure TWAVEosSCOPE.SpinEdit1Change(Sender: TObject);
begin
  speed;
end;

end.


