// wenn nichts weiter anliegt, dann wird alle 100 ms eine anftage an das Korad gestekkt
unit Korad;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CPort, comsetup, ExtCtrls, ComCtrls, Buttons;

type
  THist = record
    volt  : real;
    strom : real;
  end;

  TForm1 = class(TForm)
    ComPort1: TComPort;
    Memo1: TMemo;
    Timer1: TTimer;
    Button7: TButton;
    Timer2: TTimer;
    Timer3: TTimer;
    GroupBox1: TGroupBox;
    VoltTrackBar: TTrackBar;
    MilliVoltTrackBar: TTrackBar;
    UoutLabel: TLabel;
    USetLabel: TLabel;
    GroupBox2: TGroupBox;
    AmpereTrackBar: TTrackBar;
    MilliAmpereTrackBar: TTrackBar;
    IOutLabel: TLabel;
    ISetLabel: TLabel;
    GroupBox3: TGroupBox;
    Button14: TButton;
    Button15: TButton;
    Button16: TButton;
    Button17: TButton;
    Button6: TButton;
    Button9: TButton;
    Button18: TButton;
    Button19: TButton;
    Button20: TButton;
    Button21: TButton;
    Button22: TButton;
    Button23: TButton;
    Button24: TButton;
    Button25: TButton;
    GroupBox4: TGroupBox;
    Button3: TButton;
    Button4: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Image1: TImage;
    ocpShape: TShape;
    ovpShape: TShape;
    outputShape: TShape;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    GroupBox5: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Button5: TButton;
    Button26: TButton;
    Button27: TButton;
    Button8: TButton;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure ComPortSetup;
    procedure readKorad;
    procedure FormCreate(Sender: TObject);
    procedure ShowHist;
    function Sende_Empfange(in_str :string; M:integer): string;
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    function GetSetVoltage:real;
    function GetSetCurrent:real;
    function GetOutVoltage:real;
    function GetOutCurrent:real;
    procedure Timer1Timer(Sender: TObject);
    function Identify:string;
    procedure Button7Click(Sender: TObject);
    function GetStatus:byte;
    procedure Button8Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure SetNextCommand(st:string);
    procedure Timer2Timer(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure SetVoltage;
    procedure Button15Click(Sender: TObject);
    procedure SetVoltage_st(st:string);
    procedure SetCurrent_st(st:string);
    procedure VoltTrackBarChange(Sender: TObject);
    procedure MilliVoltTrackBarChange(Sender: TObject);
    procedure SetCurrent;
    procedure AmpereTrackBarChange(Sender: TObject);
    procedure MilliAmpereTrackBarChange(Sender: TObject);
    procedure ComPort1BeforeClose(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button16Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button23Click(Sender: TObject);
    procedure Button24Click(Sender: TObject);
    procedure Button25Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button20Click(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure Button22Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    nextIsVoltage : boolean;
    donotupdate   : boolean;
    nextcommand   : string;
    uset_str      : string;
    iset_str      : string;
    uset_r        : real;
    iset_r        : real;
    historie      : array[0..500] of THist;
    hist_pointer  : integer
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  ComPortSetup;
end;


procedure TForm1.ComPortSetup;
begin
  if ComSetup1.ShowModal=mrOK then readKorad;
end;


procedure TForm1.readKorad;
begin
  if not ComPort1.Connected then begin
    try
      ComPort1.Open;
      ComPort1.ClearBuffer(true, true);
    except
      Application.MessageBox(
        'Can not open the selected COM-port'+ chr($0D)+
        'Please check your COM-port-selection',
        'OOPS',  //kopfzeile
        MB_OK
        + MB_ICONWARNING            // gelbes warndreieck
        + MB_APPLMODAL              // user muss ok clicken um weiterzuarbeiten
        + MB_SETFOREGROUND);
    end;
  end;
  if not ComPort1.Connected then exit;
  Identify;
  Timer1.enabled := true;
  GetSetVoltage;
  GetSetCurrent;
end; //readKorad


procedure TForm1.FormCreate(Sender: TObject);
var k : integer;
begin
  Button7.visible := false;
  memo1.visible := false;
  nextIsVoltage := true;
  donotupdate   := false;
  nextcommand   := '';
  uset_str      := '';
  iset_str      := '';
  uset_r        := 30;
  iset_r        :=  5;
  for k:=0 to 500 do begin
    Historie[k].volt  := 0;
    Historie[k].strom := 0;
  end;
  hist_pointer := 0;
  ComPort1.CustomBaudRate := 9600; //115200;
  Timer2.enabled := true;
end;  //FormCreate


// grafische darstellung des Spannungs und Stromverbrauchs
// am output terminal
procedure TForm1.ShowHist;
var
  x, xp, yV, yV_alt, yA, yA_alt : integer;
  V_set, A_set : real;
begin
  //Grafikfenster lschen
  image1.canvas.brush.color := clWhite;
  image1.canvas.pen.color   := clWhite;
  image1.canvas.rectangle(0,0,500,200);

  V_set := 30;
  A_set := 5;
  if uset_r<1   then V_set:=1   else V_set := uset_r;
  if iset_r<0.1 then A_set:=0.1 else A_set := iset_r;

  image1.canvas.pen.color := clgray;
  image1.canvas.pen.style:= psDot;
  image1.canvas.moveto(0,   10);
  image1.canvas.lineto(500, 10);
  image1.canvas.moveto(0,   190);
  image1.canvas.lineto(500, 190);
  image1.canvas.moveto(0,   100);
  image1.canvas.lineto(500, 100);

  image1.canvas.font.color := clred;
  image1.canvas.Textout(10,05, ' '+floattostr(A_set)+'A ');
  image1.canvas.font.color := clblue;
  image1.canvas.Textout(10,95, ' '+floattostr(V_set)+'V ');

  for x:=0 to 500 do begin
    //hist_pointer
    xp := x;
    xp := (x + hist_pointer) mod 500;
    yV := 200 - round(historie[xp].volt/V_set*90   + 10);
    yA := 200 - round(historie[xp].strom/A_set*180 + 10);
    if x>1 then begin
     image1.canvas.pen.style := psSolid;
      image1.canvas.pen.color := clblue;
      image1.canvas.moveto(x-1, yV_alt);
      image1.canvas.lineto(x  , yV);

      image1.canvas.pen.color := clred;
      image1.canvas.moveto(x-1, yA_alt);
      image1.canvas.lineto(x  , yA);
    end;
    if (xp mod 100)=0 then begin
      image1.canvas.pen.style:= psDot;
      image1.canvas.pen.color := clgray;
      image1.canvas.moveto(x, 10);
      image1.canvas.lineto(x, 190);
    end;
    yV_alt := yV;
    yA_alt := yA;
  end;
end;  //ShowHist


//N Bytes senden und M Bytes empfangen
//timeout ist jeweils 100 ms
// N ist maximal 4
// M wird ignoriert
function TForm1.Sende_Empfange(in_str :string; M:integer): string;
var
   asciistr    : string[63];
   rx_str      : AnsiString;
   nrrx        : integer;
   k           : integer;
   st          : string;
begin
  if not ComPort1.Connected then exit;
  if length(in_str)>0 then begin
    //senden ber comport
    asciistr := in_str;
    //memo1.lines.add('');
    //memo1.lines.add('PC -> Korad');
    //memo1.lines.add('TXT : '+asciistr);

    ComPort1.ClearBuffer(true, true);
    sleep(100);
    ComPort1.ClearBuffer(true, true);
    Comport1.WriteStr(asciistr);
  end;

  result := '';
  if M<1 then exit;
  //empfangen ber comport
  nrrx   := Comport1.ReadStr(rx_str, M);
  //mo1.lines.add('  Korad -> PC');
  //mo1.lines.add('  TXT : '+rx_str);
  result := rx_str;
end; // sende_empfange
       

function TForm1.GetOutVoltage:real;
var uout_str : string;
    Volt_r   : real;
begin
  result := 0;
  uout_str := Sende_Empfange('VOUT1?',5);
  UoutLabel.Caption := uout_str+' V';
  // in hist eintragen  xx.yy
  try
    Volt_r := strtoint( copy(uout_str, 1, 2) + copy(uout_str, 4, 2)) /100;
  except
    Volt_r := 0;
  end;
  inc(hist_pointer);
  if hist_pointer>500 then hist_pointer:=0;
  historie[hist_pointer].volt := Volt_r;
end;  //GetOutVoltage


function TForm1.GetSetCurrent:real;
var Ampere_st      : string;
    MilliAmpere_st : string;
begin
  result := 0;
  iset_str := Sende_Empfange('ISET1?',5);
  IsetLabel.Caption := iset_str+' A';
  // trackbars setzen      'x.xyy'
  Ampere_st      := copy(iset_str, 1, 1) + copy(iset_str, 3, 1);
  MilliAmpere_st := copy(iset_str, 4, 2);
  try
    AmpereTrackBar.position      := strtoint(Ampere_st);
    MilliAmpereTrackBar.position := strtoint(MilliAmpere_st);
    iset_r := strtoint(Ampere_st)/10 + strtoint(MilliAmpere_st)/1000;
  except
    iset_r := 5;
  end;
end;  //GetSetCurrent


function TForm1.GetSetVoltage:real;
var Volt_st      : string;
    MilliVolt_st : string;
begin
  result := 0;
  uset_str := Sende_Empfange('VSET1?',5);
  UsetLabel.Caption := uset_str+' V';
  // trackbars setzen      'xx.yy'
  Volt_st      := copy(uset_str, 1, 2);
  MilliVolt_st := copy(uset_str, 4, 2);
  try
    VoltTrackBar.position      := strtoint(Volt_st);
    MilliVoltTrackBar.position := strtoint(MilliVolt_st);
    uset_r := strtoint(Volt_st) + strtoint(MilliVolt_st)/100;
  except
    uset_r := 30;
  end;
end;  //GetSetVoltage


function TForm1.GetOutCurrent:real;
var iout_str : string;
    Amp_r    : real;
begin
  result := 0;
  iout_str := Sende_Empfange('IOUT1?',5);
  IoutLabel.Caption := iout_str+' A';
  // in hist eintragen  x.yyy
  try
    Amp_r := strtoint( copy(iout_str, 1, 1) + copy(iout_str, 3, 3)) /1000;
  except
    Amp_r := 0;
  end;
  historie[hist_pointer].strom := Amp_r;
  showhist;
end;


procedure TForm1.Timer1Timer(Sender: TObject);
begin
  // was anderes zu tun ?
  if nextcommand<>'' then begin
    Sende_Empfange(nextcommand,0);
    nextcommand := '';
    GetStatus;
    exit;
  end;
  //
  nextIsVoltage := not nextIsVoltage;
  if nextIsVoltage then GetOutVoltage else GetOutCurrent;
end;


function TForm1.Identify:string;
begin
  Result  := Sende_Empfange('*IDN?',50);
  Caption := result;
end;


procedure TForm1.Button7Click(Sender: TObject);
begin
  GetStatus;
end;


// Request the actual status. The output is a single byte with the actual status encoded in bits.
// At least the Velleman PS3005D V2.0 is a bit buggy here. The only reliable bits are:
//  0x40 (Output mode: 1:on, 0:off), 0x20 (OVP and/or OCP mode: 1:on, 0:off) and 0x01 (CV/CC mode: 1:CV, 0:CC)
function TForm1.GetStatus:byte;
var st     : string;
    rx_str : string;
    k      : integer;
    status : byte;
begin
  rx_str := Sende_Empfange('STATUS?',50);
  st := '';
  status := ord(rx_str[1]);
  //if (status and $80)<>0 then ovpShape.brush.color:=clRed    else ovpShape.brush.color:=clGray;      // ovp-off klappt nict wenn ocp-on ist
  if (status and $80)=0 then ovpShape.brush.color:=clGray; 
  if (status and $20)<>0 then ocpShape.brush.color:=clRed    else ocpShape.brush.color:=clGray;
  if (status and $40)<>0 then outputShape.brush.color:=clRed else outputShape.brush.color:=clGray;
  
  for k := 1 to length(rx_str) do st := st + inttohex(ord(rx_str[k]),2) + ' ';
  memo1.lines.add('  HEX : '+st);
end;  //GetStatus


procedure TForm1.Button8Click(Sender: TObject);
begin
  close;
end;


procedure TForm1.Button3Click(Sender: TObject);
begin
  SetNextCommand('OUT1');
  outputShape.brush.color:=clRed;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  SetNextCommand('OUT0');
  outputShape.brush.color:=clGray;
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
  SetNextCommand('OCP1');
  ocpShape.brush.color:=clRed;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
  SetNextCommand('OCP0');
  ocpShape.brush.color:=clGray;
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
  SetNextCommand('OVP1');
  ovpShape.brush.color:=clRed;
end;

procedure TForm1.Button13Click(Sender: TObject);
begin
  SetNextCommand('OVP0');
  ovpShape.brush.color:=clGray;
end;

procedure TForm1.SetNextCommand(st:string);
begin
  if Timer1.enabled then nextcommand:=st else begin
    Sende_Empfange(st,0);
    GetStatus;
  end;  
end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
  Timer2.enabled := false;
  ComPortSetup;
end;

procedure TForm1.Button14Click(Sender: TObject);
begin
  SetVoltage_st('01.25');
end;

procedure TForm1.Button15Click(Sender: TObject);
begin
  SetVoltage_st('03.33');
end;

procedure TForm1.Button16Click(Sender: TObject);
begin
  SetVoltage_st('05.00');
end;

procedure TForm1.Button17Click(Sender: TObject);
begin
  SetVoltage_st('09.00');
end;

procedure TForm1.Button23Click(Sender: TObject);
begin
  SetVoltage_st('12.00');
end;

procedure TForm1.Button24Click(Sender: TObject);
begin
  SetVoltage_st('15.00');
end;

procedure TForm1.Button25Click(Sender: TObject);
begin
  SetVoltage_st('24.00');
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  SetCurrent_st('0.100');
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  SetCurrent_st('0.500');
end;

procedure TForm1.Button18Click(Sender: TObject);
begin
  SetCurrent_st('1.000');
end;

procedure TForm1.Button19Click(Sender: TObject);
begin
  SetCurrent_st('2.000');
end;

procedure TForm1.Button20Click(Sender: TObject);
begin
  SetCurrent_st('3.000');
end;

procedure TForm1.Button21Click(Sender: TObject);
begin
  SetCurrent_st('4.000');
end;

procedure TForm1.Button22Click(Sender: TObject);
begin
  SetCurrent_st('5.000');
end;


procedure TForm1.SetVoltage_st(st:string);
begin
  SetNextCommand('VSET1:'+st);
  Timer3.enabled := false;
  Timer3.enabled := true;
end;

procedure TForm1.SetCurrent_st(st:string);
begin
  SetNextCommand('ISET1:'+st);
  Timer3.enabled := false;
  Timer3.enabled := true;
end;

procedure TForm1.Timer3Timer(Sender: TObject);
begin
  donotupdate := true;
  GetSetVoltage;
  GetSetCurrent;
  if (uset_str<>'') and (iset_str<>'') then Timer3.enabled := false;
  donotupdate := false;
end;


procedure TForm1.SetVoltage;
var
  vorkomma  : string;
  nachkomma : string;
begin
  vorkomma  := inttostr(VoltTrackBar.position);
  nachkomma := inttostr(MilliVoltTrackBar.position);
  while length(vorkomma)<2  do vorkomma  := '0' + vorkomma;
  while length(nachkomma)<2 do nachkomma := '0' + nachkomma;
  USetLabel.Caption := vorkomma+'.'+nachkomma+' V';
  if not donotupdate then SetVoltage_st(vorkomma+'.'+nachkomma);
end; //SetVoltage


procedure TForm1.VoltTrackBarChange(Sender: TObject);
begin
  SetVoltage;
end;

procedure TForm1.MilliVoltTrackBarChange(Sender: TObject);
begin
  SetVoltage;
end;

procedure TForm1.SetCurrent;
var
  vorkomma  : string;
  nachkomma : string;
begin
  vorkomma  := inttostr(AmpereTrackBar.position div 10);
  nachkomma := inttostr((AmpereTrackBar.position mod 10)*100  +  MilliAmpereTrackBar.position);
  while length(vorkomma)<1  do vorkomma  := '0' + vorkomma;
  while length(nachkomma)<3 do nachkomma := '0' + nachkomma;
  ISetLabel.Caption := vorkomma+'.'+nachkomma+' A';
  if not donotupdate then SetCurrent_st(vorkomma+'.'+nachkomma);
end;   //SetCurrent

procedure TForm1.AmpereTrackBarChange(Sender: TObject);
begin
  SetCurrent;
end;

procedure TForm1.MilliAmpereTrackBarChange(Sender: TObject);
begin
  SetCurrent;
end;

procedure TForm1.ComPort1BeforeClose(Sender: TObject);
begin
 ComPort1.ClearBuffer(true, true);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Sende_Empfange('OUT0',0);
end; 
        
end.
