/*********************************************************************
 *
 *                HP-Print
 *
 *********************************************************************
 * FileName:        mainwindow.h
 * Compiler etc.    GCC, Qt5.11.3
 * Author:          sprut (sprut@sprut.de)
 *
 * Software License Agreement
 *
 *  HP-Print,   convert outputs from HP8595 into a PNG-Graphic
 *   Copyright (C) 2021  Bredendiek (sprut)
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <https://www.gnu.org/licenses/>.
 ***********************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtSerialPort/QSerialPort>
#include <QtSerialPort/QSerialPortInfo>
#include <QComboBox>
#include <QMessageBox>

#include <QPixmap>
#include <QPainter>
#include <QTimer>

#include <stdio.h>   /* Standard input/output definitions */
#include <string.h>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <termios.h> /* POSIX terminal control definitions */
#include <ctype.h>   /* for isprint */
#include <stdlib.h>  /* for atoi */
#include <time.h>    /* time handling */

#include "settingsdialog.h"

typedef unsigned short int  word;           // 16-bit

#define     MAX_PRINT_FILE_SIZE     200000  // HP-Farbe 170kByte,  Epson 70 ... 100 kByte
#define     interval_ms             1000
#define     TimeMode_s              0
#define     TimeMode_m              1
#define     TimeMode_h              2


namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow();
    void Reset(void);
    virtual void paintEvent(QPaintEvent *event);

private slots:
    void TimerAction();
    int getRxBufferInt(int p);
    void readData();
    void handleError(QSerialPort::SerialPortError error);
    void closeSerialPort();
    void showStatusMessage(const QString &message);
    void on_pushButton_clicked();
    void OpenPort();
   // void on_btnReset_clicked();
    void on_actionAbout_triggered();
    void on_pushButton_3_clicked();
    void SaveToFile();
    void MakePicture();
    void on_actionClear_triggered();
    void on_pushButton_2_clicked();
    void on_pushButton_5_clicked();

private:
    void initActionsConnections();

private:
    char        *dvalue = NULL; //device interface
    int         c,j;
    int         debug = 0;      // 0=debug,  1=normal
    int         connect_fail = 0;
    int         connected = 0;
    int         multimeter_fd;
    int         TimeMode = TimeMode_s;
    int         value_i;
    int         skipvalues = 0;
    float       value_f;
    double      Zeit = 0;
    double      Vmin = 0;
    double      Vmax = 0;
    timeval     ZeitStart, ZeitNow;
    long int    recordings = 0;
    int         mode = 0;
    int         oldmode = 0;
    int         buffer_pointer;
    bool        paint_enable = false;
    bool        toPNG = false;
    bool        rx_active   = false;
    bool        rx_finished = true;

    QByteArray      RxBuffer;
    QVector<double> qv_V, qv_T;
    unsigned char   buffer_printer[MAX_PRINT_FILE_SIZE];

    Ui::MainWindow *ui;
    SettingsDialog *m_settings = nullptr;
    QSerialPort *m_serial = nullptr;
    QTimer *timer  = new QTimer(this);
};

#endif // MAINWINDOW_H
