
/*//////////////////////////////////////////////////////////////////
              -    FB Aka Heartman/Hearty 2016     -                   
              -   http://heartygfx.blogspot.com    -                  
              -       OpenScad Parametric Box      -                     
              -         CC BY-NC 3.0 License       -                      
////////////////////////////////////////////////////////////////////                                                                                                             
12/02/2016 - Fixed minor bug 
28/02/2016 - Added holes ventilation option                    
09/03/2016 - Added PCB feet support, fixed the shell artefact on export mode. 

*/////////////////////////// - Info - //////////////////////////////

// All coordinates are starting as integrated circuit pins.
// From the top view :

//   CoordD           <---       CoordC
//                                 ^
//                                 ^
//                                 ^
//   CoordA           --->       CoordB


////////////////////////////////////////////////////////////////////


////////// - Paramètres de la boite - Box parameters - /////////////

/* [Box dimensions] */
// - Longueur - Length  
  Length        = 150;       
// - Largeur - Width
  Width         = 150; //170;                     
// - Hauteur - Height  
  Height        = 150;  //100;  
// - Epaisseur - Wall thickness  
  Thick         = 2;//[2:5]  
  
/* [Box options] */
// - Diamètre Coin arrondi - Filet diameter  
  Filet         = 2;//[0.1:12] 
// - lissage de l'arrondi - Filet smoothness  
  Resolution    = 50;//[1:100] 
// - Tolérance - Tolerance (Panel/rails gap)
  m             = 0.9;
// Pieds PCB - PCB feet (x4) 
  PCBFeet       = 0;// [0:No, 1:Yes]
// - Decorations to ventilation holes
  Vent          = 1;// [0:No, 1:Yes]
// - Decoration-Holes width (in mm)
  Vent_width    = 1.5;   


  
/* [PCB_Feet] */
//All dimensions are from the center foot axis

// - Coin bas gauche - Low left corner X position
PCBPosX         = 7;
// - Coin bas gauche - Low left corner Y position
PCBPosY         = 6;
// - Longueur PCB - PCB Length
PCBLength       = 70;
// - Largeur PCB - PCB Width
PCBWidth        = 50;
// - Heuteur pied - Feet height
FootHeight      = 10;
// - Diamètre pied - Foot diameter
FootDia         = 8;
// - Diamètre trou - Hole diameter
FootHole        = 3;  
  

/* [STL element to export] */
//Coque haut - Top shell
TShell          = 1;// [0:No, 1:Yes]
//Coque bas- Bottom shell
BShell          = 1;// [0:No, 1:Yes]
//Panneau avant - Front panel
FPanL           = 1;// [0:No, 1:Yes]
//Panneau arrière - Back panel  
BPanL           = 1;// [0:No, 1:Yes]


  
/* [Hidden] */
// - Couleur coque - Shell color  
Couleur1        = "Orange";       
// - Couleur panneaux - Panels color    
Couleur2        = "OrangeRed";    
// Thick X 2 - making decorations thicker if it is a vent to make sure they go through shell
Dec_Thick       = Vent ? Thick*2 : Thick; 
// - Depth decoration
Dec_size        = Vent ? Thick*2 : 0.8;


// Platinenbefestigungen an der bodenplatte
if(BShell==1) {
  // position des AMP  
  ampdx = 27.3;
  ampdy = 17.4;  
  ampx  = 38;
  ampy  = 7;
    
  // Position des Att  
  attdx = 45.2;
  attdy = 45.2;  
  attx  = ampx + 12.7  - attdx;
  atty  = ampy + ampdy + 11.3;
    
  //Position des ADF  
  adfdx = 42.6; //30.6;
  adfdy = 30.6; //42.5;
  adfx  = attx + attdx + 3;
  adfy  = atty + attdy + 14;
    
  my4foots(ampx, ampy, ampdx, ampdy);   // AMP xx, yy, dx,  dy  

  //my4foots(10, 10, 40.5, 40.5);   // Atten 6 bit
  my4foots(attx, atty, attdx, attdy);   // Atten 7 bit

  my4foots(adfx, adfy, adfdx, adfdy);   //ADF435x
  my4foots(80, atty, adfdy, adfdx);   //ADF435x

  //my4foots(80, 70, 78.4, 51.2);   //PIC
  pcbklemm(50, 130, 0, 85.25, 5, 1.6); // PIC
}


//Platinenbefestigung an Rückseite
if (BPanL==1){
    // position des PS
    psdy = 45;
    psdz = 18;  
    psy  = 20;
    psz  = 70;
    translate([0, psy     , psz   ])   myfoot_back();
    translate([0, psy+psdy, psz   ])   myfoot_back();
    translate([0, psy     , psz+psdz]) myfoot_back();
    translate([0, psy+psdy, psz+psdz]) myfoot_back();     
}



module my4foots(xx, yy, dx, dy){
    translate([xx   , yy   ]) myfoot();
    translate([xx+dx, yy   ]) myfoot();
    translate([xx   , yy+dy]) myfoot();
    translate([xx+dx, yy+dy]) myfoot();    
}   

module pcbklemm(xx, yy, dir, lang, hoch, dick){  // xx, yy ist mittelpunkt
    translate([xx, yy, Thick+2.4]) rotate([0,0,dir])
    difference(){
       union(){
         cube([lang+4, dick+4, 5], center=true);   
         translate([-lang/2+1, 0, 2.5-0]) cube([6, dick+4, 10], center=true);   
         translate([ lang/2-1, 0, 2.5-2]) cube([6, dick+4, 10], center=true);              
       }     
       translate([0,0,1]) cube([lang, dick+0.1, 15], center=true);    
    }        
}    



module myfoot(){
    translate([3*Thick+7,Thick+10,Thick/2]){foot(FootDia,FootHole,FootHeight);}
}

module myfoot_back(){
    color(Couleur2) translate([1.4*Thick, -5, 20]) rotate([0,90,0]) myfoot();
}


/////////// - Boitier générique bord arrondis - Generic rounded box - //////////

module RoundBox($a=Length, $b=Width, $c=Height){// Cube bords arrondis
                    $fn=Resolution;            
                    translate([0,Filet,Filet]){  
                    minkowski (){                                              
                        cube ([$a-(Length/2),$b-(2*Filet),$c-(2*Filet)], center = false);
                        rotate([0,90,0]){    
                        cylinder(r=Filet,h=Length/2, center = false);
                            } 
                        }
                    }
                }// End of RoundBox Module

      
////////////////////////////////// - Module Coque/Shell - //////////////////////////////////         

module Coque(){//Coque - Shell  
    Thick = Thick*2;  
    difference(){    
        difference(){//sides decoration
            union(){    
                     difference() {//soustraction de la forme centrale - Substraction Fileted box
                      
                        difference(){//soustraction cube median - Median cube slicer
                            union() {//union               
                            difference(){//Coque    
                                RoundBox();
                                translate([Thick/2,Thick/2,Thick/2]){     
                                        RoundBox($a=Length-Thick, $b=Width-Thick, $c=Height-Thick);
                                        }
                                        }//Fin diff Coque                            
                                difference(){//largeur Rails        
                                     translate([Thick+m,Thick/2,Thick/2]){// Rails
                                          RoundBox($a=Length-((2*Thick)+(2*m)), $b=Width-Thick, $c=Height-(Thick*2));
                                                          }//fin Rails
                                     translate([((Thick+m/2)*1.55),Thick/2,Thick/2+0.1]){ // +0.1 added to avoid the artefact
                                          RoundBox($a=Length-((Thick*3)+2*m), $b=Width-Thick, $c=Height-Thick);
                                                    }           
                                                }//Fin largeur Rails
                                    }//Fin union                                   
                               translate([-Thick,-Thick,Height/2]){// Cube à soustraire
                                    cube ([Length+100, Width+100, Height], center=false);
                                            }                                            
                                      }//fin soustraction cube median - End Median cube slicer
                               translate([-Thick/2,Thick,Thick]){// Forme de soustraction centrale 
                                    RoundBox($a=Length+Thick, $b=Width-Thick*2, $c=Height-Thick);       
                                    }                          
                                }                                          


                difference(){// wall fixation box legs
                    union(){
                        translate([3*Thick +5,Thick,Height/2]){
                            rotate([90,0,0]){
                                    $fn=6;
                                    cylinder(d=16,Thick/2);
                                    }   
                            }
                            
                       translate([Length-((3*Thick)+5),Thick,Height/2]){
                            rotate([90,0,0]){
                                    $fn=6;
                                    cylinder(d=16,Thick/2);
                                    }   
                            }

                        }
                            translate([4,Thick+Filet,Height/2-57]){   
                             rotate([45,0,0]){
                                   cube([Length,40,40]);    
                                  }
                           }
                           translate([0,-(Thick*1.46),Height/2]){
                                cube([Length,Thick*2,10]);
                           }
                    } //Fin fixation box legs
            }

        union(){// outbox sides decorations
            
            for(i=[0:Thick:Length/4]){

                // Ventilation holes part code submitted by Ettie - Thanks ;) 
                    translate([10+i,-Dec_Thick+Dec_size,1]){
                    cube([Vent_width,Dec_Thick,Height/4]);
                    }
                    translate([(Length-10) - i,-Dec_Thick+Dec_size,1]){
                    cube([Vent_width,Dec_Thick,Height/4]);
                    }
                    translate([(Length-10) - i,Width-Dec_size,1]){
                    cube([Vent_width,Dec_Thick,Height/4]);
                    }
                    translate([10+i,Width-Dec_size,1]){
                    cube([Vent_width,Dec_Thick,Height/4]);
                    }
  
                
                    }// fin de for
               // }
                }//fin union decoration
            }//fin difference decoration


            union(){ //sides holes
                $fn=50;
                translate([3*Thick+5,20,Height/2+4]){
                    rotate([90,0,0]){
                    cylinder(d=2,20);
                    }
                }
                translate([Length-((3*Thick)+5),20,Height/2+4]){
                    rotate([90,0,0]){
                    cylinder(d=2,20);
                    }
                }
                translate([3*Thick+5,Width+5,Height/2-4]){
                    rotate([90,0,0]){
                    cylinder(d=2,20);
                    }
                }
                translate([Length-((3*Thick)+5),Width+5,Height/2-4]){
                    rotate([90,0,0]){
                    cylinder(d=2,20);
                    }
                }
            }//fin de sides holes

        }//fin de difference holes
}// fin coque 

////////////////////////////// - Experiment - ///////////////////////////////////////////





/////////////////////// - Foot with base filet - /////////////////////////////
module foot(FootDia,FootHole,FootHeight){
    Filet=2;
    color(Couleur1)   
    translate([0,0,Filet-1.5])
    difference(){
    
    difference(){
            //translate ([0,0,-Thick]){
                cylinder(d=FootDia+Filet,FootHeight-Thick, $fn=100);
                        //}
                    rotate_extrude($fn=100){
                            translate([(FootDia+Filet*2)/2,Filet,0]){
                                    minkowski(){
                                            square(10);
                                            circle(Filet, $fn=100);
                                        }
                                 }
                           }
                   }
            cylinder(d=FootHole,FootHeight+1, $fn=100);
               }          
}// Fin module foot
  
module Feet(){     
//////////////////// - PCB only visible in the preview mode - /////////////////////    
    translate([3*Thick+2,Thick+5,FootHeight+(Thick/2)-0.5]){
    
    %square ([PCBLength+10,PCBWidth+10]);
       translate([PCBLength/2,PCBWidth/2,0.5]){ 
        color("Olive")
        %text("PCB", halign="center", valign="center", font="Arial black");
       }
    } // Fin PCB 
  
    
////////////////////////////// - 4 Feet - //////////////////////////////////////////     
    translate([3*Thick+7,Thick+10,Thick/2]){
        foot(FootDia,FootHole,FootHeight);
    }
    translate([(3*Thick)+PCBLength+7,Thick+10,Thick/2]){
        foot(FootDia,FootHole,FootHeight);
        }
    translate([(3*Thick)+PCBLength+7,(Thick)+PCBWidth+10,Thick/2]){
        foot(FootDia,FootHole,FootHeight);
        }        
    translate([3*Thick+7,(Thick)+PCBWidth+10,Thick/2]){
        foot(FootDia,FootHole,FootHeight);
    }   

} // Fin du module Feet
 


 
 ////////////////////////////////////////////////////////////////////////
////////////////////// <- Holes Panel Manager -> ///////////////////////
////////////////////////////////////////////////////////////////////////

//                           <- Panel ->  
module Panel(Length,Width,Thick,Filet){
    scale([0.5,1,1])
    minkowski(){
            cube([Thick,Width-(Thick*2+Filet*2+m),Height-(Thick*2+Filet*2+m)]);
            translate([0,Filet,Filet])
            rotate([0,90,0])
            cylinder(r=Filet,h=Thick, $fn=100);
      }
}



//                          <- Circle hole -> 
// Cx=Cylinder X position | Cy=Cylinder Y position | Cdia= Cylinder dia | Cheight=Cyl height
module CylinderHole(OnOff,Cx,Cy,Cdia){
    if(OnOff==1)
    translate([Cx,Cy,-1])
        cylinder(d=Cdia,10, $fn=50);
}

//                          <- Square hole ->  
// Sx=Square X position | Sy=Square Y position | Sl= Square Length | Sw=Square Width | Filet = Round corner
module SquareHole(OnOff,Sx,Sy,Sl,Sw,Filet){
    if(OnOff==1)
     minkowski(){
        translate([Sx+Filet/2,Sy+Filet/2,-1])
            cube([Sl-Filet,Sw-Filet,10]);
            cylinder(d=Filet,h=10, $fn=100);
       }
}


 
//                      <- Linear text panel -> 
module LText(OnOff,Tx,Ty,Font,Size,Content){
    if(OnOff==1)
    translate([Tx,Ty,Thick+.5])
    linear_extrude(height = 0.5){
    text(Content, size=Size, font=Font);
    }
}
//                     <- Circular text panel->  
module CText(OnOff,Tx,Ty,Font,Size,TxtRadius,Angl,Turn,Content){ 
      if(OnOff==1) {
      Angle = -Angl / len(Content);
      translate([Tx,Ty,Thick+.5])
          for (i= [0:len(Content)-1] ){   
              rotate([0,0,i*Angle+90+Turn])
              translate([0,TxtRadius,0]) {
                linear_extrude(height = 0.5){
                text(Content[i], font = Font, size = Size,  valign ="baseline", halign ="center");
                    }
                }   
             }
      }
}
////////////////////// <- New module Panel -> //////////////////////

//Frontseite mit Löchern
module FPanL(){
    difference(){
        color(Couleur2)
        Panel(Length,Width,Thick,Filet);
    
 
    rotate([90,0,90]){
        color(Couleur2){
//                     <- Cutting shapes from here ->  
        // Netzschalter    
        SquareHole  (1,11,37,12,20,1); //(On/Off, Xpos,Ypos,Length,Width,Filet)
            
        //SMA-output
        difference(){    
          CylinderHole(1,17,20,6.5);       //(On/Off, Xpos, Ypos, Diameter) 
           SquareHole(1,12,13,10,4.2,1);
        }    

        xd =24;yd=137.5;   // referenzpunkt ist obere linke platinenecke              
        SquareHole  (1,xd,yd-50,98,40.2,1);  // Display  
        
        CylinderHole(1,xd+2.5,    yd-2.5,    3.5);
        CylinderHole(1,xd+2.5+93, yd-2.5,    3.5);
        CylinderHole(1,xd+2.5+93, yd-2.5-55, 3.5);
        CylinderHole(1,xd+2.5   , yd-2.5-55, 3.5);
            
            
        SquareHole  (1,35,10,60,57,1);   // Tastatur   gedruckt: 59,8 x 56,8   
           
        xr=118; yr=45;    
        CylinderHole(1,xr,yr,8);        // rotary encoder mit 2 Tastern        
        CylinderHole(1,xr-9, yr-30, 13); CylinderHole(1,xr-9, yr-30+6, 2.5);
        CylinderHole(1,xr+9, yr-30, 13); CylinderHole(1,xr+9, yr-30+6, 2.5);

//                            <- To here -> 
           }
       }
}

    color(Couleur1){
        translate ([-.5,0,0])
        rotate([90,0,90]){
//                      <- Adding text from here ->          
        TextOn = 0; // 0 für no-text,  1 für text    
            
        LText(TextOn,8,60,"Arial Black",4,"Power");//(On/Off, Xpos, Ypos, "Font", Size, "Text")
        LText(TextOn,8,5,"Arial Black",4,"RF-Out");
        LText(TextOn,24,81,"Arial Black",6,"  A       B        C        D");
        LText(TextOn,100,4,"Arial Black",6," <        >");            
            
        LText(TextOn,80,120,"Arial Black",4,"Display");    
        LText(TextOn,70,40,"Arial Black",4,"Key-Pad"); 
            
//        CText(1,93,29,"Arial Black",4,10,180,0,"1 . 2 . 3 . 4 . 5 . 6");//(On/Off, Xpos, Ypos, "Font", Size, Diameter, Arc(Deg), Starting Angle(Deg),"Text")
//                            <- To here ->
            }
      }
}


// Rückseite mit Löchern
module BPanL(){
    difference(){
        color(Couleur2)
        Panel(Length,Width,Thick,Filet);
               
        rotate([90,0,90]){
            color(Couleur2){
//          <- Cutting shapes from here ->  
            // Netzschalter    
            //SquareHole  (1,11,37,12,20,1);   //(On/Off, Xpos,Ypos,Length,Width,Filet) 
            //CylinderHole(1,17,20,6.5);       //(On/Off, Xpos, Ypos, Diameter)     
            
            links = Width-5;        //x
            unten = 0;              //y
            //usb
            SquareHole  (1,links-31, 11, 13, 14,1);   
                
            //CylinderHole(1,Width-5, 5, 0.5);    
            //CylinderHole(1, 140, 0, 0.5);        
            }    
        }
    }
}    


/////////////////////////// <- Main part -> /////////////////////////

if(TShell==1)
// Coque haut - Top Shell
        color( Couleur1,1){
            translate([0,Width,Height+0.2]){
                rotate([0,180,180]){
                        Coque();
                        }
                }
        }

if(BShell==1)
// Coque bas - Bottom shell
        color(Couleur1){ 
        Coque();
        }

// Pied support PCB - PCB feet
if (PCBFeet==1)
// Feet
        translate([PCBPosX,PCBPosY,0]){ 
        Feet();
        }

// Panneau avant - Front panel  <<<<<< Text and holes only on this one.
//rotate([0,-90,-90]) 
if(FPanL==1)
        translate([Length-(Thick*2+m/2),Thick+m/2,Thick+m/2])
        FPanL();

//Panneau arrière - Back panel
if(BPanL==1)
        color(Couleur2)
        translate([Thick+m/2,Thick+m/2,Thick+m/2])
        BPanL();
        //Panel(Length,Width,Thick,Filet);

