
/* [Platinen Maße] */
// Breite [mm]
pcb_x = 33;
// Tiefe [mm]
pcb_y = 23;
// Dicke [mm]
pcb_z = 0.8;// [0.8, 1.6]

/* [Aushöhlungen der Schalen] */
// Tiefe der Oberschale [mm]
o_schale_z = 6.5;
// Tiefe der Unterschale [mm]
u_schale_z = 3;

/* [Platinen Bohrungen] */
// seitlicher Abstand von der Mitte [mm] (links rechts)
drill_offset_x   = 13.5;
// Abstand von der Mitte in der Tiefe [mm] (vorn hinten)
drill_offset_y   =  17.17/2;
// Durchmesser der PCB-Bohrung [mm]
loch_durchmesser = 3.0;

/* [SMA-Anschluesse] */
// linker SMA: Abweichung von der Mitte, positiv: vorn / negativ: hinten [mm]
sma_links_offset_y  = 0.8;   
// rechter SMA: Abweichung von der Mitte, positiv: vorn / negativ: hinten [mm]
sma_rechts_offset_y = 0.8;

/* [Qualität der Rundungen] */
$fn=40;

/* [STL element to export] */
//Oberschale - Top shell
showTShell          = 0;// [0:No, 1:Yes]
//Unterschale
showBShell          = 1;// [0:No, 1:Yes]
//Platine
showBoard           = 1;// [0:No, 1:Yes]

//cut();


if (showBoard==1)  pcb();
if (showBShell==1) translate([0,0,-0.1]) unterschale("silver");  //silver
if (showTShell==1) rotate([180,0,0]) translate([0,0,-0.1]) oberschale("Gainsboro");
    

module test(){
  hull(){
    translate([-20, 0, 20]) sphere(r=5);
    translate([ 20, 0, 20]) sphere(r=5);
    translate([-20, 0, 40]) sphere(r=5);
    translate([ 20, 0, 40]) sphere(r=5);
  }
}


module cut(){
    difference(){
        union(){
            pcb();
            translate([0,0,-0.1]) unterschale("silver");  //silver
            rotate([180,0,0]) translate([0,0,-0.1]) oberschale("Gainsboro");
            // oberschale("Gainsboro");
        }
        translate([26.2, 0, 0]) cube(27, true);
    } 
}


module schraub_u(){
    translate([ 0,  0, -u_schale_z/2-pcb_z/4]) cylinder(h=u_schale_z-pcb_z/2, r=3, center=true);
    translate([ 0,  0, -pcb_z/4-0.25]) cylinder(h=1, d=loch_durchmesser-0.4, center=true);
    difference(){
      union(){  
        translate([ 0,  0, 1.5-pcb_z/2]) cylinder(h=4, d=loch_durchmesser-0.4, center=true);
        translate([ 0,  0, 3-pcb_z/2]) sphere(d=loch_durchmesser);  
      }    
      for(a = [0 : 90 : 180]) rotate([0,0,a]) cube([4, 0.4, 9], true); 
    }
}


module schraub_o(){
    difference(){
      translate([ 0,  0, -o_schale_z/2-pcb_z/4]) cylinder(h=o_schale_z-pcb_z/2, r=2.2, center=true);
      translate([ 0,  0, 0.1-o_schale_z/2]) cylinder(h=o_schale_z-pcb_z/2, d=loch_durchmesser-0.1, center=true);    
    }
}


module oberschale(c) {
    color(c)
    difference(){
       union(){ 
         translate([0,0, -(o_schale_z)/2]) cube([pcb_x+3, pcb_y+3, o_schale_z], true); 
         translate([0,0, -0.5]) cube([pcb_x+1.9, pcb_y+1.9, 2], true);// passkante aufsetzen
       } 
       translate([0,0, 0.51-(+o_schale_z)/2+1]) cube([pcb_x+1, pcb_y+1, o_schale_z-1+1], true); 
       translate([-pcb_x/2, -sma_rechts_offset_y, -1.5]) cube(7, true);
       translate([ pcb_x/2, -sma_links_offset_y,  -1.5]) cube(7, true);  
       translate([7,7.5,-o_schale_z]) cube([5.2, 2.7, 4], true);  // stromanschluss
    }  
   color(c) union(){ 
     translate([ drill_offset_x,  drill_offset_y, 0]) schraub_o();  
     translate([ drill_offset_x, -drill_offset_y, 0]) schraub_o();  
     translate([-drill_offset_x,  drill_offset_y, 0]) schraub_o();  
     translate([-drill_offset_x, -drill_offset_y, 0]) schraub_o();  
   }   
}  


module unterschale(c) {
    color(c)
    difference(){
       translate([0,0,  -(u_schale_z)/2]) cube([pcb_x+3, pcb_y+3, u_schale_z], true); 
       translate([0,0, 0.51-(+u_schale_z)/2]) cube([pcb_x+1, pcb_y+1, u_schale_z-1], true); 
       translate([0,0, 0]) cube([pcb_x+2.1, pcb_y+2.1, 1], true);    // passkante ausschneiden
       translate([-pcb_x/2, sma_rechts_offset_y, 1.6]) cube(7, true);
       translate([ pcb_x/2, sma_links_offset_y,  1.6]) cube(7, true);  
    } 
    color(c) union(){ 
      translate([ drill_offset_x,  drill_offset_y, 0]) schraub_u();  
      translate([ drill_offset_x, -drill_offset_y, 0]) schraub_u();  
      translate([-drill_offset_x,  drill_offset_y, 0]) schraub_u();  
      translate([-drill_offset_x, -drill_offset_y, 0]) schraub_u();
   }    
}    


module sma(){
    translate([0,0,1.4])  rotate([-90,0,0]) 
    color("Gold") difference(){
      union(){
        translate([0,0,0.75])cube([6.5, 6.5, 1.5], true);                   // boden
        translate([ 0,  0, 9.5/2])cylinder(h=9.5, r=5.2/2, center=true);   // hülse
        translate([ 0,  0, 6])cylinder(h=4, r=6/2, center=true);           // gewinde    
        translate([ 0,  0, -2]) cylinder(h=4, r=1.3/2, center=true);       // mittelpin
        translate([ 2.55,  2.55 ,-2])cube([1, 1, 4], true);                // gnd-pins
        translate([ 2.55, -2.55 ,-2])cube([1, 1, 4], true);
        translate([-2.55,  2.55 ,-2])cube([1, 1, 4], true);
        translate([-2.55, -2.55 ,-2])cube([1, 1, 4], true);
      }
     translate([ 0,  0, 8])cylinder(h=4, r=4/2, center=true);           // frontloch 
   }
}    


module pcb() {
    color("LimeGreen") difference() {
        cube([pcb_x, pcb_y, pcb_z], true);                  // platine
        $fn=20;
        translate([ drill_offset_x,  drill_offset_y, 0]) cylinder(h=3, d=loch_durchmesser, center=true);
        translate([ drill_offset_x, -drill_offset_y, 0]) cylinder(h=3, d=loch_durchmesser, center=true);
        translate([-drill_offset_x,  drill_offset_y, 0]) cylinder(h=3, d=loch_durchmesser, center=true);
        translate([-drill_offset_x, -drill_offset_y, 0]) cylinder(h=3, d=loch_durchmesser, center=true);
    }
    translate([-pcb_x/2, sma_rechts_offset_y,0]) rotate([0,0, 90]) sma();
    translate([ pcb_x/2, sma_links_offset_y, 0]) rotate([0,0,-90]) sma();
}    