	list p=12f675
;***********************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	GP: 	0 < analog ein
;*		1 > Schalttransistor fuer IR-LED
;*		2 > Pulsausgang
;*		3 < high:RS232-Pegel (1=low);  low:TTL-Pegel (1=high)		(GP3/MCLR/V PP)
;*		4 > RS232out 9600 Bps
;*		5 > Test-LED out
;*	
;***********************************************************************
;
; sprut (zero) Bredendiek 05/2011 ... 04/2022
; http://www.sprut.de
;
; IR-Sensor fuer Stromzaehler
;
; Spannungsmessung mit ADC am Pin  GP0
; Schalttransistor fr IR-LED an GP1
;
; Prozessor 12F675 
;
; Prozessor-Takt 4 MHz intern
;
; Die Anzeige erwartet 20 ms Aufloesung vom Sensor
;
;
;***********************************************************************
; Includedatei fr den 12F675 einbinden

;	#include "P12f675.INC"
	#include "p12f675.inc"

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen:
; kein Power on Timer, kein Watchdog, int-Oscillator, kein Brown out
	__CONFIG	_MCLRE_OFF & _PWRTE_OFF & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _BODEN_OFF


;***********************************************************************
; Variablen festlegen
; 64 Byte:   20h ... 5Fh 

count		equ	0x20	; universeller zhler
loops		equ	0x21	; timer fr wait
loops2		equ	0x22	; timer fr wait

;16 Bit Rechenregister
f0		equ	0x23	; 
f1		equ	0x24	; 
f2		equ	0x25	; 
xw0		equ	0x26	; 
xw1		equ	0x27	; 
xw2		equ	0x28	; 
;16 Bit Durchschnittspegel
dp0		equ	0x29	; 
dp1		equ	0x2A	; 
;16 Bit Durchschnittsrauschen
dr0		equ	0x2B	; 
dr1		equ	0x2C	; 
;16 Bit aktueller Pegel
p0		equ	0x2D	; 
p1		equ	0x2E	; 

Fehler		equ	0x2F
; RS232
cycl_1		equ	0x30
cycl_2		equ	0x31
RsByte		equ	0x32
RsByte2		equ	0x33
;16 Bit Rauschen
r0		equ	0x34
r1		equ	0x35
; Zeit
T0		equ	0x36	
T1		equ	0x37
	
TM0		equ	0x38
TM1		equ	0x39
TM2		equ	0x3A
TM3		equ	0x3B

Flags		equ	0x3C
; Rechenregister fuer division
g0		equ	0x3D
g1		equ	0x3E
g2		equ	0x3F
; Dezimalstellen
HdT		equ	0x40
HdH		equ	0x41
HdZ		equ	0x42
HdE		equ	0x43
HdX		equ	0x44
; BCD-rotationszaehler
ro0		equ	0x45
ro1		equ	0x46
ro2		equ	0x47
roAdr		equ	0x48
; interrupts
w_copy		equ	0x5D 
s_copy		equ	0x5E 
p_copy		equ	0x5F 


#define	Timeout		Flags, 0
#define	DatenDa		Flags, 1
#define	IrLED		GPIO, 1
#define	PulsePin	GPIO, 2
#define	TTL		GPIO, 3
#define	RsTx		GPIO, 4
#define	TestLED		GPIO, 5


;***********************************************************************
; EEPROM
;***********************************************************************

	org	H'2100'		; Adresse des EEPROM
	de	0		; 0
	de	0		; ro1
	de	0 		; ro2

;***********************************************************************
	org	0x00

	goto	Init


;***********************************************************************
; die Interuptserviceroutine
;***********************************************************************
	org 	4 	
intvec
	movwf	w_copy		; w retten
	swapf	STATUS, w 	; STATUS retten
	bcf	STATUS, RP0	; Bank 0
	movwf	s_copy	
	movf	PCLATH, W
	movwf	p_copy
	clrf	PCLATH		; Bank 0 

	incf	T0, f		; 0.524288 s
	skpnz
	incf	T1, f		; 134.218 s
	skpnz
	bsf	Timeout		;34359 s = 572 min = 9,5 h	

Int_end
	bcf	PIR1, TMR1IF
	movf	p_copy, W
	movwf	PCLATH
	swapf	s_copy, w	; STATUS zurck
	movwf	STATUS 
	swapf	w_copy, f	; w zurck mit flags
	swapf	w_copy, w
	retfie


;***********************************************************************
; HEX-Tabelle
;***********************************************************************
ASCII
	addwf	PCL, f
	retlw	'0'	
	retlw	'1'
	retlw	'2'	
	retlw	'3'
	retlw	'4'	
	retlw	'5'
	retlw	'6'	
	retlw	'7'
	retlw	'8'	
	retlw	'9'
	retlw	'A'	
	retlw	'B'
	retlw	'C'	
	retlw	'D'
	retlw	'E'	
	retlw	'F'
	retlw	'?'	
	retlw	'?'

;***********************************************************************
; Initialisierung
;***********************************************************************
Init
	clrf	Flags
	clrf	TM0
	clrf	TM1
	clrf	TM2
	clrf	TM3

	clrf	ro0
	movlw	1
	call	EERead
	movwf	ro1
	movlw	2
	call	EERead
	movwf	ro2


	; IO-Pins
	bcf	STATUS, RP0	; Bank 0
	clrf	GPIO		; alles aus!
	movlw	0x07
	movwf	CMCON		; Comparator aus
	bsf	STATUS, RP0	; Bank 1
	bcf	TRISIO,1	; GP1 output IR-LED
	bcf	TRISIO,2	; GP2 output fr Pulse
	bcf	TRISIO,4	; GP4 output fr RS232
	bcf	TRISIO,5	; GP5 output fr Test-LED
	bcf	STATUS, RP0	; Bank0

	; internen Taktgenerator kalibrieren
	bsf	STATUS, RP0	; Bank 1
	call	0x3FF
	movwf	OSCCAL		; 4-MHz-Kalibrierung
	bcf	STATUS, RP0	; Bank 0

	; kein Interrupt
	bcf	INTCON, GIE	; Int deaktiviert

	movlw	'0'			; DEBUG
	call	RsSendW			; DEBUG

; ADC initialisieren
	; ADC einschalten
	BSF	ADCON0, ADON	; ADON=1
	; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, CHS1	; ADCHS1=0
	BCF	ADCON0, CHS0	; ADCHS0=0
	; ADC speed fr 1,25 ... 5 MHz einstellen
	BSF	STATUS,RP0	; Bank1
	clrf	ANSEL
	BSF	ANSEL, ADCS0	; ADCS0=1 Fosc/8
	; AN0,1 analog
	BSF	ANSEL, ANS0	; AN1=analog
	BCF	STATUS,RP0	; Bank0
	; Daten linksbndig
	BCF	ADCON0, VCFG	; RA2=digital
	BCF	ADCON0, ADFM	; ADFM=0 linksbuendig

	
	movlw	'1'			; DEBUG
	call	RsSendW			; DEBUG


; Startwert fuer den Durchschnitt festlegen
	bsf	TestLED		; DEBUG
	call	UMessen1
	bcf	TestLED		; DEBUG
	movfw	f0
	movwf	dp0
	movfw	f1		; Pegel gleich aktueller Pegel
	movwf	dp1
	clrf	dr1		; Rauschen 50 mV
	movlw	D'10'
	movwf	dr0		

	movlw	'2'			; DEBUG
	call	RsSendW			; DEBUG
	call	RsNL			; DEBUG


; Timer 1 als Stoppuhr, 1MHz:8 = 125kHz = 8 us
; Ueberlauf nach 0,524 s
	clrf	T1CON
	clrf	T0
	clrf	T1
	; 8:1 Vorteiler
	bsf	T1CON, T1CKPS0
	bsf	T1CON, T1CKPS1
	bsf	T1CON, TMR1ON
	clrf	TMR1L
	clrf	TMR1H
	; int fuer Timer1 erlauben
	clrf	INTCON
	bcf	PIR1, TMR1IF
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	clrf	PIE1
	bsf	PIE1, TMR1IE
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten
	bsf	INTCON, PEIE
	bsf	INTCON, GIE



;***********************************************************************
; Main 
;***********************************************************************
Mainloop
	; Messen
	bsf	TestLED			; DEBUG
	call	UMessen1	; AN0 nach f1,f0
	bcf	TestLED			; DEBUG
;	call	RsP		; MomentPower           -> RS232
	call	Durchschnitt	; durchschnittshelligkeit berechnen
;	call	RsDP		; DurchschnittsPower    -> RS232
;	Call	RsR		; Rauschen              -> RS232
;	Call	RsDR		; durchschnittsrauschen -> RS232
	call	Rot		; rote Marke erkannt?

	btfsc	DatenDa
	call	Rechne

	call	RsW		; Leistung in Watt  	-> RS232
	call	RsRo		; Scheibendrehungen 	-> RS232

	call	RsNL		; Zeilenwechsel		-> RS232
	call	wait20ms	; Wartezeit wird durch RS232-Routinen verfaelscht
	goto	Mainloop


;***********************************************************************
; Spannung wandeln nach f1, f0 
; ADC-clock = 4MHz/8 = 500 kHz
; 11-Takte = 22 us
;***********************************************************************
UMessen1
	bsf	IrLED		; LED an
	nop			; 1 us zum LED "aufwrmen"
	movlw	33		; 100 us aquisition-time fuer ADC Eingang
	movwf	f0
loop0
        decfsz  f0, F		; loop complete?
        goto    loop0		; no, go again

	BSF	ADCON0, 1	; ADC starten
loop
	BTFSC	ADCON0, 1	; ist der ADC fertig?
	GOTO	loop		; nein, weiter warten
	bcf	IrLED		; LED aus , nach ca 25 us
	movfw	ADRESH		; obere  8 Bit auslesen
	movwf	f1		; obere  8-Bit nach f1 und p1
	movwf	p1
	bsf	STATUS,RP0	; Bank1
	movfw	ADRESL		; untere 2 Bit auslesen
	bcf	STATUS,RP0	; Bank0
	movwf	f0		; untere 2-Bit nach f0 und p0
	movwf	p0
	return


;***********************************************************************
; Durchschnittshelligkeit bestimmen
; input: f1, f0
;***********************************************************************
Durchschnitt
	; f = dp
	; xw = dp/64
	movfw	dp1
	movwf	f1
	movwf	xw1

	movfw	dp0
	movwf	f0
	movwf	xw0

	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; dp/2
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; dp/4
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; dp/8
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; dp/16
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; dp/32
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; dp/64

	call	Sub16		; f = dp x 63/64

	; xw = p/64
	movfw	p1
	movwf	xw1
	movfw	p0
	movwf	xw0

	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; p/2
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; p/4
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; p/8
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; p/16
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; p/32
	bcf	STATUS, C
	rrf	xw1, f
	rrf	xw0, f		; p/64

	call	Add16		; f = dp x 63/64  + p/64

	movfw	f1
	movwf	dp1
	movfw	f0
	movwf	dp0		; dp = dp x 63/64  + p/64


	;*** und nun das rauschen***************************
	; in f steht nun noch der dp-Wert
	; xw = p
	movfw	p1
	movwf	xw1
	movfw	p0
	movwf	xw0
	call	Sub16		; f=dp-p
	skpnc
	call	Neg16		; invertieren f := 0-f

	; aktueller Rauschwert nun in f1, f0
	movfw	f1
	movwf	r1
	movfw	f0
	movwf	r0

	bcf	STATUS, C
	rrf	f1, f
	rrf	f0, f		; r/2
	bcf	STATUS, C
	rrf	dr1, f
	rrf	dr0, f		; dr/2
	
	movfw	dr1
	movwf	xw1
	movfw	dr0
	movwf	xw0

	call	Add16

	movfw	f1
	movwf	dr1
	movfw	f0
	movwf	dr0		; dr = dr/2 + r/2

	return


;***********************************************************************
; rote Marke erkennen
; mit ST-funktion zum entprellen
;***********************************************************************
Rot
	; rote Markierung reflektiert schlechter
	; das fuehrt zu einer erhoehten Spannung
	clrf	f2
	movfw	dp1		; f = dp
	movwf	f1
	movfw	dp0
	movwf	f0

	; 125mv = 0x0666
	; 250mv = 0x0CCC
	; 500mv = 0x1999  =  102 x 64 = 6553
	;   1 V = 0x3330
	clrf	xw2
	btfsc	PulsePin
	goto	Rot125
Rot250
	movlw	0x0C	; puls aus, also 250mV offset fordern
	movwf	xw1
	movlw	0xCC
	movwf	xw0
	goto	RotAdd

Rot125
	movlw	0x06	; puls an, also 125mV offset genug
	movwf	xw1
	movlw	0x66
	movwf	xw0
	goto	RotAdd

RotAdd
	call	Add24		; f = dp +offset

	clrf	xw2
	movfw	p1		; xw = p
	movwf	xw1
	movfw	p0
	movwf	xw0

	call	Sub24		; 24 bit f:=f-xw = (dp + offset) - p
	bc	RotAn
RotAus
	bcf	PulsePin
	return
RotAn
	btfss	PulsePin
	call	Zeitnahme	; low-high-Flanke des Pulses erkannt
	bsf	PulsePin	
	return


;***********************************************************************
; Zeit fuer die Scheibenderehung ermitteln
; 
; output : TM3-TM2-TM1-TM0    Drehzeit in 8 us increments
;***********************************************************************
Zeitnahme
	; der timer 2 bleibt fuer 16 Zyklen stehen, das kompensiere ich
	; durch das Laden von 2 in TMR1L
	bcf	T1CON, TMR1ON	; timer 1 stoppen
	movfw	TMR1L
	movwf	TM0
	movfw	TMR1H
	movwf	TM1
	movfw	T0
	movwf	TM2
	movfw	T1
	movwf	TM3
	movlw	2
	movwf	TMR1L
	clrf	TMR1H
	clrf	T0
	clrf	T1
	nop
	bsf	DatenDa
	bsf	T1CON, TMR1ON	; timer 1 starten

	

	; bcd zaehler
	; 999.999 drehungen = 13 MWh
	incf	ro0, f
	movfw	ro0		; xxxx1010
	andlw	0x0F
	xorlw	0x0A
	bnz	BCD_End
	movlw	6
	addwf	ro0, f
	movfw	ro0		; 1010xxxx
	andlw	0xF0
	xorlw	0xA0
	bnz	BCD_End
	movlw	0x60
	addwf	ro0, f

	incf	ro1, f
	movfw	ro1	
	andlw	0x0F
	xorlw	0x0A
	bnz	BCD_EE1
	movlw	6
	addwf	ro1, f
	movfw	ro1	
	andlw	0xF0
	xorlw	0xA0
	bnz	BCD_EE1
	movlw	0x60
	addwf	ro1, f

	incf	ro2, f
	movfw	ro2	
	andlw	0x0F
	xorlw	0x0A
	bnz	BCD_EE21
	movlw	6
	addwf	ro2, f
	movfw	ro2	
	andlw	0xF0
	xorlw	0xA0
	bnz	BCD_EE21
	movlw	0x60
	addwf	ro2, f

BCD_EE21
	movlw	2
	movwf	roAdr
	movfw	ro2
	call	EEWrite

BCD_EE1
	movlw	1
	movwf	roAdr
	movfw	ro1
	call	EEWrite

BCD_End
	return


;***********************************************************************
; Berechne die Leistung
; 
; input : TM3-TM2-TM1-TM0    Drehzeit in 8 us increments
;***********************************************************************
; fuer AN617-Division ist der RAM zu knapp
Rechne
	bcf	DatenDa
; Berechnung mit 1 W Aufloesung
; Leistung [Watt] = 48 000 / Drehzeit [Sekunde]
; Leistung [Watt] = 6.000.000.000 / Drehzeit [8 us] (0x01 65 A0 BC 00)		TM3..TM0
; Leistung [Watt] =    23.437.500 / Drehzeit [2,048 ms] (0x01 65 A0 BC)		TM3..TM1
; Leistung [Watt] =        91.553 / Drehzeit [0,5243 s]    (0x01 65 A1)		TM3..TM2
; Berechnung mit 10W Aufloesung
; Leistung [10 W] =     2.343.750 / Drehzeit [2,048 ms]    (0x23 C3 46)		TM3..TM1

	movfw	TM3
	iorwf	TM2, w
	bz	RechneOver	; >90kW
	iorwf	TM1, w
	bnz	Rechne1

	; Zaehlergebnis ist 0	; failsave Anzeige '----'
	movlw	'-'
	movwf	HdT
	movwf	HdH
	movwf	HdZ
	movwf	HdE
	return

RechneOver
	; Zaehlergebnis ist <255 P>90kW	; failsave Anzeige '****'
	movlw	'*'
	movwf	HdT
	movwf	HdH
	movwf	HdZ
	movwf	HdE
	return

Rechne1
	movlw	0x23
	movwf	f2
	movlw	0xC3
	movwf	f1
	movlw	0x46
	movwf	f0

	; obere 24 Bit der Drehzeit -> xw
	movfw	TM1
	movwf	xw0
	movfw	TM2
	movwf	xw1
	movfw	TM3
	movwf	xw2

	call	Div24			; f = f/xw

	call	Hex2Dez16

	return


;**************************************************************
; positiven 16 Bit Wert (f1,f0) in 4 dezimale Ziffern wandeln
;
; input: f1-f0
; output HdT-HdH-HdZ-HdE in  ASCII
;**************************************************************
; 16-bit(f1,f0) in 4-stellen Bcd (T,H,Z,E)
;             1000 = 0000 03E8 h
;              100 = 0000 0064 h
;               10 = 0000 000A h
;                1 = 0000 0001 h
Hex2Dez16			
	clrf	f2

	movlw	0x00		; 1000 = 0000 03E8 h
	movwf	xw2
	movlw	0x03
	movwf	xw1
	movlw	0xE8
	movwf	xw0
	clrf	HdX
	decf	HdX, f
HdLoop5
	incf	HdX, f
	call	Sub24	
	btfss	STATUS, C	; berlauf
	goto	HdLoop5		; Stelle 1 mehr
	call	Add24
	movfw	HdX
	; Test auf eberlauf , vereinfacht >7999
	andlw	0xF8		; >8 ?
	bnz	Over		; ja: ueberlauf
	movfw	HdX
	iorlw	'0'
	movwf	HdT
	
	movlw	0x00		; 100 = 00 00 64 h
	movwf	xw2
	movwf	xw1
	movlw	0x64
	movwf	xw0
	clrf	HdX
	decf	HdX, f
HdLoop3
	incf	HdX, f
	call	Sub24	
	btfss	STATUS, C	; berlauf
	goto	HdLoop3		; Stelle 1 mehr
	call	Add24
	movfw	HdX
	iorlw	'0'
	movwf	HdH

	movlw	0x00		; 10 = 00 00 0A h
	movwf	xw2
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	clrf	HdX
	decf	HdX, f
HdLoop4
	incf	HdX, f
	call	Sub24	
	btfss	STATUS, C	; berlauf
	goto	HdLoop4		; Stelle 1 mehr
	call	Add24
	movfw	HdX
	iorlw	'0'
	movwf	HdZ

	movfw	f0
	iorlw	'0'
	movwf	HdE
	return

Over	; >7999		'////'
	movlw	'/'
	movwf	HdT
	movwf	HdH
	movwf	HdZ
	movwf	HdE
	return


;***********************************************************************
; Mathematik-Routinen 
;
;***********************************************************************
; 16 Bit invertierung (Vorzeichenwechsel)
; input:  f1,f0
; output: f1,f0
;***********************************************************************
Neg16
	movfw	f1
	movwf	xw1
	movfw	f0
	movwf	xw0
	clrf	f1
	clrf	f0
	call	Sub16
	return


;***********************************************************************
; 24 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
;***********************************************************************
Sub24				; 24 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen

	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    sb0
	movlw   0x01		; borgen von f1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb0
	subwf   f2    ,f        ; borgen von f2

	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf

sb0     movf    xw1, w		; f1=f1-xw1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb1
	movlw   0x01		; borgen von f2
	subwf   f2    ,f

        btfss   STATUS,C
	bsf	Fehler, C	; Unterlauf

sb1     movf    xw2,w		; f2=f2-xw2
        subwf   f2, f

        btfss   STATUS,C
       	bsf	Fehler, C	; Unterlauf

	bcf	STATUS, C	; C-Flag invertieren
	btfsc	Fehler, C
	bsf	STATUS, C
	return


;***********************************************************************
; 16 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
;***********************************************************************
Sub16                           ; 16 bit f:=f-xw 
         clrf    Fehler          ; extraflags lschen 

         movf    xw0, w          ; f0:=f0-xw0
         subwf   f0, f

         btfsc   STATUS,C
         goto    Sub16a
         movlw   0x01            ; borgen von f1
         subwf   f1, f

         btfss   STATUS,C
         bsf     Fehler, C       ; Unterlauf

Sub16a
         movf    xw1,w           ; f1:=f1-xw1
         subwf   f1    ,f

         btfss   STATUS,C
         bsf     Fehler, C       ; Unterlauf

         bcf     STATUS, C       ; C-Flag invertieren
         btfsc   Fehler, C
         bsf     STATUS, C
         return


;***********************************************************************
;24 bit Adition, C-Flag bei berlauf gesetzt
;***********************************************************************
Add24 				; 24-bit add: f = f + xw
	movf	xw0,w		; low byte
	addwf	f0,f 		; low byte add

	movf	xw1,w 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,w 		; add C if it was set
	addwf	f1,f 		; high byte add if NZ
	
	movf	xw2,w		; high byte 
	btfsc	STATUS,C	; berspringe falls C nicht gesetzt 
	incfsz	xw2,w		; addiere C falls gesetzt 
	addwf	f2,f		; next byte add wenn  NZ 

	return 			; fertig


;***********************************************************************
;16 bit Adition, C-Flag bei berlauf gesetzt
;***********************************************************************
Add16 				; 24-bit add: f = f + xw
	movf	xw0,w		; low byte
	addwf	f0,f 		; low byte add

	movf	xw1,w 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,w 		; add C if it was set
	addwf	f1,f 		; high byte add if NZ
	
	return 			; fertig


;***********************************************************************
; primitive 24 bit Division 	f:= f / xw
; sehr langsam
;***********************************************************************
Div24
	clrf	g0
	decf	g0, f
	clrf	g1
	decf	g1, f
	clrf	g2
	decf	g2, f
Div24Loop
	incf	g0, f
	btfsc	STATUS, Z
	incf	g1, f
	btfsc	STATUS, Z
	incf	g2, f
	call	Sub24		;
	btfss	STATUS, C	;berlauf
	goto	Div24Loop	;Stelle 1 mehr
	movfw	g0
	movwf	f0
	movfw	g1
	movwf	f1
	movfw	g2
	movwf	f2
	return


;***********************************************************************
; RS232-Routinen
;
;***********************************************************************
; sende avg-Rausch (dr1,dr0)
;***********************************************************************
RsDR
	movlw	'D'
	call	RsSendW
	movlw	'R'
	call	RsSendW
	movlw	':'
	call	RsSendW
	movfw	dr1
	call	RsSend8
	movfw	dr0
	call	RsSend8
	movlw	' '
	call	RsSendW
	return

;***********************************************************************
; sende avg-power (dp1,dp0)
;***********************************************************************
RsDP
	movlw	'D'
	call	RsSendW
	movlw	'P'
	call	RsSendW
	movlw	':'
	call	RsSendW
	movfw	dp1
	call	RsSend8
	movfw	dp0
	call	RsSend8
	movlw	' '
	call	RsSendW
	return

;***********************************************************************
; sende rauschen (r1,r0)
;***********************************************************************
RsR
	movlw	'R'
	call	RsSendW
	movlw	':'
	call	RsSendW
	movfw	r1
	call	RsSend8
	movfw	r0
	call	RsSend8
	movlw	' '
	call	RsSendW
	return

;***********************************************************************
; sende power (p1,p0)
;***********************************************************************
RsP
	movlw	'P'
	call	RsSendW
	movlw	':'
	call	RsSendW
	movfw	p1
	call	RsSend8
	movfw	p0
	call	RsSend8
	movlw	' '
	call	RsSendW
	return

;***********************************************************************
; sende Watt (HdT..HdE)
;***********************************************************************
RsW
	movlw	'W'
	call	RsSendW
	movlw	'='
	call	RsSendW
	movfw	HdT
	call	RsSendW
	movfw	HdH
	call	RsSendW
	movfw	HdZ
	call	RsSendW
	movfw	HdE
	call	RsSendW
	movlw	'0'
	call	RsSendW
	movlw	'W'
	call	RsSendW
	movlw	' '
	call	RsSendW
	return

;***********************************************************************
; sende Zahl der Rotationen (ro2, ro1, ro0)
;***********************************************************************
RsRo
	movlw	'R'
	call	RsSendW
	movlw	'o'
	call	RsSendW
	movlw	':'
	call	RsSendW
	movfw	ro2
	call	RsSend8
	movfw	ro1
	call	RsSend8
	movfw	ro0
	call	RsSend8
	movlw	' '
	call	RsSendW
	return

;***********************************************************************
; sende new line
;***********************************************************************
RsNL
	movlw	0x0A
	call	RsSendW
	movlw	0x0D
	call	RsSendW
	return

;***********************************************************************
; sende Zeichen in w als zweistelligen ascii-string
;***********************************************************************
RsSend8
	movwf	RsByte2

	swapf	RsByte2, w
	andlw	0x0F
	call	ASCII
	call	RsSendW

	movfw	RsByte2
	andlw	0x0F
	call	ASCII
	call	RsSendW

	return

;***********************************************************************
;senden des Bytes, das im Register W steht 
;***********************************************************************
RsSendW				; Ausgabe eines Bytes seriell	
	
	btfss	TTL
	goto	RsSendWTTL
	
	; RES232-Pegel 1->low   0->high   
	bcf	INTCON, GIE
	movwf	RsByte		; Byte in w
	movlw	8		; es werden 8 Bit gesendet
	movwf 	cycl_1
	bcf	RsTx
	call	Warte_s		; 1 Stopbit (1)
	bsf	RsTx
	call 	Warte_s		; 1 Startbit (0)

Send_1	rrf	RsByte, f	; aktuelles Bit in das Carry-Flag schieben
	btfsc	STATUS, C
	bcf	RsTx		; Lo wenn Bit = 1
	btfss	STATUS, C
	bsf	RsTx		; Hi wenn Bit = 0
	call	Warte_s		; 1 Bit lang warten
	decfsz	cycl_1, f	; waren das schon 8 Bit?
	goto	Send_1		; nein, es geht weiter
	bcf	RsTx		; Byte zuende, 1 Stoppbit (1) senden
	call 	Warte_s	
	bsf	INTCON, GIE	;
	return

	
RsSendWTTL
	; TTL-Pegel 1->high   0->low   
	bcf	INTCON, GIE
	movwf	RsByte		; Byte in w
	movlw	8		; es werden 8 Bit gesendet
	movwf 	cycl_1
	bsf	RsTx
	call	Warte_s		; 1 Stopbit (1)
	bcf	RsTx
	call 	Warte_s		; 1 Startbit (0)

Send_1a	rrf	RsByte, f	; aktuelles Bit in das Carry-Flag schieben
	btfsc	STATUS, C
	bsf	RsTx		; Lo wenn Bit = 1
	btfss	STATUS, C
	bcf	RsTx		; Hi wenn Bit = 0
	call	Warte_s		; 1 Bit lang warten
	decfsz	cycl_1, f	; waren das schon 8 Bit?
	goto	Send_1a		; nein, es geht weiter
	bsf	RsTx		; Byte zuende, 1 Stoppbit (1) senden
	call 	Warte_s	
	bsf	INTCON, GIE	;
	return	
	
;**********************************************************
; ein Bit Zeitverzoegerung mit einer Warteschleife
; Timing mu genau stimmen (5%)
;
; senden            4 MHz    10 MHz
; 2400 Bps =          69d    173d
; 9600 Bps =          16d     43d
;***********************************************************************
Warte_s	movlw	D'15'		; 9600 Bps / 4 MHz senden
	movwf	cycl_2
Warte1				; 6 Zyklen Schleife
	nop
	nop
	nop
	decfsz	cycl_2, 1	
	goto	Warte1
	return


;***********************************************************************
; 75 ms warten
;***********************************************************************
wait75ms
	movlw	D'75'		; 75ms
	movwf	loops	
	goto	WAIT


;***********************************************************************
; 20 ms warten
;***********************************************************************
wait20ms
	movlw	D'20'		; 20ms
	movwf	loops	
	goto	WAIT


;***********************************************************************
;Zeitverzgerung um loops * 1 ms
; 4 MHz externer Takt bedeutet 1 MHz interner Takt
; also dauert 1 ms genau 1000 Befehle
; 100 Schleifen a 10 Befehle sind 1000 Befehle = 1 ms
WAIT
top     movlw   .100           ; timing adjustment variable (1ms)
        movwf   loops2
top2    nop                    ; sit and wait
        nop
        nop
        nop
	nop
        nop
        nop
        decfsz  loops2, F      ; inner loops complete?
        goto    top2           ; no, go again
                               ;
        decfsz  loops, F       ; outer loops complete?
        goto    top            ; no, go again
        retlw   0              ; yes, return from subWAIT


;***********************************************************************
;  EEPROM-Routine fr 12F675
;
;***********************************************************************
; 12F675 hat 256 EEPROM-Zellen
; 1 000 000 Schreibzyklen sind garantiert
;				
;***********************************************************************
; lesen des EEPROM  (w) -> w
;
; input:  Adresse in W
; output: W
;
;***********************************************************************
EERead
	BSF    STATUS, RP0     ; EEADR liegt in der Bank 1 
	MOVWF  EEADR           ; schreibe die Adresse in EEADR 
	BSF    EECON1, RD      ; EEPROM Leseproze starten 
	MOVF   EEDAT, W        ; Die Daten der EEPROM Zelle nach W kopieren 
	BCF    STATUS, RP0     ; Bank 0 
	RETURN 


;***********************************************************************
; beschreiben des EEPROM;   w -> (roAdr)
;
; input: Adresse ist in roAdr
;        Wert in w
;***********************************************************************
EEWrite
	BSF	STATUS, RP0	; der Bank 1 
EEWait
	BTFSC	EECON1, WR  	;L ist letzter zyklus fertig?
	goto	EEWait
	MOVWF	EEDATA		; w wollen wir schreiben
	MOVFW	roAdr		; beim 12F675 steht in beiden Banken das gleiche
	MOVWF	EEADR		; Die Zelle (roAdr) soll beschrieben werden
	BSF	EECON1, WREN	; nun ist Schreiben erlaubt
EEW_GIE
	BCF	INTCON, GIE	; verbieten aller Interrupts
	BTFSC	INTCON,GIE	; See AN576
	GOTO	EEW_GIE
	; Die folgenden 5 Zeilen mssen genau so im Code stehen!!!
	MOVLW	0x55		;
	MOVWF	EECON2		; schreibe 55h nach EECON2
	MOVLW	0xAA		;
	MOVWF	EECON2 		; schreibe AAh nach EECON2
	BSF	EECON1, WR  	; starte den Schreibzyklus
	BSF	INTCON, GIE	; Interrupts wieder erlauben , falls noetig
	BCF	STATUS, RP0	; Bank 0
	RETURN 

;***********************************************************************

	end


