/*********************************************************************
 * FileName:        user.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         sprut
 * Copyright:       2007-2010 Joerg Bredendiek (sprut)
 *
 *
 ********************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef USER_H
#define USER_H



/** I N C L U D E S **********************************************************/
#include "system\usb\usb.h"
#include "system\typedefs.h"


/** D E F I N I T I O N S ****************************************************/
/* 28-Pin-Testplatinen-Test Version */
#define MINOR_VERSION   0x09    //Firmware-Version = 09   string in usbdsc.c anpassen !
#define MAJOR_VERSION   0x02    //USB4a            = 02

//LCD
#define	LCD_E2			LATCbits.LATC0	//enable display 2
#define	LCD_E1			LATBbits.LATB0  //enable display 1
#define	LCD_RS			LATBbits.LATB2
#define	LCD_RW			LATBbits.LATB3
#define	LCD_D4			LATBbits.LATB4
#define	LCD_D5			LATBbits.LATB5
#define	LCD_D6			LATBbits.LATB6
#define	LCD_D7			LATBbits.LATB7

//Schieberegister
#define	SR_IN			LATBbits.LATB0
#define	SR_TAKT			LATBbits.LATB1
#define	SR_OUT			LATCbits.LATC7



/** S T R U C T U R E S ******************************************************/

// IO, ADC, FRQin, 12MHz, I2C, LCD, TMR1-3, CCP1, CCP2, RS232, EEPROM, KEY, LED


typedef union DATA_PACKET
{
    byte _byte[USBGEN_EP_SIZE];  	// for byte access
    word _word[USBGEN_EP_SIZE/2];	// for word access(USBGEN_EP_SIZE must be even)
    struct
    {
        enum
        {
            READ_VERSION    = 0x00,
            LED_ONOFF       = 0x31,
            READ_SWITCH     = 0x32,
            RD_ADC          = 0x37,
			SET_AN			= 0x38,
			SET_PWM			= 0x39,
			SET_SIGNAL		= 0x3B,
			READ_DATA		= 0x3D,

			SET_ADRESS		= 0x42,
			SET_VPP			= 0x43,
			READ_EDATA		= 0x44,
			WRITE_EDATA		= 0x45,

			SYS_IO			= 0x50,
			SYS_ADC			= 0x51,
			SYS_FRQ			= 0x52,
			SYS_SPI			= 0x53,
			SYS_I2C			= 0x54,
			SYS_LCD1		= 0x55,
			SYS_LCD2		= 0x56,
			SYS_PWM1		= 0x57,
			SYS_PWM2		= 0x58,
			SYS_RS232		= 0x59,
			SYS_EEPROM		= 0x5A,
			SYS_KEY			= 0x5B,
			SYS_STEP4		= 0x5C,
			SYS_STEP1		= 0x5D,
			SYS_STEP2		= 0x5E,
			SYS_STEP3		= 0x5F,
			SYS_L297_1		= 0x60,
			SYS_L297_2		= 0x61,
			SYS_L297_3		= 0x62,
			SYS_L297_4		= 0x63,
			SYS_ServoB		= 0x64,
			SYS_ServoC		= 0x65,
			SYS_SR			= 0x66,
			SYS_MWIRE		= 0x67,
			SYS_COUNTER_0	= 0x68,
			SYS_COUNTER_3	= 0x69,

			SYS_TMR			= 0x6A,
			SYS_LED			= 0x6B,

            RESET           = 0xFF
        }CMD;
        byte len;
    };
    struct
    {
        unsigned :8;
        byte ID;
    };
    struct
    {
        unsigned :8;
        word word_data;
    };
} DATA_PACKET;


//typedef char T_BESCH;


// ABCD-Schrittmotorstellung
typedef struct T_STEP
{
	byte		step;
	byte		running;
	byte		mode;
	byte		periode;
	int			schritte;
	int			gone;
	byte		besch[8];
} T_STEP;


// L297_Schrittmotorstellung
typedef struct T_L297
{
	byte		running;
	BYTE		mode;
	byte		periode;
	int			schritte;
} T_L297;


/** P U B L I C  P R O T O T Y P E S *****************************************/
void UserInit(void);
void ProcessIO(void);


/** P R I V A T E  P R O T O T Y P E S ***************************************/
void ServiceRequests(void);

void SleepUs(unsigned int us);
void SleepMs(unsigned int ms);

void readEdata(void);
void writeEdata(void);
void ReadADC(void);
void initPWM(void);

void UP_IO(void);
void UP_ADC(void);
void UP_FRQ(void);
void UP_RS232(void);
void RS232_run(void);

//unsigned char I2C_ready(void);
void UP_I2C(void);
void UP_SPI(void);
void UP_MWIRE(void);
void UP_SR(void);
void UP_LCD(void);
void UP_PWM1(void);
void UP_PWM2(void);
void UP_EEPROM(void);

void UP_STEPuni(char kanal);
void StepBeschInit(byte kanal);
void stepUnirun (char kanal);

void UP_L297_Uni(char kanal);
void L297_Unirun(char kanal);

void UP_ServoB(void);
void ServoB_run(void);
void UP_ServoC(void);
void ServoC_run(void);

void UP_Counter0(void);
void UP_Counter3(void);

#endif	// USER_H

/****  E N D E  *********************************************/
