	list p=12F683
;**************************************************************
;*
;* Pinbelegung
;*	----------------------------------	
;*	GPIO: 	0 > Toggel
;*		1 < RC5-code
;*		2 > CCP1
;*		3 < 1-TV / 0-VCR
;*		4 > on/Off 1  on bei >0%
;*		5 > on/off 2  on bei 100%
;*
;**************************************************************
;
; sprut (zero) Bredendiek 06/2001 - 2012
; www.sprut.de
;
; Takt 4 MHz
;
;
;
; RC5-code hatt 5 Adressenbits (A0-A4) und 7 Commandobits (C0-C6)
; und ist wie folgt als 14-bit code aufgebaut:
;  1. startbit=1
;  2. invertiertes C6
;  3. Toggelbit: wechselt seinen wert von code zu code
;  4. A4
;  5. A3
;  6. A2
;  7. A1
;  8. A0
;  9. C5
; 10. C4
; 11. C3
; 12. C2
; 13. C1
; 14. C0
;
;**************************************************************
; Includedatei fr den 16F683 einbinden

	#include <P12f683.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen
;
; bis 4 MHz: Power on Timer, kein Watchdog, interner Oscillator
	__CONFIG	_PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _BOREN_ON
;
; Variablennamen vergeben

w_copy	Equ	0x20		; Backup fr Akkuregister
s_copy	Equ	0x21		; Backup fr Statusregister
Gruppe	Equ	0x22		; 
Buffer	Equ	0x23
Flags	Equ	0x24
loops	Equ	0x25
loops2	Equ	0x26
ar	Equ	0x27
gr_e	Equ	0x28		; empfangene gruppe
cycl_1	Equ	0x29		; zhler
cycl_2	Equ	0x2A		; zhler
cycl_3	Equ	0x2B		; zhler fe empfangsbitschleife
data_1	Equ	0x2C		; datenpuffer low-teil
data_2	Equ	0x2D		; datenpuffer high-teil
co_e	Equ	0x2E		; empfangenes commando
step	Equ	0x2F		; helligkeit 0..9
roAdr	Equ	0x70


#define		IRIN_Pin	GPIO,1
#define		AdrPin		GPIO,3
#define		SwPin1		GPIO,4
#define		SwPin2		GPIO,5
#define		TgPin 		GPIO,0

#define		C_aus		0
#define		C_1		1
#define		C_2		2
#define		C_3		3
#define		C_4		4
#define		C_5		5
#define		C_6		6
#define		C_7		7
#define		C_8		8
#define		C_an		9
#define		C_up		0x20
#define		C_down		0x21
#define		C_Vol_up	0x10
#define		C_Vol_down	0x11
#define		C_Mute		D'13'

#define		Mute		Flags,0

;***********************************************************************
; EEPROM
;***********************************************************************

	org	H'2100'		; Adresse des EEPROM
	de	0		; 0
	de	0		; 
	de	0 		; 


;**************************************************************
; los gehts mit dem Programm

	org 	0
	goto	Init	


;***********************************************************************
; PWM-Tabelle, Helligkeitsstufen 0 ... 9
;***********************************************************************
PWM
	addwf	PCL, f
	retlw	D'0'		; 0
	retlw	D'4'		; 1
	retlw	D'7'		; 2
	retlw	D'10'		; 3
	retlw	D'16'		; 4
	retlw	D'24'		; 5
	retlw	D'36'		; 6
	retlw	D'55'		; 7
	retlw	D'83'		; 8
	retlw	D'126'		; 9
	retlw	D'126'		; 9 failsave
	retlw	D'126'		; 9 failsave



	retlw	D'0'		; 0
	retlw	D'14'		; 1
	retlw	D'28'		; 2
	retlw	D'42'		; 3
	retlw	D'56'		; 4
	retlw	D'70'		; 5
	retlw	D'84'		; 6
	retlw	D'98'		; 7
	retlw	D'112'		; 8
	retlw	D'126'		; 9
	retlw	D'126'		; 9 failsave
	retlw	D'126'		; 9 failsave


;**************************************************************
Init
; Pins initialisieren
	BCF	STATUS,RP0
	CLRF	GPIO
	MOVLW	07h
	MOVWF	CMCON0		; Comparator Off 
	BSF	STATUS,RP0
	movlw	0xFF
	movwf	WPU		; pull up on
	CLRF	ANSEL
	movlw	B'11001010'	; CCP1 = GPIO2 output,  GPIO0 output fuer Debug
	MOVWF	TRISIO
	BCF	STATUS,RP0

	bsf	TgPin

	clrf	step
	clrf	gr_e
	clrf	co_e
	clrf	Flags

; festlegen der RC5-Geraetegruppe
	movlw	0x05		; VCR1
	movwf	Gruppe
	btfsc	AdrPin
	clrf	Gruppe		; TV

; Vorteiler 16:1 und Timer2 einschalten
	BSF    T2CON,T2CKPS1  ; Vorteiler 16:1    1 MHz/16= 62,5 kHz
	BSF    T2CON,TMR2ON   ; Timer2 ein
; Frequenz auf 496 Hz einstellen
	BSF    STATUS,RP0     ; Bank1
	MOVLW  D'126'
	MOVWF  PR2        
	BCF    STATUS,RP0     ; Bank0
; Tastverhltnis auf 100% einstellen
	movlw	D'126'
	movwf	CCPR1L	
; RC2/CCP1 auf Ausgang stellen
	BSF    STATUS,RP0     ; Bank1
	BCF    TRISIO, 2      ; GPIO2: output=0
	BCF    STATUS,RP0     ; Bank 0
; PWM MODE mit CCP1 initialisieren
	CLRF   CCP1CON        ; CCP1-Modus aus
	BSF    CCP1CON,CCP1M3 ; CCP1-Modus PWM-Mode
	BSF    CCP1CON,CCP1M2 

; gespeicherten Wert benutzen
	movlw	0
	call	EERead
	skpnz
	movlw	9
	call	SetPwm


;**********************************************************
;**********************************************************
;*
;* pollen der leitung
;*
;* RC-5 bus pollen
;* empfangene signale auf LED ausgeben
;*
;**********************************************************
;**********************************************************
pollen
	call	empfangen	;IR empfangen

	movfw	gr_e		; gruppenadresse 
	xorwf	Gruppe, w
	bnz	fail

	; RC5-Geretegruppe stimmt, nun Kommando auswerten
	movlw	C_aus
	xorwf	co_e, w
	bnz	next0
	movlw	0
	goto	save
next0

	movlw	C_1
	xorwf	co_e, w
	bnz	next1
	movlw	1
	goto	save
next1

	movlw	C_2
	xorwf	co_e, w
	bnz	next2
	movlw	2
	goto	save
next2

	movlw	C_3
	xorwf	co_e, w
	bnz	next3
	movlw	3
	goto	save
next3

	movlw	C_4
	xorwf	co_e, w
	bnz	next4
	movlw	4
	goto	save
next4

	movlw	C_5
	xorwf	co_e, w
	bnz	next5
	movlw	5
	goto	save
next5

	movlw	C_6
	xorwf	co_e, w
	bnz	next6
	movlw	6
	goto	save
next6

	movlw	C_7
	xorwf	co_e, w
	bnz	next7
	movlw	7
	goto	save
next7

	movlw	C_8
	xorwf	co_e, w
	bnz	next8
	movlw	8
	goto	save
next8

	movlw	C_an
	xorwf	co_e, w
	bnz	next9
	movlw	9
	goto	save
next9

	movlw	C_up
	xorwf	co_e, w
	bnz	nextup
	incf	step, w
	goto	save
nextup

	movlw	C_Vol_up
	xorwf	co_e, w
	bnz	nextVup
	incf	step, w
	goto	save
nextVup


	movlw	C_down
	xorwf	co_e, w
	bnz	nextdown
	decf	step, w
	goto	save
nextdown

	movlw	C_Vol_down
	xorwf	co_e, w
	bnz	nextVdown
	decf	step, w
	goto	save
nextVdown

	; kein gesuchtes Kommando
	goto	fail

save
	call	Toggel
	call	SetPwm
fail
	goto	pollen


;**********************************************************
;**********************************************************
;*
;* TgPin umschalten
;*
;**********************************************************
;**********************************************************
Toggel
	btfss	TgPin
	goto	TgOn
TgOff
	bcf	TgPin
	return
TgOn
	bsf	TgPin
	return

;**********************************************************
;**********************************************************
;*
;* Einstellen des PWM 
;* prfen des Wertebereichs und speichern in step und EEPROM
;*
;* input: w  0..9
;*
;**********************************************************
;**********************************************************

SetPwm
	movwf	Buffer
	btfsc	Buffer, 7	; negativ oder >127, dann ignorieren
	goto	SP_fail
	
	movlw	D'10'
	subwf	Buffer, w	; f - w   Buffer-10
	bc	SP_fail		; >9

	movfw	Buffer
	movwf	step
	call	PWM
	; gueltigen PWM-DC verwenden
	movwf	CCPR1L	

	; Schalt-Pin 1 steuern
	movfw	step
	bz	SP_Sw1Off
SP_Sw1On
	bsf	SwPin1		; einschalten	
	goto	SP_Sw1end	
SP_Sw1Off
	bcf	SwPin1		; ausschalten	
SP_Sw1end

	; Schalt-Pin 2 steuern
	movfw	step
	xorlw	9
	bnz	SP_Sw2Off
	bsf	SwPin2		; einschalten	
	goto	SP_Sw2end	
SP_Sw2Off
	bcf	SwPin2		; ausschalten	
SP_Sw2end


	; step-Wert im EEPROM speichern
	movfw	step
SP_save2
	clrf	roAdr
	call	EEWrite
SP_fail
	call	wait250ms	; 250ms warten
	return


;**********************************************************
;
; einen RC-5-code mit polling empfangen
;
; IRIN_Pin ist active-low
;
; gruppencode: gr_e
; commando   : co_e
;
;**********************************************************
; vor dem aufruf wenigstens 1 ms low pegel abwarten !!
empfangen
	btfss	IRIN_Pin
	goto	empfangen	; warten auf high

empfangenL
	btfsc	IRIN_Pin
	goto	empfangenL	; warten auf low, 1/2-Bit vorbei

;	bcf	INTCON,GIE	; interupts sperren

	call	viertelbit	; 1/4 nach bitmitte

	btfsc	IRIN_Pin
	goto	Fehler		; war nur spike

	clrf	data_1		; datenpuffer lschen
	clrf	data_2
	movlw	D'13'		; 13 bits bei syncronisation
	movwf	cycl_3
;
; 3/4 nach bitanfang wird wert gelesen, invertiert
; und eingeschrieben
; dann wird auf die flanke gewartet, die das neue bit einleitet
; nach der flanke wird bis 3/4 bit gewartet und dann neu begonnen
;
	call	halbbit		; 1/4 des 2. Bits

nextbit
	rlf	data_1,f
	rlf	data_2,f
	bcf	data_1, 0	; angenommen leitung ist low (0) 
	btfsc	IRIN_Pin	; leitung abfragen
	bsf	data_1, 0	; leitung ist high (1), in datenpuffer

; warten auf pegelnderung
	call	anders		; Bitmitte

	call	viertelbit	; 3/4 Bit
	call	halbbit		; 1/4 nach bitanfang
	decfsz	cycl_3,f	; alle 13 bit + startbit empfangen?
	goto	nextbit

	movfw	data_1
	movwf	co_e
	bcf	co_e, 6
	bcf	co_e, 7		; auf 6 bit begrenzen

	rlf	data_1,f
	rlf	data_2,f	
	rlf	data_1,f
	rlf	data_2,f	; gruppe nach data_2
	movfw	data_2
	movwf	gr_e
	bcf	gr_e, 7
	bcf	gr_e, 6
	bcf	gr_e, 5		; auf 5 bit begrenzen
	
; 2. stoppbit zum 7 commandobit machen
	btfss	data_2, 6
	bsf	co_e, 6		;2. Stoppbit invers  -> 7.commandobit

	movfw	co_e
Fehler
;	bsf	INTCON,GIE	; interrupts wieder erlauben

	return

;**************************************************************
;
; warten darauf, dass die leitung IRIN_Pin dem inversen wert in 'data_1, 0' entspricht
;
; zeitbegrenzt auf ca. ein halbes bit
;
;**************************************************************
anders
	movlw	D'9'		; 9 x  ( 4 MHz)
	movwf	cycl_1
a_1
	movlw	D'32'		; 100 takte
	movwf	cycl_2
a_2
	decfsz	cycl_2,f	
	goto	a_2

	btfsc	IRIN_Pin	; portpegel abfragen
	goto	a_high
a_low				; portpegel ist 0
	btfsc	data_1, 0	; ist sollwert=0 ?
	return			; high-low flanke
	goto	a_weiter
a_high				; portpegel ist 1
	btfss	data_1, 0	; ist sollwert=1 ?
	return			; low-high flanke
a_weiter
	decfsz	cycl_1,f	
	goto	a_1	
	return			; keine flanke gefunden

;**************************************************************
;
; zeitverzgerung um ein viertelbit = 444,5 us ca. 445 takte  (4 MHz)
;
; zeitverzgerung um ein halbbit    = 889 us   ca. 889 takte  (4 MHz)
;
;**************************************************************
pause				;2ms fr 45
	movlw	D'45'
	goto	l_0
pause_l				;ca 12ms fr 255
	movlw	D'255'
	goto	l_0
viertelbit
	movlw	D'9'		; 9 x  ( 4 MHz)
	goto	l_0
halbbit
	movlw	D'18'		; 18 x ( 4 MHz)
l_0
	movwf	cycl_1
l_1

	movlw	D'15'		; 49 takte  ( 4 MHz)
	movwf	cycl_2
l_2
	decfsz	cycl_2,f	
	goto	l_2

	decfsz	cycl_1,f	
	goto	l_1	
	return

;***********************************************************************
; 250 ms warten
;***********************************************************************
wait250ms
	movlw	D'250'		; 250ms
	movwf	loops	
	goto	WAIT


;***********************************************************************
; 75 ms warten
;***********************************************************************
wait75ms
	movlw	D'75'		; 75ms
	movwf	loops	
	goto	WAIT


;***********************************************************************
; 20 ms warten
;***********************************************************************
wait20ms
	movlw	D'20'		; 20ms
	movwf	loops	
	goto	WAIT


;***********************************************************************
;Zeitverzgerung um loops * 1 ms
; 4 MHz externer Takt bedeutet 1 MHz interner Takt
; also dauert 1 ms genau 1000 Befehle
; 100 Schleifen a 10 Befehle sind 1000 Befehle = 1 ms
WAIT
top     movlw   .100           ; timing adjustment variable (1ms)
        movwf   loops2
top2    nop                    ; sit and wait
        nop
        nop
        nop
	nop
        nop
        nop
        decfsz  loops2, F      ; inner loops complete?
        goto    top2           ; no, go again
                               ;
        decfsz  loops, F       ; outer loops complete?
        goto    top            ; no, go again
        retlw   0              ; yes, return from subWAIT


;***********************************************************************
;  EEPROM-Routine fr 12F683
;
;***********************************************************************
; 12F683 hat 256 EEPROM-Zellen
; 1 000 000 Schreibzyklen sind garantiert
;				
;***********************************************************************
; lesen des EEPROM  (w) -> w
;
; input:  Adresse in W
; output: W
;
;***********************************************************************
EERead
	BSF    STATUS, RP0     ; EEADR liegt in der Bank 1 
	MOVWF  EEADR           ; schreibe die Adresse in EEADR 
	BSF    EECON1, RD      ; EEPROM Leseproze starten 
	MOVF   EEDAT, W        ; Die Daten der EEPROM Zelle nach W kopieren 
	BCF    STATUS, RP0     ; Bank 0 
	RETURN 


;***********************************************************************
; beschreiben des EEPROM;   w -> (roAdr)
;
; input: Adresse ist in roAdr
;        Wert in w
;***********************************************************************
EEWrite
	BSF	STATUS, RP0	; der Bank 1 
EEWait
	BTFSC	EECON1, WR  	;L ist letzter zyklus fertig?
	goto	EEWait
	MOVWF	EEDATA		; w wollen wir schreiben
	MOVFW	roAdr		; beim 12F675 steht ab 0x70 in beiden Banken das gleiche
	MOVWF	EEADR		; Die Zelle (roAdr) soll beschrieben werden
	BSF	EECON1, WREN	; nun ist Schreiben erlaubt
;EEW_GIE
;	BCF	INTCON, GIE	; verbieten aller Interrupts
;	BTFSC	INTCON,GIE	; See AN576
;	GOTO	EEW_GIE
	; Die folgenden 5 Zeilen mssen genau so im Code stehen!!!
	MOVLW	0x55		;
	MOVWF	EECON2		; schreibe 55h nach EECON2
	MOVLW	0xAA		;
	MOVWF	EECON2 		; schreibe AAh nach EECON2
	BSF	EECON1, WR  	; starte den Schreibzyklus
;	BSF	INTCON, GIE	; Interrupts wieder erlauben , falls noetig
	BCF	STATUS, RP0	; Bank 0
	RETURN 

;***********************************************************************



	end



