	list p=16f628
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 < Band LSB
;*		1 < Band
;*		2 < Band
;*		3 < Band MSB
;*		4 < Takteingang
;*		5 < 1=1x16  0=2x16
;*
;*	PORTB:	0 > LCD Display E
;*		1 -		
;*		2 > LCD Display RS
;*		3 > LCD Display R/W	
;*		4-7 LCD Display D4 .. D7 
;*	
;**************************************************************
;
;sprut (zero) Bredendiek 04/2002 .. 02/2010
;
; 8-stellige Frequenzanzeige mit LCD-Display
; fr einen 12-Band KW-Empfnger R250
; externer Vorteiler: keiner
;
; Prozessor-Takt 10 MHz (Quarz!!)
;
; moeglicher Mebereich:
; 0 MHz ... 5 MHz	Auflsung 4 Hz
; moeglicher Mebereich bei Test:
; 0 MHz ... 20 MHz	Auflsung 16 Hz
;
; Berechnung: fo = LO2 -IF2 + LO2 = Messwert - 215kHz + Quarzfrequenz
; Anzeige: (f x 4) - 215.000 + (Bandnummer -1)*2MHz
; Anzeige bei Test: (f x 16)
;
; Bandnummer an RA3..RA0
; 0=Test
; 1..12 ist Band 1..12
; falls ein 13-Stufen-Binaercodeschalter nicht verfuegbar ist
; muesste auf einen anderen Code (BCD) zurueckgegriffen werden
; dafuer waere ein weiteres Pin noetig, 
; RA5 (MCLR) kann dann dafuer genutzt werden
;
; Eingangsfrequenz an RA4 ist ca. 1,715 ... 3.715 MHz
; interner Vorteiler		= 2:1
; interner Vorteiler bei Test	= 8:1
; Timer-Eingangsfrequenz	= 0,8575 .. 1,8575 MHz
; Timer-Eingangsfrequenz bei Test= 0 .. 2,5 MHz
;
; ZF=215 kHz
;
; Mezeit 0,5 Sekunden
;  Zhlwert ca. 428 750  .. 1 018 575 =	00 06 8A CE .. 00 0F 8A CF
;  2. ZF        215 000 Hz          =	00 03 47 D8  :4 ->	00 D1 F6
;  
; Bereich	Quarz
; 1		0			00 00 00 00  :4 ->	00 00 00
; 2		2 Mhz			00 1E 84 80  :4 ->	07 A1 20
;...		...			...			...
; 12		22 MHz			01 4F B1 80  :4 ->	53 EC 60
;
; Maximale Frequnz zur anzeige : 25 500 000 Hz = 01 85 19 60
; also reicht 24 Bit nicht aus, Berechnung erfolgt in 32 Bit
;
;**********************************************************
; Includedatei fr den 16F628 einbinden

	#include <P16f628.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen: 16F628
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming
	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC & _BODEN_OFF & _LVP_OFF & _MCLRE_OFF

;**********************************************************

;Speicherbereich fr Variablen
; Bank0: 0x20 .. 0x7F ; 96 Byte
; Bank1: 0xA0 .. 0xEF ; 80 Byte
; Bank2:0x120 ..0x14F ; 46 Byte

; Variablen festlegen

;w_copy		Equ	0x20	; nur fr INT
;s_copy		Equ	0x21	; nur fr INT
LcdDaten  	Equ	0x22
LcdStatus 	Equ	0x23
loops		EQU	0x24	; Wait-Schleife
loops2		EQU	0x25	; Wait-Schleife
BcdDaten	EQU	0x26
BcdDaten1	EQU	0x27
Fehler		EQU	0x28
;xw1a		EQU	0x29
; 32-Bit Rechenregister
xw0		EQU	0x2A	;LSB
xw1		EQU	0x2B	; I 
xw2		EQU	0x2C	; I 
xw3		EQU	0x2D	;MSB
; Dezimalstellen
HdZM		EQU	0x2E	;8 ZehnMillionen
HdM		EQU	0x2F	;7 Millionen
HdHT		EQU	0x30	;6 Hunderttausender
HdZT		EQU	0x31	;5 Zehntausender
HdT		EQU	0x32	;4 Tausender
HdH		EQU	0x33	;3 Hunderter
HdZ		EQU	0x34	;2 Zehner
HdE		EQU	0x35	;1 Einer
HdX		EQU	0x36	; Puffer fr eine Dezimalstelle
; 32-Bit Rechenregister
f0		EQU	0x37	;LSB
f1		EQU	0x38	; I 
f2		EQU	0x39	; I 
f3		EQU	0x3A	;MSB
; 32 Bit Frequenzzhler
BIN4		EQU	0x3B	;LSB
BIN41		EQU	0x3C	; I 
BIN42		EQU	0x3D	; I 
BIN43		EQU	0x3E	;MSB
; Hilfszellen fr Frequenzmeschleife
HLTest		EQU	0x3F	; HL-Flanken-Detektorn fr Timer0-berlauf
HighCOU		EQU	0x40	; high-Teil des Schleifenzhlers
LowCOU		EQU	0x41	; low-Teil des Schleifenzhlers
PreSC		EQU	0x42	; Vorteiler fr die richtige Messung

HdHM		EQU	0x43	;9 HundertMillionen
Bandnummer	EQU	0x44
Bandloop	EQU	0x45

; Konstanten festlegen

PORTC	equ	PORTB		; LCD-Control-Port
PORTD	equ	PORTB		; LCD-Daten-Port
LcdE	equ	0		; enable Lcd
LcdRw	equ	3		; read Lcd
LcdRs	equ	2		; Daten Lcd (nicht control)	
Ini_con Equ	B'00000000'	; TMR0 -> Intetupt disable
Ini_opt	Equ	B'00000000'	; pull-up; PS=2:1

;********************************************************
; Das Programm beginnt mit der Initialisierung

Init	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up on
	movwf   OPTION_REG 
	movlw	B'11111111'	; RA0 .. RA4 input 
	movwf	TRISA		; 
	movlw	B'00000000'	; PortB alle outputs 
	movwf	TRISB
	bcf     STATUS, RP0	; Bank 0	
	clrf	PORTB		

; 16F628 alle Comparatoreingnge auf Digital umschalten
	BSF	CMCON, CM0
	BSF	CMCON, CM1
	BSF	CMCON, CM2
		
	movlw   Ini_con     	; Interupt disable
	movwf   INTCON   

	call	InitLCD		; Display initialisieren

; am LCD "Hallo" ausgeben
	movlw	'H'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'a'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'l'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'l'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'o'
	movwf	LcdDaten
	call	OutLcdDaten

; timer1 vorbereiten
	bsf     STATUS, RP0	; Bank 1
	bsf	OPTION_REG, T0CS; RA4-Takt zum Timer0
	bsf	OPTION_REG, PSA	; noch ohne Vorteiler
	bcf     STATUS, RP0	; Bank 0

	movlw	1
	movwf	PreSC		; 4:1

;*****************************************************************
; (HighCOU,LowCOU)x20Takte lang wird gezhlt
; das 24-Bit Ergebnis steht in BIN4+2 (MSB) bis BIN4 (LSB)
; virtuell steht davor BIN+3=0
; das mach dann 32Bit
; 
;
; fr die Messung 500 ms
; 10MHz ; 500 ms = 1250000 Takte = 62500 x 20 Takte, 0,f4,24h=62500d   -Default
; 10MHz ; 250 ms =  625000 Takte = 32250 x 20 Takte, 0,7A,12h=32250d
; 10MHz ; 125 ms =  312500 Takte = 15625 x 20 Takte, 0,3D,09h=15625d
;
;*****************************************************************

;*HAUPTSCHLEIFE***************************************************
Frequ_Loop

; Bandnummer ermitteln
; Binaercode an RA0..RA3
	movfw	PORTA
	andlw	B'00001111'
	movwf	Bandnummer


; Einstellung des Vorteilers 
; >32 MHz 32:1 - PS=4
; >16 MHz 16:1 - PS=3
; > 8 MHz  8:1 - PS=2   fuer Test
; > 4 MHz  4:1 - PS=1
; > 2 MHz  2:1 - PS=0   fuer LO2-Messung

;Vorteiler fuer normale Messung 2:1
	movlw	0x00		; PRESC = Vorteiler-Faktor 2:1
	movwf	PreSC

;Vorteiler fuer Test 8:1
	movfw	Bandnummer
	skpz
	goto	VTende
	movlw	0x02		; PRESC = Vorteiler-Faktor 8:1
	movwf	PreSC
VTende


;Messung mit optimaler Auflsung
	clrf	BIN4+1 		; clear counter 
	clrf	BIN4+2 		; clear counter 
	clrf	BIN4+3 		; clear counter 

	clrf	HLTest	 	; initialize TMR0 overflow detector
	movlw	0f4h+1 		; high loop counter for 500 ms
	movwf	HighCOU 	; HighCOU = hi byte counter
	movlw	24h+1 		; 0f424h=.62500 cycles=1250000,T=500 ms
	movwf	LowCOU 		; LowCOU = lo byte counter
	movfw	PreSC		; PRESC = Vorteiler-Faktor
	call	Messung
;Ende der Zhlroutine
; 500 ms
; 2:1 Fmax =  5 MHz = 2,5 Mill-Schwingungen = 1,25 Mill = 13 12 D0 h
; 4:1 Fmax = 10 MHz =   5 Mill-Schwingungen = 1,25 Mill = 13 12 D0 h


;************************************************************************
; 0 = Test, keinerklei Frequenzkorrektur
	movfw	Bandnummer
	skpnz
	goto	Kompensation

;************************************************************************
; ZF/4 (215 kHz / 4) abziehen
; 215000/4 = 53750 = D1 F6
; Bin3..Bin := BIN3..BIN - 00 00 D1 F6

	; BIN -> f
	movfw	BIN43	;MSB
	movwf	f3
	movfw	BIN42
	movwf	f2
	movfw	BIN41
	movwf	f1
	movfw	BIN4	;LSB
	movwf	f0

	; ZF/4 -> w
	movlw	00	;MSB
	movwf	xw3
	movlw	00
	movwf	xw2
	movlw	0xD1
	movwf	xw1
	movlw	0xF6	;LSB
	movwf	xw0

	; f = f-w
	call	Sub32

	
;************************************************************************
; 1st LO addieren
; 1stLO = (Bandnummer-1) * 2 MHz
; da hier weder Vorteiler noch Messzeit kompensiert wurden gilt: (Bandnummer-1) * 500kHz

	; 500kHz (00 07 A1 20) -> w
	movlw	00	;MSB
	movwf	xw3
	movlw	0x07
	movwf	xw2
	movlw	0xA1
	movwf	xw1
	movlw	0x20	;LSB
	movwf	xw0

	call	Sub32
	movfw	Bandnummer
	movwf	Bandloop
LO1korr	
	call	Add32
	decfsz	Bandloop, f
	goto	LO1korr

	; f -> BIN
	movfw	f3	;MSB
	movwf	BIN43
	movfw	f2
	movwf	BIN42
	movfw	f1
	movwf	BIN41
	movfw	f0	;LSB
	movwf	BIN4

;************************************************************************
Kompensation
; Zhlwert in Frequenz umrechnen
; Mezeit kompensieren
	call	Mal2		; 500ms -> 1s

; Vorteiler kompensieren
	call	Mal2

; Vorteiler zusaetzlich kompensieren fuer Test
	movfw	Bandnummer
	skpz
	goto	KompEnde
	call	Mal2
	call	Mal2
KompEnde

;************************************************************************
;Kursor zurck
	movlw	B'00000011'	; 8 cursor home, cursor home
	call	OutLcdControl

; 32 Bit zur Anzeige bringen
	movfw	BIN4
	movwf	f0
	movfw	BIN4+1
	movwf	f1
	movfw	BIN4+2
	movwf	f2
	movfw	BIN4+3
	movwf	f3
;Binr zu ASCII Wandlung mit Ausgabe
	call	OutDez32	; 'xx xxx xxx'
	call	OutHz		; ' Hz'

	goto	Frequ_Loop	; und alles noch mal von vorne
;***********************************************************************************

;***********************************************************************************
; die eigentliche  Messroutine
; Messzeit = 20Takte x (HighCOU,LowCOU)
; Prescaler in w
Messung
	addlw	20h 		; for PRESC 0,1,2,3... w=20h,21h,22h,23h...
				; TOSE=0, TOCS=1, PSA=0, PS=0..7
	bsf	STATUS,RP0 	; bank 1
	movwf	OPTION_REG 	; 
	bcf	STATUS,RP0 	; bank 0
	clrf	TMR0 		; initialize TMR0

LoopLow
	nop			; warten
	nop			; warten
LoopHigh
	movf	TMR0, W		; 1 1 1 only place where TMR0 is read
	movwf	BIN4		; 1 1 1 rtcc ---> freq0
	rlf	BIN4, W		; 1 1 1 carry <--- TMR0.7
	rlf	HLTest, F	; 1 1 1 rotor <--- carry
	movf	HLTest, W	; 1 1 1 HLTest=TMR0 overflow detect
	andlw	3		; 1 1 1 mask 2 LSbs for edge detect
	xorlw	2		; 1 1 1 00000000 if 1 <--- 0
	btfss	STATUS, Z	; 1 2 2 | skip if TMR0 overflow
	goto	NotOvf1		; 2 - - | if nz
				;       | 5T any case
	incf	BIN4+1, F	; - 1 1 | nsb
NotOvf1 btfsc	STATUS, Z	; 2 2 1 | skip MSB adv ifnot overflow
	incf	BIN4+2, F 	; - - 1 | msb
	nop			; warten
	nop			; warten
	nop			; warten
	decfsz	LowCOU, F 	; 1 (2) lo loop counter
	goto	LoopLow 	; 2 (-) 20T total
	decfsz	HighCOU, F 	; (1) hi loop counter
	goto	LoopHigh 	; (2) 20T total

	return


;*******************************************************************************
;Multiplikation: 32-Bit x 2 
Mal2
	bcf	STATUS,C
	rlf	BIN4, f
	rlf	BIN4+1, f
	rlf	BIN4+2, f
	rlf	BIN4+3, f
	return

;*******************************************************************************
; String ' Hz' am LCD ausgeben
OutHz
	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'H'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'z'
	movwf	LcdDaten
	call	OutLcdDaten
	return

;*****************************************************************	
;Zeitverzgerung um loops * 1 ms
;10MHz -> 2,5MHz -> 2500T
WAIT
top      movlw   .249           ; timing adjustment variable (1ms)  10MHz 249*10=2490T
         movwf   loops2
top2     nop                     ; sit and wait (Schleifenlnge 10T)
         nop
         nop
         nop
         nop
         nop
	 nop			
         decfsz  loops2, F      ; inner loops complete?
         goto    top2           ; no, go again
                                ;
         decfsz  loops, F       ; outer loops complete?
         goto    top            ; no, go again
         retlw   0              ; yes, return from subWAIT

;**************************************************************
; LCD-Routinen
;	
; Initialisierung des LCD-Displays
InitLCD
	movlw	D'255'		; 250 ms Pause nach dem Einschalten
	movwf	loops	
	call	WAIT		

	movlw	B'00110000'	; 1
	movwf	PORTB
	bsf	PORTB, LcdE
	nop	
	bcf	PORTB, LcdE
	
	movlw	D'50'		; 50 ms Pause
	movwf	loops
	call	WAIT
	
	movlw	B'00110000'	; 2
	call	Control8Bit
	movlw	B'00110000'	; 3
	call 	Control8Bit
	movlw	B'00100000'	; 4
	call 	Control8Bit

	movlw	B'00000001'	; lschen und cusor home
	call	OutLcdControl	
	movlw	B'00101000'	; 5 function set, 4-bit  2-zeilig,  5x7
	call	OutLcdControl	
	movlw	B'00001000'	; 6 display off
	call	OutLcdControl
	movlw	B'00000110'	; 7 entry mode, increment, disable display-shift
	call	OutLcdControl
	movlw	B'00000011'	; 8 cursor home, cursor home
	call	OutLcdControl
	movlw	B'00001100'	; 9 display on, cursor off, cursor flash off
	call	OutLcdControl
	return

; ein Steuerbyte 8-bittig bertragen
Control8Bit
	movwf	PORTB
	bsf	PORTB, LcdE
	nop
	bcf	PORTB, LcdE
	movlw	D'10'
	movwf	loops
	call 	WAIT
	return

; darauf warten, dass das Display bereit zur Datenannahme ist
LcdBusy
        bsf     STATUS, RP0	; make Port B4..7 input
	movlw	B'11110000'
	iorwf   TRISB, f 
        bcf     STATUS, RP0
BusyLoop		
	bcf	PORTC, LcdRs
	bsf	PORTC, LcdRw	; Lesen
	bsf	PORTC, LcdE
	nop
	movf	PORTD, w
	movwf	LcdStatus
	bcf	PORTC, LcdE
	nop
	bsf	PORTC, LcdE	; Enable
	nop
	bcf	PORTC, LcdE
	btfsc	LcdStatus, 7	; teste bit 7
	goto	BusyLoop
	bcf	PORTC, LcdRw
        bsf     STATUS, RP0	; make Port B4..7 output
	movlw	B'00001111'
	andwf   TRISB, f    
        bcf     STATUS, RP0
	return	

; ein Byte mit Steuerdaten von LcdDaten zum Display bertragen
OutLcdControl
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	PORTD		; Hi-teil Daten schreiben
	bsf	PORTC, LcdE
	nop
	bcf	PORTC, LcdE	; Disable LcdBus
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	PORTD		; Lo-teil Daten schreiben
	bsf	PORTC, LcdE
	nop
	bcf	PORTC, LcdE	; Disable LcdBus
	return

; ein Datenbyte von LCDDaten zum Display bertragen
OutLcdDaten
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	PORTD		; Hi-teil Daten schreiben
	bsf	PORTC, LcdRs	; Daten
	bsf	PORTC, LcdE	; Enable LcdBus
	nop
	bcf	PORTC, LcdE	; Disable LcdBus	
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	PORTD		; Lo-teil Daten schreiben
	bsf	PORTC, LcdRs	; Daten
	bsf	PORTC, LcdE
	nop
	bcf	PORTC, LcdE	; Disable LcdBus	
	bcf	PORTC, LcdRs	;
	return


;***********************************************************
; 32 Bit Wert (f3,f2,f1,f0) auf LCD dezimal anzeigen
; dabei fhrende Nullen unterdrcken
OutDez32			;32-bit (f3,f2,f1,f0) als Dez zum Lcd
	call	Hex2Dez32	;32 Bit to BCD
	clrf	Fehler		; Leading0 vorbereiten

	movfw	HdHM	
	Call	Leading0
	movfw	HdZM
	Call	Leading0
	movfw	HdM
	Call	Leading0

	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten

	movfw	HdHT
	Call	Leading0
	movfw	HdZT
	Call	Leading0
	movfw	HdT
	Call	Leading0

	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten

;8 Zeichen fertig
;ACHTUNG
; Umschaltung zwischen einzeiligem und zweizeiligem Display
	movlw	B'11000000'	; Sprung zur virtuellen 2. Zeile bei 1x16
	btfss	PORTA,5
	call	OutLcdControl	; Sprung zur virtuellen 2. Zeile bei 1x16

	movfw	HdH
	Call	Leading0
	movfw	HdZ
	Call	Leading0
	movfw	HdE
	Call	Bcd4Bit
	return

Leading0
	iorwf	Fehler, f
	movf	Fehler, f	; Test auf 0
	btfss	STATUS, Z	; bisher alles '0'
	goto	Bcd4Bit		; nein
	movlw	' '		; ja
	movwf	LcdDaten
	goto	OutLcdDaten


;**************************************************************
; 16 Bit Wert (f1,f0) auf LCD dezimal anzeigen
OutDez16			;16-bit (f0,f1) als Dez zum Lcd
	call	Hex2Dez16
	movfw	HdZT
	Call	Bcd4Bit
	movfw	HdT
	Call	Bcd4Bit

	movlw	' '
	movwf	LcdDaten

	movfw	HdH
	Call	Bcd4Bit
	movfw	HdZ
	Call	Bcd4Bit
	movfw	HdE
	Call	Bcd4Bit
	return


;**************************************************************
; 32-bit(f3,f2,f1,f0) in 8-stellen Bcd (G,HM,ZM,M,HT,ZT,T,H,Z,E)

; 100 000 000 = 05F5 E100 h
;  10 000 000 = 0098 9680 h
;   1 000 000 = 000F 4240 h
;     100 000 = 0001 86A0 h
;      10 000 = 0000 2710 h
;       1 000 = 0000 03E8 h
;         100 = 0000 0064 h
;          10 = 0000 000A h
;           1 = 0000 0001 h

Hex2Dez32			; 32-bit(f3,f2,f1,f0) in 8-stellen Bcd (ZM,M,HT,ZT,T,H,Z,E)

	movlw	0x05		; 100 000 000 = 05 F5 E1 00 h	
	movwf	xw3
	movlw	0xF5		
	movwf	xw2
	movlw	0xE1
	movwf	xw1
	movlw	0x00
	movwf	xw0
	call	Hex2Dez1	; 100 000 000er
	movfw	HdX
	movwf	HdHM
	
	clrf	xw3		; 10 000 000 = 00 98 96 80 h
	movlw	0x98		
	movwf	xw2
	movlw	0x96
	movwf	xw1
	movlw	0x80
	movwf	xw0
	call	Hex2Dez1	; 10 000 000er
	movfw	HdX
	movwf	HdZM

	clrf	xw3		; 1 000 000 = 00 0F 42 40 h
	movlw	0x0F		
	movwf	xw2
	movlw	0x42
	movwf	xw1
	movlw	0x40
	movwf	xw0
	call	Hex2Dez1	; 1 000 000er
	movfw	HdX
	movwf	HdM

	clrf	xw3		; 100 000 = 00 01 86 A0 h
	movlw	0x01		
	movwf	xw2
	movlw	0x86
	movwf	xw1
	movlw	0xA0
	movwf	xw0
	call	Hex2Dez1	; 100 000er
	movfw	HdX
	movwf	HdHT
Hex2Dez16			; 16-bit(f1,f0) in 5-stellen Bcd (ZT,T,H,Z,E)				
	movlw	0x27		; 10 000 = 00 00 27 10 h
	movwf	xw1
	clrf	xw2
	clrf	xw3
	movlw	0x10
	movwf	xw0
	call	Hex2Dez1	; 10 000er
	movfw	HdX
	movwf	HdZT

	movlw	0x03		; 1 000 = 00 00 03 E8 h
	movwf	xw1
	clrf	xw2
	clrf	xw3
	movlw	0xE8
	movwf	xw0
	call	Hex2Dez1	; 1000er
	movfw	HdX
	movwf	HdT
Hex2Dez8			; 8-bit (f1, f0) in 3-stellen BCD
	movlw	0x00		; 100 = 00 00 00 64 h
	movwf	xw3
	movwf	xw2
	movwf	xw1
	movlw	0x64
	movwf	xw0
	call	Hex2Dez1	; 100er
	movfw	HdX
	movwf	HdH

	movlw	0x00		; 10 = 00 00 00 0A h
	movwf	xw3
	movwf	xw2
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	movwf	HdZ

	movfw	f0
	movwf	HdE
	return

Hex2Dez1
	clrf	HdX
	decf	HdX, f
HdLoop
	incf	HdX, f
	call	Sub32		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop		;Stelle 1 mehr
	call	Add32
	return

;**************************************************************
; 32 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub32				; 32 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen    
	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    sb0
	movlw   0x01		; borgen von f1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb0
	subwf   f2    ,f        ; borgen von f2

	btfsc   STATUS,C
	goto    sb0
	subwf   f3    ,f        ; borgen von f3
	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf

sb0     movf    xw1, w		; f1=f1-xw1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb1
	movlw   0x01		; borgen von f2
	subwf   f2    ,f

	btfsc   STATUS,C
	goto    sb1
	subwf   f3, f		; borgen von f3

        btfss   STATUS,C
	bsf	Fehler, C	; Unterlauf

sb1     movf    xw2,w		; f2=f2-xw2
        subwf   f2, f

        btfsc   STATUS,C
        goto    sb2
        movlw   0x01		
        subwf   f3, f		; borgen von f3

        btfss   STATUS,C
       	bsf	Fehler, C	; Unterlauf

sb2     movf    xw3,w		; f3=f3-xw3
        subwf   f3    ,f

        btfss   STATUS,C
 	bsf	Fehler, C	; Unterlauf

	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return


;32 bit Adition, C-Flag bei berlauf gesetzt 
;********************************************************************* 
;*  
;* addiere xw (32-byte value) mit f (32-byte value). 
;* Input  variablen: f (32-bit value), xw (32-bit value) 
;* Output variablen: f (32-bit value), 33. bit in STATUS,C 
;********************************************************************* 
Add32 				; 32-bit add: f = f + xw
	movf	xw0,W		; low byte
	addwf	f0,F 		; low byte add

	movf	xw1,W 		; next byte
	btfsc	STATUS,C 	; berspringe falls C nicht gesetzt
	incfsz	xw1,W 		; addiere C falls gesetzt 
	addwf	f1,F 		; next byte add wenn NZ
	
	movf	xw2,W 		; next byte
	btfsc	STATUS,C 	; berspringe falls C nicht gesetzt
	incfsz	xw2,W 		; addiere C falls gesetzt 
	addwf	f2,F 		; next byte add wenn NZ
	
	movf	xw3,W 		; high byte
	btfsc	STATUS,C 	; berspringe falls C nicht gesetzt
	incfsz	xw3,W 		; addiere C falls gesetzt 
	addwf	f3,F 		; high byte add wenn NZ
	
	return 			; fertig



;**************************************************************
;8-Bit als BCD ausgeben
OutBcd				;8-Bit als BCD ausgeben
	movwf	BcdDaten	;8-Bit kopieren
	movwf	BcdDaten1
	rrf	BcdDaten, f
	rrf	BcdDaten, f
	rrf	BcdDaten, f
	rrf	BcdDaten, f	;4 High-Bit in BcdDaten
	movlw	B'00001111'
	andwf	BcdDaten, f	; / 
	andwf	BcdDaten1, f	; 4-Low-Bit in BcdDaten1
	movfw	BcdDaten
	call	Bcd4Bit		;4 High-Bit ausgeben
	movfw	BcdDaten1
	call	Bcd4Bit		;4 Low-Bit ausgeben
	return
Bcd4Bit				;low-4 Bit als BCD ausgeben
	movwf	BcdDaten
	movlw	B'00110000'
	ADDwf	BcdDaten, f	;ASCII-wandeln (+48)
	movlw	B'00111010'
	subwf	BcdDaten, w
	btfss	STATUS, C	;Test auf A ... F
	goto	BcdOk
	movlw	.7
	addwf	BcdDaten, f	;korrigiere A...F (+7)
BcdOk
	movfw	BcdDaten
	call	OutLcdDaten
	return
;**************************************************************


	end		
;**************************************************************