	list p=12f629
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	GPIO: 	0 > Band Bit 0
;*		1 > Band Bit 1
;*		2 < Takteingang
;*		3 < 0:Testmode; 1:Bandsensor
;*		4 > Band Bit 2
;*		5 > Band Bit 3
;*
;*	
;**************************************************************
;
;sprut (zero) Bredendiek 04/2002 .. 02/2010
;
; LO1-gesteuerter Bandwahlschalter
; fr einen 12-Band KW-Empfnger R250
; externer Vorteiler: keiner
; interner Vorteiler: 256:1
; Messzeit: 1280 us
;
; Prozessor-Takt 4 MHz intern
;
; moeglicher Mebereich:
; 0 MHz ... 22 MHz	Auflsung 200 kHz
;
;**********************************************************
; Includedatei fr den 12F629 einbinden

	#include <P12f629.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen: 12F629
; Power on Timer, kein Watchdog, interner-Oscillator, kein Brown out, kein MCLRE
	__CONFIG	_PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _BODEN_OFF & _MCLRE_OFF

;**********************************************************

;Speicherbereich fr Variablen
; Bank0: 0x20 .. 0x5F ; 64 Byte

; Variablen festlegen

loops		EQU	0x24	; Wait-Schleife
loops2		EQU	0x25	; Wait-Schleife
Bandnummer	EQU	0x26
Muster		EQU	0x27

; 32 Bit Frequenzzhler
BIN4		EQU	0x3B	;LSB
BIN41		EQU	0x3C	; I 
BIN42		EQU	0x3D	; I 
BIN43		EQU	0x3E	;MSB

; Hilfszellen fr Frequenzmessschleife
HLTest		EQU	0x3F	; HL-Flanken-Detektorn fr Timer0-berlauf
HighCOU		EQU	0x40	; high-Teil des Schleifenzhlers
LowCOU		EQU	0x41	; low-Teil des Schleifenzhlers
PreSC		EQU	0x42	; Vorteiler fr die richtige Messung


;********************************************************
; Das Programm beginnt mit der Initialisierung
	org	0

Init	
	; interner Taktgenerator
	bsf	STATUS, RP0	; Bank 1
	call	0x3FF
	movwf	OSCCAL		; 4-MHz-Kalibrierung
	bcf	STATUS, RP0	; Bank 0

	; Interrupt
	bcf	INTCON, GIE	; Int deaktiviert

	; Port
	clrf	GPIO
	movlw	0x07
	movwf	CMCON		; Komparator off
	bsf     STATUS, RP0	; Bank 1
	clrf	OPTION_REG 
	movlw	B'11001100'	; GP0,1,4,5 output 
	movwf	TRISIO		; 
	bcf     STATUS, RP0	; Bank 0	
	clrf	GPIO
	
	; timer1 vorbereiten
	bsf     STATUS, RP0	; Bank 1
	bsf	OPTION_REG, T0CS; GP2-Takt zum Timer0
	bsf	OPTION_REG, PSA	; noch ohne Vorteiler
	bcf     STATUS, RP0	; Bank 0

	; Einstellung des Vorteilers 
	;  256:1 - PS=7
	movlw	0x07		; PRESC = Vorteiler-Faktor 256:1
	movwf	PreSC

;*****************************************************************
; (HighCOU,LowCOU)x20Takte lang wird gezhlt
; das 24-Bit Ergebnis steht in BIN4+2 (MSB) bis BIN4 (LSB)
; virtuell steht davor BIN+3=0
; das mach dann 32Bit
; 
; 200 kHz Resolution bei PT=256:1
; 1280 us x 1 MHz / 256 = 5
; 1280 us = 1280 Takte = 64 x 20 Takte , 00-40 = 64d
;
;
; 	Band	Freq	/256	
;	1	0	0
;	2	2 MHz	10
;	3	4 MHz	20
;	4	6 MHz	30	
;	5	8 MHz	40
;	6	10 MHz	50
;	7	12 MHz	60
;	8	14 MHz	70
;	9	16 MHz	80
;	10	18 MHz	90
;	11	20 MHz	100
;	12	22 MHz	110
;
;*****************************************************************

;*HAUPTSCHLEIFE***************************************************
Frequ_Loop

	; sicher ist sicher, ab und zu hat GP5 gesponnen
	bsf     STATUS, RP0	; Bank 1
	movlw	B'11001100'	; GP0,1,4,5 output 
	movwf	TRISIO		; 
	bcf     STATUS, RP0	; Bank 0	

	; Testmode?
	btfss	GPIO,3
	goto	Bandausgabe0	; ja, Testmode

	;Messung mit 200kHz Auflsung
	clrf	BIN4+1 		; clear counter 
	clrf	BIN4+2 		; clear counter 
	clrf	BIN4+3 		; clear counter 

	clrf	HLTest	 	; initialize TMR0 overflow detector
	movlw	00h+1 		; high loop counter for 1280 us
	movwf	HighCOU 	; HighCOU = hi byte counter
	movlw	40h+1 		; 0040h=64d, cycles=1280, T=1280 us 
	movwf	LowCOU 		; LowCOU = lo byte counter
	movfw	PreSC		; PRESC = Vorteiler-Faktor
	call	Messung
	;Ende der Zhlroutine


;************************************************************************
; Bandnummer ermitteln
;
;	Zhlstand	Band
;	0..4		1
;	5..14		2
;	15..24		3
;	25..34		4
;	35..44		5
;	45..54		6
;	55..64		7
;	65..74		8
;	75..84		9
;	85..94		10
;	95..104		11
;	105..114	12

	; >255 ist eine Fehlmessung
	movfw	BIN43
	bnz	Frequ_Loop	; und alles noch mal von vorne
	movfw	BIN42
	bnz	Frequ_Loop	; und alles noch mal von vorne
	movfw	BIN41
	bnz	Frequ_Loop	; und alles noch mal von vorne

	clrf	Bandnummer
	movlw	5

	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 1

	movlw	D'10'

	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 2
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 3
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 4
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 5
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 6
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 7
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 8
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 9
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 10
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 11
	incf	Bandnummer,f
	subwf	BIN4,f
	bnc	Bandausgabe	; Band 12
	; >114 ist eine Fehlmessung

	goto	Frequ_Loop	; und alles noch mal von vorne


;***********************************************************************************
Bandausgabe0
	clrf	Bandnummer	; Testmode

Bandausgabe
	movfw	Bandnummer
	andlw	B'00001100'
	movwf	Muster
	bcf	STATUS,C
	rlf	Muster, f
	rlf	Muster, f
	movfw	Bandnummer
	andlw	B'00000011'
	iorwf	Muster,w
	movwf	GPIO


	goto	Frequ_Loop	; und alles noch mal von vorne


;***********************************************************************************

;***********************************************************************************
; die eigentliche  Messroutine
; Messzeit = 20Takte x (HighCOU,LowCOU)
; Prescaler in w
Messung
	addlw	20h 		; for PRESC 0,1,2,3... w=20h,21h,22h,23h...
				; TOSE=0, TOCS=1, PSA=0, PS=0..7
	bsf	STATUS,RP0 	; bank 1
	movwf	OPTION_REG 	; 
	bcf	STATUS,RP0 	; bank 0
	clrf	TMR0 		; initialize TMR0

LoopLow
	nop			; warten
	nop			; warten
LoopHigh
	movf	TMR0, W		; 1 1 1 only place where TMR0 is read
	movwf	BIN4		; 1 1 1 rtcc ---> freq0
	rlf	BIN4, W		; 1 1 1 carry <--- TMR0.7
	rlf	HLTest, F	; 1 1 1 rotor <--- carry
	movf	HLTest, W	; 1 1 1 HLTest=TMR0 overflow detect
	andlw	3		; 1 1 1 mask 2 LSbs for edge detect
	xorlw	2		; 1 1 1 00000000 if 1 <--- 0
	btfss	STATUS, Z	; 1 2 2 | skip if TMR0 overflow
	goto	NotOvf1		; 2 - - | if nz
				;       | 5T any case
	incf	BIN4+1, F	; - 1 1 | nsb
NotOvf1 btfsc	STATUS, Z	; 2 2 1 | skip MSB adv ifnot overflow
	incf	BIN4+2, F 	; - - 1 | msb
	nop			; warten
	nop			; warten
	nop			; warten
	decfsz	LowCOU, F 	; 1 (2) lo loop counter
	goto	LoopLow 	; 2 (-) 20T total
	decfsz	HighCOU, F 	; (1) hi loop counter
	goto	LoopHigh 	; (2) 20T total

	return

;**************************************************************

	end		
;**************************************************************