	list p=12f675
;***********************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	GP: 	0 < Taste OSCCAL+
;*		1 < Taste OSCCAL-
;*		2 < Taste OSCCAL -> EEPROM
;*		3 < MCLR (Reset)
;*		4 > Takt/4 (ca. 1 MHz)
;*		5 > Rechteck 1953,125 Hz
;*	
;***********************************************************************
;
;sprut (zero) Bredendiek 07/2004
;
; Kalibrierung des RC-Oszillators im 12F629/675 und hnlichen PICs
; Variante 2 mit Frequenzmesser an GP5 und Tasten an GP0..2
;	Pin GP0 Taster zur Takterhhung
;	Pin GP1 Taster zur Taktverminderung
;	Pin GP2 Taster zum Speichern und beenden
;	GP5 : 1953,125 Hz Ausgang
;	GP4 : 1 MHz-Ausgang
;
; Prozessor 12F629/675 o.. 
;
; Prozessor-Takt ~ 4 MHz intern
;
;
;***********************************************************************
; Includedatei fr den 12F675 einbinden

	#include <P12f675.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen:
; kein Power on Timer, kein Watchdog, int-Oscillator, kein Brown out
	__CONFIG	_MCLRE_ON & _PWRTE_OFF & _WDT_OFF & _INTRC_OSC_CLKOUT & _BODEN_OFF


;***********************************************************************
; Variablen festlegen ab 20h

W_save		Equ	0x20		; auch 0xA0
Status_save	equ	0x21		; registers for saving context
PCLATH_save	equ	0x22
counter		equ	0x23
EEWriteData	equ	0x24
osccalcopy	equ	0x25		; auch 0xA5


;***********************************************************************
	org	0x00

	goto	Main

;***********************************************************************
	org	0x04

InterruptServiceVector
	movwf	W_save			; save W
	swapf	STATUS,W
	bcf	STATUS, RP0		; Bank 0
	movwf	Status_save

	;Rechteckschwingung erzeugen
	btfss	GPIO,5
	goto	PinEin
	bcf	GPIO,5
	goto	PinFertig
PinEin
	bsf	GPIO, 5
PinFertig

	; Zeit fr Tastenabfrage?
	incf	counter, f
	btfss	STATUS, Z
	goto	weiter			; nein, noch nicht

	; Taster abfragen
Taste0
	btfsc	GPIO, 0
	goto	Taste1
	bsf	STATUS, RP0		; OSACCAL erhhen
	incf	osccalcopy, f
	movfw	osccalcopy
	movwf	OSCCAL
	bcf	STATUS, RP0
Taste1
	btfsc	GPIO, 1
	goto	Taste2
	bsf	STATUS, RP0		; OSACCAL verringern
	decf	osccalcopy, f
	movfw	osccalcopy
	movwf	OSCCAL

	bcf	STATUS, RP0
Taste2
	btfsc	GPIO, 2
	goto	weiter
	bsf	STATUS, RP0		; OSCCAL in den EEPROM
	movfw	OSCCAL
	bcf	STATUS, RP0
	movwf	EEWriteData
	movlw	0x7F
	call	EEWrite

	;anhalten
	bcf	INTCON, T0IE
	sleep

weiter
	bcf	INTCON, T0IF

	; Ende ISR, restore context 
	swapf	Status_save, w
	movwf	STATUS
	swapf	W_save,f    		; restore W without corrupting STATUS
	swapf	W_save,w
	retfie
 

;***********************************************************************
; Initialisierung
;
;***********************************************************************
Init
	; IO-Pins
	bcf	STATUS, RP0		; Bank 0
	clrf	GPIO			; aus!
	movlw	0x07
	movwf	CMCON			; alle Pins digital (nicht Comp)

	bsf	STATUS, RP0		; Bank 1
	clrf	ANSEL			; alle Pins digital (nicht ADC 12F675)

	movlw	0x1F			; '0001 1111'
	movwf	TRISIO			; alle input auer GP5

	bcf	OPTION_REG,7		; pull up
	bsf	WPU, 0			; pull up fr die Taster ein
	bsf	WPU, 1
	bsf	WPU, 2
	bcf	STATUS, RP0		; Bank0

	; interner Taktgenerator
	bsf	STATUS, RP0		; Bank 1
	movlw	D'128'
	movwf	osccalcopy
	movwf	OSCCAL			; 4-MHz-Kalibrierung auf Mittelwert
	bcf	STATUS, RP0		; Bank 0

	; steht schon ein OSCCAL im EERPOM??
	; alle Werte auer 0x00 und 0xFF werden akzeptiert
	movlw	0x7F
	call	EERead
	movwf	counter
	incf	counter, f		; test auf FF
	btfsc	STATUS, Z
	goto	nichts			; FF ist kein gltiger OSCCAL
	decf	counter, w		; test auf 00
	btfsc	STATUS, Z
	goto	nichts			; 00 ist kein gltiger OSCCAL
	bsf	STATUS, RP0		; Bank 1
	movwf	OSCCAL			; wenn nicht 00 oder FF dan OSCCAL
	movwf	osccalcopy
	bcf	STATUS, RP0		; Bank 0
nichts

	; Interrupt
	bcf	INTCON, GIE		; Int deaktiviert
	clrf	counter

	; TIMER0 mu eingestellt sein! 
	; 1:1 bei 4 MHz -> 1 MHz
	; berlauf nach 0,256 ms
	; 3906,25 int in s Sekunden
	; daraus entsteht der 1953,125 Hz-Takt an GP5
	bsf	STATUS, RP0		; Bank 1
	bcf	OPTION_REG, T0CS	; interner Takt/4
	bsf	OPTION_REG, PSA		; kein Vorteiler am Timer0
	bcf	STATUS, RP0		; Bank 0

	; Interrupt nur von Timer0 erlauben
	bcf	INTCON, T0IF
	bsf	INTCON, T0IE
	bsf	INTCON, GIE		; Int aktiviert

	return


;***********************************************************************
;Main 
;
;***********************************************************************
Main
	call	Init			; PIC initialisieren

Loop
	goto	Loop			; warten bis der Mensch endlich fertig ist


;***********************************************************************
;  EEPROM-Routinen fr 12F6xx                  
;
;***********************************************************************
; 12F6xx hat 128 EEPROM-Zellen

;	EEADR 		Bank 1
;	EEDATA		Bank 1
;	EECON1		Bank 1
;	EECON2 		Bank 1


; lesen der Zelle ^W nach W
EERead
	BSF  	STATUS, RP0 		; Bank 1
 	MOVWF 	EEADR 			; schreibe die Adresse in EEADR 
	BSF  	EECON1, RD 		; EEPROM Leseproze starten 
	MOVF 	EEDATA, W 		; Die Daten der EEPROM Zelle nach W kopieren 
	BCF 	STATUS, RP0 		; Bank 0 
	return

; schreibe EEWriteData in Zelle ^W
EEWrite
	BSF 	STATUS, RP0 		; Bank 1
	MOVWF 	EEADR 			; Die Zelle @W soll beschrieben werden 
	BCF 	STATUS, RP0		; EEWritedata liegt in Bank 0
	MOVFW 	EEWriteData	
	BSF 	STATUS, RP0 		; EEDATA liegt in der Bank 1
	MOVWF 	EEDATA 			; EEWriteData wollen wir schreiben 
	BSF 	EECON1, WREN 		; nun ist Schreiben erlaubt 

	bcf	INTCON, GIE
	; Die folgenden 5 Zeilen mssen genau so im Code stehen!!! 
	MOVLW 	055h
	MOVWF 	EECON2 			; schreibe 55h nach EECON2 
	MOVLW 	0AAh
	MOVWF 	EECON2 			; schreibe AAh nach EECON2 
	BSF 	EECON1, WR 		; starte den Schreibzyklus 
	bsf	INTCON, GIE

EEWrite1				; warten das write fertig ist
	btfsc	EECON1, WR
	goto	EEWrite1
	BCF	EECON1, WREN		; disable schreiben
	BCF 	STATUS, RP0 		; Bank 0 
	return

	end


