	list p=12f675
;***********************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	GP: 	0 > 7,6294 Hz-Takt
;*		1 > L-arbeitet; H-fertig
;*		2 -
;*		3 -
;*		4 > OSC2 Quarz nach OSC1 und 33 pF nach Vss
;*		5 < OCS1 Quarz nach OSC2 und 33 pF nach Vss
;*	
;***********************************************************************
;
;sprut (zero) Bredendiek 07/2004
;
; Kalibrierung des RC-Oszillators im 12F629/675 und hnlichen PICs
; Variante 1 mit Uhrenquarzu an Timer1
;
; Prozessor 12F629/675 o.. 
;
; Prozessor-Takt ~ 4 MHz intern
;
;
;***********************************************************************
; Includedatei fr den 12F675 einbinden

	#include <P12f675.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen:
; kein Power on Timer, kein Watchdog, int-Oscillator, kein Brown out
	__CONFIG	_MCLRE_ON & _PWRTE_OFF & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _BODEN_OFF


;***********************************************************************
; Variablen festlegen ab 20h

W_save		Equ	0x20		; auch 0xA0
Status_save	equ	0x21		; registers for saving context
PCLATH_save	equ	0x22
counter		equ	0x23
EEWriteData	equ	0x24
osccalcopy	equ	0x25		; auch 0xA5
tLow		equ	0x26
tHigh		equ	0x27


;***********************************************************************
	org	0x00

	goto	Main

;***********************************************************************
	org	0x04

InterruptServiceVector
	movwf	W_save			; save W
	swapf	STATUS,W
	bcf	STATUS, RP0		; Bank 0
	movwf	Status_save

	;Rechteckschwingung erzeugen
	btfss	GPIO,0
	goto	PinEin
	bcf	GPIO,0
	goto	PinFertig
PinEin
	bsf	GPIO, 0
PinFertig


	; Timer 1 auslesen
	bcf	T1CON, TMR1ON		; Timer1 anhalten
	movfw	TMR1L
	movwf	tLow
	movfw	TMR1H
	movwf	tHigh
	clrf	TMR1L
	clrf	TMR1H
	bsf	T1CON, TMR1ON		; Timer1 an

	; falls timer1 zu klein ist, dann war frequenz zu hoch
	;	-> osccal verkleinern


	; Test TMR1H
	movfw	tHigh			; Test auf 0
	btfsc	STATUS, Z
	goto	Odown			; 0 -> takt zu hoch

	decf	tHigh, w		; Test auf 1
	btfss	STATUS, Z
	goto	Oup			; >1 -> Takt viel zu niedrig

	; nun wissen wir, das TMR1H=1
	; Test TMR1L folgt nun, 9..F ist zulssig
	; sicherheitshalber teste ich auf A..D
	; Test auf <0x0A
	movlw	0x0A
	subwf	tLow, w			; w:= low - A
	btfss	STATUS,C
	goto	Odown
	; Test auf >D
	movlw	0x0D
	subwf	tLow, w			; w:= low - D
	btfsc	STATUS,C
	goto	Oup
	;fertig
	incf	counter, f
	btfsc	counter,2		;4x korrekt
	goto	Oend
	goto	weiter

Oup
	clrf	counter
	bsf	STATUS, RP0		; OSACCAL erhhen
	incf	osccalcopy, f
	movfw	osccalcopy
	movwf	OSCCAL
	bcf	STATUS, RP0
	goto	weiter

Odown
	clrf	counter
	bsf	STATUS, RP0		; OSACCAL verringern
	decf	osccalcopy, f
	movfw	osccalcopy
	movwf	OSCCAL
	bcf	STATUS, RP0
	goto	weiter

Oend
	bsf	STATUS, RP0		; OSCCAL in den EEPROM
	movfw	OSCCAL
	bcf	STATUS, RP0
	movwf	EEWriteData
	movlw	0x7F
	call	EEWrite
	;anhalten
	bcf	INTCON, T0IE
	bcf	GPIO, 0
	bsf	GPIO, 1
	sleep

weiter
	bcf	INTCON, T0IF

	; Ende ISR, restore context 
	swapf	Status_save, w
	movwf	STATUS
	swapf	W_save,f    		; restore W without corrupting STATUS
	swapf	W_save,w
	retfie
 

;***********************************************************************
; Initialisierung
;
;***********************************************************************
Init
	; IO-Pins
	bcf	STATUS, RP0		; Bank 0
	clrf	GPIO			; aus!
	movlw	0x07
	movwf	CMCON			; alle Pins digital (nicht Comp)

	bsf	STATUS, RP0		; Bank 1
	clrf	ANSEL			; alle Pins digital (nicht ADC 12F675)

	movlw	0x3C			; '0011 1100'
	movwf	TRISIO			; alle input auer GP0,&1

	bcf	STATUS, RP0		; Bank0

	; interner Taktgenerator
	bsf	STATUS, RP0		; Bank 1
	movlw	D'128'
	movwf	osccalcopy
	movwf	OSCCAL			; 4-MHz-Kalibrierung auf Mittelwert
	bcf	STATUS, RP0		; Bank 0

	; steht schon ein OSCCAL im EERPOM??
	; alle Werte auer 0x00 und 0xFF werden akzeptiert
	movlw	0x7F
	call	EERead
	movwf	counter
	incf	counter, f		; test auf FF
	btfsc	STATUS, Z
	goto	nichts			; FF ist kein gltiger OSCCAL
	decf	counter, w		; test auf 00
	btfsc	STATUS, Z
	goto	nichts			; 00 ist kein gltiger OSCCAL
	bsf	STATUS, RP0		; Bank 1
	movwf	OSCCAL			; wenn nicht 00 oder FF dan OSCCAL
	movwf	osccalcopy
	bcf	STATUS, RP0		; Bank 0
nichts

	; Interrupt
	bcf	INTCON, GIE		; Int deaktiviert
	clrf	counter

	; TIMER1 mu eingestellt sein! 
	; Takt von OCS1/OSC2
	; kein Vorteiler
	bsf	T1CON, T1OSCEN		; 32 kHz Quarz anschalten
	bsf	T1CON, T1CKPS1	
	bsf	T1CON, T1CKPS0		; Vorteiler 8:1
	bcf	T1CON, NOT_T1SYNC	; synchrones Zhlen
	bsf	T1CON, TMR1CS		; externer Takt (32kHz)
	bsf	T1CON, TMR1ON		; Timer1 an
	clrf	TMR1L
	clrf	TMR1H
	

	; TIMER0 mu eingestellt sein! 
	; 256:1 bei 4 MHz -> 3906,25 Hz
	; berlauf nach 65,5 ms
	; 15,26 int pro Sekunde
	; daraus entsteht der 7,62 Hz-Takt an GP5
	bsf	STATUS, RP0		; Bank 1
	bcf	OPTION_REG, T0CS	; interner Takt/4
	bcf	OPTION_REG, PSA		; Vorteiler am Timer0
	bsf	OPTION_REG, PS0
	bsf	OPTION_REG, PS1
	bsf	OPTION_REG, PS2		; Vorteiler 256:1
	bcf	STATUS, RP0		; Bank 0

	; Interrupt nur von Timer0 erlauben
	bcf	INTCON, T0IF
	bsf	INTCON, T0IE
	bsf	INTCON, GIE		; Int aktiviert

	return


;***********************************************************************
;Main 
;
;***********************************************************************
Main
	call	Init			; PIC initialisieren

Loop
	goto	Loop			; warten bis der Mensch endlich fertig ist


;***********************************************************************
;  EEPROM-Routinen fr 12F6xx                  
;
;***********************************************************************
; 12F6xx hat 128 EEPROM-Zellen

;	EEADR 		Bank 1
;	EEDATA		Bank 1
;	EECON1		Bank 1
;	EECON2 		Bank 1


; lesen der Zelle ^W nach W
EERead
	BSF  	STATUS, RP0 		; Bank 1
 	MOVWF 	EEADR 			; schreibe die Adresse in EEADR 
	BSF  	EECON1, RD 		; EEPROM Leseproze starten 
	MOVF 	EEDATA, W 		; Die Daten der EEPROM Zelle nach W kopieren 
	BCF 	STATUS, RP0 		; Bank 0 
	return

; schreibe EEWriteData in Zelle ^W
EEWrite
	BSF 	STATUS, RP0 		; Bank 1
	MOVWF 	EEADR 			; Die Zelle @W soll beschrieben werden 
	BCF 	STATUS, RP0		; EEWritedata liegt in Bank 0
	MOVFW 	EEWriteData	
	BSF 	STATUS, RP0 		; EEDATA liegt in der Bank 1
	MOVWF 	EEDATA 			; EEWriteData wollen wir schreiben 
	BSF 	EECON1, WREN 		; nun ist Schreiben erlaubt 

	bcf	INTCON, GIE
	; Die folgenden 5 Zeilen mssen genau so im Code stehen!!! 
	MOVLW 	055h
	MOVWF 	EECON2 			; schreibe 55h nach EECON2 
	MOVLW 	0AAh
	MOVWF 	EECON2 			; schreibe AAh nach EECON2 
	BSF 	EECON1, WR 		; starte den Schreibzyklus 
	bsf	INTCON, GIE

EEWrite1				; warten das write fertig ist
	btfsc	EECON1, WR
	goto	EEWrite1
	BCF	EECON1, WREN		; disable schreiben
	BCF 	STATUS, RP0 		; Bank 0 
	return

	end


