	list p=16f876
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 < PTC-Spannung No 1
;*		1 < PTC-Spannung No 2
;*		2 > Lautsprecher
;*		3 -
;*		4 -
;*
;*	PORTB:	0 Segment A	   AAAAA	   AAAAA	   AAAAA	   AAAAA
;*		1 Segment F	  F     B	  F     B	  F     B	  F     B
;*		2 Segment E	  F     B	  F     B	  F     B	  F     B
;*		3 Segment D	   GGGGG  	   GGGGG  	   GGGGG  	   GGGGG 
;*		4 Segment H	  E     C	  E     C	  E     C	  E     C
;*		5 Segment C	  E     C	  E     C	  E     C	  E     C
;*		6 Segment G	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH
;*		7 Segment B    
;*	
;*	PORTC:	0 LED----------------------------------------------------------------A4
;*		1 > PWM-Ausgang No 2		
;*		2 > PWM-Ausgang No 1       
;*		3 LED------------------------------------------------A3
;*		4 LED--------------------------------A2
;*		5 LED----------------A1
;*		6 - (> TX: RS-232-Ausgang zum Treiber)
;*		7 - (< RX: RS-232-Eingang vom Treiber)	
;*	
;**************************************************************
;
;sprut (zero) Bredendiek 08/2005  11/2008
;
; Termometer mit 16F876 und KTY81-110
; Lftersteuerung ber PWM und Schalttransitor
;
; Prozessor 16F876 / 16F673
;
; Prozessor-Takt 4 MHz
;
; PTC-Spannung:
;	Temp.	Spannung	ADC
;	-20C	1,0106 V	206
;	0C	1,1593 V	237
;	+20C	1,3125 V	268
;	+40C	1,4678 V	300
;	+100C	1,9290 V	395
;
; PWM-Verhltnis (default) (Steilheit 4%/K)
;	<35C	  0%
;	 35C	 50%
;	 48C	100%
;	>63C	Alarm
;
; RS232-Kommandos (19,2 kBaud)
;	h	diesen Hilfetext ausgeben
;	t	Temperaturen und Einschalttemperaturen ausgeben
;	q	Nullpunkt 1. Kanal um 1K erhhen
;	a	Nullpunkt 1. Kanal um 1K absenken
;	w	Nullpunkt 2. Kanal um 1K erhhen
;	s	Nullpunkt 2. Kanal um 1K absenken
;	e	Einschaltpunkt 1. Kanal um 1K erhhen
;	d	Einschaltpunkt 1. Kanal um 1K absenken
;	r	Einschaltpunkt 2. Kanal um 1K erhhen
;	f	Einschaltpunkt 2. Kanal um 1K absenken
;	u	Alarm 1. Kanal um 1K erhhen
;	j	Alarm 1. Kanal um 1K absenken
;	i	Alarm 2. Kanal um 1K erhhen
;	k	Alarm 2. Kanal um 1K absenken
;	o	mindest-PWM um 1 erhhen
;	l	mindest-PWM um 1 absenken
;	c	Hysterese 1. Kanal um 1K erhhen
;	v	Hysterese 1. Kanal um 1K absenken
;	b	Hysterese 2. Kanal um 1K erhhen
;	n	Hysterese 2. Kanal um 1K absenken
;
;
;**************************************************************
; Includedatei fr den 16F876 einbinden

	#include <P16f876.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen:
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming
	__CONFIG	_PWRTE_ON & _WDT_OFF & _XT_OSC & _BODEN_OFF & _LVP_OFF


;**************************************************************
; Variablen festlegen

w_copy		Equ	0x20	; nur fr INT
s_copy		Equ	0x21	; nur fr INT
p_copy		EQU	0x22	; nur fr INT

Flags		EQU	0x23
NrMessung	EQU	0x24	; zhlt die 64 Temperaturmessungen
Fehler		equ	0x25	; Fehlerregister fr Mathematik

count		equ	0x26	; universeller zhler
loops		equ	0x27	; timer fr wait
loops2		equ	0x28	; timer fr wait

; Dezimalstellen
Digit		EQU	0x29
Ziffer1		EQU	0x2A
Ziffer2		EQU	0x2B
Ziffer3		EQU	0x2C
Ziffer4		EQU	0x2D
HdH		EQU	0x2E	;3  Hunderter
HdZ		EQU	0x2F	;2  Zehner
HdE		EQU	0x30	;1  Einer
HdX		EQU	0x31	; Puffer fr eine Dezimalstelle

;16 Bit Rechenregister
f0		equ	0x32	; 
f1		equ	0x33	; 
;16 Bit Rechenregister
xw0		equ	0x34	; 
xw1		equ	0x35	; 
;16 Bit Rechenregister
g0		equ	0x36	; 
g1		equ	0x37	; 

TMin1		equ	0x38
TMin2		equ	0x39
DCratio		equ	0x3A	; Rechenregister fr PWM
Zeichen		equ	0x3B	; Puffer fr RS232-Empfang
EEWriteData	equ	0x3C	; Schreibpuffer fr EEPROM
Offset1		equ	0x3D	; Offset des PTC No 1
Offset2		equ	0x3E	; Offset des PTC No 2
Offset		equ	0x3F	; aktueller Offset
Temp		equ	0x40	; Puffer fr Stringausgabe
Alarm1		equ	0x41	; berhitzungstemperatur Kanal 1
Alarm2		equ	0x42	; berhitzungstemperatur Kanal 2
Alarm		equ	0x43	; aktuelle berhitzungstemperatur
PWMmin		equ	0x44	; Einschalt-PWM
Hyst1		equ	0x45	; Hysterese 1. Kanal
Hyst2		equ	0x46	; Hysterese 2. Kanal

; Konstanten festlegen
#define Leading0	Flags,7
#define	Negativ		Flags,6	; 1: Temperatur ist negativ
#define	DatenSindDa	Flags,5	; rs232 hat was empfangen
#define L1_on		Flags,4	; Luefter 1 laeuft
#define L2_on		Flags,3	; Luefter 2 laeuft

Ini_con		Equ	B'00000000'	; TMR0 -> Interupt disable
Ini_opt		Equ	B'10000011'	; Timer0 int 16:1



;**************************************************************

;voreingestellte Default-Werte im EEPROM
	org	H'2100'		; EEPROM
	de	D'150'		; Adr 0 = Offset1
	de	D'150'		; Adr 1 = Offset2
	de	D'35'		; Adr 2 = TMin1
	de	D'35'		; Adr 3 = TMin2
	de	D'63'		; Adr 4 = Alarm1
	de	D'63'		; Adr 5 = Alarm2
	de	D'50'		; Adr 6 = PWMmin
	de	D'1'		; Adr 7 = Hyst1
	de	D'1'		; Adr 8 = Hyst2

;**************************************************************
	org	0
	goto	Init
	org 	4 
	goto	Intvec


;**************************************************************
; 7-Segment-Tabelle
; Absturzgefahr falls w>11 , also bei Temp>119C	!!

;*	PORTB:	0 Segment A	   AAAAA
;*		1 Segment F	  F     B
;*		2 Segment E	  F     B
;*		3 Segment D	   GGGGG
;*		4 Segment H	  E     C
;*		5 Segment C	  E     C
;*		6 Segment G	   DDDDD  HH
;*		7 Segment B    
;
Segmente
	addwf	PCL, f
;		  76543210
; 		  BGCHDEFA
	retlw	B'01010000'	; 0
	retlw	B'01011111'	; 1
	retlw	B'00110010'	; 2
	retlw	B'00010110'	; 3
	retlw	B'00011101'	; 4
	retlw	B'10010100'	; 5
	retlw	B'10010000'	; 6
	retlw	B'01011110'	; 7
	retlw	B'00010000'	; 8
	retlw	B'00010100'	; 9
	retlw	B'11111111'	; dunkel
	retlw	B'10111111'	; -

;**************************************************************
; Texte

Txt_1	dt	"Temp    Thresh   Offset    Alarm    Hyterese RPM   RPMmin",0Ah,8Dh	; RETLW
Txt_K	dt	" C   ",' '+80h					; RETLW

Txt_h1	dt	"h   - diesen Text ausgeben",0Ah,8Dh		; RETLW
Txt_h2	dt	"t   - Werte anzeigen",0Ah,8Dh			; RETLW
Txt_h3	dt	"q/a - Offset 1 +/-",0Ah,8Dh			; RETLW
Txt_h4	dt	"w/s - Offset 2 +/-",0Ah,8Dh			; RETLW
Txt_h5	dt	"e/d - Einschaltpunkt 1 +/-",0Ah,8Dh		; RETLW
Txt_h6	dt	"r/f - Einschaltpunkt 2 +/-",0Ah,8Dh		; RETLW
Txt_h7	dt	"u/j - Alarm 1 +/-",0Ah,8Dh			; RETLW
	org	0x100
Txt_h8	dt	"i/k - Alarm 2 +/-",0Ah,8Dh			; RETLW
Txt_h9	dt	"o/l - Mindest-PWM +/-",0Ah,8Dh			; RETLW
Txt_h10	dt	"c/v - Hysterese 1 +/-",0Ah,8Dh			; RETLW
Txt_h11	dt	"b/n - Hysterese 2 +/-",0Ah,8Dh			; RETLW



;**************************************************************
; die Interuptserviceroutine

	
Intvec
	movwf	w_copy		; w retten
	swapf	STATUS, w 	; STATUS retten
	clrf	STATUS
	movwf	s_copy		;
	movf	PCLATH, W
	movwf	p_copy
	clrf	PCLATH		; Bank 0 

	; Intrupt servic routine
Int_serv 
;RS232-Empfnger-Interupt? 
	btfss	PIR1,RCIF 
	goto	IntTimer0	; Interrupt kam von wo anders 
	;RS232-Empfnger-Interupt! 
	movfw	RCREG		; RS232-Register auslesen 
	movwf	Zeichen		; und in den Speicher nach 'Zeichen' schreiben 
	bsf	DatenSindDa	; Kennzeichen fr gltige Daten setzen
	bcf	PIR1,RCIF	; interrupt-Flag lschen 
	goto	Int_end

;Timer0-Interupt
IntTimer0
	bsf	PORTC, 0	; Ziffer1 aus
	bsf	PORTC, 3	; Ziffer2 aus
	bsf	PORTC, 4	; Ziffer3 aus
	bsf	PORTC, 5	; Ziffer4 aus
	decf	Digit,f		; Ziffernzhler verringern
	;Digit=3: anzeigen Ziffer 4    1er 1
	;Digit=2: anzeigen Ziffer 3   10er 1
	;Digit=1: anzeigen Ziffer 2    1er 2
	;Digit=0: anzeigen Ziffer 1   10er 2
	btfsc	STATUS, Z
	goto	Int_0		; Z-Flag=1 ergo Digit=0
	decf	Digit, w
	btfsc	STATUS, Z
	goto	Int_1		; Digit=1
	btfss	Digit, 0	; 2 oder 3?
	goto	Int_2		; Digit=2
	goto	Int_3		; Digit=3

Int_0
	movfw	Ziffer1		; Wert der 1. Ziffer (10er No 2)
	call	Segmente
	movwf	PORTB		; Segmente einschalten
	bcf	PORTC, 5	; 1. Ziffer einschalten
	movlw	4
	movwf	Digit
	goto	Int_end

Int_1
	movfw	Ziffer2		; Wert der 2. Ziffer (1er No 2)
	call	Segmente
	movwf	PORTB		; Segmente einschalten
	bcf	PORTC, 4	; 2. Ziffer einschalten
	goto	Int_end

Int_2
	movfw	Ziffer3		; Wert der 3. Ziffer (10er No 1)
	call	Segmente
	movwf	PORTB		; Segmente einschalten
	bcf	PORTC, 3	; 3. Ziffer einschalten
	goto	Int_end

Int_3
	movfw	Ziffer4		; Wert der 3. Ziffer (1er No 1)
	call	Segmente
	movwf	PORTB		; Segmente einschalten
	bcf	PORTC, 0	; 3. Ziffer einschalten
	goto	Int_end

Int_end
	movf	p_copy, W
	movwf	PCLATH
	swapf	s_copy, w	; STATUS zurck
	movwf	STATUS 
	swapf	w_copy, f	; w zurck mit flags
	swapf	w_copy, w

	bcf	INTCON, T0IF	; Interupt-Flag lschen
	retfie


;**************************************************************
; Das Programm beginnt mit der Initialisierung

Init	
	; IO-Ports einstellen
	movlw	B'11111111'
	movwf	PORTB
	movwf	PORTC		; LED aus
	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up on
	movwf   OPTION_REG 
	movlw	B'11111011'	; PortA2 output fr sound
	movwf	TRISA
	movlw	B'00000000'	; PortB alle outputs 
	movwf	TRISB
	movlw	B'10000000'	; PortC alle outputs auer RC7 fr RS232
	movwf	TRISC
	bcf     STATUS, RP0	; Bank 0
	movlw	B'11111111'
	movwf	PORTB
	movwf	PORTC		; LED aus

	bcf	L1_on		; Flags lschen
	bcf	L2_on		; Flags lschen
	
	movlw   Ini_con     	; Interupt disable
	movwf   INTCON   

	movlw	3
	movwf	Digit

	movlw	D'1'
	movwf	Ziffer1
	movlw	D'2'
	movwf	Ziffer2
	movlw	D'3'
	movwf	Ziffer3
	movlw	D'4'
	movwf	Ziffer4		; Anzeige '4321'

	;Lftereinschalttemperatur festlegen
	movlw	0
	call	EERead
	movwf	Offset1
	movlw	1
	call	EERead
	movwf	Offset2
	movlw	2
	call	EERead
	movwf	TMin1
	movlw	3
	call	EERead
	movwf	TMin2
	movlw	4
	call	EERead
	movwf	Alarm1
	movlw	5
	call	EERead
	movwf	Alarm2
	movlw	6
	call	EERead
	movwf	PWMmin
	movlw	7
	call	EERead
	movwf	Hyst1
	movlw	8
	call	EERead
	movwf	Hyst2


; ADC initialisieren
	; ADC einschalten
	BSF	ADCON0, 0	; ADON=1
	; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, 5	; ADCHS2=0
	BCF	ADCON0, 4	; ADCHS1=0
	BCF	ADCON0, 3	; ADCHS0=0
	; ADC speed fr 1,25 ... 5 MHz einstellen
	BCF	ADCON0, 7	; ADCS1=0
	BSF	ADCON0, 6	; ADCS0=1
	; Daten rechtsbndig
	BSF	STATUS,RP0	; Bank1
	clrf	ADCON1
	BSF	ADCON1, PCFG2	; RA2=digital
	BSF	ADCON1, 7	; ADFM=1
	BCF	STATUS,RP0	; Bank0

; 244 Hz-Timer0-Interupt einstellen
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'10000011'	; internen Takt zhlen, Vorteiler zum Timer0, 16:1
				; T0CS=0, PSA=0, PS=100, xx0x0100
	movwf	OPTION_REG
	movlw	D'0'		; (1MHz : 16 ): 256= 244Hz
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten
	movwf	TMR0

	bcf	INTCON, T0IF
	bsf	INTCON, T0IE	; Timer0 interupt erlauben
	bsf	INTCON, GIE	; Interupt erlauben

; PWM initialisieren
	; 16F876 erzeugt an RC2 & RC1 ein 10 kHz-Signal 
	; an RC2 betrgt das Tastverhltnis 50%
	; an RC1 betrgt das Tastverhltnis 25%
	; Prozessortakt:  4 MHz

	; Vorteiler 1:1 und Timer2 einschalten
	BCF	T2CON,T2CKPS1	; Vorteiler 1:1
	BCF	T2CON,T2CKPS0	; Vorteiler 1:1
	BSF	T2CON,TMR2ON	; Timer2 ein

	; Frequenz auf 10 kHz einstellen
	BSF	STATUS,RP0	; Bank1
	MOVLW	D'99'		;
	MOVWF	PR2		; 10 kHz
	BCF	STATUS,RP0	; Bank0

	; Tastverhltnis auf 50% bzw 25% einstellen als DEBUG-Test
	MOVLW	D'50'		;
	MOVWF	CCPR1L		; 50% von 100
	MOVLW	D'25'	
	MOVWF	CCPR2L		; 25% von 100

	; RC2/CCP1 und RC1/CCP2 auf Ausgang stellen
	BSF	STATUS,RP0	; Bank1
	BCF	TRISC, 2	; RC2: output=0
	BCF	TRISC, 1	; RC1: output=0
	BCF	STATUS,RP0	; Bank 0

	; PWM MODE mit CCP1 initialisieren
	CLRF	CCP1CON		; CCP1-Modus aus
	BSF	CCP1CON,CCP1M3	; CCP1-Modus PWM-Mode
	BSF	CCP1CON,CCP1M2	;

	; PWM MODE mit CCP2 initialisieren
	CLRF	CCP2CON		; CCP2-Modus aus
	BSF	CCP2CON,CCP2M3	; CCP2-Modus PWM-Mode
	BSF	CCP2CON,CCP2M2	;


; USART initialisieren 
	BSF	STATUS,RP0	; Bank1 
	MOVLW	0x20		; Sender: RS232 
	MOVWF	TXSTA		; 
	BCF	STATUS,RP0	; Bank 0 
	MOVLW	0x90		; Empfnger: RS232 
	MOVWF	RCSTA		; 

	; USART Baudrate einstellen 
	BSF	STATUS,RP0	; Bank1 
	MOVLW	D'12'		; Set Baud rate 19,2 kBPS bei 4 MHz 
	MOVWF	SPBRG 
	BSF	TXSTA, BRGH	; BRGH=1 
	BCF	STATUS,RP0	; Bank 0 

	;USART Interrupts vorbereiten 
	BSF	STATUS,RP0	; Bank1 
	BSF	PIE1,RCIE	; Enable receive interrupts 
	BCF	STATUS,RP0	; Bank 0 
	clrf	PIR1		; alle Interruptflags lschen 
	clrf	PIR2 
	BSF	INTCON,GIE	; generell Interrupts erlauben 
	BSF	INTCON,PEIE	; Interrupts von Peripheriegerten erlauben 



;   1. Temperaturregister (16-Bit) auf 82 setzen (32+50)
;   2. 64 mal ADC abfragen, ADC-Wert jeweils zum Temperaturregister addieren (16 Bit Addition)
;   3. Temperaturregister durch 101 dividieren (16 Bit Division)
;   4. Vom Temperaturregister 150 subtrahieren (16 Bit Subtraktion)
;   5. Temperaturregister in BCD umrechen (3-stellig), Vorzeichen beachten


mainloop
	; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, 3	; ADCHS0=0
	; Messen
	movfw	Offset1
	movwf	Offset
	movfw	Alarm1
	movwf	Alarm
	call	Temperatur	; Messung der Temperatur am Sensor 1
	call	Hot		; Test auf bertemperatur
	call	SetPWM1		; PWM1 einstellen
	call	Hex2Dez8_1	; Umrechnung in BCD fr die Anzeige 1

	; ADC-Eingang AN1 auswhlen
	BSF	ADCON0, 3	; ADCHS0=1
	; Messen
	movfw	Offset2
	movwf	Offset
	movfw	Alarm2
	movwf	Alarm
	call	Temperatur	; Messung der Temperatur am Sensor 2
	call	Hot		; Test auf bertemperatur
	call	SetPWM2		; PWM2 einstellen
	call	Hex2Dez8_2	; Umrechnung in BCD fr die Anzeige 2

	; RS232-Terminal
	btfsc	DatenSindDa
	call	RS232Service


	call	wait75ms
	goto	mainloop



;**************************************************************
; Temperatur messen und in f1,f0 ablegen (in C als Binr-Integer)
; bei negativer Temperatur wird das Negativ-Flag=1 gesetzt

Temperatur
	; Startwert fr korrektes Runden
	clrf	f1
	movlw	D'82'
	movwf	f0

	; 64 Messungen
	movlw	D'64'
	movwf	NrMessung
Messung
	call	UMessen1	; AN0 nach xw1,xw0
	call	Add16 		; 16-bit add: f = f + xw
	decfsz	NrMessung, f
	goto	Messung

	; Division durch 101
	movlw	0x00		; 101 = 00 65 h
	movwf	xw1
	movlw	0x65
	movwf	xw0
	call	Div16		; Division f:= f / xw

	; 150C Offset entfernen
	bcf	Negativ		; angenommen: positive Temperatur
	clrf	xw1
	movfw	Offset
	movwf	xw0
	call	Sub16		; 16 bit f:=f-xw   calc=xw cnt=f;  neg=C
	btfss	STATUS, C
	goto	Positiv
	bsf	Negativ
	movfw	f0
	movwf	xw0
	movfw	f1
	movwf	xw1
	clrf	f1
	clrf	f0	
	call	Sub16		; 16 bit f:=f-xw   calc=xw cnt=f;  neg=C

Positiv
	return



;**************************************************************
; Spannung wandeln nach xw1, xw0 
UMessen1
	clrf	count
aqui				; 0,3 ms  ADC Aqusitionszeit nach Eingangswahl
	DECFSZ	count, f
	goto	aqui

	BSF	ADCON0, 2	; ADC starten
loop
	BTFSC	ADCON0, 2	; ist der ADC fertig?
	GOTO	loop		; nein, weiter warten
	movfw	ADRESH		; obere  2 Bit auslesen
	movwf	xw1		; obere  2-Bit nach xw1
	bsf	STATUS,RP0	; Bank1
	movfw	ADRESL		; untere 8 Bit auslesen
	bcf	STATUS,RP0	; Bank0
	movwf	xw0		; untere 8-Bit nach xw0

	clrf	count		; Warten, damit der ADC sich erholen kann
warten
	DECFSZ	count, f
	goto	warten
	return


;**************************************************************
;Warteroutinen verschiedener Lnge ****************************

; 75 ms warten
wait75ms
	movlw	D'75'		; 75ms
	movwf	loops	
	goto	WAIT

;**************************************************************
;Zeitverzgerung um loops * 1 ms
; 4 MHz externer Takt bedeutet 1 MHz interner Takt
; also dauert 1 ms genau 1000 Befehle
; 100 Schleifen a 10 Befehle sind 1000 Befehle = 1 ms

WAIT
top     movlw   .100           ; timing adjustment variable (1ms)
        movwf   loops2
top2    nop                    ; sit and wait
        nop
        nop
        nop
	nop
        nop
        nop
        decfsz  loops2, F      ; inner loops complete?
        goto    top2           ; no, go again
                               ;
        decfsz  loops, F       ; outer loops complete?
        goto    top            ; no, go again
        retlw   0              ; yes, return from subWAIT



;**************************************************************
;+++Mathematik-Routinen ***************************************

;**************************************************************
; 16 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub16				; 16 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen
	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f
	btfsc   STATUS,C
	goto    Sub16A
	movlw   0x01		; borgen von f1
	subwf   f1, f
	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf
Sub16A
	movf    xw1,w		; f1=f1-xw1
        subwf   f1    , f
        btfss   STATUS, C
 	bsf	Fehler, C	; Unterlauf
	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return

;**************************************************************
;16 bit Adition, C-Flag bei berlauf gesetzt
Add16 				; 16-bit add: f = f + xw
	movf	xw0,W		; low byte
	addwf	f0,F 		; low byte add

	movf	xw1,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,W 		; add C if it was set
	addwf	f1,F 		; high byte add if NZ
	
	return 			; finished


;**************************************************************
;primitive 16 bit Division 	f:= f / xw
Div16
	clrf	g0
	decf	g0, f
	clrf	g1
	decf	g1, f
Div16Loop
	incf	g0, f
	btfsc	STATUS, Z
	incf	g1, f
	call	Sub16		;
	btfss	STATUS, C	;berlauf
	goto	Div16Loop	;Stelle 1 mehr
	movfw	g0
	movwf	f0
	movfw	g1
	movwf	f1
	return


;**************************************************************
; 8 Bit Wert w auf LED 2/3-stellig dezimal anzeigen

;              100 = 0064 h
;               10 = 000A h
;                1 = 0001 h

Hex2Dez8_1			; 8-bit (f1, f0) in 2-stellen BCD
	bsf	Leading0
	movlw	0x00		; 10 = 00 0A h
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	btfsc	Negativ
	movlw	D'11'		;'-'
	movwf	Ziffer3
	movfw	f0
	movwf	Ziffer4		; 1 er
	return


Hex2Dez8_2			; 8-bit (f1, f0) in 2-stellen BCD
	bsf	Leading0
	movlw	0x00		; 10 = 00 0A h
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	btfsc	Negativ
	movlw	D'11'		;'-'
	movwf	Ziffer1
	movfw	f0
	movwf	Ziffer2		; 1 er
	return



Hex2Dez8_3			; 8-bit (f1, f0) in 3-stellen BCD
	bsf	Leading0
	movlw	0x00		; 100 = 00 64 h
	movwf	xw1
	movlw	0x64
	movwf	xw0
	call	Hex2Dez1	; 100er
	movfw	HdX
	btfsc	Negativ
	movlw	D'11'		;'-'
	movwf	HdH

	movlw	0x00		; 10 = 00 0A h
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	movwf	HdZ

	movfw	f0
	movwf	HdE		; Einer
	return



Hex2Dez1
	clrf	HdX
	decf	HdX, f
HdLoop
	incf	HdX, f
	call	Sub16		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop		;Stelle 1 mehr
	call	Add16

	; falls fhrende 0 dann Wert=D'10'
	movfw	HdX
	btfss	STATUS, Z
	bcf	Leading0
	btfss	Leading0
	return
	movlw	D'10'
	movwf	HdX
	return

;**************************************************************
; bertemperaturtest
; Alarmton an RA2 falls f0 > Alarm (63C)

Hot
	; prfen ob Temp<Alarm
	MOVFW	Alarm
	subwf	f0, w		; w:=f-w = temp-Alarm
	btfss	STATUS, C
	return			; <64C
	; fr einen 2kHz-Ton sind 4000 Flanken ntig
	; bei 4MHz sind das 250 Zyklen zwischen 2 Flanken

	movlw	D'100'		; 100 Schleifen fr 50 ms Sound
	movwf	Temp
Hot1
	bsf	PORTA, 2
	movlw	.25		; timing adjustment variable (1/4ms)	
	movwf	loops2
	movlw	1
	movwf	loops
	call	top2		; 250us Wait
	bcf	PORTA, 2
	movlw	.25		; timing adjustment variable (1/4ms)	
	movwf	loops2
	movlw	1
	movwf	loops
	call	top2		; 250us Wait
	decfsz	Temp, f
	goto	Hot1
	return


;**************************************************************
; PWM-Verhltnis (default) (Steilheit 4%/K)
; bei Tmin=35
;	<35C	  0%
;	 35C	 50%
;	 48C	100%
;	>63C	Alarm

SetPWM1
	; prfen ob Temp<TMin
	MOVFW	TMin1
	subwf	f0, w		; w:=f-w = temp-TMin
	btfss	STATUS, C
	goto	PWM1off
	; DCratio berechnen :  DCratio:= (bertemperatur x 4) +50%
	bsf	L1_on		; Lfter an
	movwf	DCratio		; bertemperatur -> DCratio
	bcf	STATUS, C
	rlf	DCratio, f	; x2
	bcf	STATUS, C
	rlf	DCratio, f	; x4
	movfw	PWMmin		; +50%
	addwf	DCratio, f
	; prfen ob DCratio>100
	movlw	D'100'
	subwf	DCratio,w	; w:=DCratio-100
	btfsc	STATUS,C
	goto	PWM1max		; DCratio>100
	; DC setzen
	movfw	DCratio
	MOVWF	CCPR1L
	return
PWM1max
	movlw	D'100'
	movwf	CCPR1L
	return
PWM1off
	; Ausschalten, aber nur unterhalb der Hysterese
	addwf	Hyst1,w		; w = temp - Tmin + Hyst
	btfsc	STATUS, C
	return
	clrf	CCPR1L
	bcf	L1_on		; Lfter aus
	return

SetPWM2
	; prfen ob Temp<TMin
	MOVFW	TMin2
	subwf	f0, w		; w:=f-w = temp-TMin
	btfss	STATUS, C
	goto	PWM2off
	; DCratio berechnen :  DCratio:= (bertemperatur x 4) +50%
	bsf	L2_on		; Lfter 1 an
	movwf	DCratio		; bertemperatur -> DCratio
	bcf	STATUS, C
	rlf	DCratio, f	; x2
	bcf	STATUS, C
	rlf	DCratio, f	; x4
	movfw	PWMmin		; +50%
	addwf	DCratio, f
	; prfen ob DCratio>100
	movlw	D'100'
	subwf	DCratio,w	; w:=DCratio-100
	btfsc	STATUS,C
	goto	PWM2max		; DCratio>100
	; DC setzen
	movfw	DCratio
	MOVWF	CCPR2L
	return
PWM2max
	movlw	D'100'
	movwf	CCPR2L
	return
PWM2off
	; Ausschalten, aber nur unterhalb der Hysterese
	addwf	Hyst2,w		; w = temp - Tmin + Hyst
	btfsc	STATUS, C
	return
	clrf	CCPR2L
	bcf	L2_on		; Lfter aus
	return


;SetPWM2
;	MOVFW	f0
;	MOVWF	CCPR2L
;	return


;**************************************************************
;EEPROM-Routinen fr 16F876
;
; 16F876 hat 256 EEPROM-Zellen
; 16F873 hat 128 EEPROM-Zellen

; lesen der Zelle ^W nach W
EERead
	BCF  	STATUS, RP0 	; EEADR liegt in der Bank 2 
	BSF  	STATUS, RP1
 	MOVWF 	EEADR 		; schreibe die Adresse in EEADR 
	BSF  	STATUS, RP0 	; EECON1 liegt in der Bank 3
	BCF  	EECON1, EEPGD 	; EEPROM (und nicht FLASH)
	BSF  	EECON1, RD 	; EEPROM Leseproze starten 
	BCF  	STATUS, RP0 	; EEDATA liegt in der Bank 2 
	MOVF 	EEDATA, W 	; Die Daten der EEPROM Zelle nach W kopieren 
	BCF 	STATUS, RP1 	; Bank 0 
	return

; schreibe EEWriteData in Zelle ^W
EEWrite
	BCF  	STATUS, RP0 	; EEADR liegt in der Bank 2 
	BSF  	STATUS, RP1
	MOVWF 	EEADR 		; Die Zelle @W soll beschrieben werden 
	BCF 	STATUS, RP1	; Bank0
	MOVFW 	EEWriteData	; EEWritedata liegt in Bank 0
	BSF 	STATUS, RP1	; EEDATA liegt in der Bank 2 
	MOVWF 	EEDATA 		; EEWriteData wollen wir schreiben 
	BSF  	STATUS, RP0 	; EECON1 liegt in der Bank 3
	BCF  	EECON1, EEPGD 	; EEPROM (und nicht FLASH)
	BSF 	EECON1, WREN 	; nun ist Schreiben erlaubt 
	BCF	INTCON, GIE	; disable Interrupts

; Die folgenden 5 Zeilen mssen genau so im Code stehen!!! 
	MOVLW 	055h
	MOVWF 	EECON2 		; schreibe 55h nach EECON2 
	MOVLW 	0AAh
	MOVWF 	EECON2 		; schreibe AAh nach EECON2 
	BSF 	EECON1, WR 	; starte den Schreibzyklus 

	BSF	INTCON, GIE	; Interrupts wieder erlauben
EEWrite1			; warten das write fertig ist
	btfsc	EECON1, WR
	goto	EEWrite1
	BCF 	STATUS, RP0 	; Bank 0 
	BCF 	STATUS, RP1
	return


;**************************************************************
; RS232-Terminal-Kommandos
;	h	diesen Hilfetext ausgeben
;	t	Temperaturen und Einschalttemperaturen ausgeben
;	q	Nullpunkt 1. Kanal um 1K erhhen
;	a	Nullpunkt 1. Kanal um 1K absenken
;	w	Nullpunkt 2. Kanal um 1K erhhen
;	s	Nullpunkt 2. Kanal um 1K absenken
;	e	Einschaltpunkt 1. Kanal um 1K erhhen
;	d	Einschaltpunkt 1. Kanal um 1K absenken
;	r	Einschaltpunkt 2. Kanal um 1K erhhen
;	f	Einschaltpunkt 2. Kanal um 1K absenken

;	u	Alarm 1. Kanal um 1K erhhen
;	j	Alarm 1. Kanal um 1K absenken
;	i	Alarm 2. Kanal um 1K erhhen
;	k	Alarm 2. Kanal um 1K absenken
;	o	mindest-PWM um 1 erhhen
;	l	mindest-PWM um 1 absenken

;	c	Hysterese 1. Kanal um 1K erhhen
;	v	Hysterese 1. Kanal um 1K absenken
;	b	Hysterese 2. Kanal um 1K erhhen
;	n	Hysterese 2. Kanal um 1K absenken

RS232Service 
	movfw	Zeichen
	call	RS232TX		;Echo fr DEBUG
	movlw	0x0A
	call	RS232TX
	movlw	0x0D
	call	RS232TX

	movfw	Zeichen
	sublw	'h'
	btfsc	STATUS, Z
	goto	RS232_h
	movfw	Zeichen
	sublw	't'
	btfsc	STATUS, Z
	goto	RS232_t
	movfw	Zeichen
	sublw	'q'
	btfsc	STATUS, Z
	goto	RS232_q
	movfw	Zeichen
	sublw	'a'
	btfsc	STATUS, Z
	goto	RS232_a
	movfw	Zeichen
	sublw	'w'
	btfsc	STATUS, Z
	goto	RS232_w
	movfw	Zeichen
	sublw	's'
	btfsc	STATUS, Z
	goto	RS232_s
	movfw	Zeichen
	sublw	'e'
	btfsc	STATUS, Z
	goto	RS232_e
	movfw	Zeichen
	sublw	'd'
	btfsc	STATUS, Z
	goto	RS232_d
	movfw	Zeichen
	sublw	'r'
	btfsc	STATUS, Z
	goto	RS232_r
	movfw	Zeichen
	sublw	'f'
	btfsc	STATUS, Z
	goto	RS232_f
	movfw	Zeichen
	sublw	'u'
	btfsc	STATUS, Z
	goto	RS232_u
	movfw	Zeichen
	sublw	'j'
	btfsc	STATUS, Z
	goto	RS232_j
	movfw	Zeichen
	sublw	'i'
	btfsc	STATUS, Z
	goto	RS232_i
	movfw	Zeichen
	sublw	'k'
	btfsc	STATUS, Z
	goto	RS232_k
	movfw	Zeichen
	sublw	'o'
	btfsc	STATUS, Z
	goto	RS232_o
	movfw	Zeichen
	sublw	'l'
	btfsc	STATUS, Z
	goto	RS232_l

	movfw	Zeichen
	sublw	'c'
	btfsc	STATUS, Z
	goto	RS232_c
	movfw	Zeichen
	sublw	'v'
	btfsc	STATUS, Z
	goto	RS232_v
	movfw	Zeichen
	sublw	'b'
	btfsc	STATUS, Z
	goto	RS232_b
	movfw	Zeichen
	sublw	'n'
	btfsc	STATUS, Z
	goto	RS232_n
	goto	RS232_x

;h	diesen Hilfetext ausgeben
RS232_h
	movlw	Txt_h1
	call	Write
	movlw	Txt_h2
	call	Write
	movlw	Txt_h3
	call	Write
	movlw	Txt_h4
	call	Write
	movlw	Txt_h5
	call	Write
	movlw	Txt_h6
	call	Write
	movlw	Txt_h7
	call	Write
	bsf	PCLATH, 0
	movlw	Txt_h8
	call	Write
	movlw	Txt_h9
	call	Write
	movlw	Txt_h10
	call	Write
	movlw	Txt_h11
	call	Write
	bcf	PCLATH, 0
	goto	RS232_x

;t	Temperaturen, Einschalttemperaturen, Offsets und Uout ausgeben
RS232_t
	; Kopfzeile
	movlw	Txt_1
	call	Write
	bcf	Negativ

	; Temperatur 1
	movfw	Ziffer3
	call	RS232TxtZiffer
	movfw	Ziffer4
	call	RS232TxtZiffer
	movlw	Txt_K
	call	Write
	; TMin1
	movfw	TMin1
	call	KtoRS232
	; Offset1
	movfw	Offset1
	call	KtoRS232
	; Alarm1
	movfw	Alarm1
	call	KtoRS232
	; Hysterese 1
	movfw	Hyst1
	call	KtoRS232
	;rpm 1
	movfw	CCPR1L
	movwf	f0	
	clrf	f1
	call	Hex2Dez8_3
	movfw	HdH
	call	RS232TxtZiffer
	movfw	HdZ
	call	RS232TxtZiffer
	movfw	HdE
	call	RS232TxtZiffer
	movlw	'%'
	call	RS232TX
	movlw	' '
	call	RS232TX
	movlw	' '
	call	RS232TX
	;rpmmin
	movfw	PWMmin
	movwf	f0	
	clrf	f1
	call	Hex2Dez8_3
	movfw	HdH
	call	RS232TxtZiffer
	movfw	HdZ
	call	RS232TxtZiffer
	movfw	HdE
	call	RS232TxtZiffer
	movlw	'%'
	call	RS232TX
	movlw	0x0A
	call	RS232TX
	movlw	0x0D
	call	RS232TX


	; Temperatur 2
	movfw	Ziffer1
	call	RS232TxtZiffer
	movfw	Ziffer2
	call	RS232TxtZiffer
	movlw	Txt_K
	call	Write
	; TMin2
	movfw	TMin2
	call	KtoRS232
	; Offset2
	movfw	Offset2
	call	KtoRS232
	; Alarm2
	movfw	Alarm2
	call	KtoRS232
	; Hysterese 2
	movfw	Hyst2
	call	KtoRS232
	;rpm 2
	movfw	CCPR2L
	movwf	f0	
	clrf	f1
	call	Hex2Dez8_3
	movfw	HdH
	call	RS232TxtZiffer
	movfw	HdZ
	call	RS232TxtZiffer
	movfw	HdE
	call	RS232TxtZiffer
	movlw	'%'
	call	RS232TX
	movlw	0x0A
	call	RS232TX
	movlw	0x0D
	call	RS232TX
	goto	RS232_x


	; binre Temperatur aus w als BCD+C an RS232
KtoRS232
	movwf	f0	
	clrf	f1
	call	Hex2Dez8_3
	movfw	HdH
	call	RS232TxtZiffer
	movfw	HdZ
	call	RS232TxtZiffer
	movfw	HdE
	call	RS232TxtZiffer
	movlw	Txt_K
	call	Write
	return


;q	Nullpunkt 1. Kanal um 1K erhhen
RS232_q
	incf	Offset1, f
	movfw	Offset1
	movwf	EEWriteData
	movlw	0
	call	EEWrite
	goto	RS232_t

;a	Nullpunkt 1. Kanal um 1K absenken
RS232_a
	decf	Offset1, f
	movfw	Offset1
	movwf	EEWriteData
	movlw	0
	call	EEWrite
	goto	RS232_t


;w	Nullpunkt 2. Kanal um 1K erhhen
RS232_w
	incf	Offset2, f
	movfw	Offset2
	movwf	EEWriteData
	movlw	1
	call	EEWrite
	goto	RS232_t

;s	Nullpunkt 2. Kanal um 1K absenken
RS232_s
	decf	Offset2, f
	movfw	Offset2
	movwf	EEWriteData
	movlw	1
	call	EEWrite
	goto	RS232_t

;e	Einschaltpunkt 1. Kanal um 1K erhhen
RS232_e
	incf	TMin1, f
	movfw	TMin1
	movwf	EEWriteData
	movlw	2
	call	EEWrite
	goto	RS232_t

;d	Einschaltpunkt 1. Kanal um 1K absenken
RS232_d
	decf	TMin1, f
	movfw	TMin1
	movwf	EEWriteData
	movlw	2
	call	EEWrite
	goto	RS232_t

;r	Einschaltpunkt 2. Kanal um 1K erhhen
RS232_r
	incf	TMin2, f
	movfw	TMin2
	movwf	EEWriteData
	movlw	3
	call	EEWrite
	goto	RS232_t

;f	Einschaltpunkt 2. Kanal um 1K absenken
RS232_f
	decf	TMin2, f
	movfw	TMin2
	movwf	EEWriteData
	movlw	3
	call	EEWrite
	goto	RS232_t

;u	Alarm 1. Kanal um 1K erhhen
RS232_u
	incf	Alarm1, f
	movfw	Alarm1
	movwf	EEWriteData
	movlw	4
	call	EEWrite
	goto	RS232_t

;j	Alarm 1. Kanal um 1K absenken
RS232_j
	decf	Alarm1, f
	movfw	Alarm1
	movwf	EEWriteData
	movlw	4
	call	EEWrite
	goto	RS232_t

;i	Alarm 2. Kanal um 1K erhhen
RS232_i
	incf	Alarm2, f
	movfw	Alarm2
	movwf	EEWriteData
	movlw	5
	call	EEWrite
	goto	RS232_t

;k	Alarm 2. Kanal um 1K absenken
RS232_k
	decf	Alarm2, f
	movfw	Alarm2
	movwf	EEWriteData
	movlw	5
	call	EEWrite
	goto	RS232_t

;o	PWMmin um 1K erhhen
RS232_o
	incf	PWMmin, f
	movfw	PWMmin
	movwf	EEWriteData
	movlw	6
	call	EEWrite
	goto	RS232_t

;l	PWMmin um 1K absenken
RS232_l
	decf	PWMmin, f
	movfw	PWMmin
	movwf	EEWriteData
	movlw	6
	call	EEWrite
	goto	RS232_t

;	c	Hysterese 1. Kanal um 1K erhhen
RS232_c
	incf	Hyst1, f
	movfw	Hyst1
	movwf	EEWriteData
	movlw	7
	call	EEWrite
	goto	RS232_t

;	v	Hysterese 1. Kanal um 1K absenken
RS232_v
	decf	Hyst1, f
	movfw	Hyst1
	movwf	EEWriteData
	movlw	7
	call	EEWrite
	goto	RS232_t

;	b	Hysterese 2. Kanal um 1K erhhen
RS232_b
	incf	Hyst2, f
	movfw	Hyst2
	movwf	EEWriteData
	movlw	8
	call	EEWrite
	goto	RS232_t

;	n	Hysterese 2. Kanal um 1K absenken
RS232_n
	decf	Hyst2, f
	movfw	Hyst2
	movwf	EEWriteData
	movlw	8
	call	EEWrite
	goto	RS232_t
	return


RS232_x
	movlw	0x0D
	call	RS232TX
	movlw	0x0A
	call	RS232TX
	bcf	DatenSindDa
	return



; Zeichen aus W nach RS232 ausgeben
RS232TxtZiffer
	xorlw	D'10'
	btfss	STATUS, Z
	goto	RS232Znorm
	movlw	' '
	goto	RS232TX
RS232Znorm
	xorlw	D'10'
	xorlw	D'11'
	btfss	STATUS, Z
	goto	RS232Znorm2
	movlw	'-'
	goto	RS232TX
RS232Znorm2
	xorlw	D'11'
	iorlw	'0'
RS232TX
	btfss	PIR1,TXIF	; ist Sender leer ? 
	goto	RS232TX		; nein, noch nicht leer
	movwf	TXREG		; w in den RS232-Sender schreiben 
	return


;**************************************************************
;  Write
;  Ausgabe eines Strings der ab W im Speicher steht an RS232
;  Note: Endekennzeichen ist Zeichen mit Bit 7 = 1
; 
;  Input : W zeigt auf String (RETLWs)


Write 
	movwf	Temp		; Temp = Pointer
	decf	Temp, f		; Position vor dem 1. Zeichen
GoWrite	
	call	PclSub2		; Pointer erhhen und nchstes Zeichen lesen
	addlw	80h		; ist Bit 7 gesetzt? EOT
	btfsc	STATUS,C
	goto	RS232TX		; letztes Zeichen
	andlw	7fh		; Zeichen wieder herstellen
	call	RS232TX		; Ausgabe
	goto	GoWrite	

PclSub2
	incf	Temp, F		; Pointer auf nchstes Zeichen
	movf	Temp, W		; Pointer nach W
	movwf	PCL		; Sprung zur Addresse auf die PCLATH,W zeigt

;**************************************************************

	end		
;****************
