	list p=16f84
;**************************************************************
;*
;*   Pinbelegung des PIC
;*	----------------------------------	
;*	PORTA: 	0   Ausgang 8	K=9
;*		1   Ausgang 9	K=10 
;*		2   Ausgang A	K=11 
;*		3   Ausgang b	K=12 
;*		4   LED
;*	PORTB:	0   Ausgang 0	K=1   
;*		1   Ausgang 1	K=2 
;*		2   Ausgang 2	K=3 
;*		3   Ausgang 3	K=4 
;*		4   Ausgang 4	K=5 
;*		5   Ausgang 5	K=6 
;*		6   Ausgang 6	K=7 
;*		7   Ausgang 7	K=8 
;*
;**************************************************************
;*
;* sprut (zero) Bredendiek 06/2001 (mod 10/2002, mod 12/2002)
;*
;* Leitungszuordner - Sender 
;* 
;* Ports RB0 - RB7 sowie RA0 - RA3 werden mit Pulsen codiert
;* Port RA4: LED flasht  bei Betrieb
;*
;*
;* Anfang: alle Ausgnge auf Low
;* dann von 0 bis b
;* - 16T lang High
;* - 8 T lang Low
;* - (K x 16)+8 lang High
;*
;*
;*__XXXXXXXXXXXXXXXX________XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX__
;*
;* T=16us 
;* bei 4MHz -> 1 Takt =1us -> Vorteiler 16:1 -> 16us
;*
;*
;**************************************************************
; Includedatei fr den 16F84 einbinden

	#include <P16f84.INC>

;Variablennamen vergeben

Zeit	Equ	0x20


;**************************************************************
; los gehts mit dem Programm

Init
	bsf     STATUS, RP0	; unschalten auf Bank 1

	clrf	TRISA		; 
	clrf	TRISB		; alles auf Ausgang

	movlw	B'00000011'	; Vorteiler 16:1
	movwf	OPTION_REG

	bcf     STATUS, RP0	; zurckschalten zur Bank 0
	clrf	PORTA		; 
	clrf	PORTB		;
	bsf	PORTA,4		; LED aus

; Vorteiler auf Takt, 16:1

Loop
	
K0
	bsf	PORTB,0
	call	T16
	bcf	PORTB,0
	call	T8
	bsf	PORTB,0
	movlw	0x08
	call	Tw
	bcf	PORTB,0

K1
	bsf	PORTB,1
	call	T16
	bcf	PORTB,1
	call	T8
	bsf	PORTB,1
	movlw	0x18
	call	Tw
	bcf	PORTB,1

K2
	bsf	PORTB,2
	call	T16
	bcf	PORTB,2
	call	T8
	bsf	PORTB,2
	movlw	0x28
	call	Tw
	bcf	PORTB,2

K3
	bsf	PORTB,3
	call	T16
	bcf	PORTB,3
	call	T8
	bsf	PORTB,3
	movlw	0x38
	call	Tw
	bcf	PORTB,3

K4
	bsf	PORTB,4
	call	T16
	bcf	PORTB,4
	call	T8
	bsf	PORTB,4
	movlw	0x48
	call	Tw
	bcf	PORTB,4

K5
	bsf	PORTB,5
	call	T16
	bcf	PORTB,5
	call	T8
	bsf	PORTB,5
	movlw	0x58
	call	Tw
	bcf	PORTB,5

K6
	bsf	PORTB,6
	call	T16
	bcf	PORTB,6
	call	T8
	bsf	PORTB,6
	movlw	0x68
	call	Tw
	bcf	PORTB,6

K7
	bsf	PORTB,7
	call	T16
	bcf	PORTB,7
	call	T8
	bsf	PORTB,7
	movlw	0x78
	call	Tw
	bcf	PORTB,7
K8
	bsf	PORTA,0
	call	T16
	bcf	PORTA,0
	call	T8
	bsf	PORTA,0
	movlw	0x88
	call	Tw
	bcf	PORTA,0

K9
	bsf	PORTA,1
	call	T16
	bcf	PORTA,1
	call	T8
	bsf	PORTA,1
	movlw	0x98
	call	Tw
	bcf	PORTA,1

KA
	bsf	PORTA,2
	call	T16
	bcf	PORTA,2
	call	T8
	bsf	PORTA,2
	movlw	0xA8
	call	Tw
	bcf	PORTA,2

Kb
	bsf	PORTA,3
	call	T16
	bcf	PORTA,3
	call	T8
	bsf	PORTA,3
	movlw	0xB8
	call	Tw
	bcf	PORTA,3

KLED				; LED flackern
	bcf	PORTA,4
	movlw	0x80
	call	Tw
	bsf	PORTA,4

	goto	Loop


; Warteschleife
T16
	movlw	D'15'
	goto	Tw
T8
	movlw	D'8'
	goto	Tw
Tw				; 255 - w -> TMR0
	clrf	Zeit
	subwf	Zeit,w

	movwf	TMR0
	bcf	INTCON,T0IF
TwL
	btfss	INTCON,T0IF
	goto	TwL

	return

	goto	Loop

	end





