	list p=16f84
;**************************************************************
;*
;*	----------------------------------	
;*	PORTA: 	0 
;*		1 
;*		2 
;*		3 
;*		4 Meleitung 
;*	PORTB:	0 Segment B	   AAAAA	
;*		1 Segment F	  F     B	
;*		2 Segment A	  F     B	
;*		3 Segment G	   GGGGG  	
;*		4 Segment H	  E     C	
;*		5 Segment C	  E     C	
;*		6 Segment E	   DDDDD  HH	 
;*		7 Segment D    
;*
;**************************************************************
;
;sprut (zero) Bredendiek 06/2001
;
; Leitungszuordner (Rev 2 vom 23.06.2001)
; input : RA4
;
; Empfangener Code wird am Port B mit 7-Segment-Anzeige ausgegeben
;
;**************************************************************
; Includedatei fr den 16F84 einbinden

	#include <P16f84a.INC>

;Variablennamen vergeben


Normal	Equ	0x20		; T16-Wert 
Kanal	Equ	0x21		; zhler
KanalT	Equ	0x22

;**************************************************************
; los gehts mit dem Programm
; Port B auf Ausgabe stellen

Init
	bsf     STATUS, RP0	; auf Bank 1 umschalten

	movlw	B'00000000'	; PortB alle output
	movwf	TRISB
;folgender Befehl nur ntig auf 4-stelliger LED-Ziffernanzeige
; um die Anode der erstenAnzeigenstelle einzuschalten 
	bcf	TRISA,3

	movlw	B'00000011'	; Vorteiler 16:1
	movwf	OPTION_REG

	bcf     STATUS, RP0	; auf Bank 0 zurckschalten
	clrf	PORTA		; 
Fehler
	clrf	PORTB		; alle LEDs ausschalten
	decf	PORTB,f
	bcf	PORTB,3		; '-'

;Zeichen empfangen und dann an PORTB ausgeben
Main
	
SyncLH
	btfss	PORTA,4		; warten auf Anfang des Sync Pulses
	goto	SyncLH
	btfss	PORTA,4		; warten auf Anfang des Sync Pulses
	goto	SyncLH

	clrf	TMR0
	bcf	INTCON,T0IF	; Messung des Sync-Pulses vorbereiten

SyncHL
	btfsc	INTCON,T0IF	; Timer bergelaufen (Impuls zu lang)?
	goto	Fehler
	btfsc	PORTA,4		; warten auf Ende des Sync Pulses
	goto	SyncHL
	btfsc	PORTA,4		; warten auf Ende des Sync Pulses
	goto	SyncHL
	movfw	TMR0

	clrf	Normal
	subwf	Normal,f	; 256-Lnge des Sync-Pulses speichern
	incf	Normal,f	; Korrektur auf Null
	
	clrf	Kanal
	
Mess
	movfw	Normal
	movwf	TMR0
	bcf	INTCON,T0IF

MessL
	btfss	INTCON,T0IF	; T16 lang warten
	goto	MessL	
	btfss	PORTA,4		; Impuls zu ende
	goto	MessEnde
	incf	Kanal,f
	btfsc	STATUS,Z	;Kanal 256? - das ist zu lang
	goto	Fehler
	goto	Mess

MessEnde
; 0 - Fehler
; 1..12 Kanle 0..b
; >13 - Fehler

	incf	Kanal,f
	decf	Kanal,f		; KanalNr-1 -> Kanal
	btfsc	STATUS,Z
	goto	Fehler		; zu kurzer Impuls

	decf	Kanal,f		;0..11 = 0..b
	
	movlw	D'12'
	movwf	KanalT

	movfw	Kanal
	subwf	KanalT,f

	btfss	STATUS,C
	goto	Fehler		; Impuls zu lang

	call	Segmente
	movwf	PORTB		; Segmente einschalten

	goto	Main

; 7-Segment-Tabelle
Segmente
	addwf	PCL, f
	retlw	B'00011000'	; 0
	retlw	B'11011110'	; 1
	retlw	B'00110010'	; 2
	retlw	B'01010010'	; 3
	retlw	B'11010100'	; 4
	retlw	B'01010001'	; 5
	retlw	B'00010001'	; 6
	retlw	B'11011010'	; 7
	retlw	B'00010000'	; 8
	retlw	B'01010000'	; 9
	retlw	B'10010000'	; A
	retlw	B'00010101'	; b
	retlw	B'00110001'	; E (Error)
	retlw	B'00110001'	; E


	end





