	list p=16f876
;**************************************************************
;*
;* Pinbelegung
;*	
;*	PORTA: 	0 Ziffer1	-------------------------------------------------------------------------------------+
;*		1 Ziffer2	---------------------------------------------------------------------+               I
;*		2 Ziffer3	-----------------------------------------------------+               I               I
;*		3 Ziffer4	-------------------------------------+               I               I               I
;*		4 Eingang	                                     I               I               I               I  
;*		5 Ziffer5	---------------------+               I               I               I               I  
;*	PORTB:	0 Segment B	   AAAAA	   AAAAA	   AAAAA	   AAAAA	   AAAAA	   AAAAA
;*		1 Segment F	  F     B	  F     B	  F     B	  F     B	  F     B	  F     B
;*		2 Segment A	  F     B	  F     B	  F     B	  F     B	  F     B	  F     B
;*		3 Segment G	   GGGGG  	   GGGGG  	   GGGGG  	   GGGGG  	   GGGGG  	   GGGGG  
;*		4 Segment H	  E     C	  E     C	  E     C	  E     C	  E     C	  E     C
;*		5 Segment C	  E     C	  E     C	  E     C	  E     C	  E     C	  E     C
;*		6 Segment E	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH
;*		7 Segment D    	     I
;*      PORTC:	0 Switch +/- ZF    0:Addition,        1:Subtraktion
;*		1 Switch Segmente  0:low-aktiv;       1:high-aktiv
;*		2 Switch Stellen   0:low-aktiv;       1:high-aktiv
;*		3 Switch           0:Ausgabe der 7 Segmente     1:Ausgabe als BCD
;*		4 Switch ZF0	     I
;*		5 Switch ZF1	     I
;*		6 Switch ZF2	     I
;*		7 Ziffer6	 ----+
;*
;**************************************************************
;
; sprut (zero) Bredendiek 06/2011
;
; Frequenzzhler mit 6-stellige LED-Anzeige
; Aufloesung 100 Hz -> 10 ms effektive Zhlzeit , wegen 16:1 Vorteiler ->160 ms Zhlzeit
; 24 Bit : 0xFFFFFF x 100 = 16777215 x 100 = 1 677 721 500 Hz -> reicht aus
;
; max Eingangstakt = 2.5 MHz, mit VT 16:1 ergibt sich 40 MHz
; -> Zhlzeit 10ms*16 = 160 ms fuer 100 Hz Aufloesung
;
; Der Timer0 kann mit Vorteiler maximal 50 MHz sicher verarbeiten
; Dazu wre ein VT 32:1 noetig, da am Timer1-Eingang nur 2,5 MHz (bei 10 MHz Takt)
; zulaessig sind (50/32=1.56;  50/16=3.12).
; Um 100 Hz-Auflsung bei 16:1 zu erreichen ist eine Zaehlzeit von 160 ms erforderlich.
; Um 100 Hz-Auflsung bei 32:1 zu erreichen waere eine Zaehlzeit von 320 ms erforderlich.
; In jedem Fall muss waerend des Zaehlens das Display weiter arbeiten.
;
; Taktquelle: 10 MHz
;
;**************************************************************
; Includedatei fr den 16F876 einbinden

	#include <P16f876.INC>

	ERRORLEVEL      -302    ; SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen
; 10 MHz: Power on Timer, kein Watchdog, HS-Oscillator

	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC & _LVP_OFF

;**************************************************************

; Variablennamen vergeben

w_copy		Equ	0x20	; Backup fr Akkuregister
s_copy		Equ	0x21	; Backup fr Statusregister

Ziffer1		Equ	0x22	; Wert des LSD
Ziffer2		Equ	0x23	; Wert der zweitkleinsten Stelle
Ziffer3		Equ	0x24
Ziffer4		Equ	0x25
Ziffer5		Equ	0x26	; Wert der zweitgrten Stelle
Ziffer6		Equ	0x27	; Wert des MSD
Digit		Equ	0x28	; Ziffernzhler
ar		Equ	0x29
countdown 	Equ	0x2A	; stoppt Display nach 1/4 Sekunde
Fehler		EQU	0x2B

; 16-Bit Rechenregister
xw0		EQU	0x2C	;LSB
xw1		EQU	0x2D	;MSB 
xw2		EQU	0x2E	;USB 

; 16-Bit Rechenregister
f0		EQU	0x2F	;LSB
f1		EQU	0x30	;MSB
f2		EQU	0x31	;USB

; Dezimalstellen
HdX		EQU	0x36	; Puffer fr eine Dezimalstelle

; 24 Bit Frequenzzhler
BIN4		EQU	0x3B	;LSB
BIN41		EQU	0x3C	;MSB 
BIN42		EQU	0x3D	; I extra

; Hilfszellen fr Frequenzmeschleife
HLTest		EQU	0x3F	; HL-Flanken-Detektorn fr Timer0-berlauf
HighCOU		EQU	0x40	; high-Teil des Schleifenzhlers
LowCOU		EQU	0x41	; low-Teil des Schleifenzhlers

ZF		equ	0x42	; 0 bis 7 , je nach Schalterstellung

Delay		equ	0x43	; fuer Verzgerungsschleifen
MLoop		equ	0x44	; Schleife fuer Anzeige waerend der Messung

#define	SegmentPort	PORTB
#define	StellenPort	PORTA
#define	SwitchPort	PORTC

#define	Sw_PlusMinus	SwitchPort, 0	; +/- ZF    0:Addition,        1:Subtraktion
#define	Sw_InvSeg	SwitchPort, 1	; Segmente  0:low-aktiv;       1:high-aktiv
#define	Sw_InvAK	SwitchPort, 2	; Stellen   0:low-aktiv;       1:high-aktiv
#define	Sw_BCD		SwitchPort, 3	; 0:Ausgabe der 7 Segmente     1:Ausgabe als BCD

#define	Sw_ZF0		SwitchPort, 4	; Auswahl der ZF-Frequenz
#define	Sw_ZF1		SwitchPort, 5
#define	Sw_ZF2		SwitchPort, 6

#define	Stelle1		StellenPort, 0
#define	Stelle2		StellenPort, 1
#define	Stelle3		StellenPort, 2
#define	Stelle4		StellenPort, 3
#define	Stelle5		StellenPort, 5
#define	Stelle6		PORTC, 7



;**************************************************************
; los gehts mit dem Programm

	org 	0
	goto	Init	

;**************************************************************
;* die Interuptserviceroutine fr die multiplexe Anzeige
;* Int wird vom Timer0 ausgelst
;**************************************************************
	org 	4 	
intvec
	movwf	w_copy		; w retten
	swapf	STATUS, w 	; STATUS retten
	movwf	s_copy		;
	; die Multiplexfrequenz der Anzeige betrgt 305 Hz um Flackern zu vermeiden
	movlw	D'0'		; 256-0=256 ((2,5 MHz : 32 ): 256 = 305 Hz)
	movwf	TMR0

	call	Int_serv 	; Anzeigeschleife

	swapf	s_copy, w	; STATUS zurck
	movwf	STATUS 
	swapf	w_copy, f	; w zurck mit flags
	swapf	w_copy, w

	bcf	INTCON, T0IF	; Interupt-Flag lschen
	retfie


;**************************************************************
;* Anzeigeschleife, Umschalten zur nchsten Stelle der
;* LED-Multiplexanzeige
;* gerufen von:
;* - Int wird vom Timer0 ausgelst
;* - Messschleife
;**************************************************************
; Aufruf dauert in jedem Fall gleich lang (80 cycl)
Int_serv 
	; alle Stellen abschalten
	call	DisplayDark	; Anzeige dunkel

	decf	Digit,f		; Ziffernzhler verringern
	;Digit=6: anzeigen Ziffer X-----
	;Digit=5: anzeigen Ziffer -X----
	;Digit=4: anzeigen Ziffer --X---
	;Digit=3: anzeigen Ziffer ---X--
	;Digit=2: anzeigen Ziffer ----X-
	;Digit=1: anzeigen Ziffer -----X
	;Digit=0: andere Aktionen, keine Anzeige

	btfsc	STATUS, Z
	goto	Int_0		; Z-Flag=1 ergo Digit=0
	movfw	Digit

	movlw	1
	xorwf	Digit,w
	bz	Int_1

	movlw	2
	xorwf	Digit,w
	bz	Int_2

	movlw	3
	xorwf	Digit,w
	bz	Int_3

	movlw	4
	xorwf	Digit,w
	bz	Int_4

	movlw	5
	xorwf	Digit,w
	bz	Int_5

	movlw	6
	xorwf	Digit,w
	bz	Int_6

Int_0
	; die Anzeigeroutine wird zwischen 2 Messungen 15 mal durchlaufen
	decf	countdown, f
	; Ziffernzhler wieder zurckstellen
	movlw	7
	movwf	Digit
	movlw	D'14'		; Lauflaengenausgleich
	movwf	Delay
Int_L0
	decfsz	Delay,f
	goto	Int_L0
	nop
	goto	Int_end

Int_1
	movfw	Ziffer1		; Wert der letzten Ziffer
	call	Segmente	; Segmente einschalten
	btfss	Sw_InvAK
	bcf	Stelle1		; letzte Ziffer einschalten		InvAK=0
	btfsc	Sw_InvAK
	bsf	Stelle1		; letzte Ziffer einschalten		InvAK=1
	movlw	D'6'		; Lauflaengenausgleich
	movwf	Delay
Int_L1
	decfsz	Delay,f
	goto	Int_L1
	nop
	goto	Int_end

Int_2
	movfw	Ziffer2		; Wert der vorletzten Ziffer
	call	Segmente	; Segmente einschalten
	nop			; Lauflaengenausgleich
	btfsc	Sw_InvSeg
	bsf	SegmentPort,4	; Komma einschalten
	btfss	Sw_InvSeg
	bcf	SegmentPort,4	; Komma einschalten
	nop			; Lauflaengenausgleich
	btfss	Sw_InvAK
	bcf	Stelle2		; Ziffer einschalten		InvAK=0
	btfsc	Sw_InvAK
	bsf	Stelle2		; Ziffer einschalten		InvAK=1
	movlw	D'3'		; Lauflaengenausgleich
	movwf	Delay
Int_L2
	decfsz	Delay,f
	goto	Int_L2
	goto	Int_end

Int_3
	movfw	Ziffer3		; Wert der 3. Ziffer
	call	Segmente	; Segmente einschalten
	btfss	Sw_InvAK
	bcf	Stelle3		; 3. Ziffer einschalten		InvAK=0
	btfsc	Sw_InvAK
	bsf	Stelle3		; 3. Ziffer einschalten		InvAK=1
	nop			; Lauflaengenausgleich
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	goto	Int_end

Int_4
	movfw	Ziffer4		; Wert der 4. Ziffer
	call	Segmente	; Segmente einschalten
	btfss	Sw_InvAK
	bcf	Stelle4		; 4. Ziffer einschalten		InvAK=0
	btfsc	Sw_InvAK
	bsf	Stelle4		; 4. Ziffer einschalten		InvAK=1
	nop			; Lauflaengenausgleich
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	goto	Int_end

Int_5
	movfw	Ziffer5		; Wert der 5. Ziffer
	call	Segmente	; Segmente einschalten
	btfsc	Sw_InvSeg
	bsf	SegmentPort,4	; Komma einschalten
	btfss	Sw_InvSeg
	bcf	SegmentPort,4	; Komma einschalten
;	nop			; Lauflaengenausgleich falls kein Komma gewuenscht
;	nop
;	nop
;	nop
	btfss	Sw_InvAK
	bcf	Stelle5		; 5. Ziffer einschalten		InvAK=0
	btfsc	Sw_InvAK
	bsf	Stelle5		; 5. Ziffer einschalten		InvAK=1
	goto	Int_end

Int_6
	movfw	Ziffer6		; Wert der vordersten Ziffer
	call	Segmente	; Segmente einschalten
	btfss	Sw_InvAK
	bcf	Stelle6		; 6. Ziffer einschalten		InvAK=0
	btfsc	Sw_InvAK
	bsf	Stelle6		; 6. Ziffer einschalten		InvAK=1
	goto	Int_end

Int_end	
	; auf 80 cycl auffuellen
	nop
	nop
	nop
	nop
	return
	


;**************************************************************
;* Segmente
;* Ausgabe der Segmente oder BCD am SegmentePort
;* Lauflaenge der Routine ist in jedem Fall gleich
;* input: w
;**************************************************************
Segmente
	;  BCD : 2 cy
	;noBCD : 6 cy
	btfss	Sw_BCD
	call	SegmenteT	; 5 zyklen
	
	;  BCD : 7 cy
	;noBCD : 3 cy
	btfss	Sw_BCD
	goto	SegmenteD
	nop			; Lauflaengenausgleich
	nop			; Lauflaengenausgleich
	nop			; Lauflaengenausgleich
	nop			; Lauflaengenausgleich
	nop			; Lauflaengenausgleich
SegmenteD

	btfsc	Sw_InvSeg
	xorlw	0xFF
	movwf	SegmentPort
	return	

; 7-Segment-Tabelle
SegmenteT
	addwf	PCL, f
	;         DECHGAFB
	retlw	B'00011000'	; 0  tabelle ist low-aktiv
	retlw	B'11011110'	; 1
	retlw	B'00110010'	; 2
	retlw	B'01010010'	; 3
	retlw	B'11010100'	; 4
	retlw	B'01010001'	; 5
	retlw	B'00010001'	; 6
	retlw	B'11011010'	; 7
	retlw	B'00010000'	; 8
	retlw	B'01010000'	; 9
	retlw	B'11110111'	; -


;**************************************************************
;* DisplayDark
;* alle Stellen abschalten
;* Lauflaenge der Routine ist in jedem Fall gleich
;**************************************************************
DisplayDark
	btfsc	Sw_InvAK
	goto	DD2
	bsf	Stelle1		; Ziffer1 aus	InvAK=0
	bsf	Stelle2		; Ziffer2 aus
	bsf	Stelle3		; Ziffer3 aus
	bsf	Stelle4		; Ziffer4 aus
	bsf	Stelle5		; Ziffer4 aus
	bsf	Stelle6		; Ziffer4 aus
	goto	DD3

DD2
	bcf	Stelle1		; Ziffer1 aus	InvAK=1
	bcf	Stelle2		; Ziffer2 aus
	bcf	Stelle3		; Ziffer3 aus
	bcf	Stelle4		; Ziffer4 aus
	bcf	Stelle5		; Ziffer4 aus
	bcf	Stelle6		; Ziffer4 aus
	nop			; Lauflaengenausgleich
DD3
	return


;**************************************************************
; Hauptprogramm beginnt mit der Initialisierung
; Port A/B auf Ausgabe stellen (auer RA4)
;**************************************************************
Init
	call	DisplayDark	; Anzeige dunkel

	bsf     STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'11010000'	; PortA RA0,1,2,3,5 output (LED-Stellen)
	movwf	TRISA
	movlw	B'00000000'	; PortB alle output (Segmente)
	movwf	TRISB
	movlw	B'01111111'	; Pin RC7 output (LED-Stelle)
	movwf	TRISC
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten

	; Ziffernzhler fr die multiplexe Anzeige voreinstellen
	movlw	7
	movwf	Digit

	; eine beliebige Zahl einstellen (hier: 123456)
	; die dann vom Frequenzmesser sofort berschrieben wird
	movlw	6
	movwf	Ziffer1
	movlw	5
	movwf	Ziffer2
	movlw	4
	movwf	Ziffer3
	movlw	3
	movwf	Ziffer4
	movlw	2
	movwf	Ziffer5
	movlw	1
	movwf	Ziffer6


	; Display fr 1/3 Sekunde einschalten
	; das sind 15 Anzeigezyklen
LEDan
	call	Init_TMR0

	; warten auf das Ende der 1/3 Sekunde
loop
	tstf	countdown
	bnz	loop		; warten auf Ende der 1/3 Sekunde
	bcf	INTCON, GIE	; Interupt verbieten
	call	DisplayDark	; Display aus
	call	Frequ_Loop	; Frequenz an RA4 messen
	bsf	INTCON, GIE	; Interupt erlauben
	goto	LEDan		; Frequenz anzeigen



Init_TMR0
	movlw	D'15'
	movwf	countdown

	; 305 Hz-Timer-Interupt einstellen
	; 305/7 = 43 Hz Refresh fuer das Display
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'10000100'	; internen Takt zhlen, Vorteiler zum Timer0, 32:1
	movwf	OPTION_REG
	movlw	D'0'		; 256-0=256 ((2,5 MHz : 32 ): 256 = 305 Hz)
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten
	movwf	TMR0
	bsf	INTCON, T0IE	; Timer0 interupt erlauben
	bsf	INTCON, GIE	; Interupt erlauben
	return


;**************************************************************
; (HighCOU,LowCOU)x20Takte lang wird gezhlt
; das 24-Bit Ergebnis steht in BIN4+2 (MSB) bis BIN4 (LSB)
; virtuell steht davor BIN+3=0
; das mach dann 32Bit
; 
; fr die Messung
; 10MHz ; 3,2  ms =   8000 Takte =   400 x 20 Takte, 0,01,90h=   400d
; 10MHz ; 160  ms = 400000 Takte = 20000 x 20 Takte, 0,4E,20h= 20000d
;
; 400000 = 50 x 8000 = 7x7x8163 + 13 = 49 x (20 x 404 + 80)
;
;**************************************************************
Frequ_Loop

; Test auf >40 MHz in 3,2 ms mit vorteiler
; 40MHx / 32 * 3.2ms = 4000 = 0FA0
	clrf	BIN4+1 		; Zhler lschen
	clrf	BIN4+2 		; Zhler lschen
	clrf	BIN4+3 		; Zhler lschen
	clrf	HLTest	 	; lsche TMR0 berlauf-Detektor
	movlw	001h+1 		; high loop counter fr die Mezeit
	movwf	HighCOU 	; HighCOU = hi byte counter
	movlw	090h+1 		; 
	movwf	LowCOU 		; LowCOU = lo byte counter  fr die Mezeit
	movlw	4	 	; Vorteiler-Faktor = 32:1  2,5MHz x 32 = 80 MHz max Frequenz
	call	Messung1

	movfw	BIN4		; Wert aus dem Timer0
	movwf	f0
	movfw	BIN4+1		; Softwarezhler untere 8 Bit
	movwf	f1
	movfw	BIN4+2		; Softwarezhler obere 8 Bit
	movwf	f2
	movlw	0x00
	movwf	xw2
	movlw	0x0F
	movwf	xw1
	movlw	0xA1
	movwf	xw0
	call	Sub24		; messergebnis-4001 sollte C ausloesen
	btfsc	STATUS,C
	goto	Unter40

	; es wurde >40MHz festgestellt
	movlw	D'10'
	movwf	Ziffer1
	movwf	Ziffer2
	movwf	Ziffer3
	movwf	Ziffer4
	movwf	Ziffer5
	movwf	Ziffer6	;'------'
	return


Unter40
;Messung mit Vorteiler 16:1 in 160 ms
	clrf	BIN4+1 		; Zhler lschen
	clrf	BIN4+2 		; Zhler lschen
	clrf	BIN4+3 		; Zhler lschen
	clrf	HLTest	 	; lsche TMR0 berlauf-Detektor
	movlw	04Eh+1 		; high loop counter fr die Mezeit
	movwf	HighCOU 	; HighCOU = hi byte counter
	movlw	020h+1 		; 
	movwf	LowCOU 		; LowCOU = lo byte counter  fr die Mezeit
	movlw	3	 	; Vorteiler-Faktor = 16:1  2,5MHz x 16 = 40MHz max Frequenz

	call	Messung
	;Ende der Zhlroutine

	; ZF abziehen
	;1. 200khz (mechanische filter in ameteurempfaenger/sender)
	;2. 455khz (druch die verwendung von keramischen filtern bzw. resonatoren ist das so vorgegeben)
	;3. 468 khz (betrifft alle roehrengeraete mit spulenfiltern)
	;4. 1,6mhz (betrifft sgn. nachsetzer, meist sehr selektive am-empfaenger mit unterschiedlichen bandbreiten)
	;5. 9mhz (quarzfilter in amateurempfaenger/sender)
	;6. 10,7mhz (keramische filter in ukw-empfaenger bzw. 1. hohe zf in bandempfaenger, ev. mit vorteiler - s.o.)
	;
	; 1:	200 kHz	=	  2000	=	00 07 D0	ok
	; 2:	455 kHz	=	  4550	=	00 11 C6	ok
	; 3:	468 kHz	=	  4680	=	00 12 48	ok
	; 4:	1600 kHz=	 16000	=	00 3E 80	ok
	; 5:	9000 kHz=	 90000	=	01 5F 90	ok
	; 6:	10700 kHz=	107000	=	01 A1 F8	ok
	; Wahlschalter fuer ZF auslesen
	swapf	SwitchPort,w
	andlw	0x07
	movwf	ZF

	movfw	BIN4		; Wert aus dem Timer0
	movwf	f0
	movfw	BIN4+1		; Softwarezhler untere 8 Bit
	movwf	f1
	movfw	BIN4+2		; Softwarezhler obere 8 Bit
	movwf	f2

	clrf	xw2
	clrf	xw1
	clrf	xw0

	movfw	ZF
	bz	Anzeige		; ZF=0 , keine FZ
	xorlw	1
	bz	ZF1
	movfw	ZF
	xorlw	2
	bz	ZF2
	movfw	ZF
	xorlw	3
	bz	ZF3
	movfw	ZF
	xorlw	4
	bz	ZF4
	movfw	ZF
	xorlw	5
	bz	ZF5
	movfw	ZF
	xorlw	6
	bz	ZF6
	movfw	ZF
	xorlw	7
	bz	ZF7
	goto	ZFcalc
	bz	Anzeige		; failsave

ZF1; 1:	200 kHz	=	  2000	=	00 07 D0
	movlw	0x00
	movwf	xw2
	movlw	0x07
	movwf	xw1
	movlw	0xD0
	movwf	xw0
	goto	ZFcalc

ZF2; 2:	455 kHz	=	  4550	=	00 11 C6
	movlw	0x00
	movwf	xw2
	movlw	0x11
	movwf	xw1
	movlw	0xC6
	movwf	xw0
	goto	ZFcalc

ZF3; 3:	468 kHz	=	  4680	=	00 12 48
	movlw	0x00
	movwf	xw2
	movlw	0x12
	movwf	xw1
	movlw	0x48
	movwf	xw0
	goto	ZFcalc

ZF4; 4:	1600 kHz=	 16000	=	00 3E 80
	movlw	0x00
	movwf	xw2
	movlw	0x3E
	movwf	xw1
	movlw	0x80
	movwf	xw0
	goto	ZFcalc

ZF5; 5:	9000 kHz=	 90000	=	01 5F 90
	movlw	0x01
	movwf	xw2
	movlw	0x5F
	movwf	xw1
	movlw	0x90
	movwf	xw0
	goto	ZFcalc

ZF6; 6:	10700 kHz=	107000	=	01 A1 F8
	movlw	0x01
	movwf	xw2
	movlw	0xA1
	movwf	xw1
	movlw	0xF8
	movwf	xw0
	goto	ZFcalc

ZF7; unbenutzt
	movlw	0x00
	movwf	xw2
	movlw	0x00
	movwf	xw1
	movlw	0x00
	movwf	xw0
	goto	ZFcalc

ZFcalc
	btfsc	Sw_PlusMinus
	call	Sub24		; es gibt noch keine Auswertung negativer Ergebnisser
	btfss	Sw_PlusMinus
	call	Add24

; 24 Bit zur Anzeige bringen
Anzeige
	call	OutDez24	;Binr zu BCD Wandlung mit Ausgabe
	return


;**************************************************************
; die eigentliche  Meroutine
; Mezeit = 20Takte x (HighCOU,LowCOU)
; input: Prescaler in w
;**************************************************************
Messung
	; Vorteiler einstellen
	addlw	20h 		; for PRESC 0,1,2,3... w=20h,21h,22h,23h...
	bsf	STATUS,RP0 	; bank 1
	movwf	OPTION_REG 	; 
	bcf	STATUS,RP0 	; bank 0
	clrf	TMR0 		; initialisiere TMR0

	nop			; Lauflaengenausgleich auf exakt 160 ms
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

	movlw	D'49'
	movwf	MLoop

Messung_loop
	call	Int_serv
	; 403 = 01 93
	movlw	001h+1 		; high loop counter fr die Mezeit
	movwf	HighCOU 	; HighCOU = hi byte counter
	movlw	093h+1 		; 
	movwf	LowCOU 		; LowCOU = lo byte counter  fr die Mezeit

Loop500A
	nop			; warten
	nop			; warten
Loop500
	movf	TMR0, W		; 1 1 1 nur hier wird TMR0 ausgelesen
	movwf	BIN4		; 1 1 1 rtcc ---> freq0
	rlf	BIN4, W		; 1 1 1 carry <--- TMR0.7
	rlf	HLTest, F	; 1 1 1 rotor <--- carry
	movf	HLTest, W	; 1 1 1 HLTest=TMR0 overflow detect
	andlw	3		; 1 1 1 mask 2 LSbs for edge detect
	xorlw	2		; 1 1 1 00000000 if 1 <--- 0
	btfss	STATUS, Z	; 1 2 2 | skip if TMR0 overflow
	goto	NotOvf1		; 2 - - | if nz
				;       | 5T any case
	incf	BIN4+1, F	; - 1 1 | nsb
NotOvf1 btfsc	STATUS, Z	; 2 2 1 | skip MSB adv ifnot overflow
	incf	BIN4+2, F 	; - - 1 | msb
	nop			; warten
	nop			; warten
	nop			; warten
	decfsz	LowCOU, F 	; 1 (2) lo loop counter
	goto	Loop500A 	; 2 (-) 20T total
	decfsz	HighCOU, F 	; (1) hi loop counter
	goto	Loop500 	; (2) 20T total

	decfsz	MLoop
	goto	Messung_loop

	return





Messung1
	; Vorteiler einstellen
	addlw	20h 		; for PRESC 0,1,2,3... w=20h,21h,22h,23h...
	bsf	STATUS,RP0 	; bank 1
	movwf	OPTION_REG 	; 
	bcf	STATUS,RP0 	; bank 0
	clrf	TMR0 		; initialisiere TMR0

Loop500A1
	nop			; warten
	nop			; warten
Loop5001
	movf	TMR0, W		; 1 1 1 nur hier wird TMR0 ausgelesen
	movwf	BIN4		; 1 1 1 rtcc ---> freq0
	rlf	BIN4, W		; 1 1 1 carry <--- TMR0.7
	rlf	HLTest, F	; 1 1 1 rotor <--- carry
	movf	HLTest, W	; 1 1 1 HLTest=TMR0 overflow detect
	andlw	3		; 1 1 1 mask 2 LSbs for edge detect
	xorlw	2		; 1 1 1 00000000 if 1 <--- 0
	btfss	STATUS, Z	; 1 2 2 | skip if TMR0 overflow
	goto	NotOvf11	; 2 - - | if nz
				;       | 5T any case
	incf	BIN4+1, F	; - 1 1 | nsb
NotOvf11
	btfsc	STATUS, Z	; 2 2 1 | skip MSB adv ifnot overflow
	incf	BIN4+2, F 	; - - 1 | msb
	nop			; warten
	nop			; warten
	nop			; warten
	decfsz	LowCOU, F 	; 1 (2) lo loop counter
	goto	Loop500A1 	; 2 (-) 20T total
	decfsz	HighCOU, F 	; (1) hi loop counter
	goto	Loop5001 	; (2) 20T total

	return
;**************************************************************
;* 24 Bit Wert (f1,f0) auf LED dezimal anzeigen
;*
;* input f2..f0
;**************************************************************
OutDez24			;24-bit (f2f1,f0) als Dez zum LED

; Wandlung einer 16Bit-Zahl in eine 4-stellige BCD-Zahl
;    100.000 = 01 86 A0 h 
;     10.000 = 00 27 10 h
;      1 000 =    03 E8 h
;        100 =    00 64 h
;         10 =    00 0A h
;          1 =    00 01 h
; 16-bit(f1,f0) in 4-stellen Bcd (T,H,Z,E)

	; 100-Tausender
	movlw	0x01
	movwf	xw2
	movlw	0x86		; 100.000 = 01 86 A0 h 
	movwf	xw1
	movlw	0xA0
	movwf	xw0
	call	Hex2Dez1	; 1000er
	movfw	HdX
	movwf	Ziffer6		; HdHT

	; 10-Tausender
	clrf	xw2
	movlw	0x27		; 10.000 = 00 27 10 h
	movwf	xw1
	movlw	0x10
	movwf	xw0
	call	Hex2Dez1	; 1000er
	movfw	HdX
	movwf	Ziffer5		; HdZT

	; Tausender
	clrf	xw2
	movlw	0x03		; 1 000 = 03 E8 h
	movwf	xw1
	movlw	0xE8
	movwf	xw0
	call	Hex2Dez1	; 1000er
	movfw	HdX
	movwf	Ziffer4		; HdT

	; Hunderter
	clrf	xw2
	movlw	0x00		; 100 = 00 64 h
	movwf	xw1
	movlw	0x64
	movwf	xw0
	call	Hex2Dez1	; 100er
	movfw	HdX
	movwf	Ziffer3		; HdH

	; Zehner
	clrf	xw2
	movlw	0x00		; 10 = 00 0A h
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	movwf	Ziffer2		; HdZ

	; Einer
	movfw	f0
	movwf	Ziffer1		; HdE
	return

Hex2Dez1
	clrf	HdX
	decf	HdX, f
HdLoop
	incf	HdX, f
	call	Sub24		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop		;Stelle 1 mehr
	call	Add24
	return

;**************************************************************
;+++Mathematik-Routinen ***************************************
;*
;**************************************************************
; 24 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub24				; 24 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen

	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    sb0
	movlw   0x01		; borgen von f1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb0
	subwf   f2    ,f        ; borgen von f2

	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf

sb0     movf    xw1, w		; f1=f1-xw1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb1
	movlw   0x01		; borgen von f2
	subwf   f2    ,f

        btfss   STATUS,C
	bsf	Fehler, C	; Unterlauf

sb1     movf    xw2,w		; f2=f2-xw2
        subwf   f2, f

        btfss   STATUS,C
       	bsf	Fehler, C	; Unterlauf

	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return

;**************************************************************
;24 bit Adition, C-Flag bei berlauf gesetzt
Add24 				; 24-bit add: f = f + xw
	movf	xw0,w		; low byte
	addwf	f0,f 		; low byte add

	movf	xw1,w 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,w 		; add C if it was set
	addwf	f1,f 		; high byte add if NZ
	
	movf	xw2,w		; high byte 
	btfsc	STATUS,C	; berspringe falls C nicht gesetzt 
	incfsz	xw2,w		; addiere C falls gesetzt 
	addwf	f2,f		; next byte add wenn  NZ 

	return 			; fertig


;*********************************************************************

	end



