	list p=12f675
;***********************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	GP: 	0 < analog ein 1 (PTC)
;*		1 < analog ein 2 (PTC)
;*		2 > RS232outPin / AlarmoutPin
;*		3 < Umschaltsignal fr Pin GP2:  1:RS232   0:Alarm
;*		4 > schalter out 2 (H=Lfter an)
;*		5 > schalter out 1 (H=Lfter an)
;*	
;***********************************************************************
;
; sprut (zero) Bredendiek 08/2005 - 11/2009
; http://www.sprut.de
;
; Lfterschalter, temperaturabhngig
;
; Temperaturmessung mit die Pins GP0,1  
; Schalttransistor fr Lfter an GP5,4
; RS232 (Temperaturen) und Alarmton an GP2
;
; Prozessor 12F675 
;
; Prozessor-Takt 4 MHz intern
; OSCCAL ist zu verwenden, damit RS232 funktioniert !!
;
;
; Temperaturmessung mit PTC vom Typ KTY81-110
; und Vorwiderstand, als Widerstandswert kann 
; 2k7 oder auch 2k2 verwendet werden
;
; PTC-Spannung bei 2k7 Vorwiderstand:
;	Temp.	Widerst	Spannung	ADC
;	-20C	684	1,0106 V	206
;	0C	815	1,1593 V	237
;	+20C	961	1,3125 V	268
;	+40C	1122	1,4678 V	300
;	+100C	1696	1,9290 V	395
;
; ADC  = Temp x 1,575 + 237
; Temp = (ADC - 237) / 1,575 
; 101/64 = 1.578
; 101 = 0x65
; Temp = ADC*64/101 - 150
;
;
; PTC-Spannung bei 2k2 Vorwiderstand:
;	Temp.	Widerst	Spannung	ADC
;	-20C	684	1,1858 V	243
;	0C	815	1,3515 V	277
;	+20C	961	1,5200 V	311
;	+40C	1122	1,6887 V	346
;	+100C	1696	2,1766 V	446
;
; ADC  = Temp x 1,69 + 277
; Temp = (ADC - 277) / 1,69
; 108/64 = 1.6875
; 108 = 0x6C
; Temp = ADC*64/108 - 164
; ermittelter Offset : 167
;
;***********************************************************************
; Includedatei fr den 12F675 einbinden

	#include <P12f675.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen:
; kein Power on Timer, kein Watchdog, int-Oscillator, kein Brown out
	__CONFIG	_MCLRE_OFF & _PWRTE_OFF & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _BODEN_OFF


;***********************************************************************
; Variablen festlegen  20h ... 5Fh 

Flags		equ	0x23	; flag bits (see definitions below)

NrMessung	EQU	0x24	; zhlt die 64 Temperaturmessungen
Fehler		equ	0x25	; Fehlerregister fr Mathematik

count		equ	0x26	; universeller zhler
loops		equ	0x27	; timer fr wait
loops2		equ	0x28	; timer fr wait

; Dezimalstellen
HdH		EQU	0x2E	;3  Hunderter
HdZ		EQU	0x2F	;2  Zehner
HdE		EQU	0x30	;1  Einer
HdX		EQU	0x31	; Puffer fr eine Dezimalstelle

;16 Bit Rechenregister
f0		equ	0x32	; 
f1		equ	0x33	; 
;16 Bit Rechenregister
xw0		equ	0x34	; 
xw1		equ	0x35	; 
;16 Bit Rechenregister fr Division
g0		equ	0x36	; 
g1		equ	0x37	; 

Ton1		equ	0x38
Ton2		equ	0x39
Toff1		equ	0x3A
Toff2		equ	0x3B

EEWriteData	equ	0x3C	; Schreibpuffer fr EEPROM
Offset1		equ	0x3D	; Offset des PTC No 1
Offset2		equ	0x3E	; Offset des PTC No 2
Offset		equ	0x3F	; aktueller Offset
Temp		equ	0x40	; Puffer fr Stringausgabe
Alarm1		equ	0x41	; berhitzungstemperatur Kanal 1
Alarm2		equ	0x42	; berhitzungstemperatur Kanal 2
Alarm		equ	0x43	; aktuelle berhitzungstemperatur

; fr RS232
Byte		equ	0x45
cycl_1		equ	0x46
cycl_2		equ	0x47

; Konstanten festlegen
#define Leading0	Flags,7
#define	Negativ		Flags,6	; 1: Temperatur ist negativ
#define	RS232outPin	GPIO,2


;***********************************************************************

;voreingestellte Default-Werte im EEPROM  (Temperaturen in C)
	org	H'2100'		; EEPROM
	de	D'150'		; Adr 0 = Offset1 (bei 2k2 waeren es 167)
	de	D'150'		; Adr 1 = Offset2 (bei 2k2 waeren es 167)
	de	D'38'		; Adr 2 = Ton1
	de	D'38'		; Adr 3 = Ton2
	de	D'33'		; Adr 4 = Toff1
	de	D'33'		; Adr 5 = Toff2
	de	D'50'		; Adr 6 = Alarm1
	de	D'50'		; Adr 7 = Alarm2


;***********************************************************************
	org	0x00

	goto	Init


;***********************************************************************
; Initialisierung
;
Init
	; IO-Pins
	bcf	STATUS, RP0		; Bank 0
	clrf	GPIO			; aus!
	movlw	0x07
	movwf	CMCON			; Comparator aus
	bsf	STATUS, RP0		; Bank 1
	bcf	TRISIO,2		; GP4 output RS232/Alarm
	bcf	TRISIO,4		; GP4 output fr kanal 2
	bcf	TRISIO,5		; GP4 output fr kanal 1
	bcf	STATUS, RP0		; Bank0

	; mit den Lueftern spielen zur Funktionskontrolle
	bsf	GPIO,4			; Luefter 2 an
	call	wait250ms
	call	wait250ms
	bcf	GPIO,4			; Luefter 2 aus
	call	wait250ms
	bsf	GPIO,5	 		; Luefter 1 an
	call	wait250ms
	call	wait250ms
	bcf	GPIO,5			; Luefter 1 an

	; internen Taktgenerator kalibrieren
	bsf	STATUS, RP0		; Bank 1
	call	0x3FF
	movwf	OSCCAL			; 4-MHz-Kalibrierung
	bcf	STATUS, RP0		; Bank 0

	; Interrupt
	bcf	INTCON, GIE		; Int deaktiviert

	clrf	Flags


	; ADC initialisieren
	; ADC einschalten
	BSF	ADCON0, ADON	; ADON=1
	; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, CHS1	; ADCHS1=0
	BCF	ADCON0, CHS0	; ADCHS0=0
	; ADC speed fr 1,25 ... 5 MHz einstellen
	BSF	STATUS,RP0	; Bank1
	clrf	ANSEL
	BSF	ANSEL, ADCS0	; ADCS0=1 Fosc/8
	; AN0,1 analog
	BSF	ANSEL, ANS0	; AN1=analog
	BSF	ANSEL, ANS1	; AN2=analog
	BCF	STATUS,RP0	; Bank0
	; Daten rechtsbndig
	BCF	ADCON0, VCFG	; RA2=digital
	BSF	ADCON0, ADFM	; ADFM=1 rechtsbndig


	;Lftereinschalttemperatur festlegen
	movlw	0
	call	EERead
	movwf	Offset1

	movlw	1
	call	EERead
	movwf	Offset2

	movlw	2
	call	EERead
	movwf	Ton1

	movlw	3
	call	EERead
	movwf	Ton2

	movlw	4
	call	EERead
	movwf	Toff1

	movlw	5
	call	EERead
	movwf	Toff2

	movlw	6
	call	EERead
	movwf	Alarm1

	movlw	7
	call	EERead
	movwf	Alarm2


;***********************************************************************
;Main 
;

Mainloop

	; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, CHS0	; ADCHS0=0
	; Messen
	movfw	Offset1
	movwf	Offset
	movfw	Alarm1
	movwf	Alarm
	call	Temperatur	; Messung der Temperatur am Sensor 1
	call	Luft1		; Lftersteuerung 1. Kanal
	btfss	GPIO,3
	call	Hot		; Test auf bertemperatur
	btfsc	GPIO,3
	call	TempRS232	; Temperatur via RS232 ausgeben

	; ADC-Eingang AN1 auswhlen
	BSF	ADCON0, CHS0	; ADCHS0=1
	; Messen
	movfw	Offset2
	movwf	Offset
	movfw	Alarm2
	movwf	Alarm
	call	Temperatur	; Messung der Temperatur am Sensor 2
	call	Luft2		; Lftersteuerung 2. Kanal
	btfss	GPIO,3
	call	Hot		; Test auf bertemperatur
	btfss	GPIO,3
	goto	noRS232
	call	TempRS232	; Temperatur via RS232 ausgeben
	movlw	0x0A
	call	Send_RS
	movlw	0x0D
	call	Send_RS
noRS232
	call	wait75ms
	goto	Mainloop

;***********************************************************************
; Temperatur messen und in f1,f0 ablegen (in C als Binr-Integer)
; bei negativer Temperatur wird das Negativ-Flag=1 gesetzt

Temperatur
	; Startwert fr korrektes Runden
	clrf	f1
	movlw	D'82'
	movwf	f0

	; 64 Messungen
	movlw	D'64'
	movwf	NrMessung
Messung
	call	UMessen1	; AN0 nach xw1,xw0
	call	Add16 		; 16-bit add: f = f + xw
	decfsz	NrMessung, f
	goto	Messung

	; Division durch 101 bei 2k7 Vorwiderstand, 101 = 0x65
	; Division durch 108 bei 2k2 Vorwiderstand, 108 = 0x6C
	movlw	0x00		; 101 = 0x65
	movwf	xw1
	movlw	0x65
	movwf	xw0
	call	Div16		; Division f:= f / xw

	; ca. 150C Offset entfernen
	bcf	Negativ		; angenommen: positive Temperatur
	clrf	xw1
	movfw	Offset
	movwf	xw0
	call	Sub16		; 16 bit f:=f-xw   calc=xw cnt=f;  neg=C
	btfss	STATUS, C
	goto	Positiv
	bsf	Negativ
	movfw	f0
	movwf	xw0
	movfw	f1
	movwf	xw1
	clrf	f1
	clrf	f0	
	call	Sub16		; 16 bit f:=f-xw   calc=xw cnt=f;  neg=C

Positiv
	return



;***********************************************************************
; Spannung wandeln nach xw1, xw0 
UMessen1
	clrf	count
aqui				; 0,3 ms  ADC Aqusitionszeit nach Eingangswahl
	DECFSZ	count, f
	goto	aqui

	BSF	ADCON0, 1	; ADC starten
loop
	BTFSC	ADCON0, 1	; ist der ADC fertig?
	GOTO	loop		; nein, weiter warten
	movfw	ADRESH		; obere  2 Bit auslesen
	movwf	xw1		; obere  2-Bit nach xw1
	bsf	STATUS,RP0	; Bank1
	movfw	ADRESL		; untere 8 Bit auslesen
	bcf	STATUS,RP0	; Bank0
	movwf	xw0		; untere 8-Bit nach xw0

	clrf	count		; Warten, damit der ADC sich erholen kann
warten
	DECFSZ	count, f
	goto	warten
	return


;***********************************************************************
;Warteroutinen verschiedener Lnge 

; 75 ms warten
wait75ms
	movlw	D'75'		; 75ms
	movwf	loops	
	goto	WAIT

; 250 ms warten
wait250ms
	movlw	D'250'		; 250ms
	movwf	loops	
	goto	WAIT

;***********************************************************************
;Zeitverzgerung um loops * 1 ms
; 4 MHz externer Takt bedeutet 1 MHz interner Takt
; also dauert 1 ms genau 1000 Befehle
; 100 Schleifen a 10 Befehle sind 1000 Befehle = 1 ms

WAIT
top     movlw   .100           ; timing adjustment variable (1ms)
        movwf   loops2
top2    nop                    ; sit and wait
        nop
        nop
        nop
	nop
        nop
        nop
        decfsz  loops2, F      ; inner loops complete?
        goto    top2           ; no, go again
                               ;
        decfsz  loops, F       ; outer loops complete?
        goto    top            ; no, go again
        retlw   0              ; yes, return from subWAIT



;***********************************************************************
;+++Mathematik-Routinen 
;
;***********************************************************************
; 16 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub16				; 16 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen
	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f
	btfsc   STATUS,C
	goto    Sub16A
	movlw   0x01		; borgen von f1
	subwf   f1, f
	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf
Sub16A
	movf    xw1,w		; f1=f1-xw1
        subwf   f1    , f
        btfss   STATUS, C
 	bsf	Fehler, C	; Unterlauf
	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return

;***********************************************************************
; 16 bit Adition, C-Flag bei berlauf gesetzt
Add16 				; 16-bit add: f = f + xw
	movf	xw0,W		; low byte
	addwf	f0,F 		; low byte add

	movf	xw1,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,W 		; add C if it was set
	addwf	f1,F 		; high byte add if NZ
	
	return 			; finished


;***********************************************************************
; primitive 16 bit Division 	f:= f / xw
Div16
	clrf	g0
	decf	g0, f
	clrf	g1
	decf	g1, f
Div16Loop
	incf	g0, f
	btfsc	STATUS, Z
	incf	g1, f
	call	Sub16		;
	btfss	STATUS, C	;berlauf
	goto	Div16Loop	;Stelle 1 mehr
	movfw	g0
	movwf	f0
	movfw	g1
	movwf	f1
	return

;***********************************************************************
; 8 Bit Wert f1,f0 in 3-stellig dezimal wandeln,
; Vorzeichen steht im Flag 'Negativ'
; Ergebnis in HdH, HdZ, HdE als ASCII-Zeichen
; funktioniert im Bereich -99 .. 999
;
;              100 = 0064 h
;               10 = 000A h
;                1 = 0001 h

Hex2Dez8_3			; 8-bit (f1, f0) in 3-stellen BCD
	bsf	Leading0
	movlw	0x00		; 100 = 00 64 h
	movwf	xw1
	movlw	0x64
	movwf	xw0
	call	Hex2Dez1	; 100er
	movfw	HdX
	btfsc	Negativ
	movlw	'-'		;'-'
	movwf	HdH

	movlw	0x00		; 10 = 00 0A h
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	movwf	HdZ

	movfw	f0
	iorlw	'0'		; wandeln in ASCII
	movwf	HdE		; Einer
	return



Hex2Dez1
	clrf	HdX
	decf	HdX, f
HdLoop
	incf	HdX, f
	call	Sub16		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop		;Stelle 1 mehr
	call	Add16
	; nun steht in HdX ein binres Ergebnis 0..9

	; falls fhrende 0 dann Wert=D'10'
	movfw	HdX
	btfss	STATUS, Z
	bcf	Leading0
	btfss	Leading0
	goto	HdASCCI
	movlw	' '
	movwf	HdX
	return
HdASCCI
	iorlw	'0'		; wandeln in ASCII
	movwf	HdX
	return

;***********************************************************************
; Temperatur via RS232 ausgeben

TempRS232
	call	Hex2Dez8_3	; Zahl in Ziffern wandeln

	movlw	' '
	call	Send_RS	
	movfw	HdH
	call	Send_RS	
	movfw	HdZ
	call	Send_RS	
	movfw	HdE
	call	Send_RS	
	movlw	''
	call	Send_RS	
	movlw	'C'
	call	Send_RS	
	movlw	' '
	call	Send_RS	
	return


;***********************************************************************
; Lfter ein/aus-schalten

Luft1
	; prfen ob Temp<Toff
	MOVFW	Toff1
	subwf	f0, w		; w:=f-33 = temp-Toff
	btfss	STATUS, C
	bcf	GPIO,5		; Lfter aus
	; prfen ob Temp>Ton
	MOVFW	Ton1
	subwf	f0, w		; w:=f-38 = temp-Ton
	btfsc	STATUS, C
	bsf	GPIO,5		; Lfter an
	return

Luft2
	; prfen ob Temp<Toff
	MOVFW	Toff2
	subwf	f0, w		; w:=f-w = temp-Toff
	btfss	STATUS, C
	bcf	GPIO,4		; Lfter aus
	; prfen ob Temp>Ton
	MOVFW	Ton2
	subwf	f0, w		; w:=f-w = temp-Ton
	btfsc	STATUS, C
	bsf	GPIO,4		; Lfter an
	return


;***********************************************************************
; bertemperaturtest
; Alarmton an RA2 falls f0 > Alarm (ca. 50C)

Hot
	; prfen ob Temp<Alarm
	MOVFW	Alarm
	subwf	f0, w		; w:=f-w = temp-Alarm
	btfss	STATUS, C
	return			; <50C
	; fr einen 2kHz-Ton sind 4000 Flanken ntig
	; bei 4MHz sind das 250 Zyklen zwischen 2 Flanken

	movlw	D'100'		; 100 Schleifen fr 50 ms Sound
	movwf	Temp
Hot1
	bsf	GPIO, 2
	movlw	.25		; timing adjustment variable (1/4ms)	
	movwf	loops2
	movlw	1
	movwf	loops
	call	top2		; 250us Wait
	bcf	GPIO, 2
	movlw	.25		; timing adjustment variable (1/4ms)	
	movwf	loops2
	movlw	1
	movwf	loops
	call	top2		; 250us Wait
	decfsz	Temp, f
	goto	Hot1
	return


;***********************************************************************
;  EEPROM-Routinen fr 12F6xx                  
;
;***********************************************************************
; 12F6xx hat 128 EEPROM-Zellen

;	EEADR 		Bank 1
;	EEDATA		Bank 1
;	EECON1		Bank 1
;	EECON2 		Bank 1


; lesen der Zelle ^W nach W
EERead
	BSF  	STATUS, RP0 		; Bank 1
 	MOVWF 	EEADR 			; schreibe die Adresse in EEADR 
	BSF  	EECON1, RD 		; EEPROM Leseproze starten 
	MOVF 	EEDATA, W 		; Die Daten der EEPROM Zelle nach W kopieren 
	BCF 	STATUS, RP0 		; Bank 0 
	return

; schreibe EEWriteData in Zelle ^W
EEWrite
	BSF 	STATUS, RP0 		; Bank 1
	MOVWF 	EEADR 			; Die Zelle @W soll beschrieben werden 
	BCF 	STATUS, RP0		; EEWritedata liegt in Bank 0
	MOVFW 	EEWriteData	
	BSF 	STATUS, RP0 		; EEDATA liegt in der Bank 1
	MOVWF 	EEDATA 			; EEWriteData wollen wir schreiben 
	BSF 	EECON1, WREN 		; nun ist Schreiben erlaubt 

	bcf	INTCON, GIE
	; Die folgenden 5 Zeilen mssen genau so im Code stehen!!! 
	MOVLW 	055h
	MOVWF 	EECON2 			; schreibe 55h nach EECON2 
	MOVLW 	0AAh
	MOVWF 	EECON2 			; schreibe AAh nach EECON2 
	BSF 	EECON1, WR 		; starte den Schreibzyklus 
	bsf	INTCON, GIE

EEWrite1				; warten das write fertig ist
	btfsc	EECON1, WR
	goto	EEWrite1
	BCF	EECON1, WREN		; disable schreiben
	BCF 	STATUS, RP0 		; Bank 0 
	return


;***********************************************************************
;  RS232-Software-Emulation              
;
;***********************************************************************
;senden des Bytes, das im Register W steht 

Send_RS				; Ausgabe eines Bytes seriell	
	movwf	Byte		; Byte in w
	movlw	8		; es werden 8 Bit gesendet
	movwf 	cycl_1
	bcf	RS232outPin
	call	Warte_s		; 1 Stopbit (1)
	bsf	RS232outPin
	call 	Warte_s		; 1 Startbit (0)

Send_1	rrf	Byte, f		; aktuelles Bit in das Carry-Flag schieben
	btfsc	STATUS, C
	bcf	RS232outPin	; Lo wenn Bit = 1
	btfss	STATUS, C
	bsf	RS232outPin	; Hi wenn Bit = 0
	call	Warte_s		; 1 Bit lang warten
	decfsz	cycl_1, f	; waren das schon 8 Bit?
	goto	Send_1		; nein, es geht weiter
	bcf	RS232outPin	; Byte zuende, 1 Stoppbit (1) senden
	call 	Warte_s		;
	return


;***********************************************************************
;ein Bit Zeitverzoegerung mit einer Warteschleife
; Timing mu genau stimmen (max 5% Fehler)
;
; senden            4 MHz    10 MHz	Periode
; 2400 Bps =          69d    173d	208 us
; 9600 Bps =          16d     43d	104 us
;
; bei 4MHz/9600 waere also 16 korrekt
; da aber in Send_RS auch noch etwas Zeit verbraucht wird
; ergibt 15 ein besseres Timing

Warte_s	movlw	D'15'		; 9600 Bps / 4 MHz senden
	movwf	cycl_2
Warte1				; 6 Zyklen Schleife
	nop
	nop
	nop
	decfsz	cycl_2, 1	
	goto	Warte1
	return

;***********************************************************************

	end


