;sprut (zero) Bredendiek 08/2005 .. 12/2007
;
; Termometer mit 16F876 und KTY81-110
; Lftersteuerung ber Schalttransitor
;
;
; PTC-Spannung:
;	Temp.	Spannung	ADC
;	-20C	1,0106 V	206
;	0C	1,1593 V	237
;	+20C	1,3125 V	268
;	+40C	1,4678 V	300
;	+100C	1,9290 V	395
;
;
; Schaltschwellen liegen im EEPROM und werden beim Programmstart
; von akku.asm aus dem EEPROM geladen
;	<35C	Luefter aus
;	>48C	Luefter an
;	>60C	Alarm
;
;   1. Temperaturregister (16-Bit) auf 82 setzen (32+50)
;   2. 64 mal ADC abfragen, ADC-Wert jeweils zum Temperaturregister addieren (16 Bit Addition)
;   3. Temperaturregister durch 101 dividieren (16 Bit Division)
;   4. Vom Temperaturregister 150 subtrahieren (16 Bit Subtraktion)
;   5. Temperaturregister in BCD umrechen (3-stellig), Vorzeichen beachten

Luefter
	; Messen
	call	Temperatur	; Messung der Temperatur am Sensor 1
	call	Hot		; Test auf bertemperatur
	call	SwitchFan	; Luefter ein/aus
	;call	Hex2Dez8_1	; Umrechnung in f1,f0 BCD fr die Anzeige 1

TempAnzeige
	btfss	FTemp		; nur anzeigen, wenn FTemp aktiv
	return
	movfw	UTemp_0		; Uref laden
	movwf	f0
	movfw	UTemp_1
	movwf	f1	

; Negativ wird noch nicht beruecksichtigt   DEBUG
	movlw	achteStelle	; 1. Zeile 9. Stelle
	call	OutLcdControl
	movlw	' '
	call	OutLcdDaten
	call	OutDez16	; f0, f1 ausgeben 
	movlw	TxtGrd		; Name
	call	Write	
	return


;**************************************************************
; Temperatur messen und in f1,f0 ablegen (in C als Binr-Integer)
; bei negativer Temperatur wird das Negativ-Flag=1 gesetzt

Temperatur
	; Startwert fr korrektes Runden
	clrf	f1
	movlw	D'82'
	movwf	f0

	; 64 Messungen
	movlw	D'64'
	movwf	NrMessung
Messung
	call	UMessen1xw	; AN0 nach xw1,xw0
	call	Add16 		; 16-bit add: f = f + xw
	decfsz	NrMessung, f
	goto	Messung

	; Division durch 101
	movlw	0x00		; 101 = 00 65 h
	movwf	xw1
	movlw	0x65
	movwf	xw0
	call	Div16		; Division f:= f / xw

	; 150C Offset entfernen
	bcf	Negativ		; angenommen: positive Temperatur
	clrf	xw1
	movfw	Offset
	movwf	xw0
	call	Sub16		; 16 bit f:=f-xw   calc=xw cnt=f;  neg=C
	btfss	STATUS, C
	goto	Positiv
	bsf	Negativ
	movfw	f0
	movwf	xw0
	movfw	f1
	movwf	xw1
	clrf	f1
	clrf	f0	
	call	Sub16		; 16 bit f:=f-xw   calc=xw cnt=f;  neg=C

Positiv
	movfw	f1
	movwf	UTemp_1
	movfw	f0
	movwf	UTemp_0
	return



;**************************************************************
; Spannung wandeln nach xw1, xw0 
UMessen1xw
	; ADC-Eingang AN4/RA5 auswhlen
	BSF	ADCON0, 5	; ADCHS2=1
	BCF	ADCON0, 4	; ADCHS1=0
	BCF	ADCON0, 3	; ADCHS0=0
	; Uref=Vdd
	bsf	STATUS,RP0	; Bank1
	bcf	ADCON1,PCFG0	; PCFG0=0
	bcf	STATUS,RP0	; Bank0

	clrf	count
xwaqui				; 0,3 ms  ADC Aqusitionszeit nach Eingangswahl
	DECFSZ	count, f
	goto	xwaqui

	BSF	ADCON0, 2	; ADC starten
xwloop
	BTFSC	ADCON0, 2	; ist der ADC fertig?
	GOTO	xwloop		; nein, weiter warten
	movfw	ADRESH		; obere  2 Bit auslesen
	movwf	xw1		; obere  2-Bit nach xw1
	bsf	STATUS,RP0	; Bank1
	movfw	ADRESL		; untere 8 Bit auslesen
	bcf	STATUS,RP0	; Bank0
	movwf	xw0		; untere 8-Bit nach xw0

	clrf	count		; Warten, damit der ADC sich erholen kann
xwwarten
	DECFSZ	count, f
	goto	xwwarten
	return


;**************************************************************
;+++Mathematik-Routinen ***************************************

;**************************************************************

;primitive 16 bit Division 	f:= f / xw
Div16
	clrf	g0
	decf	g0, f
	clrf	g1
	decf	g1, f
Div16Loop
	incf	g0, f
	btfsc	STATUS, Z
	incf	g1, f
	call	Sub16		;
	btfss	STATUS, C	;berlauf
	goto	Div16Loop	;Stelle 1 mehr
	movfw	g0
	movwf	f0
	movfw	g1
	movwf	f1
	return


;**************************************************************
; bertemperaturtest f0 > Alarm (60C)
; es erfolgt noch keine Nutzung  DEBUG

Hot
	; prfen ob Temp<Alarm
	bcf	Akku1Hot	; hoffen wir mal das beste
	MOVFW	Alarm
	subwf	f0, w		; w:=f-w = temp-Alarm
	btfss	STATUS, C
	return			; <60C
	bsf	Akku1Hot	; ueberhitzt
	movlw	D'11'
	movwf	Menue2
	call	RMenue		; Ueberhitzung
Hotloop
	call	Bedienung
	goto	Hotloop		; Ende mit Endlosschleife nach ueberhitzen

	return


;***********************************************************************
; Lfter ein/aus-schalten
SwitchFan
Luft1
	; prfen ob Temp<Toff
	MOVFW	Toff
	subwf	f0, w		; w:=f-35 = temp-Toff
	btfss	STATUS, C
	bcf	Fan		; Lfter aus
	; prfen ob Temp>Ton
	MOVFW	Ton
	subwf	f0, w		; w:=f-48 = temp-Ton
	btfsc	STATUS, C
	bsf	Fan		; Lfter an
	return

