
;*****************************************************
;+++EEPROM-Routinen fr 16F876************************
;*****************************************************
; 16F876 hat 256 EEPROM-Zellen

;	EEADR 		Bank 2
;	EEDATA		Bank 2

;	EECON1		Bank 3
;	EECON2 		Bank 3



; speichern der Akkukapazitt im EEPROM
SaveKap
	movfw	Kapazitaet
	movwf	EEWriteData
	clrw
	call	EEWrite	
	return



; lesen der Zelle ^W nach W
EERead
	BSF  	STATUS, RP1 	; EEADR liegt in der Bank 2 
 	MOVWF 	EEADR 		; schreibe die Adresse in EEADR 
	BSF  	STATUS, RP0 	; EECON1 liegt in der Bank 3
	BCF	EECON1, EEPGD	; EEPROM und nicht FLASH lesen
	BSF  	EECON1, RD 	; EEPROM Leseproze starten 
	BCF  	STATUS, RP0 	; EEDATA liegt in der Bank 2
	MOVF 	EEDATA, W 	; Die Daten der EEPROM Zelle nach W kopieren 
	BCF 	STATUS, RP1 	; Bank 0 
	return

; schreibe EEWriteData in Zelle ^W
EEWrite
	BSF 	STATUS, RP1 	; EEADR liegt in der Bank 2
	MOVWF 	EEADR 		; Die Zelle @W soll beschrieben werden 
	BCF 	STATUS, RP1	; EEWritedata liegt in Bank 0
	MOVFW 	EEWriteData	
	BSF 	STATUS, RP1 	; EEDATA liegt in der Bank 2
	MOVWF 	EEDATA 		; EEWriteData wollen wir schreiben 
	BSF 	STATUS, RP0 	; EECON1 liegt in der Bank 3
	BCF	EECON1, EEPGD	; EEPROM und nicht FLASH schreiben
	BSF 	EECON1, WREN 	; nun ist Schreiben erlaubt 

; Die folgenden 5 Zeilen mssen genau so im Code stehen!!! 
	MOVLW 	055h
	MOVWF 	EECON2 		; schreibe 55h nach EECON2 
	MOVLW 	0AAh
	MOVWF 	EECON2 		; schreibe AAh nach EECON2 
	BSF 	EECON1, WR 	; starte den Schreibzyklus 

EEWrite1			; warten das write fertig ist
	btfsc	EECON1, WR
	goto	EEWrite1
	BCF	EECON1, WREN	; disable schreiben
	BCF 	STATUS, RP0 	; Bank 0 
	BCF 	STATUS, RP1 	; Bank 0 
	return

