	list p=16f876
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 < Akkuspannung / 3 * Gain
;*		1 - 
;*		2 - 
;*		3 < Ref+ =2,56V
;*		4 -
;*		5 < KTY81-110 
;*		6 -
;*		7 -
;*
;*	PORTB:	0 -	
;*		1 > +5V fr rotary enc.	- Vdd Pin6
;*		2 -
;*		3 -
;*		4 -
;*		5 < rotary enc. switch	-   Pin3
;*		6 < rotary encoder 	- B Pin4
;*		7 < rotary encoder 	- A Pin5
;*
;*
;*	PORTB:	0 LCD Display E
;*		1 			Keyboard 1 4 7 *
;*		2 LCD Display RS	Keyboard 2 5 8 0
;*		3 LCD Display R/W	Keyboard 3 6 9 #
;*		4 LCD Display D4 	---------I I I I
;*		5 LCD Display D5	-----------+ I I
;*		6 LCD Display D6	-------------+ I
;*		7 LCD Display D7	---------------+
;*	
;*	PORTC:	0 > Laden1
;*		1 > Entladen1
;*		2 > PWM
;*		3 > PotDir
;*		4 > PotClk
;*		5 > Luefter
;*		6 > TX: RS-232-Ausgang zum Treiber	    
;*		7 < RX: RS-232-Eingang vom Treiber	
;*	
;**************************************************************
;
;sprut (zero) Bredendiek 06/2003 ..11/2007
;
; Akkudadegert mit 16F876 
; 1..7 Zellen   150mAh ... 6Ah
;
; Prozessor 16F876 
;
; Prozessor-Takt 10 MHz
;
; - LCD & Keyboard/Rotary Encoder am PortB
; - Ladeschaltung an RC0 (high aktiv)
; - Entladeschaltung an RC1 (high aktiv)
; - Akkukapazitt als PWM an RC2
;
; Programme
;	- Entladen -> Beleben -> Laden -> Topping -> Erhalten
;	- Beleben -> Laden -> Topping -> Erhalten
;	- Entladen
;
; Unter-Programme
;	- Entladen mit C bis auf 1,00 V
;	- Beleben mit C/10 falls U<0,4V
;	- Laden mit C/3 bis delta-peak oder 4 Stunden oder 1,90 V
;	- Topping-Laden mit C/10 fr 2 Stunden
;	- Erhaltungsladung mit C/40 ohne Ende
;
;
; Display-Anzeige bei Entladen/Beleben/Laden/Toppen/Erhalten
;	Umschaltbar mit Drehen des Rotary-Encoders
;
; ##################
; #Laden   00h00m00#    Mode     - Zeit
; ##################
;	VVV
; ##################
; #Laden   123450mV#    Mode     - Spannung
; ##################
;	VVV
; ##################
; #Laden     250mAh#    Mode     - mAh
; ##################
;	VVV
; ##################
; #Laden      250mA#    Mode     - Ladestrom
; ##################
;
; Ladezyklus:    6,75 s mit C/3
; Entladezyklus: 2,25 s mit C
;
; 50 mA wrend eines Zyklus entsprechen dE = 0,09375 mAh = D'24' = 0x0000.18
;
; Ladestrom einstellbar von 50 mA..2,33A in 50 Schritten zu 50 mA
;	wird als PWM mit 3/256=300mAh bis 140/256=7000mAh ausgegeben
;
;
; Zeitmessung fr Anzeige von hh:mm
;	1 Minute = 26 Entladezyklen a(2,25 s +  57 ms)
;	1 Minute = 8 Ladezyklen     a(6,75 s + 750 ms)
;	1 Minute = 60 Toppingyklen  a(250 ms + 750 ms)
;
;	Zeitmessung erfolgt in 3 Registern
;		Zhh  - Zeit in Stunden	   0 .. 255 h  
;		Zmm  - Zeit in Minuten     0 ..  59 m
;		Zss4 - Zeit in 1/4 Minuten 0 .. 239 1/4s
;
;
; Kalibrierung 1A:
;	kurzschlieen der Akkuanschlsse
;	Ladestrom von 1,0 A einstellen (Akkutyp 3000 mAh)
;		Kapazitaet = 60; I=1,0 A; U = 470 mV
;	Spannung kontinuierlich messen und anzeigen
;	ADC-Ergebnis: 188 
;	Sollanzeige: 470 mV
;	- Regulierung an R2
;	Messung erfolgt mit 2,5mV Auflsung -> 0,5% Toleranz
;	- Messung durch bergangswiderstnde verflscht, 
;	- besser Amperemeter an Akkuklemmen benutzen
;
; Kalibrierung 100mA:
;	berbrcken der Akkuanschlsse mit 10 Ohm
;	Ladestrom von 100 mA einstellen (Akkutyp 300 mAh)
;		Kapazitaet = 6; I=100 mA; U = 1,05 V
;	Spannung kontinuierlich messen und anzeigen
;	ADC-Ergebnis: 420 
;	Sollanzeige: 1050 mV
;	- Regulierung an R2
;	Messung erfolgt mit 2,5mV Auflsung -> 0,25% Toleranz
;
; Kalibrierung Voltmeter
;	Anzeige der Spannung in mV und 
;	der binren Lupenspannung (ADC-Ergebnis) und
;	Anzeige der Referenzspannung in mV
;
;	##################
;	#Spannung 01234mV#	Text	U
;	##################
;
;	##################
;	#U-Lupe     123UL#	Text	U-Lupe
;	##################
;
;	##################
;	#U-ref     2560mV#	Text	Uref
;	##################
;	- Regulierung an R4
;
;
; Spannungsmessung
;	Vref=2,56V
;		Auflsung = 2,5 mV
;		1,00V = 400 = 0190h
;		Umrechnung in mV: X2,5;	Vref=2,56V
;	4 Messungen, danach Runden auf U:=abs((4U+2)/4)
;
;	Vref=5V
;		Auflsung = 2 mV
;		Gain = 7,33 = 1,047*(8-Zellenzahl)
;		1,00V -> 2,44V = 500 = 01F4h 
;		Umrechnung in mV: X2
;	4 Messungen, danach Runden auf U:=abs((4U+2)/4)
;
;OPV-Messverstaerker
;	Zellen	Gain		R2	realGain	Fehler
;	1	7,331378299	14	7,142857	2.6%
;	2	3,66568915	27	3,703703	1,0%
;	3	2,443792766	41	2,439024	0,2%
;	4	1,832844575	55	1,81818		0,8%
;	5	1,46627566	68	1,470588	0,3%
;	6	1,221896383	82	1,219512	0,2%
;	7	1,047339757	95	1,052631	0,5%
;
;
;	Vref=4,8714V
;		Auflsung = 2 mV
;		Gain = 7,143 = 100/14 / (8-Zellenzahl)
;		1,00V -> 2,381V = 500 = 01F4h 
;		Umrechnung in mV: x 2
;	4 Messungen, danach Runden auf U:=abs((4U+2)/4)
;
;OPV-Messverstaerker
;	Zellen	Gain		R2	realGain	Fehler
;	1	7,143		14	7,143   	0.0%
;	2	3,571		28	3,....   	0,0%
;	3	2,381   	42	2,....  	0,0%
;	4	1,786 		56	1,....  	0,0%
;	5	1,429		70	1,....		0,0%
;	6	1,190   	84	1,....		0,0%
;	7	1,020		98	1.....		0,0%
;
;
; RS-232: (zur Zeit nicht aktiv)
;
;	16F876 sendet RS232 Code
;	Mewerte werden zur Aufzeichnung ausgesendet
;
;	Prozessortakt:  10 MHz
;	RS232-Baudrate: 9 600 Baud
;
;MENUES:
; Level1
;	******************
;	*LADER 3 Akkutyp *	0 	Akkutyp
;	*	 Laden   *	1	Beleben/Laden/Toppen
;	*	 Entladen*	2	Entladen
;	*	 Ent/Lade*	3	Entladen/Beleben/Laden/Toppen
;	*	 Spannung*	4	Spannung
;	*	 U-Lupe  *	5	U-Lupe
;	*	 U-ref   *	6	U-ref
;	*	 Kal   1A*	7	Kal   1A
;	*	 Kal 0.1A*	8	Kal.0,1A
;	*        Temp    *	9	Khlkrpertemperatur
;	*	 Zellen	 *	10	Zellenzahl
;	******************
;
; Level2
;	******************
;	*XXXXX	 .0h00m00*	0	Zeit			FT
;	*	 ..1234mV*	1	Zellenspannung		FU
;	*	 .1234mAh*	2	rein/raus		FE
;	*	 ..1234mA*/Ende	3	Strom / Fertig		FI
;	*	 ..xxxxdU*	4	Ladeschlukennung	FdU
;	*	  L......*	5	Lupenspannung		FLU
;	*	 .r1234mV*	6	Referenzspannung	FUref
;	*	 ....21 C*	7	Temperatur		FTemp
;	******************
;
;
;
; Luefter wird ab 5..10W hochgetourt
;	Pe = Zellen x 1,4 x Strom
;	   = Zellen x 1,4 x Kapazitaet
;	Pl = (12V - Zellen) x Strom
;	   = (12V - Zellen) x (Kapazitaet / 3)
;	
;	Laden: Ladestrom max 2A
;	mAh	1	2	3	4	5	6
;	150
;	300
;	700
;	1000
;	2000
;	4000
;	6000
;
;	Entladen:
;	mAh\Z	1	2	3	4	5	6
;	150	0,2					1.5
;	300	0,5	1	1	2	2	3
;	700	1	2	3	4	5	6
;	1000	1,5	3	4	6	7	8
;	2000	3	6					30
;	4000	6	11					40
;	6000	9						60
;
;
; Luefter bei ueber 50 grd einschalten und unter 40 grd abschalten
; KTY81-110 mit 2,7 kOhm an 5V
;
; PTC-Spannung:
;	Temp.	Spannung	ADC	ADCcal
;	-20C	1,0106 V	206	226
;	0C	1,1593 V	237	259
;	+20C	1,3125 V	268	293
;	+40C	1,4678 V	300	328
;	+100C	1,9290 V	395	431
;
; Kelvin = (ADCcal + 211  ) / 1,72  = (ADCcal + 211  ) x 32 / 55 
; Kelvin = (ADC    + 194  ) / 1,58  = (ADC    + 194  ) x 64 / 101
;
;**********************************************************
; Includedatei fr den 16F876 einbinden

	#include <P16f876.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES


; Configuration festlegen:
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming
	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC & _BODEN_OFF & _LVP_OFF


;********************************************************
; Variablen festlegen

AkkuStatus	equ	0x2A	; AkkuStatus Flags
count		equ	0x2B	; universeller zhler
loops		equ	0x2C	; timer fr wait
loops2		equ	0x2D	; timer fr wait
LcdStatus	equ	0x2E	;
LcdDaten	equ	0x2F	;

Zellen		equ	0x30	; Zellenzahl  ICH HOFFE DIESE ADRESSE IST FREI
Kapazitaet	equ	0x31	; Akkukapazitt in 50 mAh (6..140 = 300..7000)
EEWriteData	equ	0x32	; 
counter		equ	0x33
MenueMode	equ	0x34
DisplayFlags	equ	0x35	; weitere flags auf 0x68
MenueLevel	equ	0x36	; 0=Level 1; 1=Level 2
Menue1		equ	0x37	; rechte Anzeige Level1 / linke Level2
Menue2		equ	0x38	; rechte Anzeige Level2
RotorFlags	equ	0x39	; Rotary encoder flags

LZ0		equ	0x3A	; Zhler der Ladezyklen/Toppingzyklen
LZ1		equ	0x3B

E0		equ	0x3C	; mAh-Zhler in 1/256 mAh
E1		equ	0x3D	; mAh-Zhler in     1 mAh
E2		equ	0x3E 	; mAh-Zhler in   256 mAh

dE0		equ	0x3F	; mAh pro Takt in 1/256 mAh	
dE1		equ	0x40	; mAh pro Takt in     1 mAh

Fehler		equ	0x41	; Fehlerregister fr Mathematik
Temp		equ	0x42
temp		equ	0x43
neu		equ	0x44	; temp fr rotary ecoder
alt		equ	0x45

; Zeit
Zhh		equ	0x46	; Zeit in Stunden      0 .. 255 h
Zmm		equ	0x47	; Zeit in Minuten      0 ..  59 m
Zss4		equ	0x48	; Zeit in 1/4 Sekunden 0 .. 239 1/4s

; Dezimalstellen
HdZT		EQU	0x49	;5  Zehntausender
HdT		EQU	0x4A	;4  Tausender
HdH		EQU	0x4B	;3  Hunderter
HdZ		EQU	0x4C	;2  Zehner
HdE		EQU	0x4D	;1  Einer
HdX		EQU	0x4E	; Puffer fr eine Dezimalstelle

BcdDaten	equ	0x4F
BcdDaten1	equ	0x50

AkkuAltL	equ	0x51
AkkuAltH	equ	0x52
AkkuNeuL	equ	0x53
AkkuNeuH	equ	0x54
DeltaPeak	equ	0x55	; Ladeabbruchzhler

U0		equ	0x56	; U1 in Millivolt
U1		equ	0x57
Uref0		equ	0x58	; Uref in Millivolt
Uref1		equ	0x59
UL0		equ	0x5A	; ULupe (ADC-Wert)
UL1		equ	0x5B
UTemp_0		equ	0x5C	; Temperatur in Grad-Celsius
UTemp_1		equ	0x5D

sitandwait	equ	0x5E	; Schleifenzhler

; fuer temperaturabhaengige Lueftersteuerung
NrMessung	equ	0x5F	;
Offset		equ	0x60	; Offset der Temperaturmessung
Ton		equ	0x61	; Einschalttemperatur des Luefters
Toff		equ	0x62	; Ausschalttemperastur des Luefters
Alarm		equ	0x63	; Ueberhitzungstemperatur

g0		equ	0x64	; Rechenregister fuer Division
g1		equ	0x65	;
Fir0		equ	0x66	; FIR-Ergebnis
Fir1		equ	0x67	; FIR-Ergebnis
DisplayFlags2	equ	0x68	; Fortsetzung von 0x35

; von allen Banken aus erreichbar
U1H		equ	0x70	; High Teil der Akku1-Spannung
U1L		equ	0x71	; Low  Teil der Akku1-Spannung
FirP		equ	0x72	; Pointer fr FIR-Banken
U1durch64	equ	0x73	; 1/64 der Akkuspannung

;32 Bit Rechenregister
f0		equ	0x74	; 
f1		equ	0x75	; 
f2		equ	0x76	; 
f3		equ	0x77	; 

;32 Bit Rechenregister
xw0		equ	0x78	; 
xw1		equ	0x79	; 
xw2		equ	0x7A	; 
xw3		equ	0x7B	; 

B1L		equ	0x7C
B1H		equ	0x7D
B3L		equ	0x7E
B3H		equ	0x7F



; Konstanten festlegen

; Level2
;	******************
;	*XXXXX	 .0h00m00*	0	Zeit			FT
;	*	 ..1234mV*	1	Zellenspannung		FU
;	*	 .1234mAh*	2	rein/raus		FE
;	*	 ..1234mA*/Ende	3	Strom / Fertig		FI
;	*	 ..xxxxdU*	4	Ladeschlukennung	FdU
;	*	  L......*	5	Lupenspannung		FLU
;	*	 .r1234mV*	6	Referenzspannung	FUref
;	*	 ....21 C*	7	Temperatur		FTemp
;	******************
#define	FT		DisplayFlags, 0
#define	FU		DisplayFlags, 1
#define	FE		DisplayFlags, 2
#define	FI		DisplayFlags, 3
#define	FdU		DisplayFlags, 4
#define	FLU		DisplayFlags, 5
#define	FUref		DisplayFlags, 6
#define	FFir		DisplayFlags, 7
#define	FTemp		DisplayFlags2, 0	 ; DEBUG !!
#define FZellen		DisplayFlags2, 1  ; DEBUG !!!!!!!!

#define	RotoRechts	RotorFlags,0
#define	RotoLinks	RotorFlags,1
#define	RotoDown	RotorFlags,2
#define	encoder		PORTB

#define	CHG1		PORTC,0		; laden Akku1
#define	DCHG1		PORTC,1		; entladen Akku1
#define	PotDir		PORTC,3		; Drehrichtung des Potis
#define	PotClk		PORTC,4		; Takt des Potis
#define	Fan		PORTC,5		; schaltet den Luefter
#define Akku1Voll	AkkuStatus,0	; 1=Akku1 voll				V
#define Akku1Leer	AkkuStatus,1	; 1=Akku1 leer (unter 1V)		L
#define Akku1Tot	AkkuStatus,2	; 1=Akku1 unter 0,4V			T
#define Akku1Hot	AkkuStatus,3	; 1=Kuehlkoerper ueberhitzt		H
#define FirFlag		AkkuStatus,5	; FIR hat Ladeende erkannt		F
#define Negativ		AkkuStatus,6	; negative Temperatur am Kuehlkoerper
#define Leading0	AkkuStatus,7

; fr LCD-Pins
#define	LcdE		PORTB,0		; enable Lcd
#define	LcdRw		PORTB,3		; read Lcd
#define	LcdRs		PORTB,2		; Daten Lcd (nicht control)	
#define LcdPort		PORTB		; Datenbus des LCD (obere 4 Bit)
; 1.Zeile 8. Stelle fr Display
;#define achteStelle	B'10001000'	; mit Spaltentreiber
#define achteStelle	B'11000000'	; ohne Spaltentreiber


Ini_con		Equ	B'00000000'	; TMR0 -> Interupt disable
Ini_opt		Equ	B'00000010'	; pull-up

;********************************************************
;voreingestellter Akkutyp 700 mAh = 14  / 1 Zelle
	org	H'2100'		;EEPROM
	de	0x0E		; Adr 0 = 14 x 50mAh = 700 mAh
	de	0x01		; Adr 1 = 1 Zelle
	de	D'150'		; Adr 2 = Temperatur-Offset
	de	D'48'		; Adr 3 = Ton   48 grd
	de	D'35'		; Adr 4 = Toff  35 grd
	de	D'60'		; Adr 5 = Alarm 60 grd


;********************************************************
	org	0
	goto	Init

;Txt001	dt	"Akku-Lader V2.00",' '+80h	; RETLW
Txt001a	dt	"Akku-Lad",' '+80h		; RETLW
Txt001b	dt	"er V2.00",' '+80h		; RETLW
Txt0mV	dt	"0mV",' '+80h			; RETLW
TxtmV	dt	"mV",' '+80h			; RETLW
TxtmAh	dt	"mAh",' '+80h			; RETLW
TxtUL	dt	"UL",' '+80h			; RETLW
TxtmA	dt	"mA",' '+80h			; RETLW
TxtZ	dt	"Zellen",' '+80h		; RETLW
TxtGrd	dt	" C",' '+80h			; RETLW
TxtFir	dt	"dP",' '+80h			; RETLW

; Level1
;	******************
;	*LADER 3 Akkutyp *	0 	Akkutyp
;	*	 Laden   *	1	Beleben/Laden/Toppen
;	*	 Entladen*	2	Entladen
;	*	 Ent/Lade*	3	Entladen/Beleben/Laden/Toppen
;	*	 Spannung*	4	Spannung
;	*	 U-Lupe  *	5	U-Lupe
;	*	 U-ref   *	6	U-ref
;	*	 Kal   1A*	7	Kal   1A
;	*	 Kal 0.1A*	8	Kal.0,1A
;	*	 Temp    *	9	Kuehlkoerpertemperatur
;	*	 Zellen  *	10	Zellenzahl des Packs
;	******************

Txt00	dt	"-----> ",' '+80h
Txt10	dt	"Akkutyp",' '+80h
Txt11	dt	"Laden  ",' '+80h
Txt12	dt	"Entlade",'n'+80h
Txt13	dt	"Ent/Lad",'e'+80h
Txt14	dt	"Spannun",'g'+80h
Txt15	dt	"U-Lupe ",' '+80h
Txt16	dt	"U-ref  ",' '+80h
Txt17	dt	"Kal   1",'A'+80h
Txt18	dt	"Kal 0,1",'A'+80h
Txt19	dt	"Beleben",' '+80h
Txt1A	dt	"Toppen ",' '+80h
Txt1B	dt	"Erhalte",'n'+80h
Txt1C	dt	"Temp   ",' '+80h
Txt1D	dt	"Zellen ",' '+80h

; Level2
;	******************
;	*XXXXX	 .0h00m00*	0	Zeit			FT
;	*	 ..1234mV*	1	Zellenspannung		FU
;	*	 .1234mAh*	2	rein/raus		FE
;	*	 ..1234mA*/Ende	3	Strom / Fertig		FI
;	*	 ..xxxxdU*	4	Ladeschlukennung	FdU
;	*	  L......*	5	Lupenspannung		FLU
;	*	 .r1234mV*	6	Referenzspannung	FUref
;	*	 ....21 C*	7	Temperatur		FTemp
;	******************


Txt27	dt	"Akkutyp",' '+80h
Txt28	dt	" defekt",' '+80h
Txt29	dt	" fertig",' '+80h
Txt2A	dt	" timeou",'t'+80h
Txt2C	dt	" heiss ",' '+80h

;********************************************************


RMenueText1 				; ACHTUNG TABELLENFALLE
	addwf PCL, f 
	retlw	Txt10		; 0  Akkutyp
	retlw	Txt11		; 1  Laden
	retlw	Txt12		; 2  Entladen
	retlw	Txt13		; 3  Ent/Lade
	retlw	Txt14		; 4  Spannung
	retlw	Txt15		; 5  U-Lupe
	retlw	Txt16		; 6  U-ref
	retlw	Txt17		; 7  Kal   1A
	retlw	Txt18		; 8  Kal 0,1A
	retlw	Txt1C		; 9  Temp
	retlw	Txt1D		; 10 Zellen
	retlw	Txt1B		; 11 Erhalten
	retlw	Txt19		; 12 Beleben
	retlw	Txt1A		; 13 Toppen
	retlw	Txt28		; 14  defekt
	retlw	Txt2A		; 15  timeout
	retlw	Txt2C		; 16  ueberhitzt

;
;0  Akkutyp	7
;1  Laden	0-1-2-3
;2  Entladen	0-1-2-3
;3  E/L
;4  Spannung	1
;5  U-Lupe	5
;6  U-ref	6
;7  Kal   1A	1
;8  Kal 0,1A	1
;9  Temp
;10 Zellen
;11 Erhalten	0-1-2-3
;12 Beleben	0-1-2-3
;13 Toppen	0-1-2-3


; Einstellungen fuer elektronisches Poti, je nach Zellenzahl
GainR2 			
	addwf PCL, f 
	retlw	D'14'		; 0  Fehler
	retlw	D'14'		; 1  
	retlw	D'28'		; 2  
	retlw	D'42'		; 3  
	retlw	D'56'		; 4  
	retlw	D'70'		; 5  
	retlw	D'84'		; 6  
	retlw	D'98'		; 7  


	org	0x0100
;********************************************************
; Das Programm beginnt mit der Initialisierung
	
Init	
	bsf     STATUS, RP0		; Bank 1
	movlw   Ini_opt     		; pull-up on
	movwf   OPTION_REG 
	movlw	B'00000000'		; PortB & C alle outputs 
	movwf	TRISB
	movwf	TRISC
	bcf     STATUS, RP0		; Bank 0
	clrf	PORTB
	clrf	PORTC		
	clrf	AkkuStatus
	movlw   Ini_con     		; Interupt disable
	movwf   INTCON   

; ADC initialisieren
	call	InitADC

; Standardwerte aus EEPROM lesen
	clrw				; EEPROM-Zelle 0
	call	EERead			; lesen der Zelle ^W nach W
	movwf	Kapazitaet

	movlw	1			; EEPROM-Zelle 1
	call	EERead			; lesen der Zelle ^W nach W
	movwf	Zellen

	movlw	2			; EEPROM-Zelle 2
	call	EERead			; lesen der Zelle ^W nach W
	movwf	Offset

	movlw	3			; EEPROM-Zelle 3
	call	EERead			; lesen der Zelle ^W nach W
	movwf	Ton

	movlw	4			; EEPROM-Zelle 4
	call	EERead			; lesen der Zelle ^W nach W
	movwf	Toff

	movlw	5			; EEPROM-Zelle 5
	call	EERead			; lesen der Zelle ^W nach W
	movwf	Alarm

; Energiemenge entsprechend Kapazitaet einstellen
	call	Kap2dE			; dE := Kapazitaet x 8

; Messverstaerker einstellen
	call	OpvGain			; 

; PWM initialisieren
	; Vorteiler 16:1 und Timer2 einschalten
	BSF	T2CON,T2CKPS1		; Vorteiler 16:1
	BSF	T2CON,TMR2ON		; Timer2 ein
	; Frequenz auf ca. 1,2 kHz einstellen
	BSF	STATUS,RP0		; Bank1
	MOVLW	D'140'			; maximal 140 x 50mAh=7000mAh
	MOVWF	PR2			; 1,2 kHz
	BCF	STATUS,RP0		; Bank0
	; Tastverhltnis auf AkkuKapazitt einstellen
	movfw	Kapazitaet
	MOVWF	CCPR1L
	; RC2/CCP1 auf Ausgang stellen
	BSF	STATUS,RP0		; Bank1
	BCF	TRISC, 2		; RC2: output=0
	BCF	STATUS,RP0		; Bank 0
	; PWM MODE mit CCP1 initialisieren
	CLRF	CCP1CON			; CCP1-Modus aus
	BSF	CCP1CON,CCP1M3		; CCP1-Modus PWM-Mode
	BSF	CCP1CON,CCP1M2

; USART initialisieren 
	BSF	STATUS,RP0		; Bank1 
	MOVLW	0x20			; Sender: RS232 
	MOVWF	TXSTA			; 
	BCF	STATUS,RP0		; Bank 0 
	MOVLW	0x90			; Empfnger: RS232 
	MOVWF	RCSTA
	; USART Baudrate einstellen 
	BSF	STATUS,RP0		; Bank1 
	MOVLW	D'15'			; Set Baud rate 9600 BPS bei 10 MHz 
	MOVWF	SPBRG 
	BCF	TXSTA, BRGH		; BRGH=0 
	BCF	STATUS,RP0		; Bank 0 

;Display initialisieren
	call	InitLcd
	movlw	Txt001a			; Name
	call	Write
	movlw	achteStelle		; 1. Zeile
	call	OutLcdControl
	movlw	Txt001b			; Name
	call	Write
	
	movlw	D'255'			; 0,75 Sekunden anzeigen
	movwf	loops
	call	WAIT
	movlw	D'255'
	movwf	loops
	call	WAIT
	movlw	D'255'
	movwf	loops
	call	WAIT

	; aktuelle Akkukapazitt anzeigen
	movfw	Kapazitaet
	call	Mal50
	movlw	B'10000000'		; 1. Zeile
	call	OutLcdControl
	movlw	Txt27			; Akkutyp
	call	Write	

	movlw	achteStelle		; 1. Zeile
	call	OutLcdControl

	call	OutDez16		; f0, f1 ausgeben als Kapazitt
	movlw	TxtmAh			; 'mAh'
	call	Write
	movlw	D'255'			; 0,75 Sekunden anzeigen
	movwf	loops
	call	WAIT
	movlw	D'255'
	movwf	loops
	call	WAIT
	movlw	D'255'
	movwf	loops
	call	WAIT

	call	read_encoder		; alt setzen
	clrf	MenueLevel		; Level1
	clrf	Menue1			; Akkutyp
	clrf	Menue2			; Zeit

	goto	RMainMenue

;********************************************************
; Haupt-Menue "------>  xxxx"
; Mit Rotary-Encoder wird Unterprogramm gewhlt

RMainMenue
	clrf	U0			; Mewertspeicher lschen
	clrf	U1
	clrf	UL0
	clrf	UL1
	clrf	Uref0
	clrf	Uref1
	clrf	UTemp_0
	clrf	UTemp_1
	clrf	E0
	clrf	E1
	clrf	E2
	clrf	Zss4
	clrf	Zmm
	clrf	Zhh
	
	call	RMenue			;Anzeige
RMainRead
	call	Bedienung
	btfss	RotoRechts
	goto	RMainLinks

	; rechts gedreht
	incf	Menue1, f
	movlw	D'11'			; w := Menue1 - 11
	subwf	Menue1, w
	btfsc	STATUS, C
	clrf	Menue1
	goto	RMainMenue

RMainLinks
	btfss	RotoLinks
	goto	RMainDown
	
	; links gedreht
	decf	Menue1, f
	btfss	Menue1, 7
	goto	RMainMenue
	movlw	D'10'
	movwf	Menue1
	goto	RMainMenue
	
RMainDown
	btfss	RotoDown
	goto	RMainRead

; Level1
;	******************
;	*LADER 3 Akkutyp *	0 	Akkutyp
;	*	 Laden   *	1	Beleben/Laden/Toppen
;	*	 Entladen*	2	Entladen
;	*	 Ent/Lade*	3	Entladen/Beleben/Laden/Toppen
;	*	 Spannung*	4	Spannung
;	*	 U-Lupe  *	5	U-Lupe
;	*	 U-ref   *	6	U-ref
;	*	 Kal   1A*	7	Kal   1A
;	*	 Kal 0.1A*	8	Kal.0,1A
;	*	 Temp    *	9	Temperatur
;	*	 Zellen  *	10	Zellenzahl

;	*	 Erhalten	11
;	*	 Beleben	12
;	*	 Toppen		13
;	******************

	incf	MenueLevel,f
	movfw	Menue1
	movwf	temp
	btfsc	STATUS, Z
	goto	RKapazitaet		;0 Akkutyp 
	decf	temp, f
	bz	NurLaden		;1 Beleben/Laden/Toppen
	decf	temp, f
	bz	NurEntladen		;2 Entladen
	decf	temp, f
	bz	EntladenLaden		;3 Entladen/Beleben/Laden/Toppen
	decf	temp, f
	bz	Voltmeter		;4 Spannung
	decf	temp, f
	bz	VoltmeterL		;5 U-Lupe
	decf	temp, f
	bz	VoltmeterRef		;6 U-ref
	decf	temp, f
	bz	Kalib			;7 Kal   1A
	decf	temp, f
	bz	Kalib100mA		;8 Kal.0,1A
	decf	temp, f
	bz	Termometer		;9 KTY81-110
	decf	temp, f
	bz	ZellenMenue		;10 Zellenzahl
	
	goto	RMainRead		;Failsave
	

;********************************************************
; Hauptmenue, einzeiliges Display

RMenue
	movlw	B'10000000'		; 1. Zeile
	call	OutLcdControl
	
	btfss	MenueLevel,0
	goto	RMenue1			; Hauptmenue

	;Level2
	movfw	Menue1
	call	RMenueText1
	call	Write
RMenue0
	clrf	DisplayFlags
	clrf	DisplayFlags2
	movfw	Menue2

RMenueFT
	movwf	Temp
	skpz
	goto	RMenueFU
	bsf	FT
	goto	UhrAnzeige		;0 Zeitanzeige

RMenueFU
	decf	Temp, f
	skpz
	goto	RMenueFE
	bsf	FU
	goto	UAnzeige		;1 Zellenspannung

RMenueFE
	decf	Temp, f
	skpz
	goto	RMenueFI
	bsf	FE
	goto	EnergieAnzeige		;2 Energie

RMenueFI
	decf	Temp, f
	skpz
	goto	RMenueFFir
	bsf	FI
	goto	IAnzeige		;3 Strom/fertig

RMenueFFir
	decf	Temp, f
	skpz
	goto	RMenueFLU
	bsf	FFir
	goto	FirAnzeige		;4 Ladeendeerkennung (Fir1 & Fir0)

RMenueFLU
	decf	Temp, f
	skpz
	goto	RMenueFUref
	bsf	FLU
	goto	ULAnzeige		;5 Lupe

RMenueFUref
	decf	Temp, f
	skpz
	goto	RMenueFFan
	bsf	FUref
	goto	UrefAnzeige		;6 Referenz

RMenueFFan
	decf	Temp, f
	skpz
	goto	RMenueFZellen
	bsf	FTemp
	goto	TempAnzeige		;7 Temperatur

RMenueFZellen
	decf	Temp, f
	skpz
	goto	RMenueFdefekt
	bsf	FZellen
	goto	ZellenAnzeige		;8 Zellenzahl

RMenueFdefekt
	decf	Temp, f
	skpz
	goto	RMenueFtimeout
	movlw	achteStelle
	call	OutLcdControl
	movlw	Txt28			;9 defekt
	call	Write	

RMenueFtimeout
	decf	Temp, f
	skpz
	goto	RMenueFheiss
	movlw	achteStelle
	call	OutLcdControl
	movlw	Txt2A			;10 timeout
	call	Write	

RMenueFheiss
	decf	Temp, f
	skpz
	goto	RMenueFende
	movlw	achteStelle
	call	OutLcdControl
	movlw	Txt2C			;11 heiss
	call	Write	

RMenueFende
	movfw	DisplayFlags
	bnz	RMenueOK
	movfw	DisplayFlags2
	bnz	RMenueOK

	clrf	Menue2			; Failsave	
	goto	RMenue0

RMenueOK
	return


RMenue1
	movlw	Txt00			; Anfang  ----->
	call	Write
	movlw	achteStelle
	call	OutLcdControl
	movfw	Menue1
	call	RMenueText1
	call	Write
	return


;********************************************************
; rotary encoder abfragen

;	PORTB:	0 -	
;		1 > +5V fr rotary enc.	- Vdd Pin6
;		2 -
;		3 -
;		4 -
;		5 < rotary enc. switch	-   Pin3
;		6 < rotary encoder 	- B Pin4  011001
;		7 < rotary encoder 	- A Pin5  001100

; Test des Encoders auf Verdrehung **********************
; setzt die flags RotoRechts, RotoLinks,RotoDown
; Rckkehr mit Z wenn nichts bettigt wurde

read_encoder
        bsf     STATUS, RP0		; make Port B5..7 input
	movlw	B'11100000'
	iorwf   TRISB, f 
        bcf     STATUS, RP0

	bsf	encoder,1		; Power on
	call	wait5ms			; Zeit fr die Lichtschranken

	clrf	RotorFlags
	movfw	encoder			; Port lesen
	movwf	neu			; aktuelle encoder-Stellung nach new
	movlw	B'11000000'		; Schablone fr die beiden Bits
	andwf	neu, f			; nur 2 LSB stehen lassen
	movfw	neu			; wurde der encoder bewegt?
	movwf	temp
	movfw	alt
	xorwf	temp, w			; ist neu = alt?
	bz	ende			; ja: nicht verdreht, also nichts tun
					; nein: encoder verdreht, aber in welche Richtung?
					; drehen wir mal Bit0 des alten werts zum Vergleich 
					;  nach links
	bcf	alt, 7
	clrc				; Carry-Flag lschen
	rlf	alt, f			; alten Encoder-Stand um 1 Stelle nach links drehen
	movfw	neu
	xorwf	alt, f			; falls xorf >1 ergibt, dann war es eine Rechtsdrehung
	bz	links			; links:  decrement counter
	btfss	alt,6
	goto	rechts
	btfss	alt,7
	goto	links
rechts
	bsf	RotoRechts		; rechts:  increment counter
	goto	weiter
links
	bsf	RotoLinks		; links:  decrement counter
weiter
	movfw	neu
	movwf	alt			; neu fr nchsten Vergleich als alt speichern
ende
	; Test des Schalters
	btfsc	encoder,5		; switch abfragen
	goto	ende2			; nicht gedrckt
	bsf	RotoDown
ende1
	btfss	encoder,5
	goto	ende1			; warten auf's loslassen
	bcf	encoder,1		; Power off
ende2
        bsf     STATUS, RP0		; make Port B5..7 output
	movlw	B'00011111'
	andwf   TRISB, f    
        bcf     STATUS, RP0
	movfw	RotorFlags		; Z wenn nichts bedient wurde
	return


;********************************************************
Bedienung
	; Abfrage des Rotaryencoders/Tastatur
	; Rotation: Anzeigewechsel: Zeit-Spannung-Energie-Strom
	; Druck:    Modewechsel
	call	read_encoder
	skpnz
	return
	btfss	RotoRechts
	goto	BedLinks
	incf	Menue2, f
	movlw	B'00000011'
	andwf	Menue2, f		; 3+1=0
	call	RMenue

BedLinks
	btfss	RotoLinks
	goto	BedDown
	decf	Menue2, f
	movlw	B'00000011'		; 0-1=3
	movlw	B'00000111'		; 0-1=7  DEBUG 
	andwf	Menue2, f
	call	RMenue
BedDown
	btfss	RotoDown
	return
	bcf	CHG1			; laden stopp
	bcf	DCHG1			; entladen stopp
	incf	MenueLevel,f
	btfsc	MenueLevel,0
	return				; Level 2
					; Level 1
	goto	RMainMenue

;********************************************************
BedienungDown
	; Abfrage der Rotaryencoders/Tastatur
	; rotieren ignorieren
	; bei Druck: Modewechsel
	call	read_encoder
	btfss	RotoDown
	return
	bcf	CHG1			; laden stopp
	bcf	DCHG1			; entladen stopp
	incf	MenueLevel,f
	btfsc	MenueLevel,0
	return				; Level 2
					; Level 1
	goto	RMainMenue


;********************************************************
;nderung der Zellenzahl 1 ... 7

ZellenMenue		; DEBUG
	bsf	MenueLevel,0
	movlw	D'10'			; Zellen
	movwf	Menue1
	movlw	8			; Zellenanzahl
	movwf	Menue2
	call	RMenue
	call	ZellenAnzeige		; Zellen anzeigen
Zellen1
	call	BedienungDown
	btfsc	RotoRechts
	call	ZellenPlus		; erhhen
	btfsc	RotoLinks
	call	ZellenMinus		; verringern
	goto	Zellen1

ZellenPlus				; Vergrerung zur nchstgreren Zellenzahl
	movlw	D'7'
	xorwf	Zellen, w
	bz	Zellen1			; mehr als 7 geht nicht
	incf	Zellen, f
	goto	OpvGainAndShow

ZellenMinus				; Verringerung zur nchstkleineren Aku-Gre
	movlw	1			; minimal 1
	xorwf	Zellen, w
	bz	Zellen1			; weniger als 1 geht nicht
	decf	Zellen, f

OpvGainAndShow
	movfw	Zellen
	call	OpvGain

	movfw	Zellen		; Zellenzahl
	movwf	f0
	clrf	f1	
	movlw	achteStelle	; 1. Zeile 9. Stelle
	call	OutLcdControl
	movlw	' '
	call	OutLcdDaten
	call	OutDez16	; f0, f1 ausgeben 
	movlw	TxtZ		; "Zellen"
	call	Write	
	return


ZellenAnzeige
	btfss	FZellen		; nur anzeigen, wenn FZellen aktiv
	return

	movfw	Zellen		; Zellenzahl
	movwf	f0
	clrf	f1	
	movlw	achteStelle	; 1. Zeile 9. Stelle
	call	OutLcdControl
	movlw	' '
	call	OutLcdDaten
	call	OutDez16	; f0, f1 ausgeben 
	movlw	TxtZ		; "Zellen"
	call	Write	
	return	


;********************************************************
;nderung der Akkukapazitt 150 - 7000 mAh
;  150 ...  800 mAh in  50-mAh-Schritten
;  800 ... 1600 mAh in 100-mAh-Schritten
; 1600 ... 7000 mAh in 200-mAh-Schritten

RKapazitaet
	bsf	MenueLevel,0
	movlw	0			; Akkutyp
	movwf	Menue1
	movlw	7			; Kapazitt
	movwf	Menue2
	call	RMenue
	call	PWM			; Kapazitt anzeigen
Kapazitaet1
	call	BedienungDown
	btfsc	RotoRechts
	call	KapazitaetPlus		; erhhen
	btfsc	RotoLinks
	call	KapazitaetMinus		; verringern
	goto	Kapazitaet1

KapazitaetPlus				; Vergrerung zur nchstgreren Aku-Gre
	movlw	D'120'
	xorwf	Kapazitaet, w
	bz	Kapazitaet1		; mehr als 6000 mAh geht nicht
	movlw	B'11110000'	
	andwf	Kapazitaet,w
	bz	inc1			;<16  <800mAh
	movlw	B'11100000'	
	andwf	Kapazitaet,w
	bz	inc2			;<32  <1600mAh
inc4
	incf	Kapazitaet, f
	incf	Kapazitaet, f
inc2
	incf	Kapazitaet, f
inc1
	incf	Kapazitaet, f
	goto	PWM

KapazitaetMinus				; Verringerung zur nchstkleineren Aku-Gre
	movlw	3			; minimal 150 mAh
	xorwf	Kapazitaet, w
	bz	Kapazitaet1		; weniger als 150 mAh geht nicht
	decf	Kapazitaet, f

	movlw	B'11110000'		
	andwf	Kapazitaet,w
	bz	PWM			;<16  <800 mAh
	movlw	B'11100000'		
	andwf	Kapazitaet,w
	bz	CapGerade		;<32  <1600mAh	
	movlw	B'11111100'
	andwf	Kapazitaet, f		; auf volle 4 = 200 mAh abrunden
	goto	PWM
CapGerade
	movlw	B'11111110'
	andwf	Kapazitaet, f		; auf volle 2 = 100 mAh abrunden
PWM
	movfw	Kapazitaet
	movwf	CCPR1L
	call	Mal50

	movlw	achteStelle		; 1. Zeile, 8.Stelle
	call	OutLcdControl
	call	OutDez16		; f0, f1 ausgeben als Kapazitt

	movlw	TxtmAh			; 'mAh'
	call	Write
	call	Kap2dE			; dE := Kapazitaet x 8
	return


;********************************************************
IAnzeige
	btfss	FI
	return

	movlw	achteStelle		; 1. Zeile, 8.Stelle
	call	OutLcdControl

	; wenn 	Akku1Leer dann 'fertig'
	btfss	Akku1Leer
	goto	IAnzeige1

	movlw	Txt29			; 'fertig'
	call	Write
	return

IAnzeige1
	; ansonsten Strom in mA
	movfw	Kapazitaet
	call	Mal50			; Entladestrom

	; falls Menue1=1 (Laden) dann Ladestrom
	decf	Menue1, w
	skpnz
	call	Ladestrom		; Ladestrom

	movlw	' '			; 1. Zeile, 9.Stelle
	call	OutLcdDaten
	call	OutDez16		; f0, f1 ausgeben als Kapazitt

	movlw	TxtmA			; 'mA'
	call	Write
	return



;********************************************************
;Eintrag der richtigen dE-Werte in Abhngigkeit von Kapazitaet
;
;Kapazitaet enthlt mAh/50-Werte  
;   3 =  150 mAh
; 120 = 6000 mAh
;
; dE enthlt Energie pro Takt in 1/256 mAh
;	dE ist 16 Bit-Wert dE1,dE0
;
;Einstellen der TaktEnergie fr Kapazitaet = 15
;	750 mAh * 2,25 s = 0,46875 mAh =  120 /256 mAh = 0078h
;	dE := Kapazitaet x 50 x 2,25 / 3600 x 256
;	dE := Kapazitaet x 8

Kap2dE
	clrf	dE1
	movfw	Kapazitaet
	movwf	dE0			; dE := Kapazitaet
	clrc
	rlf	dE0, f
	rlf	dE1, f			; dE := Kapazitaet x 2
	rlf	dE0, f
	rlf	dE1, f			; dE := Kapazitaet x 4
	rlf	dE0, f
	rlf	dE1, f			; dE := Kapazitaet x 8
	return


;********************************************************
;Akkuprogramme
EntladenLaden
	call	SaveKap
	call	Entladen1
NurLaden
	call	SaveKap
	goto	Beleben1		; Beleben1 / Laden1 / Topping1 / Erhalten1

NurEntladen
	call	SaveKap
	call	Entladen1	

	movlw	3
	movwf	Menue2
	call	RMenue			; fertig
tot
	call	Bedienung
	goto	tot			; stop


;********************************************************
;Energiezhler erhhen und anzeigen E2-E1-E0 := E2-E1-E0 + dE1-dE0
EnergieUp
	clrf	f3			; f := E
	movfw	E2
	movwf	f2
	movfw	E1
	movwf	f1
	movfw	E0
	movwf	f0
	clrf	xw3			; xw : =dE
	clrf	xw2
	movfw	dE1
	movwf	xw1
	movfw	dE0
	movwf	xw0
	call	Add32			; 32-bit add: f = f + xw
	movfw	f0			; E := f
	movwf	E0
	movfw	f1
	movwf	E1

	movfw	f2
	movwf	E2

EnergieAnzeige
	btfss	FE			; nur Anzeiogen, wenn FE aktiv
	return

	movfw	E1
	movwf	f0			; fr Anzeige
	movfw	E2
	movwf	f1			; fr Anzeige

	movlw	achteStelle		; 1. Zeile, 8.Stelle
	call	OutLcdControl	
	call	OutDez16		; f0, f1 ausgeben als mAh
	movlw	TxtmAh			; ' mAh'
	call	Write
	return

;********************************************************
;Zeit um w erhhen 
; w enthlt increment in 1/4s
; w <16, da sonst 239+17=256=00
; Zeit anzeigen ab 1. Zeile 8. Stelle 'hh:mm:ss'
; falls W=0, dann Uhr auf 00:00:00 setzen
Uhr
	iorlw	0			; W=0?
	bz	UhrNull			; ja

	addwf	Zss4, f			; Zeit um w erhhen
	movlw	D'240'
	subwf	Zss4, w			; w := Zss4 - 240 
	bnc	UhrAnzeige		; kein Minutenbertrag
	movwf	Zss4			; Restsekunden nach Zss4

	incf	Zmm, f			; +1 Minute
	movlw	D'60'
	subwf	Zmm, w			; w := Zmm - 60 
	bnc	UhrAnzeige		; kein Stundenbertrag
	movwf	Zmm			; Restminuten nach Zmm
	
	incf	Zhh, f			; +1 Stunde

UhrAnzeige
	btfss	FT
	return
	movlw	achteStelle		; 1. Zeile, 8.Stelle
	call	OutLcdControl
	movfw	Zhh
	call	OutDezW
	movlw	'h'
	call	OutLcdDaten
	movfw	Zmm
	call	OutDezW
	movlw	'm'
	call	OutLcdDaten
	movfw	Zss4
	movwf	Temp
	clrc
	rrf	Temp, f
	clrc
	rrf	Temp, w
	call	OutDezW
	return

UhrNull
	clrf	Zss4
	clrf	Zmm
	clrf	Zhh
	goto	UhrAnzeige


;********************************************************
;********************************************************
;Entladen************************************************
Entladen1
	bsf	MenueLevel,0
	movlw	2			; Entladen
	movwf	Menue1
	movlw	2			; Energie
	movwf	Menue2
	call	RMenue

	clrf	E0			; entladene Energie =0
	clrf	E1
	clrf	E2
	clrw
	call	Uhr
Entladen1A
	bsf	DCHG1			; Entladepuls start
					; 2,25 s lang
	; 9x 245ms warten und Bedienung
	movlw	9
	movwf	sitandwait
EntladenSaw
	call	wait245ms
	call	Bedienung
	decfsz	sitandwait, f
	goto	EntladenSaw
	
	bcf	DCHG1			; entladepuls stop
	call	EnergieUp		; Energie incrementieren
	movlw	D'9'			; Zeit incrementieren
	call	Uhr			; 2,25 Sekunden increment
	call	Luefter
	call	wait5ms			; erholen
	call	UakkuLeer1		; Akkuspannung messen
	btfss	Akku1Leer
	goto	Entladen1A		; weiter entladen
	return

;********************************************************
;Beleben mit C/10****************************************
; 2h Abschaltung 
; 1C00 = 7168 Sekunden = 1:59:28 h
Beleben1
	bcf	Akku1Leer		; 'fertig' bei IAnzeige ausschalten
	call	Uakku400mV		; Akkuspannung messen
	btfss	Akku1Tot
	goto	Laden1			; beleben nicht ntig
	bsf	MenueLevel,0
	movlw	D'12'			; Beleben
	movwf	Menue1
	movlw	1			; Spannung
	movwf	Menue2
	call	RMenue

	clrf	LZ0			; Zyklenzhler
	clrf	LZ1
	clrw
	call	Uhr	
Beleben1A
	incf	LZ0,f			; Zyklenzhler erhhen
	btfsc	STATUS,Z
	incf	LZ1,f

	movlw	0x1C			; schon 1C00 Zyklen vorbei ?		
	subwf	LZ1,w
	btfsc	STATUS,Z
	goto	Beleben1B		; 2 Stunden vorbei

	bsf	CHG1			; Laden ein
	call	wait245ms		; fr 250 ms
	call	Bedienung
	bcf	CHG1
	call	wait245ms		; 750 ms erholen
	call	Bedienung
	call	wait245ms	
	call	Bedienung
	call	wait245ms
	call	Bedienung
	movlw	D'4'
	call	Uhr			; 1 Sekunde increment
	call	Luefter
	call	Uakku400mV		; Akkuspannung messen
	btfsc	Akku1Tot
	goto	Beleben1A
	goto	Laden1			; Akku erfolgreich belebt

Beleben1B
	movlw	D'9'
	movwf	Menue2
	call	RMenue			; akku defekt
Beleben1loop
	call	Bedienung
	goto	Beleben1loop		; Ende mit Endlosschleife nach defekt


;********************************************************
;Ladezyklus mit c/3**************************************
; 4h Abschaltung 
; 2133 Zyklen a 6,75 s = 14400 Sekunden = 4:00:00 h
;2133 = 0855h

; Abbruch nach 4 Stunden: Test auf Zhh=4

Laden1
	bcf	Akku1Leer		;'fertig' bei IAnzeige ausschalten
	bsf	MenueLevel,0
	movlw	1			; Laden
	movwf	Menue1
	movlw	2			; Energie
	movwf	Menue2
	call	RMenue

	movlw	0x55+1
	movwf	LZ0	
	movlw	0x08+1			; Ladezyklenzhler =0855h
	movwf	LZ1
	clrf	E0			; geladene Energie =0
	clrf	E1
	clrf	E2
	clrw
	call	Uhr
	clrf	AkkuAltL
	clrf	AkkuAltH
	clrf	AkkuNeuL
	clrf	AkkuNeuH
	clrf	DeltaPeak
	call	InitFir			; FIR-Filter initialisieren
Laden1A
	; Zyklenzhler LZ0 wird fr das 8-stufige FIR mit verwendet
	decf	LZ0,f			; Zyklenzhler vermindern
	btfsc	STATUS,Z
	decf	LZ1,f
	nop

	btfss	Zhh,2			; Stundenzhler =4?
	goto	Laden1B			; nchter Zyklus
					; Timeout
	movlw	D'10'
	movwf	Menue2
	call	RMenue			;timeout
Laden1E
	call	Bedienung
	goto	Laden1E			; Ende mit Endlosschleife nach Timeout

Laden1B
	bsf	CHG1			; Laden ein
					; fr 6,75 sekunden
	; 27x 245ms warten und Bedienung
	movlw	D'27'
	movwf	sitandwait
LadenSaw
	call	wait245ms
	call	Bedienung
	decfsz	sitandwait, f
	goto	LadenSaw

	bcf	CHG1
	call	EnergieUp
	movlw	D'14'
	call	Uhr			; 3,5 Sekunden increment
	movlw	D'13'
	call	Uhr			; 3,25 Sekunden increment
	call	Luefter
	call	wait5ms			; erholen
	bsf	DCHG1			; Enladen
	call	wait5ms			; fr 5 ms
	bcf	DCHG1
	call	wait5ms			; erholen
	call	UakkuVoll1		; Akkuspannung messen
	btfss	Akku1Voll
	goto	Laden1A			; weiter
	goto	Topping1

;********************************************************
;Topping mit C/10****************************************
; 2h Abschaltung 
; 1C00 Zyklen a 1s = 7168 Sekunden = 1:59:28 h
Topping1
	bsf	MenueLevel,0
	movlw	D'13'			; Topping
	movwf	Menue1
	movlw	2			; Energie
	movwf	Menue2
	call	RMenue

	clrf	LZ0			; Toppingzyklenzhler
	clrf	LZ1
	clrw
	call	Uhr	
Topping1A
	incf	LZ0,f			; Zyklenzhler erhhen
	btfsc	STATUS,Z
	incf	LZ1,f

	movlw	0x1C			; schon 1C00 Zyklen vorbei ?		
	subwf	LZ1,w
	btfsc	STATUS,Z
	goto	Erhalten1		; 2 Stunden vorbei

	bsf	CHG1			; Laden ein
	call	wait245ms		; fr 250 ms
	call	Bedienung
	bcf	CHG1
	call	wait245ms		; 750 ms erholen
	call	Bedienung
	call	wait245ms	
	call	Bedienung
	call	wait245ms
	call	Bedienung
	movlw	D'4'
	call	Uhr			; 1 Sekunde increment
	call	Luefter
	goto	Topping1A


;********************************************************
;Erhalten mit C/40***************************************
; Endlosschleife
Erhalten1
	bsf	MenueLevel,0
	movlw	D'11'			; Erhalten
	movwf	Menue1
	movlw	0			; Zeit
	movwf	Menue2
	call	RMenue

	clrw
	call	Uhr	
Erhalten1A
	bsf	CHG1			; Laden ein
	call	wait75ms		; fr 75 ms
	bcf	CHG1
	call	wait245ms		; 1 s erholen
	call	Bedienung
	call	wait245ms	
	call	Bedienung
	call	wait245ms
	call	Bedienung
	call	wait245ms
	call	Bedienung
	movlw	D'4'
	call	Uhr			; 1 Sekunde increment
	call	Luefter
	goto	Erhalten1A


;********************************************************
;Kalibrieren      ***************************************


; Kalibrierung 1,0A:
;	kurzschlieen der Akkuanschlsse
;	Ladestrom von 1,0 A einstellen (3000 mAh)
;		Kapazitaet = 60; I=1,0 A; U = 470 mV
;	Spannung kontinuierlich messen und anzeigen
;	Sollanzeige: 470 mV

Kalib
	bsf	MenueLevel,0
	movlw	7			; Kal 1A
	movwf	Menue1
	movlw	1			; Spannung
	movwf	Menue2
	call	RMenue

	movlw	D'60'
	movwf	CCPR1L			; PWM auf 3000 mAh
	call	wait245ms		; PWM-Siebkondensator 
	bsf	CHG1			; Laden ein
Kalib1
	call	BedienungDown

	call	U1Messen
	call	wait75ms
	goto	Kalib1			; Endlosschleife

; Kalibrierung 100 mA:
;	berbrcken der Akkuanschlsse mit 10 Ohm
;	Ladestrom von 100 mA einstellen (300 mAh)
;		Kapazitaet = 6; I=0,1 A; U = 1,05 V
;	Spannung kontinuierlich messen und anzeigen
;	Sollanzeige: 1050 mV

Kalib100mA
	bsf	MenueLevel,0
	movlw	8			; Kal 0,1A
	movwf	Menue1
	movlw	1			; Spannung
	movwf	Menue2
	call	RMenue

	movlw	D'6'
	movwf	CCPR1L			; PWM auf 300 mAh
	call	wait245ms		; PWM-Siebkondensator 
	bsf	CHG1			; Laden ein
	goto	Kalib1

;********************************************************
;Voltmeter        ***************************************

Voltmeter
	bsf	MenueLevel,0
	movlw	4			; Spannung
	movwf	Menue1
	movlw	1			; Spannung
	movwf	Menue2
	call	RMenue
Volt1
	call	U1Messen		; Spannung messen und anzeigen

	call	BedienungDown
	call	wait75ms
	goto	Volt1			; Endlosschleife

;********************************************************
;Voltmeter   Lupe ***************************************

VoltmeterL
	bsf	MenueLevel,0
	movlw	5			; Lupe
	movwf	Menue1
	movlw	5			; Spannung
	movwf	Menue2
	call	RMenue
VoltL1
	call	U1Lupe			; Lupenspannung nach f1f0

	call	BedienungDown
	call	wait75ms
	goto	VoltL1			; Endlosschleife

;********************************************************
;Voltmeter  Referenz*************************************

VoltmeterRef
	bsf	MenueLevel,0
	movlw	6			; Referenz
	movwf	Menue1
	movlw	6			; Spannung
	movwf	Menue2
	call	RMenue
VoltRef1
	call	URef			; Referenzspannung messen und anzeigen 

	call	BedienungDown
	call	wait75ms
	goto	VoltRef1		; Endlosschleife


;********************************************************
;Termometer      ****************************************

Termometer
	bsf	MenueLevel,0
	movlw	9			; Referenz
	movwf	Menue1
	movlw	7			; 
	movwf	Menue2
	call	RMenue
Termometer_1
	call	Luefter			; Referenzspannung messen und anzeigen 

	call	BedienungDown
	call	wait75ms
	goto	Termometer_1		; Endlosschleife


;*********************************************************************
;* Write
;* Ausgabe eines Strings der ab W im Speicher steht
;* Note: Endekennzeichen ist Zeichen mit Bit 7 = 1
;*
;* Input : W zeigt auf String	 (RETLWs)
;*********************************************************************
Write 
	movwf	Temp			; Temp = Pointer
	decf	Temp,f
GoWrite	
	call	PclSub2			; Pointer erhhen und nchstes Zeichen lesen
	addlw	80h			; ist Bit 7 gesetzt? EOT
	btfsc	STATUS,C
	goto	OutLcdDaten		; letztes Zeichen
	andlw	7fh			; zeichen wieder herstellen
	call	OutLcdDaten		; Ausgabe
	goto	GoWrite	

PclSub2
	incf	Temp, F			; Pointer auf nchstes Zeichen
	movf	Temp, W			; Pointer nach W
	movwf	PCL			; Sprung zur Addresse auf die PCLATH,W zeigt


;********************************************************
;********************************************************
;Warteroutinen verschiedener Lnge***********************
;********************************************************

; 5 ms warten
wait5ms
	movlw	D'5'			; 5ms
	movwf	loops	
	goto	WAIT

; 75 ms warten
wait75ms
	movlw	D'75'			; 75ms
	movwf	loops	
	goto	WAIT

;245 ms warten
wait245ms
	movlw	D'245'			; 245ms
	movwf	loops	
	goto	WAIT	

;*****************************************************
;Zeitverzgerung um loops * 1 ms
; 10 MHz externer Takt bedeutet 2,5 MHz interner Takt
; also dauert 1 ms genau 2500 Befehle
; 250 Schleifen a 10 Befehle sind 2500 Befehle = 1 ms

WAIT
top     movlw   .250			; timing adjustment variable (1ms)
        movwf   loops2
top2    nop 				; sit and wait
        nop
        nop
        nop
	nop
        nop
        nop
        decfsz  loops2, f		; innere Schleife beendet?
        goto    top2 			; nein, noch mal rum

        decfsz  loops, f		; uere Schleife beendet?
        goto    top 			; nein, noch mal rum
        retlw   0 			; ja, return von WAIT


;*****************************************************
;*** RS232 *******************************************
;*****************************************************

; Ausgabe von
;	- Zeit
;	- Spannung
; ca 10 ms

RS232
	movlw	Zhh
	call	RS232out		;Stunden
	movlw	Zmm
	call	RS232out		;Minuten
	movlw	Zss4
	call	RS232out		;Sekunden x 4
	movlw	' '
	call	RS232out		;Trennzeichen

	movlw	U1L
	call	RS232out		;Spannung low-Teil
	movlw	U1H
	call	RS232out		;Spannung High-Teil
	movlw	' '
	call	RS232out		;Trennzeichen

	movlw	0x0A
	call	RS232out
	movlw	0x0D
	call	RS232out		;Zeilenende

	return

;*****************************************************
;Ausgabe von w an RS232
; max. 1 ms bei 9600 Baud
RS232out
	btfss	PIR1,TXIF		; ist Sender leer ? 
	goto	RS232out		; nein, noch nicht leer
	movwf	TXREG			; und in den RS232-Sender schreiben 
	return

;*****************************************************
;Tabulator zum RS232
RsTab
	movlw	9
	goto	RS232out

;*****************************************************
;Zeilenwechsel
RsEnter
	movlw	0x0A
	call	RS232out
	movlw	0x0D
	goto	RS232out



;*****************************************************
;*** INCLUDE *****************************************
;*****************************************************


#include	lcd.asm
#include	mathe.asm
#include	adcakku.asm
#include	fir.asm
#include	EEPROM.asm
#include	luefter.asm

	end		
