;********************************************************

; ADC initialisieren
InitADC
	; ADC einschalten
	BSF	ADCON0, 0	; ADON=1
	; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, 5	; ADCHS2=0
	BCF	ADCON0, 4	; ADCHS1=0
	BCF	ADCON0, 3	; ADCHS0=0
	; ADC speed fr 5 ... 20 MHz einstellen
	BSF	ADCON0, 7	; ADCS1=1
	BCF	ADCON0, 6	; ADCS0=0
	; Daten rechtsbndig
	BSF	STATUS,RP0	; Bank1
	clrf	ADCON1
	BSF	ADCON1, 7	; ADFM=1
	BCF	STATUS,RP0	; Bank0
	return


;********************************************************
;OPV entsprechen der Zellenzahl einstellen

OpvGain			; DEBUG
	; poti auf Anschlag drehen

	MOVLW	D'100' 
	MOVWF	f0
	BCF	PotDir		; PORTB/TRISB 
	nop
OpvGain1
	BCF	PotClk		; PORTB/TRISB 
	nop
	BSF	PotClk		; PORTB/TRISB 
	DECFSZ	f0,f
	GOTO	OpvGain1

	; und nun einstellen
	movfw	Zellen
	call	GainR2
	MOVWF	f0
	BSF	PotDir		; PORTB/TRISB 
	nop
OpvGain2
	BCF	PotClk		; PORTB/TRISB 
	nop
	BSF	PotClk		; PORTB/TRISB 
	DECFSZ	f0,f
	GOTO	OpvGain2
	return




;********************************************************
;Anzahl der Zellen feststellen
;  lere Zelle : 1.0 V >0,8 V
; volle Zelle : 1,2 V <1,4 V
;
;       ... 0,5 V	kein Akku
; 0,8 V ... 1,5 V	1 Zelle 	0,80 V - 1,50 V
; 1,5 V ... 2,6 V	2 Zellen	0,75 V - 1,30 V
; 2,6 V ... 3,7 V	3 Zellen	0,87 V - 1,23 V
; 3,7 V ...     	4 Zellen	0,92 V - 


;********************************************************
; Unterroutine zum
; Spannung wandeln nach U1H,U1L
UMessen
	BSF	ADCON0, 2	; ADC starten
loop
	BTFSC	ADCON0, 2	; ist der ADC fertig?
	GOTO	loop		; nein, weiter warten
	movfw	ADRESH		; obere  2 Bit auslesen
	movwf	U1H		; obere  2-Bit nach U1H
	bsf	STATUS,RP0	; Bank1
	movfw	ADRESL		; untere 8 Bit auslesen
	bcf	STATUS,RP0	; Bank0
	movwf	U1L		; untere 8-Bit nach U1L
	return

;********************************************************
; Spannung wandeln nach U1H,U1L 
UMessen1
	clrf	count
aqui				; 0,3 ms  ADC Aqusitionszeit nach Eingangswahl
	DECFSZ	count, f
	goto	aqui
	call	UMessen
	clrf	count		; Warten, damit der ADC sich erholen kann
warten
	DECFSZ	count, f
	goto	warten
	movfw	U1H
	movwf	f1
	movfw	U1L
	movfw	f0
	return

;********************************************************
; Spannung wandeln nach U1H,U1L 4x mit Durchschnittsbildung
UMessen4
	clrf	count
aqui1				; 0,3 ms  ADC Aqusitionszeit nach Eingangswahl
	DECFSZ	count, f
	goto	aqui1

	call	UMessen
	movfw	U1L
	movwf	f0
	movfw	U1H
	movwf	f1		; f := U
	clrf	count		; Warten, damit der ADC sich erholen kann
warten1
	DECFSZ	count, f
	goto	warten1

	call	UMessen
	movfw	U1L
	movwf	xw0
	movfw	U1H
	movwf	xw1
	call	Add16		; f:=f+xw = 2U
	clrf	count		; Warten, damit der ADC sich erholen kann
warten2
	DECFSZ	count, f
	goto	warten2

	call	UMessen
	movfw	U1L
	movwf	xw0
	movfw	U1H
	movwf	xw1
	call	Add16		; f:=f+xw = 3U
	clrf	count		; Warten, damit der ADC sich erholen kann
warten3
	DECFSZ	count, f
	goto	warten3

	call	UMessen
	movfw	U1L
	movwf	xw0
	movfw	U1H
	movwf	xw1
	call	Add16		; f:=f+xw = 4U
	clrf	count		; Warten, damit der ADC sich erholen kann
warten4
	DECFSZ	count, f
	goto	warten4
	; berechnung des Durchschnittswertes
	movlw	D'2'		; w=2
	movwf	xw0
	clrf	xw1
	call	Add16		; f=4U+2
	clrc
	rrf	f1, f
	rrf	f0, f		; f=abs(2U+1)
	clrc
	rrf	f1, f
	rrf	f0, f		; f=abs(U+0,5)

	movfw	f0
	movwf	U1L
	movfw	f1
	movwf	U1H
	return	


;********************************************************
; Verstrkte Eingangsspannung wandeln

U1Lupe
	; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, 5	; ADCHS2=0
	BCF	ADCON0, 4	; ADCHS1=0
	BCF	ADCON0, 3	; ADCHS0=0
	; Uref=RA3
	bsf	STATUS,RP0	; Bank1
	bsf	ADCON1,PCFG0	; PCFG0=1
	bcf	STATUS,RP0	; Bank0
	call	UMessen4

	movfw	f0		; UL speichern
	movwf	UL0
	movfw	f1
	movwf	UL1

ULAnzeige

	btfss	FLU		; nur Anzeigen wenn FLU aktiv
	return

	movfw	UL0		; UL laden
	movwf	f0
	movfw	UL1
	movwf	f1

	movlw	achteStelle	; 1. Zeile 9. Stelle
	call	OutLcdControl
	movlw	' '
	call	OutLcdDaten
	call	OutDez16	; f0, f1 ausgeben als mAh
	movlw	TxtUL		; Name
	call	Write	
	return

;********************************************************
;Eingangsspannung wandeln und anzeigen
; ADC-Messwert -> U1H, U1L
; Spannung (mV) -> U0, U1
U1Messen
	; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, 5	; ADCHS2=0
	BCF	ADCON0, 4	; ADCHS1=0
	BCF	ADCON0, 3	; ADCHS0=0
	; Uref=RA3
	bsf	STATUS,RP0	; Bank1
	bsf	ADCON1,PCFG0	; PCFG0=1
	bcf	STATUS,RP0	; Bank0
	call	UMessen4	; gemittelter ADC-Messwert -> U1H&U1L / f0&f1

;Umrechnung in mV    U:=U x 2
	call	Mal2		; f1,f0 := 2 x f1,f0
	movfw	f0		; U speichern
	movwf	U0
	movfw	f1
	movwf	U1	

UAnzeige
	btfss	FU		; nur anzeigen, wenn FU aktiv
	return

	movfw	U0		; U laden
	movwf	f0
	movfw	U1
	movwf	f1	

	movlw	achteStelle	; 2. Zeile 9. Stelle
	call	OutLcdControl
	movlw	' '
	call	OutLcdDaten
	call	OutDez16	; f0, f1 ausgeben als Spannung
	movlw	TxtmV		; Name
	call	Write	
	return

;********************************************************
;Referenzspannung wandeln und anzeigen
URef
	; ADC-Eingang AN3 auswhlen
	BCF	ADCON0, 5	; ADCHS2=0
	BSF	ADCON0, 4	; ADCHS1=1
	BSF	ADCON0, 3	; ADCHS0=1
	; Uref=Vdd
	bsf	STATUS,RP0	; Bank1
	bcf	ADCON1,PCFG0	; PCFG0=0
	bcf	STATUS,RP0	; Bank0
	call	UMessen4

	;Umrechnung    U[mV] = 5Uadc - 5Uadc/64 - 5Uadc/128
	call	mV		; Wandlung in Millivolt nach f1,f0

	movfw	f0		; Uref speichern
	movwf	Uref0
	movfw	f1
	movwf	Uref1	


UrefAnzeige
	btfss	FUref		; nur anzeigen, wenn FUref aktiv
	return

	movfw	Uref0		; Uref laden
	movwf	f0
	movfw	Uref1
	movwf	f1	

	movlw	achteStelle	; 1. Zeile 9. Stelle
	call	OutLcdControl
	movlw	' '
	call	OutLcdDaten
	call	OutDez16	; f0, f1 ausgeben 
	movlw	TxtmV		; Name
	call	Write	
	return


;*****************************************************
; Wandlung des ADC-Wert in Millivolt (binr) fuer Uref
; Der ADC-Wert steht in f1,f0
; Ergebnis steht in f1,f0
mV
	; zunchst die Multiplikation mal 5
	movfw	f0
	movwf	xw0
	movfw	f1
	movwf	xw1
	call	Add16		; f := 2xADC
	call	Add16		; f := 3xADC
	call	Add16		; f := 4xADC
	call	Add16		; f := 5xADC

	; ADC * 5 nach xw kopieren
	movfw	f0
	movwf	xw0
	movfw	f1
	movwf	xw1		; xw := 5xADC

	; xw durch 64 dividieren (6 mal durch 2)
	; dann ist xw = 5xADC/64
	movlw	6
	call	Div2
	call	Sub16		; f := 5xADC - 5xADC/64

	; xw auf 5xADC/128 verringern
	movlw	1
	call	Div2
	call	Sub16		; f := 5xADC - 5xADC/64 - 5xADC/128 
	return			; fertig



;********************************************************
; Akkuspannung 1 messen**********************************
;
; immer 8 Messungen addieren um Rauschen zu eleminieren (54 s)
; mit AkkuAlt vergleichen, wenn kleiner dann Akkuvoll
; Summe als als AkkuAlt speichern
;
; bei Bedarf abbrechen durch setzen 'Akku1Voll' : fehlt
; Abbruch nach 8 x 0 oder 4 x negativ
; positiv: DeltaPeak:=0
; 0      : DeltaPeak:=+1
; negativ: DeltaPeak:=+2
; bei DeltaPeak>=8 erfolgt Abbruch

UakkuVoll1
	bcf	Akku1Voll	; angenommen er ist nicht voll

	call	U1Lupe		; fr Delta Peak Ul in U1H,U1L und f1,f0
	call	FIR		; neu-alt in f1,f0

	movfw	U1L		; AkkuNeu:=AkkuNeu+U1
	addwf	AkkuNeuL, f
	movfw	U1H
	btfsc	STATUS, C	; kein berlauf
	incf	U1H, w		; berlauf
	addwf	AkkuNeuH, f

	movlw	B'00000111'
	andwf	LZ0, w
	bz	UAVvergleich	; 8 Messungen vorbei
	goto	UAVzuhoch	; noch keine 8 Messungen, prfen auf 1,7V und return

UAVvergleich			; Alt und Neu vergleichen nach 8 Messungen
	movfw	AkkuAltL
	movwf	xw0
	movfw	AkkuAltH
	movwf	xw1
	movfw	AkkuNeuL
	movwf	f0
	movfw	AkkuNeuH
	movwf	f1
	call	Sub16		; f=f-xw    f=Neu-Alt
				; positiv -> weitermachen
				; negativ -> abbrechen
	bc	UAnegativ	; Neu < Alt fallend 
	movfw	f1
	bnz	UApositiv	; Neu > Alt steigend
	movfw	f0
	bnz	UApositiv	; Neu > Alt steigend
	goto	UAnull		; Neu = Alt  stagnierend
	
UApositiv			; DeltaPeak =0
	clrf	DeltaPeak
	goto	UAVneuzualt

UAnegativ			; DeltaPeak +2
	incf	DeltaPeak, f
UAnull				; DeltaPeak +1
	incf	DeltaPeak, f
	btfsc	DeltaPeak, 3	; =8?
	call	UAVvoll		; Akku1Voll setzen	
UAVneuzualt
	movfw	AkkuNeuH
	movwf	AkkuAltH
	movfw	AkkuNeuL
	movwf	AkkuAltL
	clrf	AkkuNeuL
	clrf	AkkuNeuH
	
	btfss	FdU
	goto	UAVzuhoch
;DEBUG
	btfss	FdU
	goto	UAweiter

	movlw	achteStelle+2	; 1. Zeile 10.Stelle
	call	OutLcdControl
	call	OutDez16	; f0, f1 ausgeben als Spannung DeltaPeak 5stellig
	movlw	achteStelle	; 1. Zeile  8.Stelle
	call	OutLcdControl
	movfw	DeltaPeak
	call	OutDezW		; DeltaPeak-Abbruchzhler 2stellig
	movlw	':'
	call	OutLcdDaten
UAweiter

;Abbruch bei 1,7V = 348 d = 015C h (Uref=5V)
;Abbruch bei 1,7V = 680 d = 02A8 h (Uref=2,56)
;Abbruch bei 1,7V = 850 d = 0352 h (Akkupack)
UAVzuhoch
	call	U1Messen
	movfw	U1H
	movwf	f1
	movfw	U1L
	movwf	f0
	movlw	0x03
	movwf	xw1
	movlw	0x52
	movwf	xw0
	call	Sub16		; U - 0x0352 , C bei neg. Ergebnis, C bei U<1,7V
	btfss	STATUS,C	; U<1,7V
UAVvoll
	bsf	Akku1Voll	; U>1,7V oder DeltaPeak erkannt	
	return


;********************************************************
; Akkuspannung 1 messen**********************************
; Abbruch bei U<1V durch setzen 'Akku1Leer'
; bei Uref=Vdd=5V gilt 1V = D'205' = 0x00CD
; bei Uref=2,56V  gilt 1V = D'400' = 0x0190
; bei Akkupack    gilt 1V = D'500' = 0x01F4
UakkuLeer1
	bcf	Akku1Leer	; angenommen er ist nicht leer
	call	U1Messen	; messen AN0 (Ref=RA3) ADC-Wert nach U1H U1L
	movfw	U1H
	movwf	f1
	movfw	U1L
	movwf	f0
	movlw	0x01
	movwf	xw1
	movlw	0xF4
	movwf	xw0
	call	Sub16		; U - 0x01F4 , C: U<1V
	btfsc	STATUS,C
	bsf	Akku1Leer	; U<1V
	return

;********************************************************
; Akkuspannung 1 messen**********************************
; AkkuTot bei U<0,4V durch setzen 'Akku1Tot'
; bei Uref=Vdd=5V gilt 0,4V = D'82'  = 0x0052
; bei Uref=2,56V  gilt 0,4V = D'160' = 0x00A0
; bei Akkupack    gilt 0,4V = D'200' = 0x00C8
Uakku400mV
	bcf	Akku1Tot	; hoffe er ist o.k.
	call	U1Messen
	movfw	U1H
	btfss	STATUS,Z
	return			; falls U1H>0 dann zurck, o.k. (>512mV)
	movlw	D'200'		; 0,4V
	subwf	U1L, w		; w:=U1L - 200 , C falls U1L > 200
	btfss	STATUS,C
	bsf	Akku1Tot	; U<0,4V
	return
