;*****************************************************
;+++Mathematik-Routinen fr Akkulader*****************
;*****************************************************
;*****************************************************

;*****************************************************
; Division durch 2 wird w-mal ausgefhrt
; die zu dividierende Zahl steht in xw
Div2 
	movwf   counter	; Anzahl der Divisionen speichern
Div2a				; 16 bit xw:=xw/2
	bcf     STATUS, C	; carry lschen
	rrf     xw1, f
	rrf     xw0, f
	decfsz  counter, f	; fertig?
	goto    Div2a		; nein: noch mal
	return

;*****************************************************
; Multiplikation der Kapazitaet mit 16,667 (50/3)
; zur Ermittlung des Ladestroms
; Ergebnis steht in f1,f0

Ladestrom
	movfw	Kapazitaet
	movwf	f0
	clrf	f1		; f = C
	clrc
	rlf	f0, f
	rlf	f1, f
	rlf	f0, f
	rlf	f1, f
	rlf	f0, f
	rlf	f1, f
	rlf	f0, f
	rlf	f1, f		; f = C x 16

	movfw	Kapazitaet
	movwf	xw0
	incf	xw0, f
	clrc
	rrf	xw0, f
	clrf	xw1
	call	Add16		; f = 16C + C/2

	movlw	4
	addwf	Kapazitaet, w
	movwf	xw0
	clrc
	rrf	xw0, f
	clrc
	rrf	xw0, f
	clrc
	rrf	xw0, f
	clrf	xw1
	call	Add16		; f = 16C + C/2 + C/8

	movlw	16
	addwf	Kapazitaet, w
	movwf	xw0
	clrc
	rrf	xw0, f
	clrc
	rrf	xw0, f
	clrc
	rrf	xw0, f
	clrc
	rrf	xw0, f
	clrc
	rrf	xw0, f
	clrf	xw1
	call	Add16		; f = 16C + C/2 + C/8 + C/32
	return


;*****************************************************
; x 50     f1,f0 := w x 50
; 50 = 2x5x5
; 5y  = 4y +1y

Mal50
	movwf	f0
	clrf	f1
	call	Mal5	; f10 :=  5w
	call	Mal5	; f10 := 25w
	clrc
	rlf	f0, f
	rlf	f1, f	; f10 := 50w
	return

; f10 := 5 x f10
Mal5
	movfw	f0
	movwf	xw0
	movfw	f1
	movwf	xw1	; xw10 := f10
	clrc
	rlf	f0, f
	rlf	f1, f	; f10 := 2x f10
	clrc
	rlf	f0, f
	rlf	f1, f	; f10 := 4x f10
	call	Add16	; f10 := 4xf10 +f10
	return

; f10 := 2,5 x f10
Mal2_5
	call	Mal5	; f10 := 5 x f10
	clrc
	rrf	f1, f
	rrf	f0, f	; f10 := 5 x f10 / 2
	return

;*****************************************************
; 16 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub16				; 16 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen
	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f
	btfsc   STATUS,C
	goto    Sub16A
	movlw   0x01		; borgen von f1
	subwf   f1, f
	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf
Sub16A
	movf    xw1,w		; f1=f1-xw1
        subwf   f1    , f
        btfss   STATUS, C
 	bsf	Fehler, C	; Unterlauf
	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return

;*********************************************************************
;16 bit Adition, C-Flag bei berlauf gesetzt
Add16 				; 16-bit add: f = f + xw
	movf	xw0,W		; low byte
	addwf	f0,F 		; low byte add

	movf	xw1,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,W 		; add C if it was set
	addwf	f1,F 		; high byte add if NZ
	
	return 			; finished

;*****************************************************
; 32 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub32				; 32 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen

	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    sb0
	movlw   0x01		; borgen von f1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb0
	subwf   f2    ,f        ; borgen von f2

	btfsc   STATUS,C
	goto    sb0
	subwf   f3    ,f        ; borgen von f3
	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf

sb0     movf    xw1, w		; f1=f1-xw1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb1
	movlw   0x01		; borgen von f2
	subwf   f2    ,f

	btfsc   STATUS,C
	goto    sb1
	subwf   f3, f		; borgen von f3

        btfss   STATUS,C
	bsf	Fehler, C	; Unterlauf

sb1     movf    xw2,w		; f2=f2-xw2
        subwf   f2, f

        btfsc   STATUS,C
        goto    sb2
        movlw   0x01		
        subwf   f3, f		; borgen von f3

        btfss   STATUS,C
       	bsf	Fehler, C	; Unterlauf

sb2     movf    xw3,w		; f3=f3-xw3
        subwf   f3    ,f

        btfss   STATUS,C
 	bsf	Fehler, C	; Unterlauf

	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return

;32 bit Adition, C-Flag bei berlauf gesetzt
;*********************************************************************
;* Add4
;* Add xw (32-byte value) to f (32-byte value). 4-instr. groups
;* (movf-btfsc-incfsz-addwf) used instead of non-existing ADD W/ CARRY.
;* Input variables: f (32-bit value), xw (32-bit value)
;* Output variables: f (32-bit value), 33th bit in STATUS,C
;*********************************************************************
Add32 				; 32-bit add: f = f + xw
	movf	xw0,W		; low byte
	addwf	f0,F 		; low byte add

	movf	xw1,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,W 		; add C if it was set
	addwf	f1,F 		; next byte add if NZ
	
	movf	xw2,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw2,W 		; add C if it was set
	addwf	f2,F 		; next byte add if NZ
	
	movf	xw3,W 		; high byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw3,W 		; add C if it was set
	addwf	f3,F 		; high byte add if NZ
	
	return 			; finished

;*****************************************************
; positiven 16 Bit Wert (f1,f0) auf LCD dezimal anzeigen
OutDez16			;16-bit (f0,f1) als Dez zum Lcd
	bsf	Leading0
	call	Hex2Dez16	; 16-bit(f1,f0) in 5-stellen Bcd (ZT,T,H,Z,E)
	movfw	HdZT
	Call	Bcd4Bit		; low-4 Bit als BCD ausgeben
	movfw	HdT
	Call	Bcd4Bit
	movfw	HdH
	Call	Bcd4Bit
	movfw	HdZ
	Call	Bcd4Bit
	bcf	Leading0	; letzte Stelle auch anzeigen, wenn 0
	movfw	HdE
	Call	Bcd4Bit
	return

; 8 Bit Wert w auf LCD 2-stellig dezimal anzeigen (00-99)
OutDezW				; 8-bit w als Dez zum Lcd 2-stellig
	bsf	Leading0
	movwf	f0
	clrf	f1
	clrf	f2
	clrf	f3			
	call	Hex2Dez8	; 8-bit (f1,f0) in 3-stellen BCD
	movfw	HdZ	
	Call	Bcd4Bit		; low-4 Bit als BCD ausgeben
	bcf	Leading0	; letzte Stelle auch anzeigen, wenn 0
	movfw	HdE
	Call	Bcd4Bit
	return

;           10 000 = 0000 2710 h
;            1 000 = 0000 03E8 h
;              100 = 0000 0064 h
;               10 = 0000 000A h
;                1 = 0000 0001 h

Hex2Dez16			; 16-bit(f1,f0) in 5-stellen Bcd (ZT,T,H,Z,E)	
	clrf	f2
	clrf	f3	
		
	movlw	0x27		; 10 000 = 00 00 27 10 h
	movwf	xw1
	clrf	xw2
	clrf	xw3
	movlw	0x10
	movwf	xw0

	clrf	HdX
	decf	HdX, f
HdLoop1
	incf	HdX, f
	call	Sub32		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop1		;Stelle 1 mehr
	call	Add32

	movfw	HdX
	movwf	HdZT

	movlw	0x03		; 1 000 = 00 00 03 E8 h
	movwf	xw1
	clrf	xw2
	clrf	xw3
	movlw	0xE8
	movwf	xw0

	clrf	HdX
	decf	HdX, f
HdLoop2
	incf	HdX, f
	call	Sub32		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop2		;Stelle 1 mehr
	call	Add32

	movfw	HdX
	movwf	HdT
Hex2Dez8			; 8-bit (f1, f0) in 3-stellen BCD
	movlw	0x00		; 100 = 00 00 00 64 h
	movwf	xw3
	movwf	xw2
	movwf	xw1
	movlw	0x64
	movwf	xw0

	clrf	HdX
	decf	HdX, f
HdLoop3
	incf	HdX, f
	call	Sub32		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop3		;Stelle 1 mehr
	call	Add32

	movfw	HdX
	movwf	HdH

	movlw	0x00		; 10 = 00 00 00 0A h
	movwf	xw3
	movwf	xw2
	movwf	xw1
	movlw	0x0A
	movwf	xw0

	clrf	HdX
	decf	HdX, f
HdLoop4
	incf	HdX, f
	call	Sub32		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop4		;Stelle 1 mehr
	call	Add32

	movfw	HdX
	movwf	HdZ

	movfw	f0
	movwf	HdE
	return


OutBcd				;8-Bit als BCD ausgeben
	movwf	BcdDaten	;8-Bit kopieren
	movwf	BcdDaten1
	rrf	BcdDaten, f
	rrf	BcdDaten, f
	rrf	BcdDaten, f
	rrf	BcdDaten, f	;4 High-Bit in BcdDaten
	movlw	B'00001111'
	andwf	BcdDaten, f	; / 
	andwf	BcdDaten1, f	; 4-Low-Bit in BcdDaten1
	movfw	BcdDaten
	call	Bcd4Bit		;4 High-Bit ausgeben
	movfw	BcdDaten1
	call	Bcd4Bit		;4 Low-Bit ausgeben
	return
Bcd4Bit				;low-4 Bit als BCD ausgeben
	movwf	BcdDaten
	btfss	STATUS,Z	; Null?
	bcf	Leading0	; nein
	movlw	B'00110000'
	ADDwf	BcdDaten, f	;ASCII-wandeln (+48)
	movlw	B'00111010'
	subwf	BcdDaten, w
	btfss	STATUS, C	;Test auf A ... F
	goto	BcdOk
	movlw	.7
	addwf	BcdDaten, f	;korrigiere A...F (+7)
BcdOk
	movfw	BcdDaten
	btfsc	Leading0	; fhrende 0?
	movlw	' '		; ja
	call	OutLcdDaten
	return
