;**********************************************************
;64-stufiges FIR-filter
; 32 alte Werte in Bank1 0x0A0 bis 0x0DF
; 32 neue Werte in Bank3 0x1A0 bis 0x1DF
;
; Pointer zeigt auf ltesten Wert
; ltesten Wert aus Bank3 nach Bank1
; neuen Wert in Bank3 eintragen
; nderungspointer incrementieren
; Bank1 summieren
; Bank3 summieren
; FIR=SummeBank3-SummeBank1
;
; input : neuer Wert in U1H,U1L
; output: akuuvoll=1

;FirP - 6-Bit Pointer innerhalb der Banken
;	steht am Beginn auf gerader Adresse


;********************************************************
; ein neuer Wert, ein neues Ergebnis
; input : Spannung 10 Bit in U1H, U1L
; output: Akku1Voll wird gesetzt

FIR
	; ltesten Wert aus Bank3 nach Bank1
	movfw	FirP
	movwf	FSR 		; setzt den Zeiger
	bsf	FSR, 7		; auf Bank 2 oder 3
	bsf	STATUS, IRP	; Bank 3
	movfw	INDF		; holt ltesten Wert High
	bcf	STATUS, IRP	; Bank 1
	movwf	INDF		; schreibt High-wert in Bank1
	incf	FSR, f		; ungerade Adresse
	bsf	STATUS, IRP	; Bank 3
	movfw	INDF		; holt ltesten Wert Low
	bcf	STATUS, IRP	; Bank 1
	movwf	INDF		; schreibt Low-wert in Bank1
	decf	FSR, f		; gerade Adresse

	
	; neuen Wert in Bank3 eintragen
	bsf	STATUS, IRP	; Bank 3
	movfw	U1H
	movwf	INDF		; schreibt aktuellen High-Wert
	incf	FSR, f		; ungerade Adresse
	movfw	U1L
	movwf	INDF		; schreibt aktuellen Low-Wert

	; nderungspointer incrementieren
	incf	FirP, f
	incf	FirP, f
	movlw	B'00111111'
	andwf	FirP, f		; auf 63 begrenzen

	; Bank1 summieren
	bcf	STATUS, IRP	; Bank 1
	call	AddBank
	movfw	f0
	movwf	B1L
	movfw	f1
	movwf	B1H

	; Bank3 summieren
	bsf	STATUS, IRP	; Bank 3
	call	AddBank
	movfw	f0
	movwf	B3L
	movfw	f1
	movwf	B3H

	; FIR=SummeBank3-SummeBank1 = neu-alt
	movfw	B3L
	movwf	f0
	movfw	B3H
	movwf	f1
	movfw	B1L
	movwf	xw0
	movfw	B1H
	movwf	xw1
	call	Sub16		; neu-alt, NC: weiter laden, C: ende
	btfsc	STATUS, C
	bsf	Akku1Voll
	return

;********************************************************
; eine Bank zusammenaddieren nacg f1,f0
AddBank
	clrf	f0
	clrf	f1
	movlw	0x20		; beginn der Bank 'BB0100000'
				; Bank1: '0 1010 0000'=0A0
				; Bank3: '1 1010 0000'=1A0
	movwf	FSR
	bsf	FSR, 7
AddBank1
	movfw	INDF		; high Teil
	movwf	xw1
	incf	FSR, f		; ungerade Adresse
	movfw	INDF		; low Teil
	movwf	xw0
	call	Add16
	incf	FSR, f		; nchste gerade Adresse
	btfss	FSR, 5		; schon E0 erreicht? '1101 1111'->'1110 1111'
	goto	AddBank1	; nein, die nchste addieren
	return


;********************************************************
; FIR-initialisieren
InitFir
	bcf	STATUS, IRP	; Bank 1
	call	ClrBank
	bsf	STATUS, IRP	; Bank 3
	call	ClrBank
	clrf	FirP
	return


;********************************************************
;Lschen einer Bank
ClrBank
	movlw	0x20		; beginn der Bank 'BB0100000'
				; Bank1: '0 1010 0000'=0A0
				; Bank3: '1 1010 0000'=1A0
	movwf	FSR
	bsf	FSR, 7
ClrBank1
	clrf	INDF		; high Teil
	incf	FSR, f		; ungerade Adresse
	clrf	INDF		; low Teil
	incf	FSR, f		; nchste gerade Adresse
	btfss	FSR, 5		; schon E0 erreicht? '1101 1111'->'1110 1111'
	goto	ClrBank1	; nein, die nchste addieren
	return
