
{*********************************************************************
 * FileName:        watchlist.pas
 * Dependencies:    See uses section below
 * System:          Win32 (WinXP)
 * Compiler:        Delphi 5
 * Company:         sprut
 * Copyright:       2007-2011 Joerg Bredendiek (sprut)
 * Homepage :       www.sprut.de
 *
 ********************************************************************}

 {*********************************************************************
 * part of adsbScope
 * software to visualize adsb-data
 * this is the network parameter setup form
  *********************************************************************}

{*  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *}

unit watchlist;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, Unit1;

type
  TWatchListForm = class(TForm)
    WatchlistStringGrid: TStringGrid;
    Button1: TButton;
    GroupBox1: TGroupBox;
    EditAA: TEdit;
    procedure CheckNewPlane(AA : dword; plane:integer);
    procedure Button1Click(Sender: TObject);
    procedure updateWatchlistStringGrid;
    procedure FormCreate(Sender: TObject);
    procedure WatchlistStringGridMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure EditAAChange(Sender: TObject);
    procedure EditAAExit(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure makevisible(sichtbar : boolean; var position :TFormPos);
  end;

var
  WatchListForm: TWatchListForm;
  SelectedWatch : integer;
  ActiveCol     : integer;

implementation

{$R *.DFM}

procedure TWatchListForm.makevisible(sichtbar : boolean; var position :TFormPos);
begin
  if visible and (not sichtbar) then begin
    //ausblenden
    position.top    := top;
    position.left   := left;
    position.width  := width;
    position.height := height;
  end;
  if (not visible) and sichtbar then begin
    //einblenden
    if position.width > 0 then begin
      top    := position.top;
      left   := position.left;
      //width  := position.width;
      //height := position.height;
    end;
  end;
  visible := sichtbar;
end;  // makevisible


procedure TWatchListForm.updateWatchlistStringGrid;
var k, l : integer;
    af   : Tairframe;
begin
  WatchlistStringGrid.RowCount := maxWatchList;
  WatchlistStringGrid.ColCount := 6;
  with WatchlistStringGrid do
    for k := 0 to ColCount - 1 do
      for l:= 0 to RowCount - 1 do
        Cells[k,l] := '';

  WatchlistStringGrid.Cells[0, 0] := 'No';
  WatchlistStringGrid.Cells[1, 0] := 'AA';
  WatchlistStringGrid.Cells[2, 0] := 'ID';
  WatchlistStringGrid.Cells[3, 0] := 'active';   ActiveCol:=3;
  WatchlistStringGrid.Cells[4, 0] := 'present';
  WatchlistStringGrid.Cells[5, 0] := 'plane-No';
  for k:=1 to maxWatchList do begin
    af := Form1.findairframe(Form1.Watchlist[k].AA);
    WatchlistStringGrid.Cells[0, k] := inttostr(k);
    WatchlistStringGrid.Cells[1, k] := inttohex(Form1.Watchlist[k].AA, 6);
    if af.known then
    WatchlistStringGrid.Cells[2, k] := af.Kenner.name;
//                                         Planes.Airframe.Kenner.typs
    if Form1.Watchlist[k].active  then WatchlistStringGrid.Cells[3, k] := 'active';
    if Form1.Watchlist[k].present then begin
      WatchlistStringGrid.Cells[4, k] := 'present';
      WatchlistStringGrid.Cells[5, k] := inttostr(Form1.Watchlist[k].plane);
    end;
  end;
end;


// ein AA wird in die plane-Tabelle aufgenommen
procedure TWatchListForm.CheckNewPlane(AA : dword; plane:integer);
var k : integer;
begin
  if AA=0 then exit;
  for k:=1 to maxWatchList do if Form1.Watchlist[k].AA=AA then begin
    Form1.Watchlist[k].present := true;
    Form1.Watchlist[k].plane   := plane;     // nummer
    updateWatchlistStringGrid;
  end;
end; //CheckNewPlane


//unsichtbar machen
procedure TWatchListForm.Button1Click(Sender: TObject);
begin
  Form1.Watchlist1Click(nil);
end;


procedure TWatchListForm.FormCreate(Sender: TObject);
begin
  SelectedWatch := 0;
  ActiveCol     := 3;
  updateWatchlistStringGrid;
  EditAA.Text := '--';
end;


procedure TWatchListForm.WatchlistStringGridMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Column, Row: Longint;
begin
  WatchlistStringGrid.MouseToCell(X, Y, Column, Row);
  if row<1 then exit;
  if row>maxWatchList then exit;
  SelectedWatch := Row;
  if (column=ActiveCol) and (Form1.Watchlist[SelectedWatch].AA<>0) then begin
    Form1.Watchlist[SelectedWatch].active := not Form1.Watchlist[SelectedWatch].active;
    updateWatchlistStringGrid;
  end;
  EditAA.Text := inttohex(Form1.Watchlist[SelectedWatch].AA, 6);
  EditAA.Setfocus;
end;  //WatchlistStringGridMouseDown


procedure TWatchListForm.EditAAChange(Sender: TObject);
begin
  if SelectedWatch=0 then exit;
  try
    Form1.Watchlist[SelectedWatch].AA := strtoint('$'+EditAA.text);
    EditAA.font.color := clWindowText;
  except
    on EConvertError do EditAA.font.color := clRed;
  end;
  updateWatchlistStringGrid;
end;  //EditAAChange


// falls was geaendert wurde, dann noch mal sauber reinschreiben
procedure TWatchListForm.EditAAExit(Sender: TObject);
begin
  if SelectedWatch=0 then exit;
  EditAA.text := inttohex(Form1.Watchlist[SelectedWatch].AA, 6);
  if Form1.Watchlist[SelectedWatch].AA=0 then Form1.Watchlist[SelectedWatch].active := false;
  updateWatchlistStringGrid;
end;  //EditAAExit


end.
