{*********************************************************************
 * FileName:        hearbeat.pas
 * Dependencies:    See uses section below
 * System:          Win32 (WinXP)
 * Compiler:        Delphi 5
 * Company:         sprut
 * Copyright:       2007-2011 Joerg Bredendiek (sprut)
 * Homepage :       www.sprut.de
 *
 ********************************************************************}

 {*********************************************************************
 * adsbScope
 * software to visualize adsb-data
 * this is the main form
 *********************************************************************}

{*  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *}
unit hearbeat;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Unit1;

const
    maxHeart = 255;

type

  THeartBeat = record
           Uref      : word;        // Decoder HeartBeat-daten
           Usig      : word;
           ErrorHead : word;
           ErrorData : word;
           Frames    : word;
         end;

  THeartBeatForm = class(TForm)
    UImage: TImage;
    HImage: TImage;
    DImage: TImage;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    HScaleLabel: TLabel;
    DScaleLabel: TLabel;
    FImage: TImage;
    Label4: TLabel;
    FScaleLabel: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    Heart    : array[0..maxHeart]of THeartBeat;
    HeartPointer : integer;
    maxErrorHead : word;
    maxErrorData : word;
    maxFrames    : word;
  public
    { Public-Deklarationen }
    procedure makevisible(sichtbar : boolean; var position :TFormPos);
    procedure getdata(DecoderHeartBeat : THeartBeat);
    procedure graphic;
  end;

var
  HeartBeatForm: THeartBeatForm;

implementation

{$R *.DFM}

procedure THeartBeatForm.makevisible(sichtbar : boolean; var position :TFormPos);
begin
  if visible and (not sichtbar) then begin
    //ausblenden
    position.top    := top;
    position.left   := left;
    position.width  := width;
    position.height := height;
  end;
  if (not visible) and sichtbar then begin
    //einblenden
    if position.width > 0 then begin
      top    := position.top;
      left   := position.left;
      //width  := position.width;
      //height := position.height;
    end;
  end;
  visible := sichtbar;
end;  // makevisible


procedure THeartBeatForm.Button1Click(Sender: TObject);
begin
  Form1.decoderstatus1Click(nil);
end;

procedure THeartBeatForm.FormCreate(Sender: TObject);
var k : integer;
begin
  for k:=0 to maxHeart do Heart[k].Uref  := 0;
  HeartPointer := 0;
  maxErrorHead := 1000;
  maxErrorData :=  10;
  maxFrames    :=  10;
  graphic;
end;

procedure THeartBeatForm.getdata(DecoderHeartBeat : THeartBeat);
begin
  Heart[HeartPointer] := DecoderHeartBeat;
  inc(HeartPointer);
  if HeartPointer>maxHeart then HeartPointer := 0;
end;

//
// 500 mV = 100
//    1 V = 200
// Uref und Usig :
//  5V=5120
//  1V=1024 -> --
//0.8V= 819 -> 36
//0.6V= 614 -> 77
procedure THeartBeatForm.graphic;
var k, x    : integer;
    pointer : integer;
    Y_uref  : integer;
    Y_usig  : integer;
    Y_EHead : integer;
    Y_Edata : integer;
    Y_Frames: integer;
    olp,urp   : TPoint;
    rechteck  : TRect;

  // ermittelt Maximalwert an der Y-Scale der Grafik  
  function getscale(max: word):word;
  begin
    result:=1000;
    if max<100    then result:= ((max div    10)+1)*   10 else
    if max<1000   then result:= ((max div   100)+1)*  100 else
    if max<10000  then result:= ((max div  1000)+1)* 1000 else
                       result:= ((max div 10000)+1)*10000;
  end;

  function UtoY(U:word):word;
  begin
//    result:= 200-(U-512) div 3;       // 0,5V ... 1,086V
    result:= 200-(U-614) div 3;       // 0,6V ... 1,186V
  end;

begin
  // erase images 
  olp.x:=0;
  olp.y:=0;
  urp.x:=UImage.Width;
  urp.y:=UImage.Height;
  Rechteck.TopLeft:=olp;
  Rechteck.BottomRight:=urp;
  UImage.canvas.Brush.Color:=clWhite;
  UImage.canvas.FillRect(Rechteck);
  urp.x:=HImage.Width;
  urp.y:=HImage.Height;
  Rechteck.TopLeft:=olp;
  Rechteck.BottomRight:=urp;
  HImage.canvas.Brush.Color:=clWhite;
  HImage.canvas.FillRect(Rechteck);
  DImage.canvas.Brush.Color:=clWhite;
  DImage.canvas.FillRect(Rechteck);
  FImage.canvas.Brush.Color:=clWhite;
  FImage.canvas.FillRect(Rechteck);

  maxErrorHead := 1000;
  maxErrorData :=  10;
  maxFrames    :=  10;
  pointer := HeartPointer;
  for k:=0 to 255 do begin
    x := k*2;
    pointer := (HeartPointer+k) mod (maxHeart+1);
//    if Heart[pointer].Uref=0 then break;
    Y_uref  := UtoY(Heart[pointer].Uref);
    if Heart[pointer].ErrorHead>maxErrorHead then maxErrorHead := Heart[pointer].ErrorHead;
    if Heart[pointer].ErrorData>maxErrorData then maxErrorData := Heart[pointer].ErrorData;
    if Heart[pointer].Frames>maxFrames       then maxFrames := Heart[pointer].Frames;
    if k=0 then begin
      UImage.canvas.MoveTo(x,Y_uref);
    end else begin
      UImage.canvas.LineTo(x,Y_uref);
    end;
  end;
  maxErrorHead := getscale(maxErrorHead);
  maxErrorData := getscale(maxErrorData);
  maxFrames    := getscale(maxFrames);
  HScaleLabel.caption := inttostr(maxErrorHead);
  DScaleLabel.caption := inttostr(maxErrorData);
  FScaleLabel.caption := inttostr(maxFrames);
  for k:=0 to 255 do begin
    x := k*2;
    pointer := (HeartPointer+k) mod (maxHeart+1);
//    if Heart[pointer].Uref=0 then break;
    Y_usig   := UtoY(Heart[pointer].Usig);
    Y_EHead  := 99-round(Heart[pointer].ErrorHead / maxErrorHead * 100);
    Y_Edata  := 99-round(Heart[pointer].ErrorData / maxErrorData * 100);
    Y_Frames := 99-round(Heart[pointer].Frames    / maxFrames * 100);
    if k=0 then begin
      UImage.canvas.MoveTo(x,Y_usig);
      HImage.canvas.MoveTo(x,Y_EHead);
      DImage.canvas.MoveTo(x,Y_Edata);
      FImage.canvas.MoveTo(x,Y_Frames);
    end else begin
      UImage.canvas.LineTo(x,Y_usig);
      HImage.canvas.LineTo(x,Y_EHead);
      DImage.canvas.LineTo(x,Y_Edata);
      FImage.canvas.LineTo(x,Y_Frames);
    end;
  end;
end; //graphic

end.
