/*********************************************************************
 * FileName:        user.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         sprut
 * Copyright:       2007-2010 Joerg Bredendiek (sprut)
 *
 *
 ********************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef USER_H
#define USER_H



/** I N C L U D E S **********************************************************/
#include "system\usb\usb.h"
#include "system\typedefs.h"


/** D E F I N I T I O N S ****************************************************/
/* 28-Pin-Testplatinen-Test Version */
#define MINOR_VERSION   0x09    //Firmware-Version = 09; string in usbdsc.c anpassen !
#define MAJOR_VERSION   0x04    //ADSB             = 04
    //  0-Brenner8; 1=Bootloader 2=USB4A 3=Brenner9 4= adsbPIC

#define	false 	0;
#define	true 	1;

#define EECON1_RD       	EECON1bits.RD
#define EECON1_WR       	EECON1bits.WR

#define	adsb_buffer_size 	256


/** S T R U C T U R E S ******************************************************/

// fuer die strings sind nur 16 byte erforderlich
//fuer READ_DATA sind 17 bytes erforderlich
//wird ja nicht als EP benutzt
typedef union DATA_PACKET
{
    byte _byte[USBGEN_EP_SIZE];  	// 64, for byte access
    word _word[USBGEN_EP_SIZE/2];	// 32, for word access(USBGEN_EP_SIZE must be even)
    struct
    {
        enum
        {
            READ_VERSION    = 0x00,
            RD_ADC          = 0x37,
			READ_OFFSET		= 0x38,
			SET_OFFSET		= 0x39,	// SET_PWM
			SET_NEARDC		= 0x3A,
			READ_DATA		= 0x3D,
			SET_MODE		= 0x43,	// SET_VPP
			READ_EDATA		= 0x44,
			WRITE_EDATA		= 0x45,
			SYS_ADC			= 0x51,
			SYS_RS232		= 0x52,
			SYS_PWM2		= 0x58,
			SYS_EEPROM		= 0x5A,
			SYS_KEY			= 0x5B,
            RESET           = 0xFF
        }CMD;
        byte len;
    };
    struct
    {
        unsigned :8;
        byte ID;
    };
    struct
    {
        unsigned :8;
        word word_data;
    };
} DATA_PACKET;




/** P U B L I C  P R O T O T Y P E S *****************************************/
void UserInit(void);
void ProcessIO(void);


/** P R I V A T E  P R O T O T Y P E S ***************************************/
void ServiceRequests(void);

void SleepUs(unsigned int us);
void SleepMs(unsigned int ms);

void readEdata(void);
void writeEdata(void);
void UP_EEPROM(void);



/** E X T E R N     **********************************************************/
extern	byte			UsbSelected;

extern	byte			RS232_rx_count;			// zahl der per RS232 empfangenen bytes
extern	byte			RS232_rx_EOL;

extern	DATA_PACKET 	dataPacket;
extern	byte			counter;
extern	byte			counter2;
extern	byte			c2Offset;
extern	byte			Limit;
extern	byte			adsb[14];
extern	byte			Flags;
extern	byte			Zeit;
extern	byte			Lang;
extern	byte			adsbLoopL;
extern	byte			adsbLoopH;
extern	byte			Count_Error_Data;
extern	byte			Count_Error_Hdr;
extern	WORD			Sum_Error_Data;
extern	WORD			Sum_Error_Hdr;
extern	DWORD			CRC;
extern	byte			ADSB_Mode; 
extern	byte			DF;

extern	DWORD			TimeL;				// untere 2 Byte des Zeitcode
extern	BYTE			Time0;
extern	BYTE			Time1;
extern	DWORD			TimeU;
extern	byte			TimeCode;
extern	byte			SendFrameNr;
extern	byte			SendHeartBeat;

extern	DWORD			FrameNr;

extern	byte			T2_PS;
extern	byte			pwm_period;
extern	unsigned int	pwm_near_dc;
extern	unsigned int	pwm_dutycycle;
extern	WORD			U_pegel;			//HF-Spannung
extern	WORD			U_ref;				//Referenzspannung


extern	byte			agc_offset; 	// ref soll 100mV ueber pegel sein
extern	byte			agc_mode;		// 1-on   0-off
extern	byte			agc_counter;

extern	char			ASCII[16];

extern	char			adsb_buffer[adsb_buffer_size];		// xx byte

#endif	// USER_H

/****  E N D E  *********************************************/
