/*********************************************************************
 * FileName:        rs232.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         sprut
 * Copyright:       2007-2010 Joerg Bredendiek (sprut)
 *
 *
 ********************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef RS232_H
#define RS232_H



/** I N C L U D E S **********************************************************/
#include "system\usb\usb.h"
#include "system\typedefs.h"


/** D E F I N I T I O N S ****************************************************/


/******************************************************************************
 * Macro:           BOOL mRS232USARTIsTxTrfReady(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        This macro is used to check if the CDC class is ready
 *                  to send more data.
 *                  Typical Usage: if(mRS232USARTIsTxTrfReady())
 *
 * Note:            None
 *****************************************************************************/
#define mRS232USARTIsTxTrfReady()     (cdc_trf_state == CDC_TX_READY)

/******************************************************************************
 * Macro:           void mRS232USARTTxRam(byte *pData, byte len)
 *
 * PreCondition:    cdc_trf_state must be in the CDC_TX_READY state.
 *                  
 *                  Value of 'len' must be equal to or smaller than 255 bytes.
 *
 * Input:           pDdata  : Pointer to the starting location of data bytes
 *                  len     : Number of bytes to be transferred
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Use this macro to transfer data located in data memory.
 *                  Use this macro when:
 *                  1. Data stream is not null-terminated
 *                  2. Transfer length is known
 *
 *                  Remember: cdc_trf_state must == CDC_TX_READY
 *                  Unlike putsUSBUSART, there is not code double checking
 *                  the transfer state. Unexpected behavior will occur if
 *                  this function is called when cdc_trf_state != CDC_TX_READY
 *
 * Note:            This macro only handles the setup of the transfer. The
 *                  actual transfer is handled by CDCTxService().
 *****************************************************************************/
#define mRS232USARTTxRam(pData,len)   \
{                                     \
    pCDCSrc.bRam  = pData;            \
    cdc_tx_len    = len+1;            \
    cdc_trf_state = CDC_TX_BUSY;      \
}

/** S T R U C T U R E S ******************************************************/



/** P U B L I C  P R O T O T Y P E S *****************************************/
void rs232_init(void);
void RS232_tx(void);
void RS232_rx(void);
void RS232Tasks(void);

byte getsRS232USART(char *buffer, byte len);

void RS232CDCTxService(void);

extern	char	RS232_DataDa;



/** P R I V A T E  P R O T O T Y P E S ***************************************/




#endif	// RS232_H

/****  E N D E rs232.h *********************************************/
