/*********************************************************************
 * FileName:        agc.c
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         sprut
 * Copyright:       2007-2010 Joerg Bredendiek (sprut)
 *
 *
 ********************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */



/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include <usart.h>
#include "system\typedefs.h"
#include "system\usb\usb.h"
#include "io_cfg.h"             // I/O pin mapping

#include "delays.h"
//#include "system\interrupt\interrupt.h"
#include "user\user.h"
#include "user\adsbin.h"
#include "user\agc.h"

#include "timers.h"
#include "pwm.h"


/** V A R I A B L E S ********************************************************/
#pragma udata


/** D E C L A R A T I O N S **************************************************/
#pragma code


void pwm_init(void)
{
	byte	temp;
    pwm_near_dc = 280;

	// agc-offset aus dem EEPROM laden
    EECON1 = 0x00;
	EEADR  = 0x00;	//Adresse = 0x00
	EECON1_RD = 1;
	agc_offset = EEDATA;				// ref sollte etwa 100mV ueber pegel sein
    // unsinnigen offset durch 100mV ersetzen
	if (agc_offset<10)  agc_offset = 100; 
	if (agc_offset>250) agc_offset = 100; 

	// agc-mode aus dem EEPROM laden
	// 0= an	agc_mode   = 1;	
	// 1= aus	agc_mode   = 0;	
	// 2...		agc_mode   = 2...;	
    EECON1 = 0x00;
	EEADR  = 0x03;	//Adresse = 0x03
	EECON1_RD = 1;
	temp = EEDATA;
	if (temp==1) 	agc_mode   = 0;	// agc aus
	else 			agc_mode   = 1;	// agc an
	if (temp>1) 	agc_mode   = temp;	// agc spezial

	pwm_period = 0xFF;  			// 1024 stufen
    T2_PS = T2_PS_1_1;  			// 47 kHz
	pwm_dutycycle = 140;			// 0,7 / 5 * 1024 = 143
	SetDCPWM2(1);
	OpenTimer2(TIMER_INT_OFF & T2_PS); 
	OpenPWM2(pwm_period); 			// PWM period =[(period ) + 1] x 4 x TOSC x TMR2 prescaler
	SetDCPWM2(pwm_dutycycle);  		// 10 Bit
}


// stellt Comparatorpegel neu ein
// auf HF-Pegel + agc_offset
// dauert etwa 300 us
// wird alle 1,3 Sekunden gerufen
// bei DC: 1 = 5 mV
word pwm_avr(void)
{
	int	step;
	U_pegel._word = agc_Pegel();							// HF-Pegel in mV
	U_ref._word   = agc_Ref();								// Uref in mV
	step  = ((int)U_pegel._word + agc_offset - (int)U_ref._word)/10;	// in pwm-stufen umrechnen, gebremst
	pwm_dutycycle += step;
	if (pwm_dutycycle > 1000) pwm_dutycycle = 1000;			// begrenzen 240mV .. 4.88V
    if (pwm_dutycycle <   50) pwm_dutycycle =   50;
	SetDCPWM2(pwm_dutycycle);								// Spannung einstellen
	ADCON0    = 0x05;										// Pegel, AN1, , Vorbereiten fuer naechste Messung
	return step;
}

//unempfindlich fuer Nahbereich
// 280 = 1,37V
void pwm_near(void)
{
	SetDCPWM2(pwm_near_dc);
}

//normale Empfindlichkeit
void pwm_far(void)
{
	SetDCPWM2(pwm_dutycycle);
}


void agc_init(void)
{
	// init COMP: Mode 001
	CMCON = 1;
	ADCON0 = 0x05;				// AN1, idle, enabled
	ADCON1 = 0x0D;				// nur AN0 und AN1 analog
	ADCON2 = 0xFE;				// rechts, 20 Tad, Fosc/64,   Tad=27 us  , Wandlung in 15 us
}


//misst HF-Pegel
// Ergebnis in mV
// Quellwiderstand is 47 kOhm -> Tad>=10 us
word agc_Pegel(void)
{
	ADCON0 = 0x05;					// Pegel, AN1, idle, enabled
	SleepUs(100);
	return agc_Adc();
}


//misst Ref-Pegel
// Ergebnis in mV
// Quellwiderstand is 47 kOhm -> Tad>=10 us
word agc_Ref(void)
{
	ADCON0 = 0x01;					// Referenz, AN0, idle, enabled
	SleepUs(100);
	return agc_Adc();
}


//misst ADC-Eingangsspannung
// Ergebnis in mV
word agc_Adc(void)
{
	WORD	wert;
	ADCON0bits.GO = 1;              // Start AD conversion
	while(ADCON0bits.NOT_DONE);     // Wait for conversion;  dauert ca 15 us (Wandlung) + 27 us (aquisition)
    wert.byte0 = ADRESL;
    wert.byte1 = ADRESH;
	wert._word *= 5;				// Wandlung in mV
	return wert._word;
}


/** EOF agc.c ***************************************************************/
