/*********************************************************************
 * FileName:        adsbin.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         sprut
 * Copyright:       2007-2010 Joerg Bredendiek (sprut)
 *
 *
 ********************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef ADSBIN_H
#define ADSBIN_H



/** I N C L U D E S **********************************************************/
#include "system\usb\usb.h"
#include "system\typedefs.h"


/** D E F I N I T I O N S ****************************************************/
#define	GIEH	7
#define	W		0
#define	C		0
#define	F		1
#define	A		0


// alternative Namen fuer die einzelnen Zellen des arrays asdb[]
#define	AAA0	adsb
#define	AAA1	adsb+1
#define	AAA2	adsb+2
#define	AAA3	adsb+3
#define	AAA4	adsb+4
#define	AAA5	adsb+5
#define	AAA6	adsb+6
#define	AAA7	adsb+7
#define	AAA8	adsb+8
#define	AAA9	adsb+9
#define	AAA10	adsb+10
#define	AAA11	adsb+11
#define	AAA12	adsb+12
#define	AAA13	adsb+13


/** S T R U C T U R E S ******************************************************/



/** P U B L I C  P R O T O T Y P E S *****************************************/
char adsb_in(void);
char adsb_in2(void);
byte adsb_DF(void);
void adsb_CRC(void);
char adsb_CRC_OK(void);
void adsb_StringOut(void);
void adsb_heartbeat(void);

/** P R I V A T E  P R O T O T Y P E S ***************************************/
void adsb_CRC_112(void);
void adsb_CRC_56(void);
byte hex2asc_H(byte B);
byte hex2asc_L(byte B);

#endif	// ADSBIN_H

/****  E N D E adsbin.h *********************************************/
