/*********************************************************************
 * FileName:        adsbin.c
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         sprut
 * Copyright:       2007-2010 Joerg Bredendiek (sprut)
 *
 *
 ********************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */



/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include <usart.h>
#include "system\typedefs.h"
#include "system\usb\usb.h"
#include "io_cfg.h"             // I/O pin mapping

#include "delays.h"
//#include "system\interrupt\interrupt.h"
#include "user\user.h"
#include "user\adsbin.h"


/** V A R I A B L E S ********************************************************/
#pragma udata


/** D E C L A R A T I O N S **************************************************/
#pragma code


// AAA0 ... AAA6 ...AAA11 ... AAA13

// Warten und finden eines Datenblocks
// wenn er gefunden wird, dann 
//		Einschreiben in adsb[0..13]
//		56Bit:Lang=0 / 112Bit:Lang=1
//		Rueckkehr  mit w=0
// wenn er NICHT gefunden wird, dann 
//		Rueckkehr  mit w=1
// Anzahl der Suchschleifen: adsbLoopH-adsbLoopL
// max suchzeit ist adsbLoopH * 2 Millisekunden
//
// puls ist 0.5us lang
//
// das ist eine der unelegantesten routinen die denkbar ist
// aber sie funktioniert
// never touch a running system!
//
// alle Variablen: RAM bank is specified by BSR register (a=1)
// alle SFR:       RAM location in Access RAM (a=0=A)
//
// am ende steht in Count_Error_Hdr die Zahl von Header-Fehlern
// diese deuten auf zu starke Signale aus dem Nahbereich hin
char adsb_in(void)
{
	char ergebnis = adsb_in2();
	Sum_Error_Data._word += Count_Error_Data;
	Sum_Error_Hdr._word  += Count_Error_Hdr;
	return ergebnis;
}


char adsb_in2(void)
{
	_asm		
	CLRF	Count_Error_Data, 1
	CLRF	Count_Error_Hdr, 1
	BCF		PORTC, 1, A				// HDR_OUT
	BRA		Start_Hdr



// Einlesen : ist das ein Header  ?
// 1010 0001 0100 0000
// die Anfangspuls-Rutsche
// ca 100 zyklen lang  (8.5 us) warten auf den ersten pulse
// dann zu Pulse springen und prfen ob das ein gueltiger Header ist
Start_Hdr:
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse

	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BTFSC	PORTC, 0, A		// 1
	BRA		Pulse
	BRA		NoPulse_Hdr	



// inner loop ca 100 zyklen = 5.5 us
// 256 * 8.5 us = 2.2 ms
//
// Fehler im Datenblock
Error_Data:
	incf	Count_Error_Data, F, 1
	bra		Error_End

// Fehler im Header
Error_Hdr:
	incf	Count_Error_Hdr, F, 1
Error_End:
	BSF		INTCON, GIEH, A		// stoeren wieder erlaubt, ist fuer RS232 so  noetig


// 100us lang auf eine mindestens 0.75 us lange luecke warten
// 9 zyklen = 0.75us
W84Low:
	CLRF	AAA0, 1
W84LowLoop:
	DCFSNZ	AAA0, F, 1
	BRA		W84LowEnd		// 5 * 256 * 83ns = 100us gegen deadlock bei dauerhigh
	BTFSC	PORTC, 0, A
	BRA		W84LowLoop	
	BTFSC	PORTC, 0, A
	BRA		W84Low
	BTFSC	PORTC, 0, A
	BRA		W84Low
	BTFSC	PORTC, 0, A
	BRA		W84Low
	BTFSC	PORTC, 0, A
	BRA		W84Low
W84LowEnd:


//beim suchen keinen Puls gefunden
NoPulse_Hdr:
	DECFSZ	adsbLoopL, F, 1		// 255 erfolglose Leseversuche, inner loop
	BRA		Start_Hdr			// neuer Versuch		kurze Schleife 
	DECFSZ	adsbLoopH, F, 1
	BRA		Start_Hdr			// neuer Versuch		lange Schleife 
	BSF		INTCON, GIEH, A
	MOVLW	1					// true,  Fehler, nichts empfangen
	RETURN	0			




//	BTFSC	PORTC, 0, A		// 1
Pulse:
	BTFSS	PORTC, 0, A		// 2 zyklen = 0,166 us lang 
	BRA		Error_Hdr	
	BCF		INTCON, GIEH, A			// bitte nicht stoeren
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSC	PORTC, 0, A		// 1
	BTFSS	PORTC, 0, A
	BRA		_Skip_Pulse		// es wurde erst der 2. Puls gefunden, deshalb vorspringen	
	NOP		
	NOP		
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP		

	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
_Skip_Pulse:
    // ab hier kann man auch die TOA bestimmen
	movf	TMR1L,W,A		//NOP		0xFCE RAM location in Access RAM (BSR register is ignored)
	movwf	Time0,1			//NOP		RAM bank is specified by BSR register
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	movf	TMR1H,W,A		//NOP		0xFCF RAM location in Access RAM (BSR register is ignored)
	movwf	Time1,1			//NOP		RAM bank is specified by BSR register
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSC	PORTC, 0, A		// 1
	BTFSS	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP
		
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSC	PORTC, 0, A		// 1
	BTFSS	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	NOP		
	NOP	
	
	BTFSS	PORTC, 0, A		// 0
	BTFSC	PORTC, 0, A
	BRA		Error_Hdr	
	NOP		
	BCF		PORTC, 2, A		// altes frame nun ungueltig
	BSF		PORTC, 1, A

// es folgt der Datenblock
// 5 Bit Format-Number
//Lang = 0
// DF00		00000	56 bit
// DF04		00100	56 bit
// DF05		00101	56 bit
// DF11		01011	56 bit
// Lang = 1
// DF16		10000	112 bit
// DF17		10001	112 bit
// DF19		10011	112 bit
// DF20		10100	112 bit
// DF21		10101	112 bit
// DF22		10110	112 bit
// DF24		11000	112 bit
//
// das erste Bit unterscheidet zwischen 56 und 112 bit

	RRCF	PORTC, W, A
	RLCF	AAA0, F, 1
	CLRF	Lang, 1					// 56 oder 112 bit noch unbekannt, erst mal auf 56 stellen
	BTFSC	AAA0, 0, 1				// Test 56 oder 112 Bit ?
	INCF	Lang, F, 1				// 112 Bit : Lang = 1	
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA0, W, 1
	ANDLW	0x01	
	BZ	Error_Data					// Fehler im Datenblock
	NOP		
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA0, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA0, W, 1
	ANDLW	0x01	
	BNZ		BIT02_ok	
	GOTO	Error_Data	
BIT02_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA0, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA0, W, 1
	ANDLW	0x01	
	BNZ		BIT03_ok	
	GOTO	Error_Data	
BIT03_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA0, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA0, W, 1
	ANDLW	0x01	
	BNZ		BIT04_ok	
	GOTO	Error_Data	
BIT04_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA0, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA0, W, 1
	ANDLW	0x01	
	BNZ		BIT05_ok	
	GOTO	Error_Data	
BIT05_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA0, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA0, W, 1
	ANDLW	0x01	
	BNZ		BIT06_ok	
	GOTO	Error_Data	
BIT06_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA0, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA0, W, 1
	ANDLW	0x01	
	BNZ		BIT07_ok	
	GOTO	Error_Data	
BIT07_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA0, F, 1
	NOP		
	NOP		
	NOP		
	BSF	ADCON0, 1, A
	MOVF	PORTC, W, A
	XORWF	AAA0, W, 1
	ANDLW	0x01	
	BNZ		BIT08_ok	
	BRA	Error_Data	
BIT08_ok:
	NOP		

// byte 2
	RRCF	PORTC, W, A
	RLCF	AAA1, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA1, W, 1
	ANDLW	0x01	
	BNZ		BIT09_ok	
	GOTO	Error_Data	
BIT09_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA1, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA1, W, 1
	ANDLW	0x01	
	BNZ		BIT10_ok	
	GOTO	Error_Data	
BIT10_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA1, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA1, W, 1
	ANDLW	0x01	
	BNZ		BIT11_ok	
	GOTO	Error_Data	
BIT11_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA1, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA1, W, 1
	ANDLW	0x01	
	BNZ		BIT12_ok	
	GOTO	Error_Data	
BIT12_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA1, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA1, W, 1
	ANDLW	0x01	
	BNZ		BIT13_ok	
	GOTO	Error_Data	
BIT13_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA1, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA1, W, 1
	ANDLW	0x01	
	BNZ		BIT14_ok	
	GOTO	Error_Data	
BIT14_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA1, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA1, W, 1
	ANDLW	0x01	
	BNZ		BIT15_ok	
	GOTO	Error_Data	
BIT15_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA1, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA1, W, 1
	ANDLW	0x01	
	BNZ		BIT16_ok	
	GOTO	Error_Data	
BIT16_ok:
	NOP	

// byte 3	
	RRCF	PORTC, W, A
	RLCF	AAA2, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA2, W, 1
	ANDLW	0x01	
	BNZ		BIT17_ok	
	GOTO	Error_Data	
BIT17_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA2, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA2, W, 1
	ANDLW	0x01	
	BNZ		BIT18_ok	
	GOTO	Error_Data	
BIT18_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA2, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA2, W, 1
	ANDLW	0x01	
	BNZ		BIT19_ok	
	GOTO	Error_Data	
BIT19_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA2, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA2, W, 1
	ANDLW	0x01	
	BNZ		BIT20_ok	
	GOTO	Error_Data	
BIT20_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA2, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA2, W, 1
	ANDLW	0x01	
	BNZ		BIT21_ok	
	GOTO	Error_Data	
BIT21_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA2, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA2, W, 1
	ANDLW	0x01	
	BNZ		BIT22_ok	
	GOTO	Error_Data	
BIT22_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA2, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA2, W, 1
	ANDLW	0x01	
	BNZ		BIT23_ok	
	GOTO	Error_Data	
BIT23_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA2, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA2, W, 1
	ANDLW	0x01	
	BNZ		BIT24_ok	
	GOTO	Error_Data	
BIT24_ok:
	NOP		

//byte 4
	RRCF	PORTC, W, A
	RLCF	AAA3, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA3, W, 1
	ANDLW	0x01	
	BNZ		BIT25_ok	
	GOTO	Error_Data	
BIT25_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA3, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA3, W, 1
	ANDLW	0x01	
	BNZ		BIT26_ok	
	GOTO	Error_Data	
BIT26_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA3, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA3, W, 1
	ANDLW	0x01	
	BNZ		BIT27_ok	
	GOTO	Error_Data	
BIT27_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA3, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA3, W, 1
	ANDLW	0x01	
	BNZ		BIT28_ok	
	GOTO	Error_Data	
BIT28_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA3, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA3, W, 1
	ANDLW	0x01	
	BNZ		BIT29_ok	
	GOTO	Error_Data	
BIT29_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA3, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA3, W, 1
	ANDLW	0x01	
	BNZ		BIT30_ok	
	GOTO	Error_Data	
BIT30_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA3, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA3, W, 1
	ANDLW	0x01	
	BNZ		BIT31_ok	
	GOTO	Error_Data	
BIT31_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA3, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA3, W, 1
	ANDLW	0x01	
	BNZ		BIT32_ok	
	GOTO	Error_Data	
BIT32_ok:
	NOP		

//byte 5
	RRCF	PORTC, W, A
	RLCF	AAA4, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA4, W, 1
	ANDLW	0x01	
	BNZ		BIT33_ok	
	GOTO	Error_Data	
BIT33_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA4, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA4, W, 1
	ANDLW	0x01	
	BNZ		BIT34_ok	
	GOTO	Error_Data	
BIT34_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA4, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA4, W, 1
	ANDLW	0x01	
	BNZ		BIT35_ok	
	GOTO	Error_Data	
BIT35_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA4, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA4, W, 1
	ANDLW	0x01	
	BNZ		BIT36_ok	
	GOTO	Error_Data	
BIT36_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA4, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA4, W, 1
	ANDLW	0x01	
	BNZ		BIT37_ok	
	GOTO	Error_Data	
BIT37_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA4, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA4, W, 1
	ANDLW	0x01	
	BNZ		BIT38_ok	
	GOTO	Error_Data	
BIT38_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA4, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA4, W, 1
	ANDLW	0x01	
	BNZ		BIT39_ok	
	GOTO	Error_Data	
BIT39_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA4, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA4, W, 1
	ANDLW	0x01	
	BNZ		BIT40_ok	
	GOTO	Error_Data	
BIT40_ok:
	NOP		

//byte 6
	RRCF	PORTC, W, A
	RLCF	AAA5, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA5, W, 1
	ANDLW	0x01	
	BNZ		BIT41_ok	
	GOTO	Error_Data	
BIT41_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA5, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA5, W, 1
	ANDLW	0x01	
	BNZ		BIT42_ok	
	GOTO	Error_Data	
BIT42_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA5, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA5, W, 1
	ANDLW	0x01	
	BNZ		BIT43_ok	
	GOTO	Error_Data	
BIT43_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA5, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA5, W, 1
	ANDLW	0x01	
	BNZ		BIT44_ok	
	GOTO	Error_Data	
BIT44_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA5, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA5, W, 1
	ANDLW	0x01	
	BNZ		BIT45_ok	
	GOTO	Error_Data	
BIT45_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA5, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA5, W, 1
	ANDLW	0x01	
	BNZ		BIT46_ok	
	GOTO	Error_Data	
BIT46_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA5, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA5, W, 1
	ANDLW	0x01	
	BNZ		BIT47_ok	
	GOTO	Error_Data	
BIT47_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA5, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA5, W, 1
	ANDLW	0x01	
	BNZ		BIT48_ok	
	GOTO	Error_Data	
BIT48_ok:
	NOP	
	
//byte 7
	RRCF	PORTC, W, A
	RLCF	AAA6, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA6, W, 1
	ANDLW	0x01	
	BNZ		BIT49_ok	
	GOTO	Error_Data	
BIT49_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA6, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA6, W, 1
	ANDLW	0x01	
	BNZ		BIT50_ok	
	GOTO	Error_Data	
BIT50_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA6, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA6, W, 1
	ANDLW	0x01	
	BNZ		BIT51_ok	
	GOTO	Error_Data	
BIT51_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA6, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA6, W, 1
	ANDLW	0x01	
	BNZ		BIT52_ok	
	GOTO	Error_Data	
BIT52_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA6, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA6, W, 1
	ANDLW	0x01	
	BNZ		BIT53_ok	
	GOTO	Error_Data	
BIT53_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA6, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA6, W, 1
	ANDLW	0x01	
	BNZ		BIT54_ok	
	GOTO	Error_Data	
BIT54_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA6, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA6, W, 1
	ANDLW	0x01	
	BNZ		BIT55_ok	
	GOTO	Error_Data	
BIT55_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA6, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA6, W, 1
	ANDLW	0x01	
	BNZ		BIT56_ok	
	GOTO	Error_Data	
BIT56_ok:
	BTFSS	Lang, 0, 1			// langer Ftrame??
	BRA		OK_Data				// 56 Bit zuende -> Ende der Daten


// byte 8
	RRCF	PORTC, W, A			// weitere 56 bit empfangen
	RLCF	AAA7, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA7, W, 1
	ANDLW	0x01	
	BNZ		BIT57_ok	
	GOTO	Error_Data	
BIT57_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA7, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA7, W, 1
	ANDLW	0x01	
	BNZ		BIT58_ok	
	GOTO	Error_Data	
BIT58_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA7, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA7, W, 1
	ANDLW	0x01	
	BNZ		BIT59_ok	
	GOTO	Error_Data	
BIT59_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA7, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA7, W, 1
	ANDLW	0x01	
	BNZ		BIT60_ok	
	GOTO	Error_Data	
BIT60_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA7, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA7, W, 1
	ANDLW	0x01	
	BNZ		BIT61_ok	
	GOTO	Error_Data	
BIT61_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA7, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA7, W, 1
	ANDLW	0x01	
	BNZ		BIT62_ok	
	GOTO	Error_Data	
BIT62_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA7, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA7, W, 1
	ANDLW	0x01	
	BNZ		BIT63_ok	
	GOTO	Error_Data	
BIT63_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA7, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA7, W, 1
	ANDLW	0x01	
	BNZ		BIT64_ok	
	GOTO	Error_Data	
BIT64_ok:
	NOP		

//byte 8
	RRCF	PORTC, W, A
	RLCF	AAA8, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA8, W, 1
	ANDLW	0x01	
	BNZ		BIT65_ok	
	GOTO	Error_Data	
BIT65_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA8, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA8, W, 1
	ANDLW	0x01	
	BNZ		BIT66_ok	
	GOTO	Error_Data	
BIT66_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA8, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA8, W, 1
	ANDLW	0x01	
	BNZ		BIT67_ok	
	GOTO	Error_Data	
BIT67_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA8, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA8, W, 1
	ANDLW	0x01	
	BNZ		BIT68_ok	
	GOTO	Error_Data	
BIT68_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA8, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA8, W, 1
	ANDLW	0x01	
	BNZ		BIT69_ok	
	GOTO	Error_Data	
BIT69_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA8, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA8, W, 1
	ANDLW	0x01	
	BNZ		BIT70_ok	
	GOTO	Error_Data	
BIT70_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA8, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA8, W, 1
	ANDLW	0x01	
	BNZ		BIT71_ok	
	GOTO	Error_Data	
BIT71_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA8, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA8, W, 1
	ANDLW	0x01	
	BNZ		BIT72_ok	
	GOTO	Error_Data	
BIT72_ok:
	NOP	

//byte 9	
	RRCF	PORTC, W, A
	RLCF	AAA9, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA9, W, 1
	ANDLW	0x01	
	BNZ		BIT73_ok	
	GOTO	Error_Data	
BIT73_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA9, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA9, W, 1
	ANDLW	0x01	
	BNZ		BIT74_ok	
	GOTO	Error_Data	
BIT74_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA9, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA9, W, 1
	ANDLW	0x01	
	BNZ		BIT75_ok	
	GOTO	Error_Data	
BIT75_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA9, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA9, W, 1
	ANDLW	0x01	
	BNZ		BIT76_ok	
	GOTO	Error_Data	
BIT76_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA9, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA9, W, 1
	ANDLW	0x01	
	BNZ		BIT77_ok	
	GOTO	Error_Data	
BIT77_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA9, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA9, W, 1
	ANDLW	0x01	
	BNZ		BIT78_ok	
	GOTO	Error_Data	
BIT78_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA9, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA9, W, 1
	ANDLW	0x01	
	BNZ		BIT79_ok	
	GOTO	Error_Data	
BIT79_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA9, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA9, W, 1
	ANDLW	0x01	
	BNZ		BIT80_ok	
	GOTO	Error_Data	
BIT80_ok:
	NOP		

//byte 10
	RRCF	PORTC, W, A
	RLCF	AAA10, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA10, W, 1
	ANDLW	0x01	
	BNZ		BIT81_ok	
	GOTO	Error_Data	
BIT81_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA10, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA10, W, 1
	ANDLW	0x01	
	BNZ		BIT82_ok	
	GOTO	Error_Data	
BIT82_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA10, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA10, W, 1
	ANDLW	0x01	
	BNZ		BIT83_ok	
	GOTO	Error_Data	
BIT83_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA10, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA10, W, 1
	ANDLW	0x01	
	BNZ		BIT84_ok	
	GOTO	Error_Data	
BIT84_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA10, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA10, W, 1
	ANDLW	0x01	
	BNZ		BIT85_ok	
	GOTO	Error_Data	
BIT85_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA10, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA10, W, 1
	ANDLW	0x01	
	BNZ		BIT86_ok	
	GOTO	Error_Data	
BIT86_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA10, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA10, W, 1
	ANDLW	0x01	
	BNZ		BIT87_ok	
	GOTO	Error_Data	
BIT87_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA10, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA10, W, 1
	ANDLW	0x01	
	BNZ		BIT88_ok	
	GOTO	Error_Data	
BIT88_ok:
	NOP	

//byte 11	
	RRCF	PORTC, W, A
	RLCF	AAA11, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA11, W, 1
	ANDLW	0x01	
	BNZ		BIT89_ok	
	GOTO	Error_Data	
BIT89_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA11, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA11, W, 1
	ANDLW	0x01	
	BNZ		BIT90_ok	
	GOTO	Error_Data	
BIT90_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA11, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA11, W, 1
	ANDLW	0x01	
	BNZ		BIT91_ok	
	GOTO	Error_Data	
BIT91_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA11, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA11, W, 1
	ANDLW	0x01	
	BNZ		BIT92_ok	
	GOTO	Error_Data	
BIT92_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA11, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA11, W, 1
	ANDLW	0x01	
	BNZ		BIT93_ok	
	GOTO	Error_Data	
BIT93_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA11, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA11, W, 1
	ANDLW	0x01	
	BNZ		BIT94_ok	
	GOTO	Error_Data	
BIT94_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA11, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA11, W, 1
	ANDLW	0x01	
	BNZ		BIT95_ok	
	GOTO	Error_Data	
BIT95_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA11, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA11, W, 1
	ANDLW	0x01	
	BNZ		BIT96_ok	
	GOTO	Error_Data	
BIT96_ok:
	NOP		

//byte 12
	RRCF	PORTC, W, A
	RLCF	AAA12, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA12, W, 1
	ANDLW	0x01	
	BNZ		BIT97_ok	
	GOTO	Error_Data	
BIT97_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA12, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA12, W, 1
	ANDLW	0x01	
	BNZ		BIT98_ok	
	GOTO	Error_Data	
BIT98_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA12, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA12, W, 1
	ANDLW	0x01	
	BNZ		BIT99_ok	
	GOTO	Error_Data	
BIT99_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA12, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA12, W, 1
	ANDLW	0x01	
	BNZ		BIT100_ok	
	GOTO	Error_Data	
BIT100_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA12, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA12, W, 1
	ANDLW	0x01	
	BNZ		BIT101_ok	
	GOTO	Error_Data	
BIT101_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA12, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA12, W, 1
	ANDLW	0x01	
	BNZ		BIT102_ok	
	GOTO	Error_Data	
BIT102_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA12, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA12, W, 1
	ANDLW	0x01	
	BNZ		BIT103_ok	
	GOTO	Error_Data	
BIT103_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA12, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA12, W, 1
	ANDLW	0x01	
	BNZ		BIT104_ok	
	GOTO	Error_Data	
BIT104_ok:
	NOP	

//byte 13	
	RRCF	PORTC, W, A
	RLCF	AAA13, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA13, W, 1
	ANDLW	0x01	
	BNZ		BIT105_ok	
	GOTO	Error_Data	
BIT105_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA13, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA13, W, 1
	ANDLW	0x01	
	BNZ		BIT106_ok	
	GOTO	Error_Data	
BIT106_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA13, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA13, W, 1
	ANDLW	0x01	
	BNZ		BIT107_ok	
	GOTO	Error_Data	
BIT107_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA13, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA13, W, 1
	ANDLW	0x01	
	BNZ		BIT108_ok	
	GOTO	Error_Data	
BIT108_ok:
	NOP		
	RRCF	PORTC, W, A
	RLCF	AAA13, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA13, W, 1
	ANDLW	0x01	
	BNZ		BIT109_ok	
	GOTO	Error_Data	
BIT109_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA13, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA13, W, 1
	ANDLW	0x01	
	BNZ		BIT110_ok	
	GOTO	Error_Data	
BIT110_ok:
	NOP		

	RRCF	PORTC, W, A
	RLCF	AAA13, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA13, W, 1
	ANDLW	0x01	
	BNZ		BIT111_ok	
	GOTO	Error_Data	
BIT111_ok:
	NOP	
	
	RRCF	PORTC, W, A
	RLCF	AAA13, F, 1
	NOP		
	NOP		
	NOP		
	NOP		
	MOVF	PORTC, W, A
	XORWF	AAA13, W, 1
	ANDLW	0x01	
	BNZ		BIT112_ok	
	GOTO	Error_Data	
//alles fehlerfrei empfangen
BIT112_ok:
	NOP	
	
OK_Data:
	BCF		PORTC, 1, A
	BSF		PORTC, 2, A				// komplettes Frame empfangen
	BSF		INTCON, GIEH, A
	MOVLW	0						// false , korrekter Empfang
	RETURN	0
	_endasm
}	// adsb_in



/***DF***************************************************************/


//ermittelt Formatnummer der Daten in adsb[]
byte adsb_DF(void)
{
	byte DF;
	DF = adsb[0];
	DF = DF >> 3;
	return DF;
}



/***CRC**************************************************************/

/****
DF0 (56 bit)  	00000=0L  	Short Air to Air ACAS  								CRC32 xor ACID
DF4 (56 bit) 	00100=2L 	Surveillance (roll call) Altitude 					CRC32 xor ACID
DF5 (56 bit) 	00101=2H 	Surveillance (roll call) IDENT Reply 				CRC32 xor ACID
DF11 (56 bit) 	01011=5H 	Mode S Only All-Call Reply (Acq. Squitter if II=0) 	CRC32 xor IRID or 000000
DF16 (112 bit) 	10000=8L 	Long Air to Air ACAS 	
DF17 (112 bit) 	10001=8H 	ADS-B Extended Squitter 							CRC88 xor 000000
DF18 (112 bit) 	10001=9LH 	TIS-B 												CRC88 xor 000000
DF19 (112 bit) 	10011=9H 	ADS-M Military Extended Squitter 					CRC88 xor 000000
DF20 (112 bit) 	10100=AL 	Comm B Altitude Reply 								CRC88 xor ACID
DF21 (112 bit) 	10101=AH 	Comm. B IDENT Reply 								CRC88 xor ACID
DF22 			10110=BL 	Military use only 	
DF24 			11000=CL 	Comm. D Extended Length Message (ELM) 	
******/


/***
DF11:	DF(5) - CA(3) - AA(24) - PI(24)
DF17:	DF(5) - CA(3) - AA(24) - ME(56) - PI(24)	extended squitter S.72  3-52
	Airborn position squitter   0.4 ... 0.6 sec
	Surface position squitter   0.4 ... 0.6 sec oder 4.8 ... 5.2 sec
	Identification   squitter   4.8 ... 5.2 aber wenn surface-low dann 9.8 ... 10.2 sec
	Airborne velocity squitter  0.4 ... 0.6 sec

***/


/**
Beispieldaten:
*8D484395990052B2E80B027D687F;		DF=17 1000 1___ / CA=5 _101 / AA=484395 / ME=990052B2E80B02 / PI=7D687F 
*8D3C65039990FB9E286404A0043E;
*8D4BAA499945161668800268C26E;
*8D3C662B903D006914A84A707D6A;
*A028023C2010C231595820AA9001;		DF20 1010 0000
**/


// stimme die CRC ?
// ok     -> 1
// falsch -> 0
char adsb_CRC_OK(void)
{
	adsb_CRC();
	if (adsb_DF() < 16)
	{
		if ( (CRC.byte2 == adsb[4]) && (CRC.byte1 == adsb[5]) && (CRC.byte0 == adsb[6]) ) return 1;
	}
	else
	{
		if ( (CRC.byte2 == adsb[11]) && (CRC.byte1 == adsb[12]) && (CRC.byte0 == adsb[13]) ) return 1;
	}
	return 0;
}

//ermittelt CRC der Daten in adsb[]
void adsb_CRC(void)
{
	if (adsb_DF() < 16) adsb_CRC_56();	// CRC32
	else 				adsb_CRC_112();	// CRC88
}


// input 11 Byte = 88 Bit Daten
// output 3 Byte = 24 Bit Daten
void adsb_CRC_112(void)
{
	DWORD	poly;	//32 bit
	char	i;
	DWORD	data, data1, data2;

	//poly = 0xFFFA0480;
	poly.byte3 = 0xFF;
	poly.byte2 = 0xFA;
	poly.byte1 = 0x04;
	poly.byte0 = 0x80;

	data.byte3 = adsb[0];
	data.byte2 = adsb[1];
	data.byte1 = adsb[2];
	data.byte0 = adsb[3];

	data1.byte3 = adsb[4];
	data1.byte2 = adsb[5];
	data1.byte1 = adsb[6];
	data1.byte0 = adsb[7];

	data2.byte3 = adsb[8];
	data2.byte2 = adsb[9];
	data2.byte1 = adsb[10];
	data2.byte0 = 0;

	for (i=1; i<89; i++)
	{
		if (data.byte3 & 0x80)  data._dword  ^= poly._dword;	// xor
		data._dword <<= 1;
		if (data1.byte3 & 0x80) data._dword  |= 1;		// or
		data1._dword <<= 1;
		if (data2.byte3 & 0x80) data1._dword |= 1;		// or
		data2._dword <<= 1;
	}
	CRC.byte2 = data.byte3;
	CRC.byte1 = data.byte2;
	CRC.byte0 = data.byte1;
}



// input  4 Byte = 32 Bit Daten
// output 3 Byte = 24 Bit Daten
void adsb_CRC_56(void)
{
	DWORD	poly;	//32 bit
	char	i;
	DWORD	data;

	//poly = 0xFFFA0480;
	poly.byte3 = 0xFF;
	poly.byte2 = 0xFA;
	poly.byte1 = 0x04;
	poly.byte0 = 0x80;

	data.byte3 = adsb[0];
	data.byte2 = adsb[1];
	data.byte1 = adsb[2];
	data.byte0 = adsb[3];

	for (i=1; i<33; i++)
	{
		if (data.byte3 & 0x80) data._dword ^= poly._dword;		// xor
		data._dword <<= 1;
	}
	CRC.byte2 = data.byte3;
	CRC.byte1 = data.byte2;
	CRC.byte0 = data.byte1;
}


// schreibt in den usb-Sendepuffer einen String entsprechend adsb[]
void adsb_StringOut(void)
{
	byte	k;
	byte	L;
	k = counter2 + c2Offset;
	//k = 0;			//// BREMSE

	L = Limit;							// Limit fuer longframe
	if (adsb_DF() < 16) Limit += 14;	// 14 Zeichen short-frame
	if (counter2 > Limit) return;		// nicht genug platz

	// auf Wunsch die Zeit vorsetzen wenn switch1 geschlossen ist oder ein mode>15
	// Time1 & Time0 ist TMR0 waehrend des Empfangs

	// It is simple 48 bit couter counting at 12MHz, or 83.3333ns. It overflows after ~271 days. 
	// I have no idea why Bertrand have chosen 48 bits and not 32 bits, which overflows once per ~6 minutes, 
	// which is satisfactory.
	// Note that SBS-1 has timestamp counting at 20MHz (says Bev @ PlanePlotter forum).
	if (!Switch_tag | TimeCode)
	{
		// die oberen 32 Bit der 48-Bit Zeitmarke aktualisieren
		TimeL.byte0 = Time0._byte;			// triggert das lesen von TMR0H
		TimeL.byte1 = Time1._byte;
		TimeL.byte2 = 0;
		TimeL._dword <<= 3;
		while (TimeL.byte2 != (TimeU.byte0 & 0x07)) TimeU._dword++;

	    adsb_buffer[k++] = '@';
		adsb_buffer[k++] = hex2asc_H(TimeU.byte3); 
		adsb_buffer[k++] = hex2asc_L(TimeU.byte3); 
		adsb_buffer[k++] = hex2asc_H(TimeU.byte2); 
		adsb_buffer[k++] = hex2asc_L(TimeU.byte2); 
		adsb_buffer[k++] = hex2asc_H(TimeU.byte1); 
		adsb_buffer[k++] = hex2asc_L(TimeU.byte1); 
		adsb_buffer[k++] = hex2asc_H(TimeU.byte0); 
		adsb_buffer[k++] = hex2asc_L(TimeU.byte0); 
		adsb_buffer[k++] = hex2asc_H(TimeL.byte1); 
		adsb_buffer[k++] = hex2asc_L(TimeL.byte1); 
		adsb_buffer[k++] = hex2asc_H(TimeL.byte0); 
		adsb_buffer[k++] = hex2asc_L(TimeL.byte0); 
	} else
		adsb_buffer[k++] = '*';	

	// die ersten 56 bit
    adsb_buffer[k++] = hex2asc_H(adsb[0]);
    adsb_buffer[k++] = hex2asc_L(adsb[0]);
    adsb_buffer[k++] = hex2asc_H(adsb[1]);
    adsb_buffer[k++] = hex2asc_L(adsb[1]);
    adsb_buffer[k++] = hex2asc_H(adsb[2]);
    adsb_buffer[k++] = hex2asc_L(adsb[2]);
    adsb_buffer[k++] = hex2asc_H(adsb[3]);
    adsb_buffer[k++] = hex2asc_L(adsb[3]);
    adsb_buffer[k++] = hex2asc_H(adsb[4]);
    adsb_buffer[k++] = hex2asc_L(adsb[4]);
    adsb_buffer[k++] = hex2asc_H(adsb[5]);
    adsb_buffer[k++] = hex2asc_L(adsb[5]);
    adsb_buffer[k++] = hex2asc_H(adsb[6]);
    adsb_buffer[k++] = hex2asc_L(adsb[6]);

	if (adsb_DF() >= 16)
	{
		// die nchsten 56 bit
    	adsb_buffer[k++] = hex2asc_H(adsb[7]);
    	adsb_buffer[k++] = hex2asc_L(adsb[7]);
   		adsb_buffer[k++] = hex2asc_H(adsb[8]);
   		adsb_buffer[k++] = hex2asc_L(adsb[8]);
   		adsb_buffer[k++] = hex2asc_H(adsb[9]);
   		adsb_buffer[k++] = hex2asc_L(adsb[9]);
   		adsb_buffer[k++] = hex2asc_H(adsb[10]);
   		adsb_buffer[k++] = hex2asc_L(adsb[10]);
   		adsb_buffer[k++] = hex2asc_H(adsb[11]);
   		adsb_buffer[k++] = hex2asc_L(adsb[11]);
   		adsb_buffer[k++] = hex2asc_H(adsb[12]);
   		adsb_buffer[k++] = hex2asc_L(adsb[12]);
   		adsb_buffer[k++] = hex2asc_H(adsb[13]);
   		adsb_buffer[k++] = hex2asc_L(adsb[13]);
	}
	adsb_buffer[k++] = ';';

	//#framenummer;
	if (SendFrameNr)
	{
		FrameNr._dword++;
	    adsb_buffer[k++] = '#';
		adsb_buffer[k++] = hex2asc_H(FrameNr.byte3); 
		adsb_buffer[k++] = hex2asc_L(FrameNr.byte3); 
		adsb_buffer[k++] = hex2asc_H(FrameNr.byte2); 
		adsb_buffer[k++] = hex2asc_L(FrameNr.byte2); 
		adsb_buffer[k++] = hex2asc_H(FrameNr.byte1); 
		adsb_buffer[k++] = hex2asc_L(FrameNr.byte1); 
		adsb_buffer[k++] = hex2asc_H(FrameNr.byte0); 
		adsb_buffer[k++] = hex2asc_L(FrameNr.byte0); 
		adsb_buffer[k++] = ';';
	}

   	adsb_buffer[k++] = 0x0A;
  	adsb_buffer[k++] = 0x0D;
  	adsb_buffer[k]   = 0;			// zur sicherheit nullterminieren und auch fuer RS232
	counter2         = k - c2Offset;
}



byte hex2asc_H(byte B)
{
	return ASCII[B>>4];
}


byte hex2asc_L(byte B)
{
	return ASCII[B&0x0F];
}


//adsb[0]..adsb[13]
// 0 = DF
// 1-2   Uref
// 3-4   Usig
// 5-6   Error_Header
// 7-8   Error_Data
// 9-10
// 11 - 13 = 00-00-00

void adsb_heartbeat(void)
{
	adsb[0]  = 23 << 3;		// 10111---

	adsb[1]  = U_ref.byte0;
	adsb[2]  = U_ref.byte1;

	adsb[3]  = U_pegel.byte0;
	adsb[4]  = U_pegel.byte1;

	adsb[5]  = Sum_Error_Hdr.byte0;
	adsb[6]  = Sum_Error_Hdr.byte1;

	adsb[7]  = Sum_Error_Data.byte0;
	adsb[8]  = Sum_Error_Data.byte1;

	adsb[9]  = 0;
	adsb[10] = 0;

	adsb[11] = 0;
	adsb[12] = 0;
	adsb[13] = 0;

	Sum_Error_Data._word = 0;
	Sum_Error_Hdr._word = 0;
}

/** EOF adsbin.c ***************************************************************/
