/******************************************************************************
* PIC USB
* interrupt.c
******************************************************************************/

/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include "system/typedefs.h"
#include "system/interrupt/interrupt.h"
#include "user/user.h"
#include "io_cfg.h"             // I/O pin mapping

/** V A R I A B L E S ********************************************************/

/** I N T E R R U P T  V E C T O R S *****************************************/
// in main.c sind diese Vectoren auskommentiert
#pragma code high_vector=0x808
void interrupt_at_high_vector(void)
{
    _asm goto high_isr _endasm
}
#pragma code

#pragma code low_vector=0x818
void interrupt_at_low_vector(void)
{
    _asm goto low_isr _endasm
}

#pragma code

/** D E C L A R A T I O N S **************************************************/
/******************************************************************************
 * Function:        void high_isr(void)
 * PreCondition:    None
 * Input:
 * Output:
 * Side Effects:
 * Overview:
 *****************************************************************************/
#pragma interrupt high_isr
void high_isr(void)
{
	// per rs232 empfangene daten nach cdc_data_rx maximal 64 bytes
	// und RS232_rx_count incrementieren
	if (PIR1bits.RCIF)
	{
		char fehler    = RCSTA;
		char datenbyte = RCREG;

//		if (fehler && 0x02) RCSTAbits.CREN = 0;
//		else cdc_data_rx[RS232_rx_count++] = datenbyte; 

		cdc_data_rx[RS232_rx_count++] = datenbyte; 

		// zeilenende erreicht?
		if (datenbyte == 0x0D) RS232_rx_EOL = RS232_rx_count;
		if (datenbyte == 0x0A) RS232_rx_EOL = RS232_rx_count;
		if (datenbyte == 0x00) RS232_rx_EOL = RS232_rx_count;

		// primitiver failsave falls eingangspuffer ueberlaeuft
		if (RS232_rx_count>=64) 
		{
			RS232_rx_count = 0;
			RS232_rx_EOL   = 0;
		}

		RCSTAbits.CREN = 1;
		PIR1bits.RCIF  = 0;
	}
}

/******************************************************************************
 * Function:        void low_isr(void)
 * PreCondition:    None
 * Input:
 * Output:
 * Side Effects:
 * Overview:
 *****************************************************************************/
#pragma interruptlow low_isr
void low_isr(void)
{
	;
}
#pragma code

/** EOF interrupt.c **********************************************************/
