	list p=16f628
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 SDATA & TC2 & TC3
;*		1 -WR
;*		2 SCLK & TC0 & TC1 & D2
;*		3 RESET (High active)
;*		4 LOAD
;*		5 -
;*		6 -
;*		7 -
;*
;*	PORTB:	0 LCD Display E
;*		1 			Keyboard 1 4 7 *
;*		2 LCD Display RS	Keyboard 2 5 8 0
;*		3 LCD Display R/W	Keyboard 3 6 9 #
;*		4 LCD Display D4 	---------I I I I
;*		5 LCD Display D5	-----------+ I I
;*		6 LCD Display D6	-------------+ I
;*		7 LCD Display D7	---------------+
;*	
;* es werden nur die Tasten 4, 2, 5, 8, 6 bentigt
;**************************************************************
;
;sprut (zero) Bredendiek 12/2002 
;
; Frequenzgenerator mit AD7008JP50
; D2-Leitung umgelegt
;
; Prozessor 16F628 
;
; Prozessor-Takt 10 MHz
;
; AD7008 am PortA
; LCD & Keyboard am PortB
;
; Frequenzanzeige 10-stellig (hundertstel Herz)
;
; Modes: umschalten durch Taste '5'
;  Frequenz -> Amplitude -> Speichern
;
;
; Menues:
; =========
;
; Anzeige Frequenz:
;  XXXXXXXXXXXXXXXXXX
;  X12 345 678,90 HzX
;  XFrequenz        X
;  XXXXXXXXXXXXXXXXXX
;
; Anzeige Amplitude:
;  XXXXXXXXXXXXXXXXXX
;  X          256 mVX
;  XAmplitude       X
;  XXXXXXXXXXXXXXXXXX
;
; Anzeige Speichern:
;  XXXXXXXXXXXXXXXXXX
;  X<Save   1  Load>X
;  XSpeichern       X
;  XXXXXXXXXXXXXXXXXX
;
;
;
; Bedienung:
; ==========
; Mode		Frequenz		Amplitude		Speichern
;==============================================================================
; Taste 4	F erhhen		Amplitude+16		Speicherplatz+1
; Taste 6	F verringern		Amplitude-16		Speicherplatz-1
; Taste 2	Kursor links		Amplitude/2		speichern
; Taste 8	Kursor rechts		Amplitude*2		laden
; Taste 5	Amplitudenmenue		Speichernmenue		Frequenzmenue
;
;**********************************************************
; Includedatei fr den 16F628 einbinden

	#include <P16f628.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES


; Configuration festlegen:
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming
	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC & _BODEN_OFF & _LVP_OFF



; Variablen festlegen

;w_copy		Equ	0x20	; nur fr INT
;s_copy		Equ	0x21	; nur fr INT
pr0		equ	0x22	; Phasenregister LSD
pr1		equ	0x23	; Phasenregister 
pr2		equ	0x24	; Phasenregister 
pr3		equ	0x25	; Phasenregister MSD
buf0		equ	0x26	; puffer fr WrSer LSD
buf1		equ	0x27	; puffer fr WrSer 
buf2		equ	0x28	; puffer fr WrSer 
buf3		equ	0x29	; puffer fr WrSer MSD
buf		equ	0x2A	; puffer frs serielle schieben
count		equ	0x2B	; universeller zhler
loops		equ	0x2C	; timer fr wait
loops2		equ	0x2D	; timer fr wait
LcdStatus	equ	0x2E	;
LcdDaten	equ	0x2F	;
Taste		equ	0x30	; Tastaturpuffer
Kursor		equ	0x31	; Kursorposition 0..9
; 64-Bit Rechenregister
xw0		EQU	0x32	;LSB
xw1		EQU	0x33	; I 
xw2		EQU	0x34	; I 
xw3		EQU	0x35	;MSB 32
xw4		EQU	0x36	; I 
xw5		EQU	0x37	; I 
xw6		EQU	0x38	; I 
xw7		EQU	0x39	;MSB 64
; 64-Bit Rechenregister
f0		EQU	0x3A	;LSB
f1		EQU	0x3B	; I 
f2		EQU	0x3C	; I 
f3		EQU	0x3D	;MSB 32
f4		EQU	0x3E	; I 
f5		EQU	0x3F	; I 
f6		EQU	0x40	; I 
f7		EQU	0x41	;MSB 64

Fehler		equ	0x42	; Fehlerregister fr Mathematik
Temp		equ	0x43

; Dezimalstellen
HdB		EQU	0x44	;10 Milliarden
HdHM		EQU	0x45	;9  HundertMillionen
HdZM		EQU	0x46	;8  ZehnMillionen
HdM		EQU	0x47	;7  Millionen
HdHT		EQU	0x48	;6  Hunderttausender
HdZT		EQU	0x49	;5  Zehntausender
HdT		EQU	0x4A	;4  Tausender
HdH		EQU	0x4B	;3  Hunderter
HdZ		EQU	0x4C	;2  Zehner
HdE		EQU	0x4D	;1  Einer
HdX		EQU	0x4E	; Puffer fr eine Dezimalstelle

BcdDaten	equ	0x4F
BcdDaten1	equ	0x50
EEWriteData	equ	0x51
MenueMode	equ	0x52	; 0=Frequenz,  1=Amplitude, 2=Speichern
StoNo		equ	0x53

; IQregister
iq0		equ	0x54	; Cos-Amplitude 7654 3210
iq1		equ	0x55	; Cos-Amplitude ---- --98 / Sin-Amplitude 5432 10--
iq2		equ	0x56	; Sin-Amplitude ---- 9876
Amplitude	equ	0x57	; 8-Bit Amplitude fr COS, 0=0mV, 64=1024 mV

; Konstanten festlegen
; fr AD7008-Pins
#define	SCLK	PORTA,2		; serial clock
#define	SDATA	PORTA,0		; serial Data
#define	RESET	PORTA,3		; AD7008-Reset
#define	AdWR	PORTA,1		; write to AD7008 parallel
#define	LOAD	PORTA,4		; puffer in Register transferieren
#define	D2	PORTA,2		; umgeltet um I,Q-Register adressieren zu knnen	
#define	TC0	PORTA,2
#define	TC1	PORTA,2
#define	TC2	PORTA,0
#define	TC3	PORTA,0
; fr LCD-Pins
#define	LcdE	PORTB,0		; enable Lcd
#define	LcdRw	PORTB,3		; read Lcd
#define	LcdRs	PORTB,2		; Daten Lcd (nicht control)	
#define LcdPort PORTB		; Datenbus des LCD (obere 4 Bit)
; fr Tastatur-Anschlu
#define	KRow1	PORTB,1		;Keyboard 1 4 7 *
#define	KRow2	PORTB,2		;Keyboard 2 5 8 0
#define	KRow3	PORTB,3		;Keyboard 3 6 9 #
#define	KLine1	PORTB,4		;Keyboard 1 2 3
#define	KLine2	PORTB,5		;Keyboard 4 5 6
#define	KLine3	PORTB,6		;Keyboard 7 8 9
#define	KLine4	PORTB,7		;Keyboard * 0 #


Ini_con Equ	B'00000000'	; TMR0 -> Interupt disable
Ini_opt	Equ	B'00000010'	; pull-up

;voreingestellte Frequenzen
	org	H'2100'		;EEPROM
	de	0x8C		; 00 01 4F 8C = 1 kHz
	de	0x4F
	de	0x01
	de	0x00
	de	D'64'		;max Amplitude
	org	H'2108'
	de	0x72		; 00 0D 1B 72 = 10 kHz
	de	0x1B
	de	0x0D
	de	0x00
	de	D'64'		;max Amplitude
	org	H'2110'
	de	0x6F		; 00 83 12 6F = 100 kHz
	de	0x12
	de	0x83
	de	0x00
	de	D'64'		;max Amplitude
	org	H'2118'
	de	0x52		; 05 1E B8 52 = 1 MHz
	de	0xB8
	de	0x1E
	de	0x05
	de	D'64'		;max Amplitude

	org	0
	goto	Init

TxtSto	dt	"Save      Loa",'d'+80h		; RETLW
TxtFrq	dt	"Frequenz ",' '+80h		; RETLW
TxtAmp	dt	"Amplitude",' '+80h		; RETLW
TxtStor	dt	"Speichern",' '+80h		; RETLW
TxtErr	dt	"Fehler   ",' '+80h		; RETLW
Txt8Bl	dt	"       ",' '+80h		; RETLW
Txt001	dt	"DDS-Oszillator",' '+80h	; RETLW
Txt002	dt	"Vers. 1.01",' '+80h		; RETLW


;********************************************************
; Das Programm beginnt mit der Initialisierung

Init	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up on
	movwf   OPTION_REG 
	movlw	B'00000000'	; PortB alle outputs 
	movwf	TRISB
	movlw	B'00000000'	; PortA alle outputs 
	movwf	TRISA
	bcf     STATUS, RP0	; Bank 0
	clrf	PORTA		
	clrf	PORTB		
	movlw   Ini_con     	; Interupt disable
	movwf   INTCON   

; 16F628 alle Comparatoreingnge auf Digital umschalten
	BSF	CMCON, CM0
	BSF	CMCON, CM1
	BSF	CMCON, CM2

;Display initialisieren
	call	InitLcd
	movlw	Txt001-1	; Name
	call	Write	
	movlw	B'11000000'	; 2. Zeile
	call	OutLcdControl
	movlw	Txt002-1	; Version
	call	Write
	movlw	D'255'		; 0,75 Sekunden anzeigen
	movwf	loops
	call	WAIT
	movlw	D'255'
	movwf	loops
	call	WAIT
	movlw	D'255'
	movwf	loops
	call	WAIT

;Reset AD7008
	bsf	AdWR
	nop
	bsf	RESET
	nop
	bcf	RESET

;Command schreiben amplitude modulation
	bsf	D2
	bcf	AdWR
	nop
	bsf	AdWR

	bcf	TC3
	bcf	TC2
	bcf	LOAD
	bsf	LOAD
	bcf	LOAD

;letzten Wert aus EEPROM lesen
	clrw
	call	GetEEPROM		; Speicherplatz 0 lesen
	call	FREQ0			; Frequenz zum AD7008
	call	IQMOD			; Amplitude zum AD7008

	clrf	StoNo
	incf	StoNo, f		; Speicher auf 1 stellen

	clrf	MenueMode		; Frequenzmenue
	movlw	4			; Kursor auf kHz-Stelle
	movwf	Kursor
	call	FrqDisplay

mainloop
	call	Tastfrei
	call	WAIT			; Entprellen bei schlechten Schaltern
drueck
	call	Tastatur
	movfw	Taste
	btfsc	STATUS, Z		; 
	goto	drueck			; keine Taste gedrckt

	movlw	'5'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	KMenue			; Menue

	movfw	MenueMode		; welche Tastenroutine?
	btfsc	STATUS, Z
	goto	FrqKeys			; Frequenz
	movwf	Temp
	decf	Temp, f
	btfsc	STATUS, Z
	goto	AmpKeys			; Amplitude
	decf	Temp, f
	btfsc	STATUS, Z
	goto	StoKeys			; Speichern
	goto	FrqDisplay		; Failsave

FrqKeys
	movlw	'4'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	FKUp			; erhhen
	movlw	'6'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	FKDown			; verringern
	movlw	'2'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	FKLeft			; Kursor links
	movlw	'8'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	FKRight			; Kursor right

	goto	mainloop

AmpKeys
	movlw	'4'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	AKUp			; Amplitude erhhen
	movlw	'6'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	AKDown			; Amplitude verringern
	movlw	'8'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	AK2Up			; Amplitude verdoppeln
	movlw	'2'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	AK2Down			; Amplitude halbieren

	goto	mainloop

; Kursortasten zur Frequenzeinstellung
; Kursor nach rechts, zur niederwertigen Stelle
FKRight
	movfw	Kursor
	sublw	9
	btfsc	STATUS, Z
	goto	mainloop	; Kursor ist schon 9
	incf	Kursor, f
	call	Display
	goto	mainloop

; Kursor nach links, zur hherwertigen Stelle
FKLeft
	movf	Kursor, f
	btfsc	STATUS, Z
	goto	mainloop	; Kursor ist schon 0
	decf	Kursor, f
	call	Display
	goto	mainloop

; Frequenz erhhen
FKUp
	call	DfNachXw	; xw:=offset
	movfw	pr0		; f:=pr
	movwf	f0
	movfw	pr1
	movwf	f1
	movfw	pr2
	movwf	f2
	movfw	pr3
	movwf	f3
	call	Add32		; f:=f+xw
	movfw	f0		; pr:=f
	movwf	pr0
	movfw	f1
	movwf	pr1
	movfw	f2
	movwf	pr2
	movfw	f3
	movwf	pr3
	call	FREQ0		; pr an AD7008
	call	FrqDisplay	; pr Anzeigen
	goto	mainloop

; Frequenz verringern
FKDown
	call	DfNachXw
	movfw	pr0
	movwf	f0
	movfw	pr1
	movwf	f1
	movfw	pr2
	movwf	f2
	movfw	pr3
	movwf	f3
	call	Sub32
	movfw	f0		; pr:=f
	movwf	pr0
	movfw	f1
	movwf	pr1
	movfw	f2
	movwf	pr2
	movfw	f3
	movwf	pr3
	call	FREQ0
	call	FrqDisplay
	goto	mainloop

; Tastaturroutinen fr Speichern und Laden von Werten aus EEPROM
StoKeys
	movlw	'4'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	SKUp		; StoNo erhhen
	movlw	'6'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	SKDown		; StoNo verringern
	movlw	'2'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	SKLeft		; Speichern
	movlw	'8'
	subwf	Taste, w
	btfsc	STATUS, Z
	goto	SKRight		; Laden
	goto	mainloop

SKUp				; StoNo erhhen
	incf	StoNo, f
	movlw	0x03
	andwf	StoNo, f
	btfsc	STATUS, Z
	bsf	StoNo, 0	; auf 1 setzen
	call	Display
	goto	mainloop

SKDown				; StoNo verringern
	decf	StoNo, f
	btfss	STATUS, Z	
	goto	SKDown1
	movlw	3
	movwf	StoNo
SKDown1	call	Display
	goto	mainloop

SKLeft				; Save
	movfw	StoNo
	call	PutEEPROM
	clrw
	call	PutEEPROM
	clrf	MenueMode	; zur Frequenzanzeige
	call	Display
	goto	mainloop

SKRight	
	movfw	StoNo
	call	GetEEPROM	; Load
	call	FREQ0		; Frequenz  an AD7008 bertragen
	call	IQMOD		; Amplitude an AD7008 bertragen
	clrf	MenueMode	; zur Frequenzanzeige
	call	Display
	goto	mainloop

KMenue
	incf	MenueMode, f
	movlw	0x03
	subwf	MenueMode, w
	btfsc	STATUS, Z
	clrf	MenueMode	; rundherum
	call	Display
	goto	mainloop

; Tastaturroutinen fr Amplitudenregelung
AKUp				; Amplitude erhhen
	incf	Amplitude, f
	;mu auf 64 begrenzt werden
	movlw	B'11000000'
	andwf	Amplitude, w
	btfss	STATUS, Z	; >=64?
	goto	AKMax		; Ampl.=64
	call	IQMOD
	call	Display
	goto	mainloop
AKDown				; Amplitude verringern
	movf	Amplitude, f	; Test auf 0
	btfsc	STATUS, Z
	goto	mainloop	; ist schon 0
	decf	Amplitude, f
	call	IQMOD
	call	Display
	goto	mainloop
AK2Up				; Amplitude verdoppeln
	bcf	STATUS, C
	rlf	Amplitude, f
	;mu auf 64 begrenzt werden
	movlw	B'11000000'
	andwf	Amplitude, w
	btfss	STATUS, Z	; >=64?
	goto	AKMax		; Ampl.=64
	call	IQMOD
	call	Display
	goto	mainloop
AK2Down				; Amplitude halbieren
	bcf	STATUS, C
	rrf	Amplitude, f
	call	IQMOD
	call	Display
	goto	mainloop

AKMax	movlw	D'64'
	movwf	Amplitude
	call	IQMOD
	call	Display
	goto	mainloop


;zum Aktuellen Anzeigeprogramm FrqDisplay AmpDisplay StoDisplay 
Display	
	movfw	MenueMode
	btfsc	STATUS, Z
	goto	FrqDisplay	; Frequenz
	movwf	Temp
	decf	Temp, f
	btfsc	STATUS, Z
	goto	AmpDisplay	; Frequenz
	decf	Temp, f
	btfsc	STATUS, Z
	goto	StoDisplay	; Speichern
	goto	FrqDisplay

;*****************************************************
;Anzeigen des Menues in der 2. Zeile
;0 - Frequenz
;1 - Amplitude

;mark	nop
;	org	(mark | 0xFF)+1
MenueText
	movlw	B'11000000'	; Sprung zur  2. Zeile
	call	OutLcdControl	; Sprung zur  2. Zeile

	movfw	MenueMode
	movwf	Temp
	incf	Temp, f

	movlw	TxtFrq-1	; 0: "Frequenz"
	decf	Temp, f
	btfsc	STATUS, Z
	goto	Write		; Ausgabe Frequenz

	movlw	TxtAmp-1	; 1: "Amplitude"
	decf	Temp, f
	btfsc	STATUS, Z
	goto	Write		; Ausgabe Amplitude

	movlw	TxtStor-1	; 2: "Speichern"
	decf	Temp, f
	btfsc	STATUS, Z
	goto	Write		; Ausgabe Speichern

	movlw	TxtErr-1	; "Fehler"
	goto	Write		; Ausgabe Fehler

	return			; Failsave

;*********************************************************************
;* Write
;* Ausgabe eines Strings der ab W+1 im Speicher steht
;* Note: Endekennzeichen ist Zeichen mit Bit 7 = 1
;*
;* Input : W zeigt auf String-1 (RETLWs)
;*********************************************************************
Write 
	movwf	Temp		; Temp = Pointer
GoWrite	
	call	PclSub2		; Pointer erhhen und nchstes Zeichen lesen
	addlw	80h		; ist Bit 7 gesetzt? EOT
	btfsc	STATUS,C
	goto	OutLcdDaten	; letztes Zeichen
	andlw	7fh		; zeichen wieder herstellen
	call	OutLcdDaten	; Ausgabe
	goto	GoWrite	

PclSub2
	incf	Temp, F		; Pointer auf nchstes Zeichen
	movf	Temp, W		; Pointer nach W
	movwf	PCL		; Sprung zur Addresse auf die PCLATH,W zeigt

;*****************************************************
;Anzeigen des Amplitudenmenues
AmpDisplay
	call	MenueText
	movlw	B'00001110'	; Kursor an , Blinken aus
	call	OutLcdControl
	movlw	B'00000011'	; kursor home
	call	OutLcdControl

	movlw	Txt8Bl-1	; "        " 
	call	Write

	movfw	Amplitude
	movwf	f0
	clrf	f1

	; Amplitude geht von 0 bis 64, Anzeige von 0..1024
	bcf	STATUS, C	; X 16
	rlf	f0, f
	rlf	f1, f
	bcf	STATUS, C
	rlf	f0, f
	rlf	f1, f
	bcf	STATUS, C
	rlf	f0, f
	rlf	f1, f
	bcf	STATUS, C
	rlf	f0, f
	rlf	f1, f

	call	OutDez16
	movlw	' '
	call	OutLcdDaten
	movlw	'm'
	call	OutLcdDaten
	movlw	'V'
	call	OutLcdDaten

	return


;*****************************************************
;Anzeigen des Speichermenues
StoDisplay
	call	MenueText
	movlw	B'00001110'	; Kursor an , Blinken aus
	call	OutLcdControl
	movlw	B'00000011'	; kursor home
	call	OutLcdControl
	movlw	B'01111111'	; <
	call	OutLcdDaten
	movlw	TxtSto-1	; "Load Save"
	call	Write
	movlw	B'01111110'	; >
	call	OutLcdDaten

	movlw	B'10001000'	; Sprung zur  8.Stelle
	call	OutLcdControl	; 
	movfw	StoNo
	iorlw	'0'
	call	OutLcdDaten
	movlw	B'10001000'	; Sprung zur  8.Stelle
	call	OutLcdControl	; 

	return



; Anzeige:
;XX XXX XXX,XX Hz;
;Frequenz        ;

; eintragen der aktuellen Differenzfrequenz je nach Kursorposition in xw3..xw0

;  10 MHz - 858993459 d - 33 33 33 33 h - Kursor: 0
;   1 MHz - 85899346 d  - 05 1E B8 52 h - Kursor: 1
; 100 kHz - 8589935 d   - 00 83 12 6F h - Kursor: 2
;  10 kHz - 858994 d    - 00 0D 1B 72 h - Kursor: 3
;   1 kHz - 85900 d     - 00 01 4F 8C h - Kursor: 4
; 100  Hz - 8590 d      - 00 00 21 8E h - Kursor: 5
;  10  Hz - 859 d       - 00 00 03 5B h - Kursor: 6
;   1  Hz - 86 d        - 00 00 00 56 h - Kursor: 7
; 0,1  Hz - 9 d         - 00 00 00 09 h - Kursor: 8
;0,01  Hz - 1 d         - 00 00 00 01 h - Kursor: 9
  
DfNachXw
	movlw	0x00
	movwf	xw0
	movwf	xw1
	movwf	xw2
	movwf	xw3
	movfw	Kursor
	btfsc	STATUS, Z	;Kursor = 0 ?	DEBUG
	goto	Df10MHz		; ja
	movwf	Temp
	decf	Temp, f
	btfsc	STATUS, Z	;Kursor = 1 ?
	goto	Df1MHz		; ja
	decf	Temp, f
	btfsc	STATUS, Z	;Kursor = 2 ?
	goto	Df100kHz		; ja
	decf	Temp, f
	btfsc	STATUS, Z	;Kursor = 3 ?
	goto	Df10kHz		; ja
	decf	Temp, f
	btfsc	STATUS, Z	;Kursor = 4 ?
	goto	Df1kHz		; ja
	decf	Temp, f
	btfsc	STATUS, Z	;Kursor = 5 ?
	goto	Df100Hz		; ja
	decf	Temp, f
	btfsc	STATUS, Z	;Kursor = 6 ?
	goto	Df10Hz		; ja
	decf	Temp, f
	btfsc	STATUS, Z	;Kursor = 7 ?
	goto	Df1Hz		; ja
	decf	Temp, f
	btfsc	STATUS, Z	;Kursor = 8 ?
	goto	Df01Hz		; ja
	goto	Df001Hz		; 9

Df10MHz
	; 10 MHz	33 33 33 33
	movlw	0x33
	movwf	xw0
	movwf	xw1
	movwf	xw2
	movwf	xw3
	return	
Df1MHz
	; 1 MHz		05 1E B8 52
	movlw	0x52
	movwf	xw0
	movlw	0xB8
	movwf	xw1
	movlw	0x1E
	movwf	xw2
	movlw	0x05
	movwf	xw3
	return
Df100kHz
	; 100 kHz	00 83 12 6F
	movlw	0x6F
	movwf	xw0
	movlw	0x12
	movwf	xw1
	movlw	0x83
	movwf	xw2
	return
Df10kHz
	; 10 kHz	00 0D 1B 72
	movlw	0x72
	movwf	xw0
	movlw	0x1B
	movwf	xw1
	movlw	0x0D
	movwf	xw2
	return
Df1kHz
	; 1 kHz		00 01 4F 8C
	movlw	0x8C
	movwf	xw0
	movlw	0x4F
	movwf	xw1
	movlw	0x01
	movwf	xw2
	return
Df100Hz
	; 100 Hz	00 00 21 8E
	movlw	0x8E
	movwf	xw0
	movlw	0x21
	movwf	xw1
	return
Df10Hz
	; 10 Hz		00 00 03 5B
	movlw	0x5B
	movwf	xw0
	movlw	0x03
	movwf	xw1
	return
Df1Hz
	; 1 Hz		00 00 00 56
	movlw	0x56
	movwf	xw0
	return
Df01Hz
	; 0,1 Hz	00 00 00 09
	movlw	0x09
	movwf	xw0
	return
Df001Hz
	; 0,01 Hz	00 00 00 01
	movlw	0x01
	movwf	xw0
	return


;*****************************************************
;Anzeigen der Frequenz und des Kursors
FrqDisplay
	call	MenueText
	movlw	B'00001110'	; Kursor an , Blinken aus
	call	OutLcdControl
	movlw	B'00000011'	; kursor home
	call	OutLcdControl

	call	pr2f		; Frequenz aus pr errechnen

	movlw	B'00000011'	; kursor home
	call	OutLcdControl
	movfw	Kursor
	btfsc	STATUS, Z
	return			; Kursor 0
	movwf	Temp
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl
	decf	Temp, f
	btfsc	STATUS, Z
	return			; Kursor 1
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl

	decf	Temp, f
	btfsc	STATUS, Z
	return			; Kursor 2
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl

	decf	Temp, f
	btfsc	STATUS, Z
	return			; Kursor 3
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl

	decf	Temp, f
	btfsc	STATUS, Z
	return			; Kursor 4
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl

	decf	Temp, f
	btfsc	STATUS, Z
	return			; Kursor 5
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl

	decf	Temp, f
	btfsc	STATUS, Z
	return			; Kursor 6
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl

	decf	Temp, f
	btfsc	STATUS, Z
	return			; Kursor 7
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl

	decf	Temp, f
	btfsc	STATUS, Z
	return			; Kursor 8
	movlw	B'00010100'	; kursor 1 Stelle nach rechts
	call	OutLcdControl

	return			; Kursor 9

;*****************************************************
;*** AD7008-Routinen *********************************
;*****************************************************
;phasenregister nach FREQ0 schreiben
; 345 Takte
FREQ0
	movfw	pr0
	movwf	buf0
	movfw	pr1
	movwf	buf1
	movfw	pr2
	movwf	buf2
	movfw	pr3
	movwf	buf3
	call	WrSer
	bcf	TC0
	bcf	TC1
	bsf	TC2
	bsf	TC3
	bcf	LOAD
	bsf	LOAD
	bcf	LOAD
	return
;*****************************************************
;IQregister nach IQMOD schreiben
; 345 Takte
IQMOD
	movfw	Amplitude
	movwf	iq0
	clrf	iq1
	clrf	iq2
	bcf	STATUS, C
	rlf	iq0, f
	rlf	iq1, f
	rlf	iq0, f
	rlf	iq1, f
	
	movfw	iq0
	movwf	buf0
	movfw	iq1
	movwf	buf1
	movfw	iq2
	movwf	buf2
	clrf	buf3
	call	WrSer
	bsf	TC0
	bsf	TC1
	bsf	TC2
	bsf	TC3
	bcf	LOAD
	bsf	LOAD
	bcf	LOAD
	return

;*****************************************************
;32 Bit auf buf0..buf3 in AD7008 schieben (MSB first)
; 326 Takte
WrSer
	movfw	buf3
	call	WrSerW
	movfw	buf2
	call	WrSerW
	movfw	buf1
	call	WrSerW
	movfw	buf0
	call	WrSerW
	return

;schiebt das Byte aus W in den AD7008
; 78 Takte
WrSerW
	movwf	buf
	movlw	8
	movwf	count
WrSerW1
	bcf	SCLK
	bcf	SDATA
	rlf	buf,f
	btfsc	STATUS,C	; 0?
	bsf	SDATA		; nein, 1
	bsf	SCLK
	decfsz	count,f
	goto	WrSerW1

	bcf	SCLK		; abschlieend Takt low	
	return


;*****************************************************************	
;Zeitverzgerung um loops * 1 ms
; 10 MHz externer Takt bedeutet 2,5 MHz interner Takt
; also dauert 1 ms genau 2500 Befehle
; 250 Schleifen a 10 Befehle sind 2500 Befehle = 1 ms

WAIT
top     movlw   .250           ; timing adjustment variable (1ms)
        movwf   loops2
top2    nop                    ; sit and wait
        nop
        nop
        nop
	nop
        nop
        nop
        decfsz  loops2, F      ; inner loops complete?
        goto    top2           ; no, go again
                               ;
        decfsz  loops, F       ; outer loops complete?
        goto    top            ; no, go again
        retlw   0              ; yes, return from subWAIT


;*****************************************************
;+++LCD-Routinen**************************************
;*****************************************************
;LCD initialisieren, Begrung ausgeben

InitLcd
	movlw	D'255'		; 250 ms Pause nach dem Einschalten
	movwf	loops	
	call	WAIT		

	movlw	B'00110000'	; 1
	movwf	LcdPort
	bsf	LcdE
	nop	
	bcf	LcdE
	
	movlw	D'50'		; 50 ms Pause
	movwf	loops
	call	WAIT
	
	movlw	B'00110000'	; 2
	call	Control8Bit
	movlw	B'00110000'	; 3
	call 	Control8Bit
	movlw	B'00100000'	; 4
	call 	Control8Bit

	movlw	B'00000001'	; lschen und cusor home
	call	OutLcdControl	
	movlw	B'00101000'	; 5 function set, 4-bit  2-zeilig,  5x7
	call	OutLcdControl	
	movlw	B'00001000'	; 6 display off
	call	OutLcdControl
	movlw	B'00000110'	; 7 entry mode, increment, disable display-shift
	call	OutLcdControl
	movlw	B'00000011'	; 8 cursor home, cursor home
	call	OutLcdControl
	movlw	B'00001111'	; 9 display on
	call	OutLcdControl
	return

;*****************************************************
; ein Steuerbyte 8-bittig bertragen
Control8Bit
	movwf	LcdPort
	bsf	LcdE
	nop
	bcf	LcdE
	movlw	D'10'
	movwf	loops
	call 	WAIT
	return

;*****************************************************
; darauf warten, da das Display bereit zur Datenannahme ist
LcdBusy
        bsf     STATUS, RP0	; make Port B4..7 input
	movlw	B'11110000'
	iorwf   TRISB, f 
        bcf     STATUS, RP0
BusyLoop		
	bcf	LcdRs
	bsf	LcdRw		; Lesen
	bsf	LcdE
	nop
	movf	LcdPort, w
	movwf	LcdStatus
	bcf	LcdE
	nop
	bsf	LcdE		; Enable
	nop
	bcf	LcdE
	btfsc	LcdStatus, 7	; teste bit 7
	goto	BusyLoop
	bcf	LcdRw
        bsf     STATUS, RP0	; make Port B4..7 output
	movlw	B'00001111'
	andwf   TRISB, f    
        bcf     STATUS, RP0
	return	

;*****************************************************
; aus W ein Byte mit Steuerdaten zum Display bertragen
OutLcdControl
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	LcdPort		; Hi-teil Daten schreiben
	bsf	LcdE
	nop
	bcf	LcdE		; Disable LcdBus
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	LcdPort		; Lo-teil Daten schreiben
	bsf	LcdE
	nop
	bcf	LcdE		; Disable LcdBus
	return

;*****************************************************
; aus W ein Datenbyte zum Display bertragen
OutLcdDaten
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	LcdPort		; Hi-teil Daten schreiben
	bsf	LcdRs		; Daten
	bsf	LcdE		; Enable LcdBus
	nop
	bcf	LcdE		; Disable LcdBus	
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	LcdPort		; Lo-teil Daten schreiben
	bsf	LcdRs		; Daten
	bsf	LcdE
	nop
	bcf	LcdE		; Disable LcdBus	
	bcf	LcdRs		;
	return

;*******************************************************************************
; String ' Hz' am LCD ausgeben
OutHz
	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'H'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'z'
	movwf	LcdDaten
	call	OutLcdDaten
	return


;*****************************************************
;+++Tastatur-Routinen*********************************
;*****************************************************
; warten darauf, da keine Taste mehr gedrckt ist

Tastfrei			;Warten auf freie Tastatur
	call	Tastatur
	movfw	Taste
	btfss	STATUS, Z
	goto	Tastfrei
	return

;*****************************************************
; ist eine Taste gedrckt? und welche?

;#define	KRow1	PORTB,1		;Keyboard 1 4 7 *
;#define	KRow2	PORTB,2		;Keyboard 2 5 8 0
;#define	KRow3	PORTB,3		;Keyboard 3 6 9 #
;#define	KLine1	PORTB,4		;Keyboard 1 2 3
;#define	KLine2	PORTB,5		;Keyboard 4 5 6
;#define	KLine3	PORTB,6		;Keyboard 7 8 9
;#define	KLine4	PORTB,7		;Keyboard * 0 #

Tastatur			; Tastencode nach Taste
				; wenn keine Taste gedrckt dann Taste=0
	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up Widerstnde ein
	movwf   OPTION_REG 
	movlw	B'11110000'	; RB0 .. RB3 output, RB4 .. RB7 input
	movwf	TRISB
	bcf     STATUS, RP0	; Bank 0
	clrf	PORTB		; Display inaktiv am Bus

	movlw	0		; W=0

	bcf	KRow1
	bsf	KRow3
	bsf	KRow2

	call	key1		; 1. Spalte abfragen

	bcf	KRow2
	bsf	KRow1

	call	key2		; 2. Spalte

	bcf	KRow3
	bsf	KRow2

	call	key3		; 3. Spalte
	
	bsf	KRow3
	movwf	Taste

	bsf     STATUS, RP0	; Bank 1
	movlw	B'00000000'	; RB1 .. RB7 output
	movwf	TRISB
	bcf     STATUS, RP0	; Bank 0
	return

key1
	btfss	KLine1
	retlw	'1'
	btfss	KLine2
	retlw	'4'
	btfss	KLine3
	retlw	'7'
	btfss	KLine4
	retlw	'*'
	return
key2
	btfss	KLine1
	retlw	'2'
	btfss	KLine2
	retlw	'5'
	btfss	KLine3
	retlw	'8'
	btfss	KLine4
	retlw	'0'
	return
key3
	btfss	KLine1
	retlw	'3'
	btfss	KLine2
	retlw	'6'
	btfss	KLine3
	retlw	'9'
	btfss	KLine4
	retlw	'#'
	return


;*****************************************************
;+++Mathematik-Routinen*******************************
;*****************************************************

; 32 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub32				; 32 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen    

	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    sb0
	movlw   0x01		; borgen von f1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb0
	subwf   f2    ,f        ; borgen von f2

	btfsc   STATUS,C
	goto    sb0
	subwf   f3    ,f        ; borgen von f3
	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf

sb0     movf    xw1, w		; f1=f1-xw1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb1
	movlw   0x01		; borgen von f2
	subwf   f2    ,f

	btfsc   STATUS,C
	goto    sb1
	subwf   f3, f		; borgen von f3

        btfss   STATUS,C
	bsf	Fehler, C	; Unterlauf

sb1     movf    xw2,w		; f2=f2-xw2
        subwf   f2, f

        btfsc   STATUS,C
        goto    sb2
        movlw   0x01		
        subwf   f3, f		; borgen von f3

        btfss   STATUS,C
       	bsf	Fehler, C	; Unterlauf

sb2     movf    xw3,w		; f3=f3-xw3
        subwf   f3    ,f

        btfss   STATUS,C
 	bsf	Fehler, C	; Unterlauf

	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return

;32 bit Adition, C-Flag bei berlauf gesetzt
;*********************************************************************
;* Add4
;* Add xw (32-byte value) to f (32-byte value). 4-instr. groups
;* (movf-btfsc-incfsz-addwf) used instead of non-existing ADD W/ CARRY.
;* Input variables: f (32-bit value), xw (32-bit value)
;* Output variables: f (32-bit value), 33th bit in STATUS,C
;*********************************************************************
Add32 				; 32-bit add: f = f + xw
	movf	xw0,W		; low byte
	addwf	f0,F 		; low byte add

	movf	xw1,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,W 		; add C if it was set
	addwf	f1,F 		; next byte add if NZ
	
	movf	xw2,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw2,W 		; add C if it was set
	addwf	f2,F 		; next byte add if NZ
	
	movf	xw3,W 		; high byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw3,W 		; add C if it was set
	addwf	f3,F 		; high byte add if NZ
	
	return 			; finished

Add64 				; 64-bit add: f = f + xw
	movf	xw0,W		; low byte
	addwf	f0,F 		; low byte add

	movf	xw1,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,W 		; add C if it was set
	addwf	f1,F 		; next byte add if NZ
	
	movf	xw2,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw2,W 		; add C if it was set
	addwf	f2,F 		; next byte add if NZ

	movf	xw3,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw3,W 		; add C if it was set
	addwf	f3,F 		; next byte add if NZ

	movf	xw4,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw4,W 		; add C if it was set
	addwf	f4,F 		; next byte add if NZ

	movf	xw5,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw5,W 		; add C if it was set
	addwf	f5,F 		; next byte add if NZ

	movf	xw6,W 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw6,W 		; add C if it was set
	addwf	f6,F 		; next byte add if NZ
	
	movf	xw7,W 		; high byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw7,W 		; add C if it was set
	addwf	f7,F 		; high byte add if NZ
	
	return 			; finished

;*******************************************************************************
;Multiplikation: 64-Bit x 5	f:=f*5
Mal5
	movfw	f0		; xw:=f
	movwf	xw0
	movfw	f1
	movwf	xw1
	movfw	f2
	movwf	xw2
	movfw	f3
	movwf	xw3
	movfw	f4
	movwf	xw4
	movfw	f5
	movwf	xw5
	movfw	f6
	movwf	xw6
	movfw	f7
	movwf	xw7

	call	Add64		; f:=2f
	call	Add64		; f:=3f
	call	Add64		; f:=4f
	call	Add64		; f:=5f
	return

;*******************************************************************************
;Umrechnung aus Phasenincrement in frequenz*100 (hundetstel Herz)
; f:= pr * 50 000 000 / 2@32 = pr *5@10 / 2@23
pr2f	
	movfw	pr0		; f:=pr
	movwf	f0	
	movfw	pr1
	movwf	f1	
	movfw	pr2
	movwf	f2	
	movfw	pr3
	movwf	f3
	movlw	0
	movwf	f4
	movwf	f5
	movwf	f6
	movwf	f7

	; 23 x Durch2
	;  10 x Mal5

	call	Mal5
	call	Mal5
	call	Mal5
	call	Mal5
	call	Mal5
	call	Mal5
	call	Mal5
	call	Mal5
	call	Mal5
	call	Mal5

	; msb in f2 retten, wird lsb des ergebnisses
	movfw	f2
	movwf	Temp

	; 24 x durch 2
	movfw	f3
	movwf	f0
	movfw	f4
	movwf	f1
	movfw	f5
	movwf	f2
	movfw	f6
	movwf	f3
	movfw	f7
	movwf	f4

	; 1 x mal 2
	bcf	STATUS,C
	rlf	f0, f
	rlf	f1, f
	rlf	f2, f
	rlf	f3, f
	rlf	f4, f

	; LSB eintragen
	btfsc	Temp,7
	bsf	f0,0

;Binr zu ASCII Wandlung mit Ausgabe
	call	OutDez32	; 'xx xxx xxx.xx'
	call	OutHz		; ' Hz'

	return


;***********************************************************
; 32 Bit Wert (f3,f2,f1,f0) auf LCD dezimal 10stellig anzeigen
; dabei fhrende Nullen unterdrcken
OutDez32			;32-bit (f3,f2,f1,f0) als Dez zum Lcd
	call	Hex2Dez32	;32 Bit to BCD
	clrf	Fehler		; Leading0 vorbereiten

	movfw	HdB		; 1 000 000 000 = 10 000 000
	Call	Leading0
	movfw	HdHM		;   100 000 000 =  1 000 000
	Call	Leading0

	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten

	movfw	HdZM		;    10 000 000 =    100 000
	Call	Leading0
	movfw	HdM		;     1 000 000 =     10 000
	Call	Leading0
	movfw	HdHT		;       100 000 =      1 000
	Call	Leading0

	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten

	movfw	HdZT		;  10 000 = 100
	Call	Leading0
	movfw	HdT		;   1 000 =  10
	Call	Leading0
	movfw	HdH		;     100 =   1
	Call	Bcd4Bit

	movlw	','
	movwf	LcdDaten
	call	OutLcdDaten

	movfw	HdZ		;  10 = 0,1
	Call	Bcd4Bit
	movfw	HdE		;   1 = 0,01
	Call	Bcd4Bit
	return

Leading0
	iorwf	Fehler, f
	movf	Fehler, f	; Test auf 0
	btfss	STATUS, Z	; bisher alles '0'
	goto	Bcd4Bit		; nein
	movlw	' '		; ja
	movwf	LcdDaten
	goto	OutLcdDaten

;**************************************************************
; 16 Bit Wert (f1,f0) auf LCD dezimal anzeigen
OutDez16			;16-bit (f0,f1) als Dez zum Lcd
	call	Hex2Dez16
	movfw	HdZT
	Call	Bcd4Bit
	movfw	HdT
	Call	Bcd4Bit

	movlw	' '
	movwf	LcdDaten

	movfw	HdH
	Call	Bcd4Bit
	movfw	HdZ
	Call	Bcd4Bit
	movfw	HdE
	Call	Bcd4Bit
	return


;    1 000 000 000 = 3B9A CA00 h

;      100 000 000 = 05F5 E100 h
;       10 000 000 = 0098 9680 h
;        1 000 000 = 000F 4240 h

;          100 000 = 0001 86A0 h
;           10 000 = 0000 2710 h
;            1 000 = 0000 03E8 h

;              100 = 0000 0064 h
;               10 = 0000 000A h
;                1 = 0000 0001 h

Hex2Dez32			; 32-bit(f3,f2,f1,f0) in 8-stellen Bcd (ZM,M,HT,ZT,T,H,Z,E)

	movlw	0x3B		; 1 000 000 000 = 3B 9A CA 00 h
	movwf	xw3
	movlw	0x9A		
	movwf	xw2
	movlw	0xCA
	movwf	xw1
	movlw	0x00
	movwf	xw0
	call	Hex2Dez1	; 1 000 000 000er
	movfw	HdX
	movwf	HdB


	movlw	0x05		; 100 000 000 = 05 F5 E1 00 h
	movwf	xw3
	movlw	0xF5		
	movwf	xw2
	movlw	0xE1
	movwf	xw1
	movlw	0x00
	movwf	xw0
	call	Hex2Dez1	; 100 000 000er
	movfw	HdX
	movwf	HdHM


	clrf	xw3		; 10 000 000 = 00 98 96 80 h
	movlw	0x98		
	movwf	xw2
	movlw	0x96
	movwf	xw1
	movlw	0x80
	movwf	xw0
	call	Hex2Dez1	; 10 000 000er
	movfw	HdX
	movwf	HdZM

	clrf	xw3		; 1 000 000 = 00 0F 42 40 h
	movlw	0x0F		
	movwf	xw2
	movlw	0x42
	movwf	xw1
	movlw	0x40
	movwf	xw0
	call	Hex2Dez1	; 1 000 000er
	movfw	HdX
	movwf	HdM

	clrf	xw3		; 100 000 = 00 01 86 A0 h
	movlw	0x01		
	movwf	xw2
	movlw	0x86
	movwf	xw1
	movlw	0xA0
	movwf	xw0
	call	Hex2Dez1	; 100 000er
	movfw	HdX
	movwf	HdHT
Hex2Dez16			; 16-bit(f1,f0) in 5-stellen Bcd (ZT,T,H,Z,E)				
	movlw	0x27		; 10 000 = 00 00 27 10 h
	movwf	xw1
	clrf	xw2
	clrf	xw3
	movlw	0x10
	movwf	xw0
	call	Hex2Dez1	; 10 000er
	movfw	HdX
	movwf	HdZT

	movlw	0x03		; 1 000 = 00 00 03 E8 h
	movwf	xw1
	clrf	xw2
	clrf	xw3
	movlw	0xE8
	movwf	xw0
	call	Hex2Dez1	; 1000er
	movfw	HdX
	movwf	HdT
Hex2Dez8			; 8-bit (f1, f0) in 3-stellen BCD
	movlw	0x00		; 100 = 00 00 00 64 h
	movwf	xw3
	movwf	xw2
	movwf	xw1
	movlw	0x64
	movwf	xw0
	call	Hex2Dez1	; 100er
	movfw	HdX
	movwf	HdH

	movlw	0x00		; 10 = 00 00 00 0A h
	movwf	xw3
	movwf	xw2
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	movwf	HdZ

	movfw	f0
	movwf	HdE
	return

Hex2Dez1
	clrf	HdX
	decf	HdX, f
HdLoop
	incf	HdX, f
	call	Sub32		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop		;Stelle 1 mehr
	call	Add32
	return


OutBcd				;8-Bit als BCD ausgeben
	movwf	BcdDaten	;8-Bit kopieren
	movwf	BcdDaten1
	rrf	BcdDaten, f
	rrf	BcdDaten, f
	rrf	BcdDaten, f
	rrf	BcdDaten, f	;4 High-Bit in BcdDaten
	movlw	B'00001111'
	andwf	BcdDaten, f	; / 
	andwf	BcdDaten1, f	; 4-Low-Bit in BcdDaten1
	movfw	BcdDaten
	call	Bcd4Bit		;4 High-Bit ausgeben
	movfw	BcdDaten1
	call	Bcd4Bit		;4 Low-Bit ausgeben
	return
Bcd4Bit				;low-4 Bit als BCD ausgeben
	movwf	BcdDaten
	movlw	B'00110000'
	ADDwf	BcdDaten, f	;ASCII-wandeln (+48)
	movlw	B'00111010'
	subwf	BcdDaten, w
	btfss	STATUS, C	;Test auf A ... F
	goto	BcdOk
	movlw	.7
	addwf	BcdDaten, f	;korrigiere A...F (+7)
BcdOk
	movfw	BcdDaten
	call	OutLcdDaten
	return

;*****************************************************
;+++EEPROM-Routinen fr 16F628************************
;*****************************************************
; 16F628 hat 128 EEPROM-Zellen
;
; zu speichern sind:
;	4 Byte Frequenz
;	1 Byte Amplitude (cos 0..63)

;lesen der Frequenz & Amplitude fr Store w
GetEEPROM
	movwf	Temp
	bcf	STATUS, C
	rlf	Temp, f
	rlf	Temp, f
	rlf	Temp, f		; Adresse x 8
	movfw	Temp
	call	EERead
	movwf	pr0
	incf	Temp, f
	movfw	Temp
	call	EERead
	movwf	pr1
	incf	Temp, f
	movfw	Temp
	call	EERead
	movwf	pr2
	incf	Temp, f
	movfw	Temp
	call	EERead
	movwf	pr3
	incf	Temp, f
	movfw	Temp
	call	EERead
	movwf	Amplitude
	return

; schreiben der Frequenz nach Store w
PutEEPROM
	movwf	Temp
	bcf	STATUS, C
	rlf	Temp, f
	rlf	Temp, f
	rlf	Temp, f		; Adresse x 8

	movfw	pr0
	movwf	EEWriteData
	movfw	Temp
	call	EEWrite

	incf	Temp, f
	movfw	pr1
	movwf	EEWriteData
	movfw	Temp
	call	EEWrite

	incf	Temp, f
	movfw	pr2
	movwf	EEWriteData
	movfw	Temp
	call	EEWrite

	incf	Temp, f
	movfw	pr3
	movwf	EEWriteData
	movfw	Temp
	call	EEWrite

	incf	Temp, f
	movfw	Amplitude
	movwf	EEWriteData
	movfw	Temp
	call	EEWrite
	return

; lesen der Zelle ^W nach W
EERead
	BSF  	STATUS, RP0 	; EEADR liegt in der Bank 1 
 	MOVWF 	EEADR 		; schreibe die Adresse in EEADR 
	BSF  	EECON1, RD 	; EEPROM Leseproze starten 
	MOVF 	EEDATA, W 	; Die Daten der EEPROM Zelle nach W kopieren 
	BCF 	STATUS, RP0 	; Bank 0 
	return

; schreibe EEWriteData in Zelle ^W
EEWrite
	BSF 	STATUS, RP0 	; EEADR und EEDATA liegen in der Bank 1 
	MOVWF 	EEADR 		; Die Zelle @W soll beschrieben werden 
	BCF 	STATUS, RP0
	MOVFW 	EEWriteData	; EEWritedata liegt in Bank 0
	BSF 	STATUS, RP0
	MOVWF 	EEDATA 		; EEWriteData wollen wir schreiben 
	BSF 	EECON1, WREN 	; nun ist Schreiben erlaubt 

; Die folgenden 5 Zeilen mssen genau so im Code stehen!!! 
	MOVLW 	055h
	MOVWF 	EECON2 		; schreibe 55h nach EECON2 
	MOVLW 	0AAh
	MOVWF 	EECON2 		; schreibe AAh nach EECON2 
	BSF 	EECON1, WR 	; starte den Schreibzyklus 

EEWrite1			; warten das write fertig ist
	btfsc	EECON1, WR
	goto	EEWrite1
	BCF 	STATUS, RP0 	; Bank 0 
	return


;*****************************************************
;+++Modulationstabellen*******************************
;*****************************************************
; Sinustabelle mit 32 Werten von 0..90 in 2.8125 Schritten
; 0 = 0    1 = 255
Sinus 
	addwf PCL, f 
	retlw	D'0'		;  0 = 0,0000
	retlw	D'13'		;  1 = 2,8125
	retlw	D'25'		;  2 = 5,625
	retlw	D'37'		;  3 = 8,4375
	retlw	D'50'		;  4 = 11,25
	retlw	D'62'		;  5 = 14,0625
	retlw	D'74'		;  6 = 16,875
	retlw	D'86'		;  7 = 19,6875
	retlw	D'98'		;  8 = 22,5
	retlw	D'109'		;  9 = 25,3125
	retlw	D'120'		; 10 = 28,125
	retlw	D'131'		; 11 = 30,9375
	retlw	D'142'		; 12 = 33,75
	retlw	D'152'		; 13 = 36,5625
	retlw	D'162'		; 14 = 39,375
	retlw	D'171'		; 15 = 42,1875
	retlw	D'180'		; 16 = 45
	retlw	D'189'		; 17 = 47,8125
	retlw	D'197'		; 18 = 50,625
	retlw	D'205'		; 19 = 53,4375
	retlw	D'212'		; 20 = 56,25
	retlw	D'219'		; 21 = 59,0625
	retlw	D'225'		; 22 = 61,875
	retlw	D'231'		; 23 = 64,6875
	retlw	D'236'		; 24 = 67,5
	retlw	D'240'		; 25 = 70,3125
	retlw	D'244'		; 26 = 73,125
	retlw	D'247'		; 27 = 75,9375
	retlw	D'250'		; 28 = 78,75
	retlw	D'252'		; 29 = 81,5625
	retlw	D'254'		; 30 = 84,375
	retlw	D'255'		; 31 = 87,1875
	retlw	D'255'		; 32 = 90

	end		
