	list p=16f628
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 < 0=ZF+10,7 MHz  / 1:ZF-10,7 MHz
;*		1 < 0=1x16 Display / 1:2x16 Display
;*		2 < 0=4:1-Eingang  / 1= 2:1-Eingang	
;*		3 -
;*		4 < Takteingang
;*	PORTB:	0 > LCD Display E
;*		1 		
;*		2 > LCD Display RS
;*		3 > LCD Display R/W	
;*		4-7 LCD Display D4 .. D7 
;*	
;**************************************************************
;
;sprut (zero) Bredendiek 04/2002 .. 06/2010
;
; 9-stellige Frequenzanzeige mit LCD-Display
; fr einen UKW-Empfnger mit 10,7 MHz
; externer Vorteiler 2:1 odere 4:1
;
; Prozessor-Takt 10 MHz (Quarz!!)
;
; Mebereich:
; 32 MHz ... 64 MHz	Auflsung 64 Hz
;
; Anzeige: (f x 2) -/+ 10.700.000 oder (f x 4) -/+ 10.700.000
;
; Eingangsfrequenz an RA4 ist ca. 100 MHz / 2 = 50 MHz 
; interner Vorteiler = 32:1
; Timer-Eingangsfrequenz = 50 MHz / 32 = 1,5625 MHz
;
; ZF=10,7 MHz
; ZF-Offset am Timereingang 10,7 MHz / 2 / 32 =167187,5 Hz
;
; Mezeit 0,5 Sekunden
;  Zhlwert ca. 781250 (bei 100 MHz)
;  davon ZF  83593,75 = 00 01 46 8A
;                 -ZF = FF FE B9 76
;
;**********************************************************
; Includedatei fr den 16F628 einbinden

	#include <P16f628.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen: 16F628
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming
	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC & _BODEN_OFF & _LVP_OFF


;Speicherbereich fr Variablen
; Bank0: 0x20 .. 0x7F ; 96 Byte
; Bank1: 0xA0 .. 0xEF ; 80 Byte
; Bank2:0x120 ..0x14F ; 46 Byte
; Variablen festlegen

;w_copy		Equ	0x20	; nur fr INT
;s_copy		Equ	0x21	; nur fr INT
LcdDaten  	Equ	0x22
LcdStatus 	Equ	0x23
loops		EQU	0x24	; Wait-Schleife
loops2		EQU	0x25	; Wait-Schleife
BcdDaten	EQU	0x26
BcdDaten1	EQU	0x27
Fehler		EQU	0x28
;xw1a		EQU	0x29
; 32-Bit Rechenregister
xw0		EQU	0x2A	;LSB
xw1		EQU	0x2B	; I 
xw2		EQU	0x2C	; I 
xw3		EQU	0x2D	;MSB
; Dezimalstellen
HdZM		EQU	0x2E	;8 ZehnMillionen
HdM		EQU	0x2F	;7 Millionen
HdHT		EQU	0x30	;6 Hunderttausender
HdZT		EQU	0x31	;5 Zehntausender
HdT		EQU	0x32	;4 Tausender
HdH		EQU	0x33	;3 Hunderter
HdZ		EQU	0x34	;2 Zehner
HdE		EQU	0x35	;1 Einer
HdX		EQU	0x36	; Puffer fr eine Dezimalstelle
; 32-Bit Rechenregister
f0		EQU	0x37	;LSB
f1		EQU	0x38	; I 
f2		EQU	0x39	; I 
f3		EQU	0x3A	;MSB
; 32 Bit Frequenzzhler
BIN4		EQU	0x3B	;LSB
BIN41		EQU	0x3C	; I 
BIN42		EQU	0x3D	; I 
BIN43		EQU	0x3E	;MSB
; Hilfszellen fr Frequenzmeschleife
HLTest		EQU	0x3F	; HL-Flanken-Detektorn fr Timer0-berlauf
HighCOU		EQU	0x40	; high-Teil des Schleifenzhlers
LowCOU		EQU	0x41	; low-Teil des Schleifenzhlers
PreSC		EQU	0x42	; Vorteiler fr die richtige Messung

HdHM		EQU	0x43	;9 HundertMillionen

; Konstanten festlegen

LCD_Cont	equ	PORTB		; LCD-Control-Port
LCD_Data	equ	PORTB		; LCD-Daten-Port
LcdE		equ	0		; enable Lcd
LcdRw		equ	3		; read Lcd
LcdRs		equ	2		; Daten Lcd (nicht control)	
Ini_con 	Equ	B'00000000'	; TMR0 -> Intetupt disable
Ini_opt		Equ	B'00000010'	; pull-up

;********************************************************
; Das Programm beginnt mit der Initialisierung

Init	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up on
	movwf   OPTION_REG 
	movlw	B'11111111'	; PORTA input 
	movwf	TRISA		; 
	movlw	B'00000000'	; PortB alle outputs 
	movwf	TRISB
	bcf     STATUS, RP0	; Bank 0
	clrf	PORTA		
	clrf	PORTB		
		
; 16F628 alle Comparatoreingnge auf Digital umschalten
	BSF	CMCON, CM0
	BSF	CMCON, CM1
	BSF	CMCON, CM2
		
	movlw   Ini_con     	; Interupt disable
	movwf   INTCON   

	call	InitLCD		; Display initialisieren

; am LCD "Hallo" ausgeben
	
	movlw	'H'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'a'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'l'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'l'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'o'
	movwf	LcdDaten
	call	OutLcdDaten

; timer1 vorbereiten
	bsf     STATUS, RP0	; Bank 1
	bsf	OPTION_REG, T0CS; RA4-Takt zum Timer0
	bsf	OPTION_REG, PSA	; noch ohne Vorteiler
	bcf     STATUS, RP0	; Bank 0

	movlw	1
	movwf	PreSC		; 4:1

;*****************************************************************
; (HighCOU,LowCOU)x20Takte lang wird gezhlt
; das 24-Bit Ergebnis steht in BIN4+2 (MSB) bis BIN4 (LSB)
; virtuell steht davor BIN+3=0
; das mach dann 32Bit
; 
;
; fr die Messung 500 ms
; 10MHz ; 500 ms = 1250000 Takte = 62500 x 20 Takte, 0,f4,24h=62500d   -Default
;
Frequ_Loop
; Einstellung des Vorteilers 
; >32 MHz 32:1 - 111x xxxx - PS=4  -Default

	movlw	0x04		; PRESC = Vorteiler-Faktor 32:1
	movwf	PreSC

;Messung mit optimaler Auflsung
	clrf	BIN4+1 		; clear counter 
	clrf	BIN4+2 		; clear counter 
	clrf	BIN4+3 		; clear counter 

	clrf	HLTest	 	; initialize TMR0 overflow detector
	movlw	0f4h+1 		; high loop counter for 500 ms
	movwf	HighCOU 	; HighCOU = hi byte counter
	movlw	24h+1 		; 0f424h=.62500 cycles=1250000,T=500 ms
	movwf	LowCOU 		; LowCOU = lo byte counter
	movfw	PreSC		; PRESC = Vorteiler-Faktor 32:1
	call	Messung
;Ende der Zhlroutine
; 500 ms
; 2:1 Fmax =  5 MHz = 2,5 Mill-Schwingungen = 1,25 Mill = 13 12 D0 h
; 4:1 Fmax = 10 MHz =   5 Mill-Schwingungen = 1,25 Mill = 13 12 D0 h

; Zhlwert in Frequenz umrechnen

; der Zahlenwert in BIN ist 1/64 der Frequenz an RA4
; = 1/128 oder 1/256 der LO-Frequenz

; welcher externe Vorteiler wurde verwendet?
; bei 4:1 muss ich Zhlwert verdoppeln bevor ich weitermache
;*	PORTA	2 - 0=4:1-Eingang  / 1= 2:1-Eingang
	btfss	PORTA,2
	call	Mal2

; der Zahlenwert in BIN ist 1/128 der LO-Frequenz

; Messzeit kompensieren
	call	Mal2		; 500ms -> 1s
	call	Mal2		; externer Vorteiler 2:1 kompensieren

; der Zahlenwert in BIN ist 1/32 der LO-Frequenz
; 1/32 der ZF (10,7 MHz) = 334375 = 00 05 1A 27

; ZF addieren oder subtrahieren
; Bin3..Bin := BIN3..BIN +/-  00 05 1A 27
	movfw	BIN43	;MSB
	movwf	f3
	movfw	BIN42
	movwf	f2
	movfw	BIN41
	movwf	f1
	movfw	BIN4	;LSB
	movwf	f0

	movlw	00	;MSB
	movwf	xw3
	movlw	05
	movwf	xw2
	movlw	1A
	movwf	xw1
	movlw	27	;LSB
	movwf	xw0

;*	PORTA: 	0 - 0=ZF+10,7 MHz  / 1:ZF-10,7 MHz
	btfsc	PORTA,0
	goto	subZF
	call	Add32
	goto	endZF
subZF
	call	Sub32
endZF
	movfw	f3	;MSB
	movwf	BIN43
	movfw	f2
	movwf	BIN42
	movfw	f1
	movwf	BIN41
	movfw	f0	;LSB
	movwf	BIN4
	
; der Zahlenwert in BIN ist 1/32 der Empfangsfrequenz

; internen 32:1 Vorteiler kompensieren
	movfw	PreSC
	movwf	Fehler		; sichern fr Berechnung der Frequenz
	incf	Fehler, f
mal
	call	Mal2		; PS kompensieren
	decfsz	Fehler,f
	goto	mal

; der Zahlenwert in BIN ist nun die Empfangsfrequenz

;Kursor zurck
	movlw	B'00000011'	; 8 cursor home, cursor home
	call	OutLcdControl

; 32 Bit zur Anzeige bringen
	movfw	BIN4
	movwf	f0
	movfw	BIN4+1
	movwf	f1
	movfw	BIN4+2
	movwf	f2
	movfw	BIN4+3
	movwf	f3
;Binr zu ASCII Wandlung mit Ausgabe
	call	OutDez32	; 'xx xxx xxx'
	call	OutHz		; ' Hz'

	goto	Frequ_Loop	; und alles noch mal von vorne

;***********************************************************************************
; die eigentliche  Meroutine
; Mezeit = 20Takte x (HighCOU,LowCOU)
; Prescaler in w
Messung
	addlw	20h 		; for PRESC 0,1,2,3... w=20h,21h,22h,23h...
				; TOSE=0, TOCS=1, PSA=0, PS=0..7
	bsf	STATUS,RP0 	; bank 1
	movwf	OPTION_REG 	; 
	bcf	STATUS,RP0 	; bank 0
	clrf	TMR0 		; initialize TMR0

LoopLow
	nop			; warten
	nop			; warten
LoopHigh
	movf	TMR0, W		; 1 1 1 only place where TMR0 is read
	movwf	BIN4		; 1 1 1 rtcc ---> freq0
	rlf	BIN4, W		; 1 1 1 carry <--- TMR0.7
	rlf	HLTest, F	; 1 1 1 rotor <--- carry
	movf	HLTest, W	; 1 1 1 HLTest=TMR0 overflow detect
	andlw	3		; 1 1 1 mask 2 LSbs for edge detect
	xorlw	2		; 1 1 1 00000000 if 1 <--- 0
	btfss	STATUS, Z	; 1 2 2 | skip if TMR0 overflow
	goto	NotOvf1		; 2 - - | if nz
				;       | 5T any case
	incf	BIN4+1, F	; - 1 1 | nsb
NotOvf1 btfsc	STATUS, Z	; 2 2 1 | skip MSB adv ifnot overflow
	incf	BIN4+2, F 	; - - 1 | msb
	nop			; warten
	nop			; warten
	nop			; warten
	decfsz	LowCOU, F 	; 1 (2) lo loop counter
	goto	LoopLow 	; 2 (-) 20T total
	decfsz	HighCOU, F 	; (1) hi loop counter
	goto	LoopHigh 	; (2) 20T total

	return


;*******************************************************************************
;Multiplikation: 32-Bit x 2 
Mal2
	bcf	STATUS,C
	rlf	BIN4, f
	rlf	BIN4+1, f
	rlf	BIN4+2, f
	rlf	BIN4+3, f
	return

;*******************************************************************************
; String ' Hz' am LCD ausgeben
OutHz
	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'H'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'z'
	movwf	LcdDaten
	call	OutLcdDaten
	return

;*****************************************************************	
;Zeitverzgerung um loops * 1 ms
;10MHz -> 2,5MHz -> 2500T

WAIT
top      movlw   .249           ; timing adjustment variable (1ms)  10MHz 249*10=2490T
         movwf   loops2
top2     nop                     ; sit and wait (Schleifenlnge 10T)
         nop
         nop
         nop
         nop
         nop
	 nop			
         decfsz  loops2, F      ; inner loops complete?
         goto    top2           ; no, go again
                                ;
         decfsz  loops, F       ; outer loops complete?
         goto    top            ; no, go again
         retlw   0              ; yes, return from subWAIT

;**************************************************************
; LCD-Routinen
;	
; Initialisierung des LCD-Displays
InitLCD
	movlw	D'255'		; 250 ms Pause nach dem Einschalten
	movwf	loops	
	call	WAIT		

	movlw	B'00110000'	; 1
	movwf	PORTB
	bsf	PORTB, LcdE
	nop	
	bcf	PORTB, LcdE
	
	movlw	D'50'		; 50 ms Pause
	movwf	loops
	call	WAIT
	
	movlw	B'00110000'	; 2
	call	Control8Bit
	movlw	B'00110000'	; 3
	call 	Control8Bit
	movlw	B'00100000'	; 4
	call 	Control8Bit

	movlw	B'00000001'	; lschen und cusor home
	call	OutLcdControl	
	movlw	B'00101000'	; 5 function set, 4-bit  2-zeilig,  5x7
	call	OutLcdControl	
	movlw	B'00001000'	; 6 display off
	call	OutLcdControl
	movlw	B'00000110'	; 7 entry mode, increment, disable display-shift
	call	OutLcdControl
	movlw	B'00000011'	; 8 cursor home, cursor home
	call	OutLcdControl
	movlw	B'00001100'	; 9 display on, cursor off, cursor flash off
	call	OutLcdControl
	return

; ein Steuerbyte 8-bittig bertragen
Control8Bit
	movwf	PORTB
	bsf	PORTB, LcdE
	nop
	bcf	PORTB, LcdE
	movlw	D'10'
	movwf	loops
	call 	WAIT
	return

; darauf warten, da das Display bereit zur Datenannahme ist
LcdBusy
        bsf     STATUS, RP0	; make Port B4..7 input
	movlw	B'11110000'
	iorwf   TRISB, f 
        bcf     STATUS, RP0
BusyLoop		
	bcf	LCD_Cont, LcdRs
	bsf	LCD_Cont, LcdRw	; Lesen
	bsf	LCD_Cont, LcdE
	nop
	movf	LCD_Data, w
	movwf	LcdStatus
	bcf	LCD_Cont, LcdE
	nop
	bsf	LCD_Cont, LcdE	; Enable
	nop
	bcf	LCD_Cont, LcdE
	btfsc	LcdStatus, 7	; teste bit 7
	goto	BusyLoop
	bcf	LCD_Cont, LcdRw
        bsf     STATUS, RP0	; make Port B4..7 output
	movlw	B'00001111'
	andwf   TRISB, f    
        bcf     STATUS, RP0
	return	

; ein Byte mit Steuerdaten von LcdDaten zum Display bertragen
OutLcdControl
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	LCD_Data		; Hi-teil Daten schreiben
	bsf	LCD_Cont, LcdE
	nop
	bcf	LCD_Cont, LcdE	; Disable LcdBus
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	LCD_Data		; Lo-teil Daten schreiben
	bsf	LCD_Cont, LcdE
	nop
	bcf	LCD_Cont, LcdE	; Disable LcdBus
	return

; ein Datenbyte von LCDDaten zum Display bertragen
OutLcdDaten
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	LCD_Data		; Hi-teil Daten schreiben
	bsf	LCD_Cont, LcdRs	; Daten
	bsf	LCD_Cont, LcdE	; Enable LcdBus
	nop
	bcf	LCD_Cont, LcdE	; Disable LcdBus	
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	LCD_Data		; Lo-teil Daten schreiben
	bsf	LCD_Cont, LcdRs	; Daten
	bsf	LCD_Cont, LcdE
	nop
	bcf	LCD_Cont, LcdE	; Disable LcdBus	
	bcf	LCD_Cont, LcdRs	;
	return


;***********************************************************
; 32 Bit Wert (f3,f2,f1,f0) auf LCD dezimal anzeigen
; dabei fhrende Nullen unterdrcken
OutDez32			;32-bit (f3,f2,f1,f0) als Dez zum Lcd
	call	Hex2Dez32	;32 Bit to BCD
	clrf	Fehler		; Leading0 vorbereiten

	movfw	HdHM	
	Call	Leading0
	movfw	HdZM
	Call	Leading0
	movfw	HdM
	Call	Leading0

	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten

	movfw	HdHT
	Call	Leading0
	movfw	HdZT
	Call	Leading0
	movfw	HdT
	Call	Leading0

	movlw	' '
	movwf	LcdDaten
	call	OutLcdDaten

;8 Zeichen fertig
	movlw	B'11000000'	; Sprung zur virtuellen 2. Zeile bei 1x16
;*	PORTA: 	1 - 0=1x16 Display / 1:2x16 Display
	btfss	PORTA,1
	call OutLcdControl	; Sprung zur virtuellen 2. Zeile bei 1x16

	movfw	HdH
	Call	Leading0
	movfw	HdZ
	Call	Leading0
	movfw	HdE
	Call	Bcd4Bit
	return

Leading0
	iorwf	Fehler, f
	movf	Fehler, f	; Test auf 0
	btfss	STATUS, Z	; bisher alles '0'
	goto	Bcd4Bit		; nein
	movlw	' '		; ja
	movwf	LcdDaten
	goto	OutLcdDaten

;**************************************************************
; 16 Bit Wert (f1,f0) auf LCD dezimal anzeigen
OutDez16			;16-bit (f0,f1) als Dez zum Lcd
	call	Hex2Dez16
	movfw	HdZT
	Call	Bcd4Bit
	movfw	HdT
	Call	Bcd4Bit

	movlw	' '
	movwf	LcdDaten

	movfw	HdH
	Call	Bcd4Bit
	movfw	HdZ
	Call	Bcd4Bit
	movfw	HdE
	Call	Bcd4Bit
	return

; 100 000 000 = 05F5 E100 h
;  10 000 000 = 0098 9680 h
;   1 000 000 = 000F 4240 h
;     100 000 = 0001 86A0 h
;      10 000 = 0000 2710 h
;       1 000 = 0000 03E8 h
;         100 = 0000 0064 h
;          10 = 0000 000A h
;           1 = 0000 0001 h

Hex2Dez32			; 32-bit(f3,f2,f1,f0) in 8-stellen Bcd (ZM,M,HT,ZT,T,H,Z,E)

	movlw	0x05		; 100 000 000 = 05 F5 E1 00 h	
	movwf	xw3
	movlw	0xF5		
	movwf	xw2
	movlw	0xE1
	movwf	xw1
	movlw	0x00
	movwf	xw0
	call	Hex2Dez1	; 100 000 000er
	movfw	HdX
	movwf	HdHM
	
	clrf	xw3		; 10 000 000 = 00 98 96 80 h
	movlw	0x98		
	movwf	xw2
	movlw	0x96
	movwf	xw1
	movlw	0x80
	movwf	xw0
	call	Hex2Dez1	; 10 000 000er
	movfw	HdX
	movwf	HdZM

	clrf	xw3		; 1 000 000 = 00 0F 42 40 h
	movlw	0x0F		
	movwf	xw2
	movlw	0x42
	movwf	xw1
	movlw	0x40
	movwf	xw0
	call	Hex2Dez1	; 1 000 000er
	movfw	HdX
	movwf	HdM

	clrf	xw3		; 100 000 = 00 01 86 A0 h
	movlw	0x01		
	movwf	xw2
	movlw	0x86
	movwf	xw1
	movlw	0xA0
	movwf	xw0
	call	Hex2Dez1	; 100 000er
	movfw	HdX
	movwf	HdHT
Hex2Dez16			; 16-bit(f1,f0) in 5-stellen Bcd (ZT,T,H,Z,E)				
	movlw	0x27		; 10 000 = 00 00 27 10 h
	movwf	xw1
	clrf	xw2
	clrf	xw3
	movlw	0x10
	movwf	xw0
	call	Hex2Dez1	; 10 000er
	movfw	HdX
	movwf	HdZT

	movlw	0x03		; 1 000 = 00 00 03 E8 h
	movwf	xw1
	clrf	xw2
	clrf	xw3
	movlw	0xE8
	movwf	xw0
	call	Hex2Dez1	; 1000er
	movfw	HdX
	movwf	HdT
Hex2Dez8			; 8-bit (f1, f0) in 3-stellen BCD
	movlw	0x00		; 100 = 00 00 00 64 h
	movwf	xw3
	movwf	xw2
	movwf	xw1
	movlw	0x64
	movwf	xw0
	call	Hex2Dez1	; 100er
	movfw	HdX
	movwf	HdH

	movlw	0x00		; 10 = 00 00 00 0A h
	movwf	xw3
	movwf	xw2
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	movwf	HdZ

	movfw	f0
	movwf	HdE
	return

Hex2Dez1
	clrf	HdX
	decf	HdX, f
HdLoop
	incf	HdX, f
	call	Sub32		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop		;Stelle 1 mehr
	call	Add32
	return

; 32 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub32				; 32 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen    
	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    sb0
	movlw   0x01		; borgen von f1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb0
	subwf   f2    ,f        ; borgen von f2

	btfsc   STATUS,C
	goto    sb0
	subwf   f3    ,f        ; borgen von f3
	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf

sb0     movf    xw1, w		; f1=f1-xw1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb1
	movlw   0x01		; borgen von f2
	subwf   f2    ,f

	btfsc   STATUS,C
	goto    sb1
	subwf   f3, f		; borgen von f3

        btfss   STATUS,C
	bsf	Fehler, C	; Unterlauf

sb1     movf    xw2,w		; f2=f2-xw2
        subwf   f2, f

        btfsc   STATUS,C
        goto    sb2
        movlw   0x01		
        subwf   f3, f		; borgen von f3

        btfss   STATUS,C
       	bsf	Fehler, C	; Unterlauf

sb2     movf    xw3,w		; f3=f3-xw3
        subwf   f3    ,f

        btfss   STATUS,C
 	bsf	Fehler, C	; Unterlauf

	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return

;32 bit Adition, C-Flag bei berlauf gesetzt
Add32				; 32 bit f:=f+xw
	clrf	Fehler		;extraflags lschen

	movfw	xw0		;low Teil
	addwf	f0, f		;f0:=f0+xw0
	btfss	STATUS, C
	goto	ad0
	incfsz	f1, f		;bertrag nach f1
	goto	ad0
	incfsz	f2 ,f		;bertrag nach f2
	goto	ad2
	incf	f3 ,f		;bertrag nach f3
	btfsc	STATUS,Z
	bsf	Fehler, C	;berlauf

ad0	movfw	xw1
	addwf	f1, f		;f1:=f1+xw1
	btfss	STATUS,C
	goto	ad1
	incfsz	f2 ,f		;bertrag nach f2
	goto	ad1
	incf	f3 ,f		;bertrag nach f3
	btfsc	STATUS,Z
	bsf	Fehler, C	;berlauf

ad1	movfw	xw2
	addwf	f2, f		;f2:=f2+xw2
	btfss	STATUS,C
	goto	ad2
	incf	f3 ,f		;bertrag nach f3
	btfsc	STATUS,Z
	bsf	Fehler, C	;berlauf

ad2	movfw	xw3
	addwf	f3, f		;f3:=f3+xw3
	btfsc	Fehler, C
	bsf	STATUS, C
	return


OutBcd				;8-Bit als BCD ausgeben
	movwf	BcdDaten	;8-Bit kopieren
	movwf	BcdDaten1
	rrf	BcdDaten, f
	rrf	BcdDaten, f
	rrf	BcdDaten, f
	rrf	BcdDaten, f	;4 High-Bit in BcdDaten
	movlw	B'00001111'
	andwf	BcdDaten, f	; / 
	andwf	BcdDaten1, f	; 4-Low-Bit in BcdDaten1
	movfw	BcdDaten
	call	Bcd4Bit		;4 High-Bit ausgeben
	movfw	BcdDaten1
	call	Bcd4Bit		;4 Low-Bit ausgeben
	return
Bcd4Bit				;low-4 Bit als BCD ausgeben
	movwf	BcdDaten
	movlw	B'00110000'
	ADDwf	BcdDaten, f	;ASCII-wandeln (+48)
	movlw	B'00111010'
	subwf	BcdDaten, w
	btfss	STATUS, C	;Test auf A ... F
	goto	BcdOk
	movlw	.7
	addwf	BcdDaten, f	;korrigiere A...F (+7)
BcdOk
	movfw	BcdDaten
	call	OutLcdDaten
	return

;**************************************************************

	end		
