       list p=16f84
;**********************************************************
;*      Pinbelegung
;*      ---------------------------------- 
;*      PORTA:  0   LED
;*              1   LED
;*              2   LED 
;*              3   LED
;*              4   LED
;*      PORTB:  0 
;*              1   Keyboard 1 4 7 *
;*              2   Keyboard 2 5 8 0
;*              3   Keyboard 3 6 9 #
;*              4   ---------I I I I
;*              5   -----------+ I I
;*              6   -------------+ I
;*              7   ---------------+
;* 
;**********************************************************
;
;sprut (zero) Bredendiek 02/2003
;
; Matrixtastatur abfragen
; Tastencode an LED-Zeile darstellen
;
;**********************************************************
; Includedatei fr den 16F84 einbinden

	#include <P16f84.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen
; bis 4 MHz: Power on Timer, kein Watchdog, XT-Oscillator

        __CONFIG        _PWRTE_ON & _WDT_OFF & _XT_OSC

;**************************************************************
; Konstanten
#define	keyport	PORTB
#define	col1	PORTB,4
#define	col2	PORTB,5
#define	col3	PORTB,6
#define	col4	PORTB,7

; Variablen
rows	equ	0x20
Taste	equ	0x21
loop	equ	0x22

;**************************************************************
	org	0
start
	bsf	STATUS, RP0		; Bank 1
	bcf	OPTION_REG, 7	; pull ups an
	movlw	B'00000000'	; RA all output 
	movwf	TRISA		; 
	movlw	B'11110000'	; PortB7..4 input, 3..0 output
	movwf	TRISB
	bcf     STATUS, RP0	; Bank 0
	clrf	PORTA		; 
	clrf	PORTB		;

mainloop
	call	Tastatur
	movlw	0x0C
	xorwf	Taste, w
	bz	warten
	movfw	Taste
	movwf	PORTA		; Taste anzeigen
warten
	nop
	nop
	decfsz	loop, f
	goto	warten
	goto	mainloop

;**************************************************************
; Tastaturabfrage
; Tastennummer in Taste
Tastatur
	clrf	Taste
	movlw	B'00001110'	; RB0 mu output sein !
	movwf	keyport		; RB0=0
	movlw	3
	movwf	rows 		; 3 x 4 Tastatur
	; die '0' aus RB0 wird der Reihe nach durch alle Zeilen geschoben
suche
	setc
	rlf	keyport, f	; nchte Zeile
	btfss	col1
	goto	gefunden
	incf	Taste,f
	btfss	col2
	goto	gefunden
	incf	Taste,f
	btfss	col3
	goto	gefunden
	incf	Taste,f
	btfss	col4
	goto	gefunden
	incf	Taste,f
	decfsz	rows,f
	goto	suche		; alle 4 Zeilen testen
gefunden
	return 			; Taste enthlt die Tastennummer 0..B
				; 0x0C bedeutet: keine Taste gedrckt

	end
