	list p=16f84
;**********************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0   LED
;*		1   LED
;*		2   LED	
;*		3   LED
;*		4   LED
;*	PORTB:	0 
;*		1   Keyboard 1 4 7 *
;*		2   Keyboard 2 5 8 0
;*		3   Keyboard 3 6 9 #
;*		4   ---------I I I I
;*		5   -----------+ I I
;*		6   -------------+ I
;*		7   ---------------+
;*	
;**********************************************************
;
;sprut (zero) Bredendiek 05/2000 (mod. 01/2002; 10/2002)
;
; Matrixtastatur abfragen
; Tastencode an LED-Zeile darstellen
;
;**********************************************************
; Includedatei fr den 16F84 einbinden

	#include <P16f84.INC>

; Configuration festlegen
; bis 4 MHz: Power on Timer, kein Watchdog, XT-Oscillator

	__CONFIG	_PWRTE_ON & _WDT_OFF & _XT_OSC
;**************************************************************

; Variablen festlegen

Taste	Equ	0x20

; Constanten festlegen

Ini_con Equ	B'00000000'	; Interupt disable
Ini_opt	Equ	B'00000010'	; pull-up einschalten

;**********************************************************
; los gehts mit der Initialisierung

Init	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up Widerstnde ein
	movwf   OPTION_REG 
	clrf	TRISA		; RA0 .. RA4 output
	movlw	B'11110001'	; RB1 .. RB3 output
	movwf	TRISB
	bcf     STATUS, RP0	; Bank 0
	clrf	PORTA		; 
	clrf	PORTB		;
	movlw   Ini_con     	; Interupt einstellen (disable)
	movwf   INTCON   

; das Folgende ist die Hauptschleife, die endlos durchlaufen wird

Main				
	call	Tastatur	; Tastatur abfragen
	movfw	Taste
	btfsc	STATUS, Z	; Taste gedrckt?
	goto	Main2		; keine Taste gedrckt
	movwf	PORTA		; Tastencode zu LEDs
Main2	
	goto 	Main
	
;**********************************************************	
;
;Abfrage der 3x4-Tastatur
;
;**********************************************************
; Festlegung der Spaltennummern

Row1	equ	1		;Keyboard 1 4 7 *
Row2	equ	2		;Keyboard 2 5 8 0
Row3	equ	3		;Keyboard 3 6 9 #


; ist eine Taste gedrckt? und welche?

Tastatur			; Tastencode nach Taste
				; wenn keine Taste gedrckt dann Taste=0
	movlw	0		; W=0

	bsf	PORTB, Row2
	bsf	PORTB, Row3
	bcf	PORTB, Row1
	call	key1		; 1. Spalte abfragen

	bsf	PORTB, Row1
	bcf	PORTB, Row2
	call	key2		; 2. Spalte

	bsf	PORTB, Row2
	bcf	PORTB, Row3
	call	key3		; 3. Spalte
	
	movwf	Taste
	return

key1
	btfss	PORTB, 4
	retlw	'1'
	btfss	PORTB, 5
	retlw	'4'
	btfss	PORTB, 6
	retlw	'7'
	btfss	PORTB, 7
	retlw	'*'
	return
key2
	btfss	PORTB, 4
	retlw	'2'
	btfss	PORTB, 5
	retlw	'5'
	btfss	PORTB, 6
	retlw	'8'
	btfss	PORTB, 7
	retlw	'0'
	return
key3
	btfss	PORTB, 4
	retlw	'3'
	btfss	PORTB, 5
	retlw	'6'
	btfss	PORTB, 6
	retlw	'9'
	btfss	PORTB, 7
	retlw	'#'
	return

	end		
