	list p=16f84
;**************************************************************
;*
;*   Pinbelegung des PIC
;*	----------------------------------	
;*	PORTA: 	0 
;*		1 
;*		2 seriell Output	
;*		3 
;*		4 
;*	PORTB:	0 	   
;*		1 
;*		2 
;*		3  
;*		4 
;*		5 
;*		6 
;*		7 
;*
;**************************************************************
;*
;* sprut (zero) Bredendiek 05/2000 (mod. 01/2002; 09/2003)
;*
;* Senden via RS-232 am Pin RB2
;* output: RA1     (keine RS232-Treiberschaltkreise  verwenden!)
;* Takt  : 4 MHz
;*
;*
;**************************************************************
; Includedatei fr den 16F84 einbinden

	#include <P16f84.INC>

; Configuration festlegen
; bis 4 MHz: Power on Timer, kein Watchdog, XT-Oscillator

	__CONFIG	_PWRTE_ON & _WDT_OFF & _XT_OSC

;**************************************************************
;Variablennamen vergeben

Temp	Equ	0x20
cycl_1	Equ	0x21		; Zhler 
cycl_2	Equ	0x22		; Zhler
Byte	equ	0x23
out	EQU	2		; RS-232 out ist RA2

;**************************************************************
; los gehts mit dem Programm
; Pin RA2 auf Ausgabe stellen

Init
	bsf     STATUS, RP0	; unschalten auf Bank 1
	movlw	B'00111011'	; RA2 output 
	movwf	TRISA		; 
	bcf     STATUS, RP0	; zurckschalten zur Bank 0
	clrf	PORTA		; 

;zyklisches Senden des Zeichens 'A' als Beispiel
Loop
	movlw	'A'		; es soll z.B. der Buchstabe'A' gesendet werden
	call	Send_RS		; Datenwort ausgeben via RS-232
	goto	Loop

;***************************************************************
;senden des Bytes, das im Register W steht 

Send_RS				; Ausgabe eines Bytes seriell	
	movwf	Byte		; Byte in w
	movlw	8		; es werden 8 Bit gesendet
	movwf 	cycl_1
	bcf	PORTA, out
	call	Warte_s		; 1 Stopbit (1)
	bsf	PORTA, out
	call 	Warte_s		; 1 Startbit (0)

Send_1	rrf	Byte, f		; aktuelles Bit in das Carry-Flag schieben
	btfsc	STATUS, C
	bcf	PORTA, out	; Lo wenn Bit = 1
	btfss	STATUS, C
	bsf	PORTA, out	; Hi wenn Bit = 0
	call	Warte_s		; 1 Bit lang warten
	decfsz	cycl_1, f	; waren das schon 8 Bit?
	goto	Send_1		; nein, es geht weiter
	bcf	PORTA, out	; Byte zuende, 1 Stoppbit (1) senden
	call 	Warte_s		;
	return

;**********************************************************
;ein Bit Zeitverzoegerung mit einer Warteschleife
; Timing mu genau stimmen (5%)
;
; senden            4 MHz    10 MHz
; 2400 Bps =          69d    173d
; 9600 Bps =          16d     43d

Warte_s	movlw	D'15'		; 9600 Bps / 4 MHz senden
	movwf	cycl_2
Warte1				; 6 Zyklen Schleife
	nop
	nop
	nop
	decfsz	cycl_2, 1	
	goto	Warte1
	return

	end





