	list p=12f629
;***********************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	GP: 	0 > out 0
;*		1 > out 1
;*		2 > out 2
;*		3 -
;*		4 > out 4
;*		5 > out 5
;*	
;***********************************************************************
;
;sprut (zero) Bredendiek 06/2003
;
; Power-Sequencer mit 12F629
;	die Pins GP0..2,GP4 und GP5 werden mit 2 Sekunden Verzgerung  
;	der Reihe nach auf High gelegt
;
; Prozessor 12F629 
;
; Prozessor-Takt 4 MHz intern
;
;
;***********************************************************************
; Includedatei fr den 12F629 einbinden

	#include <P12f629.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen:
; kein Power on Timer, kein Watchdog, int-Oscillator, kein Brown out
	__CONFIG	_MCLRE_OFF & _PWRTE_OFF & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _BODEN_OFF


;***********************************************************************
; Variablen festlegen  20h ... 5Fh 

W_save		Equ	0x20		; auch 0xA0
Status_save	equ	0x21		; registers for saving context
PCLATH_save	equ	0x22
Flags		equ	0x23		; flag bits (see definitions below)
counter		equ	0x24		; Misc counter


; Flag bits (FLAGS)
#define weiter		Flags, 0	; nchste Leitung einschalten


;***********************************************************************
	org	0x00

	goto	Main

;***********************************************************************
	org	0x04

InterruptServiceVector
	movwf	W_save			; save W
	swapf	STATUS,W
	bcf	STATUS, RP0		; Bank 0
	movwf	Status_save

	incf	counter, f
	btfsc	STATUS, Z
	bsf	weiter

	bcf	INTCON, T0IF

	; End ISR, restore context and return to the main program
	swapf	Status_save, w
	movwf	STATUS
	swapf	W_save,f    		; restore W without corrupting STATUS
	swapf	W_save,w
	retfie
 


;***********************************************************************
; Initialisierung
;
;***********************************************************************
Init
	; IO-Pins
	bcf	STATUS, RP0		; Bank 0
	clrf	GPIO			; aus!
	movlw	0x07
	movwf	CMCON			; alle Pins digital (nicht Comp)
	bsf	STATUS, RP0		; Bank 1
	clrf	TRISIO			; alle outnput
	bcf	STATUS, RP0		; Bank0

	; interner Taktgenerator
	bsf	STATUS, RP0		; Bank 1
	call	0x3FF
	movwf	OSCCAL			; 4-MHz-Kalibrierung
	bcf	STATUS, RP0		; Bank 0

	; Interrupt
	bcf	INTCON, GIE		; Int deaktiviert

	clrf	counter
	clrf	Flags


	; TIMER0 mu eingestellt sein! 
	; 32:1 bei 4 MHz -> 31 kHz
	; berlauf nach ca 8 ms
	; 256 int in s Sekunden
	bsf	STATUS, RP0		; Bank 1
	bcf	OPTION_REG, T0CS	; interner Takt/4
	bcf	OPTION_REG, PSA		; Vorteiler am Timer0
	bsf	OPTION_REG, PS2
	bcf	OPTION_REG, PS1
	bcf	OPTION_REG, PS0		; Vorteiler 32:1
	bcf	STATUS, RP0		; Bank 0

	; Interrupt
	bcf	INTCON, T0IF
	bsf	INTCON, T0IE
	bsf	INTCON, GIE		; Int deaktiviert


	return



;***********************************************************************
;Main 
;
;***********************************************************************
Main
	call	Init			; PIC initialisieren

loop0
	btfss	weiter
	goto	loop0
	bcf	weiter
	bsf	GPIO,0

loop1
	btfss	weiter
	goto	loop1
	bcf	weiter
	bsf	GPIO,1

loop2
	btfss	weiter
	goto	loop2
	bcf	weiter
	bsf	GPIO,2

loop4
	btfss	weiter
	goto	loop4
	bcf	weiter
	bsf	GPIO,4

loop5
	btfss	weiter
	goto	loop5
	bcf	weiter
	bsf	GPIO,5

	sleep

	end


