	list p=16f628
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 < rotary encoder - B Pin4
;*		1 < rotary encoder - A Pin5
;*		2 -
;*		3 -
;*		4 -
;*		5 -
;*		6 -
;*		7 -
;*
;*	PORTB:	0 > LED
;*		1 > LED
;*		2 > LED
;*		3 > LED
;*		4 > LED
;*		5 > LED
;*		6 > LED
;*		7 > LED
;*	
;**************************************************************
;
;sprut (zero) Bredendiek 01/2003
;
; Rotary-Encoder mit LED Zeile
;
; Prozessor 16F628 
;
; Prozessor-Takt 10 MHz
;
; Rotary Encoder am PortA 0 & 1
; LED-Zeile am PortB
;
;**************************************************************
; Includedatei fr den 16F628 einbinden

	#include <P16f628.INC>

	ERRORLEVEL      -302    	; SUPPRESS BANK SELECTION MESSAGES


; Configuration festlegen:
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming
	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC & _BODEN_OFF & _LVP_OFF

; Constanten festlegen
#define	encoder	PORTA
#define	LED	PORTB

; Variable festlegen
temp	equ	0x20			; Arbeitsregister 
counter	equ	0x21			; Zhlstand
alt	equ	0x22			; alte Rotor-Position
neu	equ	0x23			; aktuelle Rotorposition

;**************************************************************
; Programmanfang

	org	0

;**************************************************************
; Initialisierung *********************************************

init
	bsf     STATUS, RP0		; Bank 1
	clrf	OPTION_REG 
	movlw	B'00000000'		; PortB alle outputs 
	movwf	TRISB
	bcf     STATUS, RP0		; Bank 0
	clrf	PORTB			; LEDs aus
	clrf	INTCON        		; Interupt disable


; 16F628 alle Comparatoreingnge auf Digital umschalten
	BSF	CMCON, CM0
	BSF	CMCON, CM1
	BSF	CMCON, CM2

	clrf	counter
	movfw	encoder
	movwf	alt			; aktuelle encoder-Stellung lesen
	movlw	B'00000011'
	andwf	alt, f			; nur 2 LSB stehen lassen

;Hauptprogrammschleife
loop
	call	read_encoder		; Rotary Encoder abfragen
	movfw	counter
	movwf	LED			; Zhlerstand anzeigen
	goto	loop


;**************************************************************
; Test des Encoders auf Verdrehung ****************************

read_encoder
	movfw	encoder
	movwf	neu			; aktuelle encoder-Stellung nach new
	movlw	B'00000011'	
	andwf	neu, f			; nur 2 LSB stehen lassen
	movfw	neu			; wurde der encoder bewegt?
	movwf	temp
	movfw	alt
	xorwf	temp, w			; ist neu = alt?
	bz	ende			; ja: nicht verdreht, also nichts tun
					; nein: encoder verdreht, aber in welche Richtung?
					; drehen wir mal Bit0 des alten werts zum Vergleich 
					;  nach links
	bcf	alt, 1
	clrc				; Carry-Flag lschen
	rlf	alt, f			; alten Encoder-Stand um 1 Stelle nach links drehen
	movfw	neu
	xorwf	alt, f			; falls xorf >1 ergibt, dann war es eine Rechtsdrehung
	bz	links			; links:  decrement counter
	decf	alt, f
	bz	links			; links:  decrement counter
rechts
	incf	counter, f		; rechts:  increment counter
	goto	weiter
links
	decf	counter, f		; links:  decrement counter
weiter
	movfw	neu
	movwf	alt			; neu fr nchsten Vergleich als alt speichern
ende
	return

	end
