 	list p=16f628a
;**************************************************************
;*	PORTA: 	0 >> Ausgang
;*		1 >> Ausgang
;*		2 >> Ausgang
;*		3 >> Ausgang
;*		4 >> Ausgang
;*	PORTB:	0 < load	- Interrupt
;*		1 < (RB1/RX/DT) Dateneingang
;*		2 
;*		3 > Datenausgang
;*		4 < (RB2/TX/CK) Takteingang - Interrupt
;*		5 >
;*		6 >
;*		7 >
;**************************************************************
;
; sprut (zero) Bredendiek 05/2010
;
; Rechteckgenerator 1 .. 9999 Hz
;
; serielles Interface kann von USB4all (ab V.5) erzeugt werden
;
; serieller Eingang fuer 16-Bit-Sollfrequenz als 4-stelliges BCD in Herz, MSD first
; Frequenzeinstellfehler ca. +0.4%
;
; Jitter im Rechtecksignal: 3,8 us
;
; Prozessor 16F628 o..
; Prozessor-Takt 20 MHz
;
;**************************************************************

; Includedatei fr den 16F628 einbinden
	#include <P16f628a.INC>

	ERRORLEVEL      -302    ; SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen:
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming, kein Reset
	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC & _BODEN_OFF & _LVP_OFF & _MCLRE_OFF


; Akku  XXXXXXXX XXXXXXXX XXXXXXXX
; s     --XXXXXX XXXXXXXX XX------
;**************************************************************
; Variablen festlegen

; Speicherbereich fr Variablen
; Bank0: 0x20 .. 0x7F ; 96 Byte
; Bank1: 0xA0 .. 0xEF ; 80 Byte
; Bank2:0x120 ..0x14F ; 46 Byte

w_copy		equ	0x4D	; nur fr INT
s_copy		equ	0x4E	; nur fr INT
p_copy		equ	0x4F	; nur fr INT

; Akkumulationsregister
akku0		equ	0x51	; 
akku1		equ	0x52	; 
akku2		equ	0x53	; 

;Frequenz
f0		equ	0x54	; 
f1		equ	0x55	; 
f2		equ	0x56	; 

;Schieberegister
s0		equ	0x57	; 
s1		equ	0x58	; 

;rechenregister
x0		equ	0x59	; 
x1		equ	0x5A	; 

; Konstanten festlegen
#define	Load		PORTB,0
#define serin		PORTB,1
#define serout		PORTB,3
#define clock		PORTB,4


Ini_opt		equ	B'10000100'	; Timer0 int 32:1, pull-up on

;**************************************************************
	org	0
	goto	Init


;**************************************************************
; die Interuptserviceroutine
; interrupt fuer load-pulse an RB0
; int fuer shift-clock an RB4

	org 	4 	
intvec
	movwf	w_copy		; w retten
	swapf	STATUS, w 	; STATUS retten
	clrf	STATUS
	movwf	s_copy		;
	movf	PCLATH, W
	movwf	p_copy
	clrf	PCLATH		; Bank 0 

; Intrupt service routine
	btfsc	INTCON, INTF
	goto	Int_Load
	btfsc	INTCON,	RBIF
	goto	Int_shift
	clrf	INTCON		; da ging was schief, failback
	goto	Int_end


Int_shift
	btfss	clock
	goto	Int_shift_skip	; falsche flanke, nichts tun
	rlf	s0,f
	rlf	s1,f
	bcf	serout		; letztes bit herausschieben
	btfsc	s1,7
	bsf	serout
	bcf	s0,0		; neues bit einlesen
	btfsc	serin
	bsf	s0,0
Int_shift_skip
	bcf	INTCON, RBIF
	goto	Int_end


Int_Load
	; f = hex(s) x 64
	call	Bcd2Hex		; f = hex(s)

	movfw	f1
	movwf	f2
	movfw	f0
	movwf	f1
	clrf	f0		; f = hex(s) * 256

	bcf	STATUS,C
	rrf	f2,f
	rrf	f1,f
	rrf	f0,f
	rrf	f2,f
	rrf	f1,f
	rrf	f0,f		; f = hex(s) * 256 / 4  =  hex(s) * 64

	bcf	INTCON, INTF
	goto	Int_end


Int_end
	movf	p_copy, W
	movwf	PCLATH
	swapf	s_copy, w	; STATUS zurck
	movwf	STATUS 
	swapf	w_copy, f	; w zurck mit flags
	swapf	w_copy, w

	retfie


;**************************************************************
; Das Programm beginnt mit der Initialisierung

Init
	movlw	0x10
	movwf	s1
	movlw	0x0
	movwf	s0
	call	Bcd2Hex
	
	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up on; Timer0 32:1 interner Takt
	movwf   OPTION_REG 
	movlw	B'00010111'	; PortB alle inputs auer RB3 ,5..7
	movwf	TRISB
	movlw	B'11100000'	; PortRA0..4 outputs 
	movwf	TRISA
	bcf     STATUS, RP0	; Bank 0

; 16F628 alle Comparatoreingnge auf Digital umschalten
	BSF	CMCON, CM0
	BSF	CMCON, CM1
	BSF	CMCON, CM2

; Interupt disable  
	clrf	INTCON      

; 100 Hz einstellen
	clrf	f2
	movlw	0x19
	movwf	f1
	movlw	0x00
	movwf	f0

	clrf	s0
	clrf	s1

; Interrupts
	clrf	INTCON
	; interrupt fuer load-pulse an RB0
	bsf     STATUS, RP0		; Bank 1
	bsf	OPTION_REG, INTEDG	; RB0-int auf steigende flanke
	bcf     STATUS, RP0		; Bank 0
	bsf	INTCON, INTE

	; int fuer clock an RB4
	movfw	PORTB
	bsf	INTCON, RBIE		; int on change RB4..7
	
	bsf	INTCON,GIE



;**************************************************************
; symmetrischer Rechteck
; Frequenz: f	
; bei Clk = 20 MHz
square
_clr	clrf	akku0
	clrf	akku1
	clrf	akku2

next	; 19 Tcycl = 3,8 us
	movf	f0,w
	addwf	akku0,f
	movf	f1,w
	btfsc	STATUS,C
	incfsz	f1,w
	addwf	akku1,f
	movf	f2,w
	btfsc	STATUS,C
	incfsz	f2,w
	addwf	akku2,f		; akku(24) = akku(24)+f(24)
	nop
	nop
	nop
	clrw
	btfsc	akku2,7
	movlw	0xFF
	movwf	PORTA	
	goto	next

;**************************************************************
; in s1-s0 stehen 16 Bit als 4-stellige BCD-Zahl
; umrechnen in hexadezimal
; hex = ((s1H*10 +s1L)*10 +s0H)*10 + s0L
Bcd2Hex
	clrf	f0
	clrf	f1
	clrf	f2

	swapf	s1,w
	andlw	B'00001111'
	movwf	f0			; f = s1H
	call	Mal_10			; f = s1H*10

	movlw	B'00001111'
	andwf	s1,w			; w = s1L

	addwf	f0,f			; low byte add
	btfsc	STATUS,C		; berspringe falls C nicht gesetzt
	incf	f1,f			; addiere C falls gesetzt

	call	Mal_10			; f = (s1H*10 +s1L)*10

	swapf	s0,w
	andlw	B'00001111'		; w = s0H

	addwf	f0,f			; low byte add
	btfsc	STATUS,C		; berspringe falls C nicht gesetzt
	incf	f1,f			; addiere C falls gesetzt

	call	Mal_10			; f = ((s1H*10 +s1L)*10 +s0H)*10

	movlw	B'00001111'
	andwf	s0,w			; w = s0L

	addwf	f0,f			; low byte add
	btfsc	STATUS,C		; berspringe falls C nicht gesetzt
	incf	f1,f			; addiere C falls gesetzt

	return				; f = = ((s1H*10 +s1L)*10 +s0H)*10 + soL

;**************************************************************
; Multiplikation von f1-f0 mal 10
; x = f
; f = (4*f + x) * 2 = 10 * f
Mal_10
	movfw	f0
	movwf	x0
	movfw	f1
	movwf	x1			; x = f

	bcf	STATUS,C
	rlf	f0,f
	rlf	f1,f			; x 2
	bcf	STATUS,C
	rlf	f0,f
	rlf	f1,f			; x 4

	movf	x0,w			; low byte
	addwf	f0,f			; low byte add

	movf	x1,w			; high byte
	btfsc	STATUS,C		; berspringe falls C nicht gesetzt
	incfsz	x1,w			; addiere C falls gesetzt
	addwf	f1,f			; high byte add wenn NZ 

	bcf	STATUS,C
	rlf	f0,f
	rlf	f1,f			; x 2

	return

;**************************************************************

	end