	list p=16f628
;**************************************************************
;*
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 -
;*		1 -
;*		2 -
;*		3 -
;*		4 -
;*		5 -
;*		6 -
;*		7 -
;*
;*	PORTB:	0 > LCD Display E
;*		1 < Rcksetz_Taster fr Uhrzeit
;*		2 > LCD Display RS
;*		3 > LCD Display R/W
;*		4 - LCD Display D4
;*		5 - LCD Display D5
;*		6 - LCD Display D6
;*		7 - LCD Display D7
;*
;**************************************************************
;
; sprut (zero) Bredendiek 02/2004  mod 06/2005
;
; Uhr mit LCD-Display 
;  Anzeige hh:mm:ss
;  Takt : 32768Hz
;
;
;**************************************************************
; Includedatei fr den 16F84 einbinden

	#include <P16f628.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen
; 32768Hz: Power on Timer, kein Watchdog, LP-Oscillator

	__CONFIG	_PWRTE_ON & _WDT_OFF & _LP_OSC & _BODEN_OFF & _LVP_OFF

;**************************************************************
; Konstanten

; Variablennamen vergeben

w_copy		Equ	0x20		; Backup fr Akkuregister
s_copy		Equ	0x21		; Backup fr Statusregister

Flags		Equ	0x22
loops		equ	0x23		; timer fr wait
LcdStatus	equ	0x24		;
LcdDaten	equ	0x25		;
ES		equ	0x26		; Einer  Sekunden
ZS		equ	0x27		; Zehner Sekunden
EM		equ	0x28		; Einer  Minuten
ZM		equ	0x29		; Zehner Minuten
EH		equ	0x2A		; Einer  Stunden
ZH		equ	0x2B		; Zehner Stunden

; fr LCD-Pins
#define	LcdE		PORTB,0		; enable Lcd
#define	LcdRw		PORTB,3		; read Lcd
#define	LcdRs		PORTB,2		; Daten Lcd (nicht control)	
#define LcdPort		PORTB		; Datenbus des LCD (obere 4 Bit)

#define	neu		Flags,0

Ini_con		Equ	B'00000000'	; TMR0 -> Interupt disable
Ini_opt		Equ	B'00000010'	; pull-up

;**************************************************************
; los gehts mit dem Programm

	org 	0
	goto	Init	

;**************************************************************
; die Interuptserviceroutine

	org 	4 	
intvec
	movwf	w_copy		; w retten
	swapf	STATUS, w 	; STATUS retten
	bcf	STATUS, RP0	; Bank 0
	movwf	s_copy		;

; Intrupt servic routine
Int_serv 
	bsf	neu

	incf	ES, f		; 1 Sekunden erhhen
	movlw	D'10'
	subwf	ES, w
	btfss	STATUS, Z	
	goto	Int_end		; 1 Sekunden <> 10	

	clrf	ES
	incf	ZS, f		; 10 Sekunden erhhen
	movlw	D'6'
	subwf	ZS, w
	btfss	STATUS, Z	
	goto	Int_end		; 10 Sekunden <> 6	

	clrf	ZS
	incf	EM, f		; 1 Minuten erhhen
	movlw	D'10'
	subwf	EM, w
	btfss	STATUS, Z	
	goto	Int_end		; 1 Minuten <> 10

	clrf	EM
	incf	ZM, f		; 10 Minuten erhhen
	movlw	D'6'
	subwf	ZM, w
	btfss	STATUS, Z	
	goto	Int_end		; 10 Minuten <> 6

	clrf	ZM
	incf	EH, f		; 1 Stunden erhhen
	movlw	D'10'
	subwf	EH, w
	btfss	STATUS, Z	
	goto	Test24		; 1 Stunden <> 10

	clrf	EH
	incf	ZH, f		; 10 Stunden erhhen
	goto	Int_end

Test24
	movlw	D'2'
	subwf	ZH, w
	btfss	STATUS, Z	
	goto	Int_end		; 10 Stunden <> 2
	movlw	D'4'
	subwf	EH, w
	btfss	STATUS, Z	
	goto	Int_end		; 1 Stunden <> 4
	clrf	EH		; Mitternacht
	clrf	ZH
	goto	Int_end

Int_end	
	bcf	INTCON, T0IF	; Interupt-Flag lschen

	swapf	s_copy, w	; STATUS zurck
	movwf	STATUS 
	swapf	w_copy, f	; w zurck mit flags
	swapf	w_copy, w
	retfie

;**************************************************************

; Port B auf Ausgabe stellen

Init	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up on
	movwf   OPTION_REG 
	movlw	B'00000010'	; PortB alle outputs auer RB1
	movwf	TRISB
	bcf     STATUS, RP0	; Bank 0
	clrf	PORTB
	movlw   Ini_con     	; Interupt disable
	movwf   INTCON   

;Display initialisieren
	call	InitLcd

	clrf	Flags

; Zeit 0 einstellen
	call	Zeit_Null

; 1 Hz-Timer-Interupt einstellen
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'10000100'	; internen Takt zhlen, Vorteiler zum Timer0, 32:1
	movwf	OPTION_REG
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten
	clrf	TMR0		; ((32,768 kHz : 32 ): 256 = 1 Hz)

	bsf	INTCON, T0IE	; Timer0 interupt erlauben
	bsf	INTCON, GIE	; Interupt erlauben

loop
	btfss	PORTB,1
	call	Zeit_Null	; wenn Taste gedrckt, dann Zeit=0
	btfss	neu
	goto	loop		; eine Endlosschleife

	; Kursor home
	movlw	B'10000000'	; 1. Zeile
	call	OutLcdControl

	movfw	ZH
	iorlw	'0'		;wandeln in ASCCI
	call	OutLcdDaten
	movfw	EH
	iorlw	'0'		;wandeln in ASCCI
	call	OutLcdDaten

	movlw	':'		; Lcke
	call	OutLcdDaten

	movfw	ZM
	iorlw	'0'		;wandeln in ASCCI
	call	OutLcdDaten
	movfw	EM
	iorlw	'0'		;wandeln in ASCCI
	call	OutLcdDaten

	movlw	':'		; Lcke
	call	OutLcdDaten

	movfw	ZS
	iorlw	'0'		;wandeln in ASCCI
	call	OutLcdDaten
	movfw	ES
	iorlw	'0'		;wandeln in ASCCI
	call	OutLcdDaten

	bcf	neu
	goto	loop		; eine Endlosschleife

Zeit_Null
	clrf	TMR0
	bsf	neu
	clrf	ES
	clrf	ZS
	clrf	EM
	clrf	ZM
	clrf	EH
	clrf	ZH
	return


;*****************************************************
;+++LCD-Routinen**************************************
;*****************************************************
;LCD initialisieren

InitLcd
	movlw	D'255'		; 250 ms Pause nach dem Einschalten
	movwf	loops	
	call	WAIT		

	movlw	B'00110000'	; 1
	movwf	LcdPort
	bsf	LcdE
	nop	
	bcf	LcdE
	
	movlw	D'50'		; 50 ms Pause
	movwf	loops
	call	WAIT
	
	movlw	B'00110000'	; 2
	call	Control8Bit
	movlw	B'00110000'	; 3
	call 	Control8Bit
	movlw	B'00100000'	; 4
	call 	Control8Bit

	movlw	B'00000001'	; lschen und cusor home
	call	OutLcdControl	
	movlw	B'00101000'	; 5 function set, 4-bit  2-zeilig,  5x7
	call	OutLcdControl	
	movlw	B'00001000'	; 6 display off
	call	OutLcdControl
	movlw	B'00000110'	; 7 entry mode, increment, disable display-shift
	call	OutLcdControl
	movlw	B'00000011'	; 8 cursor home, cursor home
	call	OutLcdControl
	movlw	B'00001100'	; 9 display on, Kursor aus , Blinken aus
	call	OutLcdControl
	return

;*****************************************************
; ein Steuerbyte 8-bittig bertragen
Control8Bit
	movwf	LcdPort
	bsf	LcdE
	nop
	bcf	LcdE
	movlw	D'10'
	movwf	loops
	call 	WAIT
	return

;*****************************************************
; darauf warten, da das Display bereit zur Datenannahme ist
LcdBusy
        bsf     STATUS, RP0	; make Port B4..7 input
	movlw	B'11110000'
	iorwf   TRISB, f 
        bcf     STATUS, RP0
BusyLoop		
	bcf	LcdRs
	bsf	LcdRw		; Lesen
	bsf	LcdE
	nop
	movf	LcdPort, w
	movwf	LcdStatus
	bcf	LcdE
	nop
	bsf	LcdE		; Enable
	nop
	bcf	LcdE
	btfsc	LcdStatus, 7	; teste bit 7
	goto	BusyLoop
	bcf	LcdRw
        bsf     STATUS, RP0	; make Port B4..7 output
	movlw	B'00001111'
	andwf   TRISB, f    
        bcf     STATUS, RP0
	return	

;*****************************************************
; aus W ein Byte mit Steuerdaten zum Display bertragen
OutLcdControl
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	LcdPort		; Hi-teil Daten schreiben
	bsf	LcdE
	nop
	bcf	LcdE		; Disable LcdBus
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	LcdPort		; Lo-teil Daten schreiben
	bsf	LcdE
	nop
	bcf	LcdE		; Disable LcdBus
	return

;*****************************************************
; aus W ein Datenbyte zum Display bertragen
OutLcdDaten
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	LcdPort		; Hi-teil Daten schreiben
	bsf	LcdRs		; Daten
	bsf	LcdE		; Enable LcdBus
	nop
	bcf	LcdE		; Disable LcdBus	
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	LcdPort		; Lo-teil Daten schreiben
	bsf	LcdRs		; Daten
	bsf	LcdE
	nop
	bcf	LcdE		; Disable LcdBus	
	bcf	LcdRs		;
	return

;*****************************************************
;Zeitverzgerung um loops * 1 ms
; 32768Hz externer Takt bedeutet ca 8 kHz interner Takt
; also dauert 1 ms etwa 8 Befehle

WAIT
top
        nop
        nop
	nop
        nop
        nop
        decfsz  loops, F       ; outer loops complete?
        goto    top            ; no, go again
        retlw   0              ; yes, return from WAIT

;*****************************************************

	end



