	list p=16f84
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 - 
;*		1 -
;*		2 -	
;*		3 -
;*		4 -
;*	PORTB:	0 LCD Display E
;*		1 		
;*		2 LCD Display RS
;*		3 LCD Display R/W	
;*		4-7 LCD Display D4 .. D7 
;*	
;**************************************************************
;
;sprut (zero) Bredendiek 05/2000 (mod. 15.01.2002)
;
; LCD-Display mit Matrixtastatur
;
; Taktquelle: 4 MHz
;
;**************************************************************
; Includedatei fr den 16F84 einbinden

	#include <P16f84.INC>

; Configuration festlegen
; bis 4 MHz: Power on Timer, kein Watchdog, XT-Oscillator

	__CONFIG	_PWRTE_ON & _WDT_OFF & _XT_OSC

;**************************************************************
; Variablen festlegen

w_copy	Equ	0x20
s_copy	Equ	0x21
LcdDaten  Equ	0x22
LcdStatus Equ	0x23
loops	EQU	0x24
loops2	EQU	0x25

; Constanten festlegen

PORTC	equ	PORTB		; LCD-Control-Port
PORTD	equ	PORTB		; LCD-Daten-Port
LcdE	equ	0		; enable Lcd
LcdRw	equ	3		; read Lcd
LcdRs	equ	2		; Daten Lcd (nicht control)	
Ini_con Equ	B'00000000'	; TMR0 -> Intetupt disable
Ini_opt	Equ	B'00000010'	; pull-up

;********************************************************
; Das Programm beginnt mit der Initialisierung

Init	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up on
	movwf   OPTION_REG 
	movlw	B'11111000'	; RA0 .. RA2 outputs, RA3, RA4 input 
	movwf	TRISA		; 
	movlw	B'00000000'	; PortB alle outputs 
	movwf	TRISB
	bcf     STATUS, RP0	; Bank 0
	clrf	PORTA		
	clrf	PORTB		
				
	movlw   Ini_con     	; Interupt disable
	movwf   INTCON   

	call	InitLCD		; Display initialisieren

; am LCD "Hallo" ausgeben
	
	movlw	'H'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'a'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'l'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'l'
	movwf	LcdDaten
	call	OutLcdDaten
	movlw	'o'
	movwf	LcdDaten
	call	OutLcdDaten

	sleep
Main				
	goto 	Main	

;*****************************************************************	
;Zeitverzgerung um loops * 1 ms
; 4MHz externer Takt bedeutet 1MHz interner Takt
; also dauert 1 ms genau 1000 Befehle
; 110 Schleifen a 9 Befehle sind 990 Befehle = 0.99 ms
; die restlichen 10 Befehle fr Einsprung und Rcksprung

WAIT
top      movlw   .110           ; timing adjustment variable (1ms)
         movwf   loops2
top2     nop                    ; sit and wait
         nop
         nop
         nop
         nop
         nop
         decfsz  loops2, F      ; inner loops complete?
         goto    top2           ; no, go again
                                ;
         decfsz  loops, F       ; outer loops complete?
         goto    top            ; no, go again
         retlw   0              ; yes, return from subWAIT

;**********************************************************	
; Initialisierung des LCD-Displays

InitLCD
	movlw	D'255'		; 250 ms Pause nach dem Einschalten
	movwf	loops	
	call	WAIT		

	movlw	B'00110000'	; 1
	movwf	PORTB
	bsf	PORTB, LcdE
	nop	
	bcf	PORTB, LcdE
	
	movlw	D'50'		; 50 ms Pause
	movwf	loops
	call	WAIT
	
	movlw	B'00110000'	; 2
	call	Control8Bit
	movlw	B'00110000'	; 3
	call 	Control8Bit
	movlw	B'00100000'	; 4
	call 	Control8Bit

	movlw	B'00000001'	; lschen und cusor home
	call	OutLcdControl	
	movlw	B'00101000'	; 5 function set, 4-bit  2-zeilig,  5x7
	call	OutLcdControl	
	movlw	B'00001000'	; 6 display off
	call	OutLcdControl
	movlw	B'00000110'	; 7 entry mode, increment, disable display-shift
	call	OutLcdControl
	movlw	B'00000011'	; 8 cursor home, cursor home
	call	OutLcdControl
	movlw	B'00001111'	; 9 display on
	call	OutLcdControl
	return

; ein Steuerbyte 8-bittig bertragen
Control8Bit
	movwf	PORTB
	bsf	PORTB, LcdE
	nop
	bcf	PORTB, LcdE
	movlw	D'10'
	movwf	loops
	call 	WAIT
	return

; darauf warten, da das Display bereit zur Datenannahme ist
LcdBusy
	bsf	PORTA, 1	; Test LED 1 on
        bsf     STATUS, RP0	; make Port B4..7 input
	movlw	B'11110000'
	iorwf   TRISB, f 
        bcf     STATUS, RP0
BusyLoop		
	bcf	PORTC, LcdRs
	bsf	PORTC, LcdRw	; Lesen
	bsf	PORTC, LcdE
	nop
	movf	PORTD, w
	movwf	LcdStatus
	bcf	PORTC, LcdE
	nop
	bsf	PORTC, LcdE	; Enable
	nop
	bcf	PORTC, LcdE
	btfsc	LcdStatus, 7	; teste bit 7
	goto	BusyLoop
	bcf	PORTC, LcdRw
        bsf     STATUS, RP0	; make Port B4..7 output
	movlw	B'00001111'
	andwf   TRISB, f    
        bcf     STATUS, RP0
	bcf	PORTA, 1	; Test LED 1 off
	return	

; ein Byte mit Steuerdaten von LcdDaten zum Display bertragen
OutLcdControl
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	PORTD		; Hi-teil Daten schreiben
	bsf	PORTC, LcdE
	nop
	bcf	PORTC, LcdE	; Disable LcdBus
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	PORTD		; Lo-teil Daten schreiben
	bsf	PORTC, LcdE
	nop
	bcf	PORTC, LcdE	; Disable LcdBus
	return

; ein Datenbyte von LCDDaten zum Display bertragen
OutLcdDaten
	bsf	PORTA, 2	; Test LED 2 on
	movwf	LcdDaten
	call	LcdBusy
	movf	LcdDaten, w
	andlw	H'F0'
	movwf	PORTD		; Hi-teil Daten schreiben
	bsf	PORTC, LcdRs	; Daten
	bsf	PORTC, LcdE	; Enable LcdBus
	nop
	bcf	PORTC, LcdE	; Disable LcdBus	
	swapf	LcdDaten, w
	andlw	H'F0'
	movwf	PORTD		; Lo-teil Daten schreiben
	bsf	PORTC, LcdRs	; Daten
	bsf	PORTC, LcdE
	nop
	bcf	PORTC, LcdE	; Disable LcdBus	
	bcf	PORTC, LcdRs	;
	bcf	PORTA, 2	; Test LED 2 on
	return

	end		
