	list p=16f84
;**************************************************************
;*
;* Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 
;*		1 
;*		2 
;*		3 
;*		4 
;*	PORTB:	0 LED	   
;*		1 LED	    
;*		2 LED	    
;*		3 LED	     
;*		4 LED	    
;*		5 LED	    
;*		6 LED	    
;*		7 LED	    
;*
;**************************************************************
;
; sprut (zero) Bredendiek 05/2000 (mod. am 16.01.2002) 
;
; Lauflicht am Port B 
;
; Taktquelle: 4MHz
;
;**************************************************************
; Includedatei fr den 16F84 einbinden
;
	#include <P16f84.INC>
;
; Configuration festlegen
;
; bis 4 MHz: Power on Timer, kein Watchdog, XT-Oscillator
	__CONFIG	_PWRTE_ON & _WDT_OFF & _XT_OSC
;
; ab 4 MHz: Power on Timer, kein Watchdog, HS-Oscillator
;	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC
;
;**************************************************************
; Variablennamen vergeben
;
loops	Equ	0x22		; Zhler fr Warteschleife 
loops2	Equ	0x23		; Zhler fr Warteschleife 

;**************************************************************
; los gehts mit dem Programm
; Port B auf Ausgabe stellen

Init
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'00000000'	; PortB alle output
	movwf	TRISB
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten
	clrf	PORTB		; alle LEDs ausschalten

; 1. LED einschalten 

	bsf	PORTB,0		; LED an RB0 einschalten

; Lauflicht

Loop
	call	Wait		; Wartezeit
	rlf	PORTB,f		; laufen zur nchsten LED
	goto	Loop	


;**********************************************************
; Warteschleife 250 ms

Wait
	movlw	D'250'		; 250 ms Pause
	movwf	loops	

Wai
	movlw   .110           ; Zeitkonstante fr 1ms
        movwf   loops2
Wai2    nop                    ; 
        nop
        nop
        nop
        nop
        nop
        decfsz  loops2, F      ; 1 ms vorbei?
        goto    Wai2           ; nein, noch nicht
                               ;
        decfsz  loops, F       ; 250 ms vorbei?
        goto    Wai            ; nein, noch nicht
        retlw   0              ; das Warten hat ein Ende

	end



