 	list p=16f628
;**************************************************************
;*	PORTA: 	0 Ziffer 3	-----------------------------------------------------+
;*		1 Ziffer 2	-------------------------------------+               I
;*		2 Ziffer 1	---------------------+               I               I
;*		3 Ziffer 0	-----+               I               I               I
;*		4 Segment G	     I               I               I               I  
;*	PORTB:	0 Segment B	   AAAAA	   AAAAA	   AAAAA	   AAAAA
;*		1 Segment F	  F     B	  F     B	  F     B	  F     B
;*		2 Segment A	  F     B	  F     B	  F     B	  F     B
;*		3 Pulseingang	   GGGGG  	   GGGGG  	   GGGGG  	   GGGGG  
;*		4 Segment H	  E     C	  E     C	  E     C	  E     C
;*		5 Segment C	  E     C	  E     C	  E     C	  E     C
;*		6 Segment E	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH
;*		7 Segment D 
;   
; 7-Segment-Tabelle fuer VQE
;Segmente
;	addwf	PCL, f
;;		  76543210
;;		  DECHgAFB
;	retlw	B'00011000'	; 0
;	retlw	B'11011110'	; 1
;	retlw	B'00110010'	; 2
;	retlw	B'01010010'	; 3
;	retlw	B'11010100'	; 4
;	retlw	B'01010001'	; 5
;	retlw	B'00010001'	; 6
;	retlw	B'11011010'	; 7
;	retlw	B'00010000'	; 8
;	retlw	B'01010000'	; 9
;	retlw	B'11111111'	; dunkel
;	retlw	B'10110111'	; -
;	retlw	B'00111101'	; L
;	retlw	B'00010111'	; o
;	retlw	B'10010100'	; H
;	retlw	B'11011111'	; i
;
; zukuenftig sollte man Segment H weglassen und mit RB4 Segment G treiben
;
;**************************************************************
;
;sprut (zero) Bredendiek 01/2004  .. 02/2010
;
; 4-stelliger LED-Frequenzmesser mit 16F628 
;
; LED-Display mit gemeinsamer Anode
; mit oder ohne Treibertransistor
;
; Prozessor 16F628 o..
; Prozessor-Takt 20 MHz
; Meimpulseingang RB3
;
; Frequenzzhler mit 4-stellige LED-Anzeige, ganzzahlig
;
;
;**************************************************************
; einige Festlegungen fuer die Division aus der Microchip-Bibliothek AN617
TRUE		EQU   1
FALSE		EQU   0

P16C5X		SET    FALSE	; If P16C5X, use INHX8M file format.
P16CXX		SET    FALSE	; If P16CXX, use INHX8M file format.
P17CXX		SET    FALSE	; If P17CXX, the INHX32 file format is required in the LIST directive
RESET_V		SET    0x0000	; Default Reset Vector address of 0h (16Cxx and 17Cxx devices)
P16_MAP1	SET    FALSE	; FOR 16C60/61/70/71/84 Memory Map
P16_MAP2	SET    FALSE	; For all other 16Cxx Memory Maps
P16CXX		SET    TRUE	; If P16CXX, use INHX8M file format.
P16_MAP2	SET    TRUE


; Includedatei fr den 16F628 einbinden
	#include <P16f628.INC>
	#INCLUDE <MATH16.INC>	; PIC16 math library definitions, belegt 0x20 bis 0x4B

	ERRORLEVEL      -302    ; SUPPRESS BANK SELECTION MESSAGES

; Configuration festlegen:
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming, kein Reset
	__CONFIG	_PWRTE_ON & _WDT_ON & _HS_OSC & _BODEN_OFF & _LVP_OFF & _MCLRE_OFF


;**************************************************************
; Variablen festlegen
; 0x20 bis 0x4B ist durch Divisionsroutine belegt
;
; Speicherbereich fr Variablen
; Bank0: 0x20 .. 0x7F ; 96 Byte
; Bank1: 0xA0 .. 0xEF ; 80 Byte
; Bank2:0x120 ..0x14F ; 46 Byte

w_copy		equ	0x4D	; nur fr INT
s_copy		equ	0x4E	; nur fr INT
p_copy		equ	0x4F	; nur fr INT

Flags		equ	0x50
Fehler		equ	0x51	; Fehlerregister fr Mathematik

; Dezimalstellen
Digit		equ	0x52	; aktuell angezeigte Stelle
Ziffer0		equ	0x53	; Tausender
Ziffer1		equ	0x54	; Hunderter
Ziffer2		equ	0x55	; Zehner
Ziffer3		equ	0x56	; Einer
HdT		equ	0x57	;4  Tausender
HdH		equ	0x58	;3  Hunderter
HdZ		equ	0x59	;2  Zehner
HdE		equ	0x5A	;1  Einer
HdX		equ	0x5B	; Puffer fr eine Dezimalstelle

;32 Bit Rechenregister
f0		equ	0x5C	; 
f1		equ	0x5D	; 
f2		equ	0x5E	; 
f3		equ	0x5F	; 
;32 Bit Rechenregister
xw0		equ	0x60	; 
xw1		equ	0x61	;
xw2		equ	0x62	;  
xw3		equ	0x63	;

; Messwert wird hier gespeichert
PeriodeL	equ	0x64	;
PeriodeH	equ	0x65	;

Mode		equ	0x66	; 0-1:1;625kHz / 1-4:1;5MHz / 2-16:1;5MHz
DisplayBremse	equ	0x67	;


; Konstanten festlegen
#define	Datenda		Flags,7	; neuer Mewert wurde gemessen

;#define	Treiber			; Treibertransistor vorhanden

; Makros
#ifdef Treiber
; das sind die Makros fuer ein LED-Display mit Treibertransistoren an den Anoden
#define	Ziffer0_aus	bsf	PORTA, 3	; Ziffer0 aus
#define	Ziffer1_aus	bsf	PORTA, 2	; Ziffer1 aus
#define	Ziffer2_aus	bsf	PORTA, 1	; Ziffer2 aus
#define	Ziffer3_aus	bsf	PORTA, 0	; Ziffer3 aus
#define	Ziffer0_an	bcf	PORTA, 3	; Ziffer0 an
#define	Ziffer1_an	bcf	PORTA, 2	; Ziffer1 an
#define	Ziffer2_an	bcf	PORTA, 1	; Ziffer2 an
#define	Ziffer3_an	bcf	PORTA, 0	; Ziffer3 an

#else
; das sind die Makros fuer ein LED-Display mit direkter Ansteuerung der Anoden ohne Treiber
#define	Ziffer0_aus	bcf	PORTA, 3	; Ziffer0 aus
#define	Ziffer1_aus	bcf	PORTA, 2	; Ziffer1 aus
#define	Ziffer2_aus	bcf	PORTA, 1	; Ziffer2 aus
#define	Ziffer3_aus	bcf	PORTA, 0	; Ziffer3 aus
#define	Ziffer0_an	bsf	PORTA, 3	; Ziffer0 an
#define	Ziffer1_an	bsf	PORTA, 2	; Ziffer1 an
#define	Ziffer2_an	bsf	PORTA, 1	; Ziffer2 an
#define	Ziffer3_an	bsf	PORTA, 0	; Ziffer3 an

#endif


Ini_opt		equ	B'10000100'	; Timer0 int 32:1, pull-up on

;**************************************************************
	org	0
	goto	Init


;**************************************************************
; die Interuptserviceroutine
; wird vom capture-Modul ausgeloest

	org 	4 	
intvec
	movwf	w_copy		; w retten
	swapf	STATUS, w 	; STATUS retten
	clrf	STATUS
	movwf	s_copy		;
	movf	PCLATH, W
	movwf	p_copy
	clrf	PCLATH		; Bank 0 

; Intrupt service routine
	clrf	TMR1L		; Timer 1 zurcksetzen
	clrf	TMR1H
	bcf	PIR1,CCP1IF	; Interupt-Flag lschen

	btfss	PIR1,TMR1IF	; Timer1 bergelaufen?
	goto	Int_copy	; nein, weitermachen
				; ja: Drehzahl zu niedrig, dann Anzeige ' Lo'
	movlw	D'10'
	movwf	Ziffer0		; tausender Stelle dunkel
	movwf	Ziffer1		; hunderter Stelle dunkel
	movlw	D'12'
	movwf	Ziffer2
	movlw	D'13'
	movwf	Ziffer3		; Anzeige '  Lo'
	goto	Int_end

Int_copy
	; Mewert retten
	movfw	CCPR1L
	movwf	PeriodeL
	movfw	CCPR1H
	movwf	PeriodeH
	bsf	Datenda		; neuen Mewert melden

Int_end
	bcf	PIR1,TMR1IF	; Timer1 berlaufflag lschen
	bcf	PIR1,CCP1IF	; Interupt-Flag lschen
	movf	p_copy, W
	movwf	PCLATH
	swapf	s_copy, w	; STATUS zurck
	movwf	STATUS 
	swapf	w_copy, f	; w zurck mit flags
	swapf	w_copy, w

	retfie

;**************************************************************
; 7-Segment-Tabelle

;*	PORTB:	0 Segment A	   AAAAA
;*		1 Segment F	  F     B
;*		2 Segment E	  F     B
;*		3 Segment D*	   GGGGG
;*		4 Segment H	  E     C
;*		5 Segment C	  E     C
;*		6 Segment G	   DDDDD  HH
;*		7 Segment B    
;

; 7-Segment-Tabelle fuer VQE
Segmente
	addwf	PCL, f
;		  76543210
;		  DECHgAFB
	retlw	B'00011000'	; 0
	retlw	B'11011110'	; 1
	retlw	B'00110010'	; 2
	retlw	B'01010010'	; 3
	retlw	B'11010100'	; 4
	retlw	B'01010001'	; 5
	retlw	B'00010001'	; 6
	retlw	B'11011010'	; 7
	retlw	B'00010000'	; 8
	retlw	B'01010000'	; 9
	retlw	B'11111111'	; dunkel 10
	retlw	B'11110111'	; -	 11
	retlw	B'00111101'	; L	 12
	retlw	B'00010111'	; o	 13
	retlw	B'10010100'	; H	 14
	retlw	B'11011111'	; i	 15


;**************************************************************
; Routine zum multiplexen Anzeigen am LED-Display
; Aufruf erfolgt 305 mal pro Sekunde
; abwechseld 6 Funktionen mit je 51 Aufrufen pro Sekunde
; 4 Zeitscheiben a 3,3ms stehen den Displaysegmenten zur Verfgung
; 2 Zeitscheiben sind fr Berechnungen reseviert
Display
	Ziffer0_aus
	Ziffer1_aus
	Ziffer2_aus
	Ziffer3_aus
	bsf	PORTA, 4	; Segmente aus
	movlw	B'11110111'
	iorwf	PORTB,f	

	decf	Digit,f		; Ziffernzhler verringern

;anstehende Arbeit:
;Digit=5: falls neuer Mewert da ist: rechnen
;Digit=4: falls noetig weiterhin rechnen
;Digit=3: anzeigen Ziffer 3     1er
;Digit=2: anzeigen Ziffer 2    10er
;Digit=1: anzeigen Ziffer 1   100er
;Digit=0: anzeigen Ziffer 0  1000er

	btfsc	STATUS, Z
	goto	Disp_0		; Z-Flag=1 ergo Digit=0
	decf	Digit, w
	btfsc	STATUS, Z
	goto	Disp_1		; Digit=1
	btfsc	Digit,2
	goto	Disp_5		; Digit=5 oder 4
	btfsc	Digit,0
	goto	Disp_3		; Digit=3
	goto	Disp_2		; Digit=2

Disp_0
	movlw	6
	movwf	Digit		; Digit wieder auf 6 einstellen
	movfw	Ziffer0		; Wert der 1. Ziffer (1000er)
	btfss	STATUS,Z	; fhrende '0' wird nicht angezeigt!
	Ziffer0_an		; 1. Ziffer einschalten
	goto	Disp_end

Disp_1
	movfw	Ziffer0		; Wert der 1. Ziffer (1000er), fuehrende 0 ?
	iorwf	Ziffer1,w	; mit 2. Zifer (100er) or-verknuepfen, fuehrende 00 ?
	btfsc	STATUS,Z	; fhrende '00' wird nicht angezeigt!
	goto	Disp_end	; 00xx; 2. Ziffer nicht einschalten

	movfw	Ziffer1		; Wert der 2. Ziffer (100er)
	Ziffer1_an		; 2. Ziffer einschalten
	goto	Disp_end

Disp_2
	movfw	Ziffer0		; Wert der 1. Ziffer (1000er), fuehrende 0 ?
	iorwf	Ziffer1,w	; mit 2. Zifer (100er) or-verknuepfen, fuehrende 00 ?
	iorwf	Ziffer2,w	; mit 3. Zifer (10er) or-verknuepfen, fuehrende 000 ?
	btfsc	STATUS,Z	; fhrende '00' wird nicht angezeigt!
	goto	Disp_end	; 00xx; 2. Ziffer nicht einschalten

	movfw	Ziffer2		; Wert der 3. Ziffer (10er)
	Ziffer2_an		; 3. Ziffer einschalten
	goto	Disp_end

Disp_3
	movfw	Ziffer3		; Wert der 3. Ziffer (1er)
	Ziffer3_an		; 4. Ziffer einschalten
	goto	Disp_end

Disp_5
	btfss	Digit,0
	goto	Disp_end2	; bei 4 nichts tun, Rechenreserve

	; wenn Mode0 Messungen nur bei jedem 16. Durchlauf 
	; dieser Routine bearbeitet werden, dann erfolgen
	; nur 6.3 Messungen pro Sekunde;
	; das beruhigt das Display
	incf	DisplayBremse,f

	btfsc	Datenda		; ist neuer Mewert da?
	goto	Disp_5aa	; ja
	btfss	PIR1,TMR1IF	; Timer1 bergelaufen?
	goto	Disp_end	; nichts zu tun

	; keine Eingangsimpulse mehr, Anzeige '  Lo'
	movlw	D'10'
	movwf	Ziffer0		; tausender Stelle dunkel
	movwf	Ziffer1		; hunderter Stelle dunkel
	movlw	D'12'
	movwf	Ziffer2
	movlw	D'13'
	movwf	Ziffer3		; Anzeige '  Lo'
	goto	Disp_end

Disp_5aa
	movfw	Mode
	bz	Disp_5a		; Mode0, da muss noch mal geprft werden
	; Mode 1 & 2
	call	Berechnung	; ja: Drehzahl berechnen Mode 1&2
	goto	Disp_end2	; keine Segmente einschalten

Disp_5a
	; Mode 0
	movlw	0xF0
	andwf	DisplayBremse,w
	bz	Disp_5b		; noch zu frueh
	clrf	DisplayBremse
	call	Berechnung	; ja: Drehzahl berechnen Mode 0
	goto	Disp_end2	; keine Segmente einschalten

Disp_5b				; noch zu frueh
	bcf	Datenda
	goto	Disp_end2

Disp_end
	call	Segmente	; 7-Segment-Code fr aktuelle Ziffer holen
	movwf	PORTB		; Segmente einschalten
	bsf	PORTA,4		; Segment G nicht vergessen
	andlw	B'00001000'
	btfsc	STATUS,Z
	bcf	PORTA,4

Disp_end2
	return


;**************************************************************
; Das Programm beginnt mit der Initialisierung

Init	movlw	B'11111111'
	movwf	PORTB		; LEDs aus
	bsf	PORTA, 4	; Segment G nicht vergessen
	bsf     STATUS, RP0	; Bank 1
	movlw   Ini_opt     	; pull-up on; Timer0 32:1 interner Takt
	movwf   OPTION_REG 
	movlw	B'00001000'	; PortB alle outputs auer RB3
	movwf	TRISB
	movlw	B'11100000'	; PortRA0..4 outputs 
	movwf	TRISA
	bcf     STATUS, RP0	; Bank 0
	Ziffer0_aus
	Ziffer1_aus
	Ziffer2_aus
	Ziffer3_aus
	movlw	B'11111111'
	movwf	PORTB		; LEDs aus
	bsf	PORTA, 4	; Segment G nicht vergessen
	
; 16F628 alle Comparatoreingnge auf Digital umschalten
	BSF	CMCON, CM0
	BSF	CMCON, CM1
	BSF	CMCON, CM2

; Interupt disable  
	clrf	INTCON      

; Anzeige initialisieren '----'
	clrf	DisplayBremse
	movlw	6
	movwf	Digit
	movlw	D'11'
	movwf	Ziffer0
	movwf	Ziffer1
	movwf	Ziffer2
	movwf	Ziffer3		; Anzeige '----'


; Timer0 initialisieren fr LED-Multiplex-Anzeige
; 32:1 Vorteiler. 
; Immer nach 256 x 32 Zyklen (~1.6 ms) luft der Timer0 ber -> 610 Hz
; da ein Anzeigezyklus aus 6 Schritten besteht, -> 102 Hz Anzeigefrequenz = flackerfrei
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'10000100'	; internen Takt zhlen, Vorteiler zum Timer0, 32:1
	movwf	OPTION_REG
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten
	clrf	TMR0
	bcf	INTCON, T0IE	; Timer0 interupt verbieten
	bcf	INTCON, T0IF	; Flag lschen
	bsf	INTCON, GIE	; Interupt erlauben


; als Lebenszeichen auf der hintersten Stelle ein Strich
	bcf	PORTB, 7	; '_'
	Ziffer3_an		; 4. Ziffer einschalten	


; Takt und Vorteiler einstellen, Capture-Modul aktivieren
	clrf	Mode		; Mode 0:  1:1  625kHz
	call	SetMode

	
; Anzeigeschleife
disploop
	btfss	INTCON, T0IF
	goto	disploop
	clrwdt			; watchdog zuruecksetzen bevor 18 ms vorbei sind (7..33 ms)
	bcf	INTCON, T0IF
	call	Display
	goto	disploop


;**************************************************************
;Takt und Vorteiler fr Messung einstellen
;Capture-Modul aktivieren
; Mode0 -  1:1 ; 625 kHz 
; Mode1 -  4:1 ;   5 MHz 
; Mode2 - 16:1 ;   5 MHz
SetMode
	; int verbieten
	bcf	INTCON,GIE

	movfw	Mode
	bz	SetMode0
	btfss	Mode,1
	goto	SetMode1

SetMode2; 16:1;5MHz
	clrf	CCP1CON		; Capture mode aus
	; Timer1 auf 5 MHz-Takt einstellen fr Messung
	movlw	B'00000001'	; internen Takt, VT 1:1; 20MHz/4=5MHz
	movwf	T1CON
	; Capture Mode
	movlw	B'00000111'	; Capture mode, jede 16.Flanke (16:1)
	movwf	CCP1CON
	goto	SetModeEnd

SetMode1; 4:1;5MHz
	clrf	CCP1CON		; Capture mode aus
	; Timer1 auf 5 MHz-Takt einstellen fr Messung
	movlw	B'00000001'	; internen Takt, VT 1:1; 20MHz/4=5MHz
	movwf	T1CON
	; Capture Mode
	movlw	B'00000110'	; Capture mode, jede 4.Flanke (4:1)
	movwf	CCP1CON
	goto	SetModeEnd

SetMode0; 1:1;625kHz
	clrf	CCP1CON		; Capture mode aus
	; Timer1 auf 625 kHz-Takt einstellen fr Messung
	movlw	B'00110001'	; internen Takt, VT 8:1; 20MHz/4/8=625kHz
	movwf	T1CON
	; Capture Mode
	movlw	B'00000101'	; Capture mode, jede steigende Flanke (1:1)
	movwf	CCP1CON

SetModeEnd
	; synchonisieren
	; int verbieten
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	clrf	PIE1
	bcf	PIE1,CCP1IE 
	bcf     STATUS, RP0	; auf Bank 0
	bcf	Datenda
	bcf	INTCON,PEIE
	bcf	INTCON,GIE
	; Messung erst starten, wenn 2x Capturen erfolgte
	; damit der 1. Mewert schon richtig ist
	clrf	TMR1L
	clrf	TMR1H
	bcf	PIR1,CCP1IF	
SetModesync	
	btfss	PIR1,CCP1IF
	goto	SetModesync
	clrf	TMR1L
	clrf	TMR1H
	bcf	PIR1,CCP1IF
	bcf	PIR1,TMR1IF
	; int erlauben
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	clrf	PIE1
	bsf	PIE1,CCP1IE 
	bcf     STATUS, RP0	; auf Bank 0
	bcf	Datenda
	bsf	INTCON,PEIE
	bsf	INTCON,GIE
	return


;**************************************************************
; Neuberechnung des Anzeigewerts
Berechnung
	; Mewert in xw laden
	bcf	INTCON,GIE
	movfw	PeriodeL
	movwf	xw0
	movfw	PeriodeH
	movwf	xw1
	clrf	xw2
	clrf	xw3
	bsf	INTCON,GIE

BerHiHi
	; falls Drehzahl zu hoch, dann Anzeige 'HiHi'
	; bei Messwerten < 0x003D abbrechen (Fehlmessung oder >10245 rpm)
	movfw	xw1
	bnz	Ber1		; zaehlwert > 255
	movfw	xw0
	bz	BerLoop		; zaehlwert = 0
	movlw	0x3D
	subwf	xw0, w
	btfsc	STATUS,C
	goto	Ber1		; Drehzahl ist nicht zu hoch, Berechnung kann beginnen
	movlw	D'14'
	movwf	Ziffer0
	movwf	Ziffer2
	movlw	D'15'
	movwf	Ziffer1
	movwf	Ziffer3		; Anzeige 'HiHi'
	goto	BerLoop		; Messergebnis zu klein, Drehzahl zu hoch
	
Ber1
	; falls Mode>0 dann berechnen und Mode auf 0 setzen
	; falls Mode=0 dann
	; xw>0x0300         berechnen
	; xw 0x0100..0x02FF Mode=1
	; xw<0x0100         Mode=2
	
	movfw	Mode
	bz	BerMode0Check
	btfss	Mode,1		; 2 oder 1 ?
	goto	BerMode1	
	goto	BerMode2

BerMode0Check
	movlw	0x03		; zaehlergebnis>0x0300 ?
	subwf	xw1, w		; xw1-03
	bc	BerMode0	; ja >0x0300 , Mode0 war ok
	movlw	1		; nein, in Mode 1 umschalten
	movwf	Mode
	movfw	xw1		; zaehlergebnis>0x00FF ?
	bnz	BerMode0Check1
	movlw	2		; nein, in Mode 2 umschalten
	movwf	Mode
BerMode0Check1
	call	SetMode	
	goto	BerLoop

BerMode2
	; 80 000 000 durch Messwert teilen
	; 80 000 000 = 04 C4 B4 00
	; 80 000 000 nach f laden
	movlw	0x04
	movwf	f3
	movlw	0xC4
	movwf	f2
	movlw	0xB4
	movwf	f1
	clrf	f0
	clrf	Mode
	call	SetMode
	goto	BerDivision

BerMode1
	; 20 000 000 durch Messwert teilen
	; 20 000 000 = 01 31 2D 00
	; 20 000 000 nach f laden
	movlw	0x01
	movwf	f3
	movlw	0x31
	movwf	f2
	movlw	0x2D
	movwf	f1
	movlw	0x00
	movwf	f0
	clrf	Mode
	call	SetMode
	goto	BerDivision

BerMode0
	; 625 000 durch Messwert teilen
	; 625 000 = 09 89 68
	; 625 000 nach f laden
	movlw	0x00
	movwf	f3
	movlw	0x09
	movwf	f2
	movlw	0x89
	movwf	f1
	movlw	0x68
	movwf	f0

BerDivision
	; nun durch den Mewert dividieren
	call	Div24		; f:= f / xw  
	call	OutDez16	; Divisionsergebnis in BCD wandeln & anzeigen (4-stellig)

BerLoop
	bcf	Datenda		; Berechnung des Mewertes erledigt

	return

;**************************************************************
;+++Mathematik-Routinen ***************************************

;**************************************************************
; 24 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub24				; 24 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen

	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    sb0
	movlw   0x01		; borgen von f1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb0
	subwf   f2    ,f        ; borgen von f2

	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf

sb0     movf    xw1, w		; f1=f1-xw1
	subwf   f1, f

	btfsc   STATUS,C
	goto    sb1
	movlw   0x01		; borgen von f2
	subwf   f2    ,f

        btfss   STATUS,C
	bsf	Fehler, C	; Unterlauf

sb1     movf    xw2,w		; f2=f2-xw2
        subwf   f2, f

        btfss   STATUS,C
       	bsf	Fehler, C	; Unterlauf

	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return


; 16 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub16				; 16 bit f:=f-xw   calc=xw cnt=f
	clrf	Fehler		; extraflags lschen

	movf    xw0, w		; f0=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    sb0a
	movlw   0x01		; borgen von f1
	subwf   f1, f

	btfss   STATUS,C
	bsf	Fehler, C	; unterlauf

sb0a    movf    xw1, w		; f1=f1-xw1
	subwf   f1, f

        btfss   STATUS,C
	bsf	Fehler, C	; Unterlauf

	bcf	STATUS, C
	btfsc	Fehler, C
	bsf	STATUS, C
	return


;**************************************************************
;24 bit Adition, C-Flag bei berlauf gesetzt
Add24 				; 24-bit add: f = f + xw
	movf	xw0,w		; low byte
	addwf	f0,f 		; low byte add

	movf	xw1,w 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,w 		; add C if it was set
	addwf	f1,f 		; high byte add if NZ
	
	movf	xw2,w		; high byte 
	btfsc	STATUS,C	; berspringe falls C nicht gesetzt 
	incfsz	xw2,w		; addiere C falls gesetzt 
	addwf	f2,f		; next byte add wenn  NZ 

	return 			; fertig


;16 bit Adition, C-Flag bei berlauf gesetzt
Add16 				; 16-bit add: f = f + xw
	movf	xw0,w		; low byte
	addwf	f0,f 		; low byte add

	movf	xw1,w 		; next byte
	btfsc	STATUS,C 	; skip to simple add if C was reset
	incfsz	xw1,w 		; add C if it was set
	addwf	f1,f 		; high byte add if NZ
	
	return 			; fertig
	

;**************************************************************
; 32/24 bit Division 	f:= f / xw
; aus der Microchip-Bibliothek AN617
; AARG := AARG / BARG
; Microchip numeriert die Bytes anders herum als ich: aufpassen!
; A0-A1-A2-A3	B0-B1-B2
; f3-f2-f1-f0	x2-x2-x0
Div24
	MOVFW	f0
	MOVWF	AARGB3
	MOVFW	f1
	MOVWF	AARGB2
	MOVFW	f2
	MOVWF	AARGB1
	MOVFW	f3
	MOVWF	AARGB0
	MOVFW	xw0
	MOVWF	BARGB2
	MOVFW	xw1
	MOVWF	BARGB1
	MOVFW	xw2
	MOVWF	BARGB0

	CALL	FXD3224S	;  ca 500 cyles = 0.1 ms

	MOVFW	AARGB3
	MOVWF	f0
	MOVFW	AARGB2
	MOVWF	f1
	MOVFW	AARGB1
	MOVWF	f2
	return



;**************************************************************
; positiven 16 Bit Wert (f1,f0) in 4 dezimale Ziffern wandeln
OutDez16
	call	Hex2Dez16	; 16-bit(f1,f0) in 4-stellen Bcd (T,H,Z,E)

	; falls HdT>9 dann '  Hi'
	movlw	D'10'
	subwf	HdT, w
	bc	OutDezOver

	; 0000 .. 9999
	movfw	HdT
	movwf	Ziffer0
	movfw	HdH
	movwf	Ziffer1
	movfw	HdZ
	movwf	Ziffer2
	movfw	HdE
	movwf	Ziffer3
	return

OutDezOver
	; HdT>9  '  Hi'
	movlw	D'10'
	movwf	Ziffer0
	movwf	Ziffer1
	movlw	D'14'
	movwf	Ziffer2
	movlw	D'15'
	movwf	Ziffer3
	return


; 16-bit(f1,f0) in 4-stellen Bcd (T,H,Z,E)
;             1000 = 0000 03E8 h
;              100 = 0000 0064 h
;               10 = 0000 000A h
;                1 = 0000 0001 h
Hex2Dez16			
	clrf	f2

	movlw	0x00		; 1000 = 0000 03E8 h
	movwf	xw2
	movlw	0x03
	movwf	xw1
	movlw	0xE8
	movwf	xw0
	clrf	HdX
	decf	HdX, f
HdLoop5
	incf	HdX, f
	call	Sub24		; ca 30 cyc	
	btfss	STATUS, C	; berlauf
	goto	HdLoop5		; Stelle 1 mehr
	call	Add24
	movfw	HdX
	movwf	HdT
	
	movlw	0x00		; 100 = 00 00 64 h
	movwf	xw2
	movwf	xw1
	movlw	0x64
	movwf	xw0
	clrf	HdX
	decf	HdX, f
HdLoop3
	incf	HdX, f
	call	Sub24	
	btfss	STATUS, C	; berlauf
	goto	HdLoop3		; Stelle 1 mehr
	call	Add24
	movfw	HdX
	movwf	HdH

	movlw	0x00		; 10 = 00 00 0A h
	movwf	xw2
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	clrf	HdX
	decf	HdX, f
HdLoop4
	incf	HdX, f
	call	Sub24	
	btfss	STATUS, C	; berlauf
	goto	HdLoop4		; Stelle 1 mehr
	call	Add24
	movfw	HdX
	movwf	HdZ

	movfw	f0
	movwf	HdE
	return



; Microchip-Bibliothek AN617
;**************************************************************
;       All arguments to the fixed point routines in the math library are passed through
;	the locations
;		AARGB0,AARGB1,AARGB2,AARGB3
;		BARGB0,BARGB1,BARGB2,BARGB3
;	with the result in
;		AARGB0,AARGB1,AARGB2,AARGB3,AARGB4,AARGB5,AARGB6,AARGB7
;	All fixed point operands are left justified to xARGB0, and are either unsigned or
;	in signed two's complement representation. 

;	To divide the 32 bit signed integer AARG = 0x83-5A-3F-C1 the the 24 bit signed integer
;	BARG = 0x5C-3B-E5, simply load AARG and BARG with the appropriate values and call
;	FXD3224S. The 32 bit signed quotient, 0xFF-FF-FE-A7, is left justified in AARG and the
;	24 bit signed remainder, 0xA6-F7-5E, is left justified in REM.

	#INCLUDE <FXD24.A16>

	end
