	list p=16f84
;**************************************************************
;*
;* Pinbelegung
;*	
;*	PORTA: 	0 Ziffer	-----------------------------------------------------+
;*		1 Ziffer	-------------------------------------+               I
;*		2 Ziffer	---------------------+               I               I
;*		3 Ziffer	-----+               I               I               I
;*		4 Eingang	     I               I               I               I  
;*	PORTB:	0 Segment B	   AAAAA	   AAAAA	   AAAAA	   AAAAA
;*		1 Segment F	  F     B	  F     B	  F     B	  F     B
;*		2 Segment A	  F     B	  F     B	  F     B	  F     B
;*		3 Segment G	   GGGGG  	   GGGGG  	   GGGGG  	   GGGGG  
;*		4 Segment H	  E     C	  E     C	  E     C	  E     C
;*		5 Segment C	  E     C	  E     C	  E     C	  E     C
;*		6 Segment E	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH	   DDDDD  HH
;*		7 Segment D    
;*
;**************************************************************
;
; sprut (zero) Bredendiek 09/2003
;
; Frequenzzhler mit 4-stellige LED-Anzeige
;
; Taktquelle: 10 MHz
;
;
;**************************************************************
; Includedatei fr den 16F84 einbinden

	#include <P16f84.INC>

; Configuration festlegen
; 10 MHz: Power on Timer, kein Watchdog, HS-Oscillator

	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC

;**************************************************************

; Variablennamen vergeben

w_copy		Equ	0x20	; Backup fr Akkuregister
s_copy		Equ	0x21	; Backup fr Statusregister
Ziffer1		Equ	0x22	; Wert des LSD
Ziffer2		Equ	0x23	; Wert der zweitkleinsten Stelle
Ziffer3		Equ	0x24	; Wert der zweitgrten Stelle
Ziffer4		Equ	0x25	; Wert des MSD
Digit		Equ	0x26	; Ziffernzhler
ar		Equ	0x27
countdown 	Equ	0x28	; stoppt Display nach 1/4 Sekunde
Fehler		EQU	0x29

; 16-Bit Rechenregister
xw0		EQU	0x2A	;LSB
xw1		EQU	0x2B	;MSB 

; 16-Bit Rechenregister
f0		EQU	0x2C	;LSB
f1		EQU	0x2D	;MSB

; Dezimalstellen
HdX		EQU	0x36	; Puffer fr eine Dezimalstelle

; 24 Bit Frequenzzhler
BIN4		EQU	0x3B	;LSB
BIN41		EQU	0x3C	;MSB 
BIN42		EQU	0x3D	; I extra

; Hilfszellen fr Frequenzmeschleife
HLTest		EQU	0x3F	; HL-Flanken-Detektorn fr Timer0-berlauf
HighCOU		EQU	0x40	; high-Teil des Schleifenzhlers
LowCOU		EQU	0x41	; low-Teil des Schleifenzhlers


;**************************************************************
; los gehts mit dem Programm

	org 	0
	goto	Init	

;**************************************************************
; die Interuptserviceroutine fr die multiplexe Anzeige
; Int wird vom Timer0 ausgelst

	org 	4 	
intvec
	movwf	w_copy		; w retten
	swapf	STATUS, w 	; STATUS retten
	movwf	s_copy		;
	; die Multiplexfrequenz der Anzeige betrgt 305 Hz um Flackern zu vermeiden
	movlw	D'0'		; 256-0=256 ((2,5 MHz : 32 ): 256 = 305 Hz)
	movwf	TMR0

; Intrupt servic routine
Int_serv 

	bsf	PORTA, 0	; Ziffer1 aus
	bsf	PORTA, 1	; Ziffer2 aus
	bsf	PORTA, 2	; Ziffer3 aus
	bsf	PORTA, 3	; Ziffer4 aus

	decf	Digit,f		; Ziffernzhler verringern
	;Digit=4: anzeigen Ziffer X---
	;Digit=3: anzeigen Ziffer -X--
	;Digit=2: anzeigen Ziffer --X-
	;Digit=1: anzeigen Ziffer ---X
	;Digit=0: andere Aktionen, keine Anzeige

	btfsc	STATUS, Z
	goto	Int_0		; Z-Flag=1 ergo Digit=0
	movfw	Digit
	movwf	ar
	decf	ar, f
	btfsc	STATUS, Z
	goto	Int_1		; Digit=1
	decf	ar, f
	btfsc	STATUS, Z
	goto	Int_2		; Digit=2
	decf	ar, f
	btfsc	STATUS, Z
	goto	Int_3		; Digit=3
	goto	Int_4		; Digit=4

Int_0
	; die Anzeigeroutine wird 15 mal durchlaufen
	decf	countdown, f
	; Ziffernzhler wieder zurckstellen
	movlw	5
	movwf	Digit
	goto	Int_end

Int_1
	movfw	Ziffer1		; Wert der letzten Ziffer
	call	Segmente
	movwf	PORTB		; Segmente einschalten
	bcf	PORTA, 0	; letzte Ziffer einschalten
	goto	Int_end

Int_2
	movfw	Ziffer2		; Wert der vorletzten Ziffer
	call	Segmente
	movwf	PORTB		; Segmente einschalten
	bcf	PORTA, 1	; vorletzte Ziffer einschalten
	goto	Int_end

Int_3
	movfw	Ziffer3		; Wert der 2. Ziffer
	call	Segmente
	movwf	PORTB		; Segmente einschalten
	bcf	PORTB,4		; Komma einschalten
	bcf	PORTA, 2	; 2. Ziffer einschalten
	goto	Int_end

Int_4
	movfw	Ziffer4		; Wert der vordersten Ziffer
	call	Segmente
	movwf	PORTB		; Segmente einschalten
	bcf	PORTA, 3	; vorderste Ziffer einschalten
	goto	Int_end

Int_end	swapf	s_copy, w	; STATUS zurck
	movwf	STATUS 
	swapf	w_copy, f	; w zurck mit flags
	swapf	w_copy, w

	bcf	INTCON, T0IF	; Interupt-Flag lschen
	retfie

; 7-Segment-Tabelle
Segmente
	addwf	PCL, f
	retlw	B'00011000'	; 0
	retlw	B'11011110'	; 1
	retlw	B'00110010'	; 2
	retlw	B'01010010'	; 3
	retlw	B'11010100'	; 4
	retlw	B'01010001'	; 5
	retlw	B'00010001'	; 6
	retlw	B'11011010'	; 7
	retlw	B'00010000'	; 8
	retlw	B'01010000'	; 9

;**************************************************************
; Hauptprogramm beginnt mit der Initialisierung
; Port A/B auf Ausgabe stellen (auer RA4)

Init
	movlw	B'11111111'
	movwf	PORTA
	movwf	PORTB		; Anzeige dunkel
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'11110000'	; PortA RA0-RA3 output
	movwf	TRISA
	movlw	B'00000000'	; PortB alle output
	movwf	TRISB
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten

	; Ziffernzhler fr die multiplexe Anzeige voreinstellen
	movlw	5
	movwf	Digit

; eine beliebige Zahl einstellen (hier: 1234)
; die dann vom Frequenzmesser sofort berschrieben wird
	movlw	4
	movwf	Ziffer1
	movlw	3
	movwf	Ziffer2
	movlw	2
	movwf	Ziffer3
	movlw	1
	movwf	Ziffer4

; Display fr 1/4 Sekunde einschalten
; das sind 15 Anzeigezyklen
LEDan
	movlw	D'15'
	movwf	countdown

; 305 Hz-Timer-Interupt einstellen
	bsf     STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'10000100'	; internen Takt zhlen, Vorteiler zum Timer0, 32:1
	movwf	OPTION_REG
	movlw	D'0'		; 256-0=256 ((2,5 MHz : 32 ): 256 = 305 Hz)
	bcf     STATUS, RP0	; auf Bank 0 zurckschalten
	movwf	TMR0
	bsf	INTCON, T0IE	; Timer0 interupt erlauben
	bsf	INTCON, GIE	; Interupt erlauben

; warten auf das Ende der 1/4 Sekunde
loop
	tstf	countdown
	bnz	loop		; eine warten auf Ende der 1/4 Sekunde
	bcf	INTCON, GIE	; Interupt verbieten
	movlw	B'11111111'
	movwf	PORTA
	movwf	PORTB		; Anzeige dunkel
	call	Frequ_Loop	; Frequenz an RA4 messen
	goto	LEDan		; Frequenz anzeigen

;**************************************************************
; (HighCOU,LowCOU)x20Takte lang wird gezhlt
; das 24-Bit Ergebnis steht in BIN4+2 (MSB) bis BIN4 (LSB)
; virtuell steht davor BIN+3=0
; das mach dann 32Bit
; 
; fr die Messung
; 10MHz ; 3,2 ms =  8000 Takte =   400 x 20 Takte, 0,01,90h=  400d
;
Frequ_Loop

;Messung mit 32:1 Vorteiler
	clrf	BIN4+1 		; Zhler lschen
	clrf	BIN4+2 		; Zhler lschen
	clrf	BIN4+3 		; Zhler lschen
	clrf	HLTest	 	; lsche TMR0 berlauf-Detektor
	movlw	001h+1 		; high loop counter fr die Mezeit
	movwf	HighCOU 	; HighCOU = hi byte counter
	movlw	090h+1 		; 0190h=400 cycles=8000,T=3,2 ms
	movwf	LowCOU 		; LowCOU = lo byte counter  fr die Mezeit
	movlw	4	 	; Vorteiler-Faktor = 32:1
	call	Messung
;Ende der Zhlroutine

; 16 Bit zur Anzeige bringen
	movfw	BIN4		; Wert aus dem Timer0
	movwf	f0
	movfw	BIN4+1		; Softwarezhler untere 8 Bit
	movwf	f1

;Binr zu BCD Wandlung mit Ausgabe
	call	OutDez16	; 'xx xxx xxx'

	return

;**************************************************************
; die eigentliche  Meroutine
; Mezeit = 20Takte x (HighCOU,LowCOU)
; Prescaler in w
Messung
	addlw	20h 		; for PRESC 0,1,2,3... w=20h,21h,22h,23h...
				; TOSE=0, TOCS=1, PSA=0, PS=0..7
	bsf	STATUS,RP0 	; bank 1
	movwf	OPTION_REG 	; 
	bcf	STATUS,RP0 	; bank 0
	clrf	TMR0 		; initialisiere TMR0

Loop500A
	nop			; warten
	nop			; warten
Loop500
	movf	TMR0, W		; 1 1 1 nur hier wird TMR0 ausgelesen
	movwf	BIN4		; 1 1 1 rtcc ---> freq0
	rlf	BIN4, W		; 1 1 1 carry <--- TMR0.7
	rlf	HLTest, F	; 1 1 1 rotor <--- carry
	movf	HLTest, W	; 1 1 1 HLTest=TMR0 overflow detect
	andlw	3		; 1 1 1 mask 2 LSbs for edge detect
	xorlw	2		; 1 1 1 00000000 if 1 <--- 0
	btfss	STATUS, Z	; 1 2 2 | skip if TMR0 overflow
	goto	NotOvf1		; 2 - - | if nz
				;       | 5T any case
	incf	BIN4+1, F	; - 1 1 | nsb
NotOvf1 btfsc	STATUS, Z	; 2 2 1 | skip MSB adv ifnot overflow
	incf	BIN4+2, F 	; - - 1 | msb
	nop			; warten
	nop			; warten
	nop			; warten
	decfsz	LowCOU, F 	; 1 (2) lo loop counter
	goto	Loop500A 	; 2 (-) 20T total
	decfsz	HighCOU, F 	; (1) hi loop counter
	goto	Loop500 	; (2) 20T total

	return

;**************************************************************
; 16 Bit Wert (f1,f0) auf LED dezimal anzeigen
OutDez16			;16-bit (f1,f0) als Dez zum LED

; Wandlung einer 16Bit-Zahl in eine 4-stellige BCD-Zahl
;      1 000 =  03E8 h
;        100 =  0064 h
;         10 =  000A h
;          1 =  0001 h
; 16-bit(f1,f0) in 4-stellen Bcd (T,H,Z,E)

	; Tausender
	movlw	0x03		; 1 000 = 03 E8 h
	movwf	xw1
	movlw	0xE8
	movwf	xw0
	call	Hex2Dez1	; 1000er
	movfw	HdX
	movwf	Ziffer4		; HdT

	; Hunderter
	movlw	0x00		; 100 = 00 64 h
	movwf	xw1
	movlw	0x64
	movwf	xw0
	call	Hex2Dez1	; 100er
	movfw	HdX
	movwf	Ziffer3		; HdH

	; Zehner
	movlw	0x00		; 10 = 00 0A h
	movwf	xw1
	movlw	0x0A
	movwf	xw0
	call	Hex2Dez1	; 10er
	movfw	HdX
	movwf	Ziffer2		; HdZ

	; Einer
	movfw	f0
	movwf	Ziffer1		; HdE
	return

Hex2Dez1
	clrf	HdX
	decf	HdX, f
HdLoop
	incf	HdX, f
	call	Sub16		;
	btfss	STATUS, C	;berlauf
	goto	HdLoop		;Stelle 1 mehr
	call	Add16
	return


;*********************************************************************
;16 bit Adition, C-Flag bei berlauf gesetzt
Add16                           ; 16-bit add: f := f + xw
	movf    xw0,W           ; xw0 nach W
	addwf   f0,F            ; f0 := f0 + xw0

	movf    xw1,W           ; xw1 nach W
	btfsc   STATUS,C        ; fall ein berlauf auftrat:
	incfsz  xw1,W           ;   xw1+1 nach W
	addwf   f1,F            ; f1 := f1 + xw1

	return                  ; fertig


;*********************************************************************
; 16 Bit Subtraktion, bei berlauf (neg. Ergebnis) ist C gesetzt
Sub16                           ; 16 bit f:=f-xw 
	clrf    Fehler          ; extraflags lschen 

	movf    xw0, w          ; f0:=f0-xw0
	subwf   f0, f

	btfsc   STATUS,C
	goto    Sub16a
	movlw   0x01            ; borgen von f1
	subwf   f1, f

	btfss   STATUS,C
	bsf     Fehler, C       ; Unterlauf

Sub16a
	movf    xw1,w           ; f1:=f1-xw1
	subwf   f1    ,f

	btfss   STATUS,C
	bsf     Fehler, C       ; Unterlauf

	bcf     STATUS, C       ; C-Flag invertieren
	btfsc   Fehler, C
	bsf     STATUS, C
	return

;*********************************************************************

	end



