	list p=16f628
;**************************************************************
;*  	Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 <---------+----+--R1---o U?
;*		1 -         I    I
;*		2 x-Vref    I    C 
;*		3 >----R2---+    I
;*		4 -               Vss  
;*		5 - MCLR
;*		6 - OSC2
;*		7 - OSC1
;*
;*	PORTB:	0 > LED
;*		1 > LED
;*		2 > LED
;*		3 > LED
;*		4 > LED
;*		5 > LED
;*		6 > LED
;*		7 > LED
;*
;* R1 =  47 k
;* R2 =  47 k
;* C  = 100 nF 
;*	
;**************************************************************
;
;sprut (zero) Bredendiek 01/2003
;
; ADC mit Comparator 
;
; Prozessor 16F628 
;
; Prozessor-Takt 4 MHz
;
; LED-Zeile am PortB
;
;**************************************************************
; 
; der code fpr die eigentliche Wandlung wurde aus AN700 bernommen
;
;**************************************************************
; Includedatei fr den 16F628 einbinden

	#include <P16f628.INC>

	ERRORLEVEL      -302    	; SUPPRESS BANK SELECTION MESSAGES


; Configuration festlegen:
; Power on Timer, kein Watchdog, HS-Oscillator, kein Brown out, kein LV-programming
	__CONFIG	_PWRTE_ON & _WDT_OFF & _HS_OSC & _BODEN_OFF & _LVP_OFF

; Constanten festlegen
#define	LED	PORTB

; Variable festlegen
counter		equ	0x20		; 
result_l	equ	0x22		; 
result_h	equ	0x23		; 


;**************************************************************
; Programmanfang

	org	0

;**************************************************************
; Initialisierung *********************************************

init
	bsf	STATUS, RP0		; Bank 1
	clrf	OPTION_REG 
	clrf	TRISB			; PortB alle outputs 
	bcf     STATUS, RP0		; Bank 0
	clrf	PORTB			; LEDs aus
	clrf	INTCON        		; Interupt disable
	call	InitCAdc		; ADC vorbereiten

mainloop
	call	CAdc			; wandeln
	movfw	result_l
	movwf	PORTB			; Low-8-Bit an PORTB anzeigen
	goto	mainloop


;**************************************************************
; ADC-code aus AN700*******************************************
; initialisierung des adc**************************************
InitCAdc
	bsf	STATUS, RP0
	movlw	0xEC		; Vref ein, Vref zu RA2
	movwf	VRCON		; LowRangeMode, VR = 12 = 2,5 V
	bcf	PORTA, 3	; RA3 output des 'DAC'
	bcf	STATUS, RP0
	movlw	0x06		; 2 Komparatoren mit Referenzspannung
	movwf	CMCON		; Comp1 out = RA3
	return

;**************************************************************
; Wandeln der spannung*****************************************
CAdc
	clrf	counter
	clrf	counter+1
	clrf	result_l
	clrf	result_h
	movlw	0x03		; 2 Komparatoren mit Referenzspannung
	movwf	CMCON
loop
	btfsc	CMCON, C1OUT	; ist Komparator High oder low
	goto	complow		; low
comphigh
	nop			; high
	bcf	PORTA, 3	; 'DAC' = 0
	incfsz	result_l, f	; zhlen der 'Spannung'
	goto	eat2cycles
	incf	result_h, f
	goto	endloop
complow
	bsf	PORTA, 3	; 'DAC' = 1
	nop
	goto	eat2cycles
eat2cycles
	goto	endloop
endloop
	incfsz	counter, f	; Zahl der Zyklen Zhlen
	goto	eat5cycles
	incf	counter+1, f
	movf	counter+1, w
	andlw	0x04		; nur Bit 2 einblenden
	btfsc	STATUS, Z	; Bit 2 =1 ?    1024 Zyklen vorbei?
	goto	loop		; nein
	goto	exit		; ja
eat5cycles
	goto	$+1
	nop
	goto	loop
exit
	movlw	0x06		; 2 Komparatoren mit Referenzspannung
	movwf	CMCON		; Comp1 out = RA3
	return

	end
