;**************************************************************
;*
;* Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 
;*		1 
;*		2 
;*		3 
;*		4 
;*	PORTB:	0 LED	   
;*		1 LED	    
;*		2 LED	    
;*		3 LED	     
;*		4 LED	    
;*		5 LED	    
;*		6 LED	    
;*		7 LED	    
;*	PORTC:	0 
;*		1   
;*		2 	    
;*		3      
;*		4 
;*		5  
;*		6 RS-232-Ausgang zum Treiber	    
;*		7 RS-232-Eingang vom Treiber	    
;*
;**************************************************************
;
; sprut (zero) Bredendiek 06/2001
;
; RS-232-ECHO:
;
; 16F876 empfngt RS232 Code
; der empfangene Ccode wird am PORTB ausgegeben
; danach wird der code um 1 erhht und mit RS232 zurckgesendet
;
; Prozessortakt:  20 MHz
; RS232-Baudrate: 19 200 Baud
;
;**************************************************************
; Includedatei fr den 16F84 einbinden

	list p=16f876
	#include <P16f876.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

;**********************************************************
; Variablennamen vergeben

w_temp		equ	0x20
status_temp	equ	0x21
Zeichen		equ	0x22
DatenSindDa	equ	0x24

	org	0
	goto	init

;**********************************************************
; Interruptroutine fr RS232-Empfang

	org	4		; Interrupt beginnt immer bei Adresse 4 
int 
	movwf	w_temp		; status retten 
	swapf	STATUS,w 
	movwf	status_temp 

;RS232-Empfnger-Interupt? 
	btfss	PIR1,RCIF 
	goto	intEnde		; Interrupt kam von wo anders 

	movfw	RCREG		; RS232-Register auslesen 
	movwf	Zeichen		; und in den Speicher nach 'Zeichen' schreiben 
	movwf	PORTB		; Zeichen am PortB anzeigen
	bsf	DatenSindDa,0	; Kennzeichen fr gltige Daten setzen
	bcf	PIR1,RCIF	; interrupt-Flag lschen 

intEnde				; geretteten Status wieder zurckschreiben 
	swapf	status_temp,w 
	movwf	STATUS 
	swapf	w_temp,f 
	swapf	w_temp,w 
	retfie 

;**********************************************************
; Anfangsinitialisierung

init
	clrf	DatenSindDa

	bsf	STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'00000000'	; PortB alle output
	movwf	TRISB
	bcf	STATUS, RP0	; auf Bank 0 zurckschalten
	clrf	PORTB		; alle LEDs ausschalten

; USART initialisieren 
	BSF	STATUS,RP0	; Bank1 
	MOVLW	0x20		; Sender: RS232 
	MOVWF	TXSTA		; 
	BCF	STATUS,RP0	; Bank 0 
	MOVLW	0x90		; Empfnger: RS232 
	MOVWF	RCSTA		; 

; USART Baudrate einstellen 
	BSF	STATUS,RP0	; Bank1 
	MOVLW	D'15'		; Set Baud rate 19,2 kBPS bei 20 MHz 
	MOVWF	SPBRG 
	BCF	TXSTA, BRGH	; BRGH=0 
	BCF	STATUS,RP0	; Bank 0 

;Interrupts vorbereiten 
	BSF	STATUS,RP0	; Bank1 
	BSF	PIE1,RCIE	; Enable receive interrupts 
	BCF	STATUS,RP0	; Bank 0 
	clrf	PIR1		; alle Interruptflags lschen 
	clrf	PIR2 
	BSF	INTCON,GIE	; generell Interrupts erlauben 
	BSF	INTCON,PEIE	; Interrupts von Peripheriegerten erlauben 

;**********************************************************
; Hauptprogrammschleife

Main
	btfss	DatenSindDa, 0
	goto	Main

RS232out 
	btfss	PIR1,TXIF	; ist Sender leer ? 
	goto	RS232out	; nein, noch nicht leer
	incf	Zeichen,w	; um 1 erhht nach w 
	movwf	TXREG		; und in den RS232-Sender schreiben 
	clrf	DatenSindDa
	goto	Main

	end

