;**************************************************************
;*
;* Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 
;*		1 
;*		2 
;*		3 
;*		4 
;*	PORTB:	0 
;*		1    
;*		2  
;*		3 
;*		4 
;*		5   
;*		6 	    
;*		7 	    
;*	PORTC:	0 
;*		1   
;*		2 PWM-Ausgang	    
;*		3      
;*		4 
;*		5  
;*		6 	    
;*		7 	    
;*
;**************************************************************
;
; sprut (zero) Bredendiek 04/2002
;
; PWM-Lernbeispiel:
;
; 16F876 erzeugt an RC2 ein 2,5 kHz-Signal mit 50% Tastverhltnis
;
;
; Prozessortakt:  20 MHz
;
;**************************************************************
; Includedatei fr den 16F84 einbinden

	list p=16f876
	#include <P16f876.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

;**********************************************************

; Anfangsinitialisierung

init
; Vorteiler 16:1 und Timer2 einschalten
	BSF	T2CON,T2CKPS1	; Vorteiler 16:1
	BSF	T2CON,TMR2ON	; Timer2 ein

; Frequenz auf 2,5 kHz einstellen
	BSF	STATUS,RP0	; Bank1
	MOVLW	D'124'		;
	MOVWF	PR2		; 2,5 kHz
	BCF	STATUS,RP0	; Bank1

; Tastverhltnis auf 50% einstellen
	MOVLW	D'62'		;
	MOVWF	CCPR1L		; 50% von 124

; RC2/CCP1 auf Ausgang stellen
	BSF	STATUS,RP0	; Bank1
	BCF	TRISC, 2	; RC2: output=0
	BCF	STATUS,RP0	; Bank 0

; PWM MODE mit CCP1 initialisieren
	CLRF	CCP1CON		; CCP1-Modus aus
	BSF	CCP1CON,CCP1M3	; CCP1-Modus PWM-Mode
	BSF	CCP1CON,CCP1M2	;

loop
	GOTO	loop

	end

;**********************************************************
