;**************************************************************
;*
;* Pinbelegung
;*	----------------------------------	
;*	PORTA: 	0 analoger Eingang
;*		1 
;*		2 
;*		3 
;*		4 
;*	PORTB:	0 LED	   
;*		1 LED	    
;*		2 LED	    
;*		3 LED	     
;*		4 LED	    
;*		5 LED	    
;*		6 LED	    
;*		7 LED	    
;*	PORTC:	0 
;*		1   
;*		2 	    
;*		3      
;*		4 
;*		5  
;*		6 	    
;*		7 	    
;*
;**************************************************************
;
; sprut (zero) Bredendiek 04/2002
;
; ADC-Lernbeispiel:
;
; 16F876 wandelt die an RA0 anliegende Spannung in einen
; 10-Bit-Wert um
; die oberen 8 Bit des Wertes werden an PortB angezeigt
;
; Prozessortakt:  20 MHz
; Eingangsspannung: 0V ... 5V (Vss ... Vdd)
;
;**************************************************************
; Includedatei fr den 16F876 einbinden

	list p=16f876
	#include <P16f876.INC>

	ERRORLEVEL      -302    	;SUPPRESS BANK SELECTION MESSAGES

;**********************************************************

; Variablen
wait	EQU	0x20

; Anfangsinitialisierung

init
; PortB vorbereiten
	bsf	STATUS, RP0	; auf Bank 1 umschalten
	movlw	B'00000000'	; PortB alle output
	movwf	TRISB
	bcf	STATUS, RP0	; auf Bank 0 zurckschalten
	clrf	PORTB		; alle LEDs ausschalten

; ADC einschalten
	BSF	ADCON0, 0	; ADON=1

; ADC-Eingang AN0 auswhlen
	BCF	ADCON0, 5	; ADCHS2=0
	BCF	ADCON0, 4	; ADCHS1=0
	BCF	ADCON0, 3	; ADCHS0=0

; ADC speed fr 20 MHz einstellen
	BSF	ADCON0, 7	; ADCS1=1
	BCF	ADCON0, 6	; ADCS0=0

; Daten linksbndig
	BSF	STATUS,RP0	; Bank1
	BCF	ADCON1, 7	; ADFM=0
	BCF	STATUS,RP0	; Bank0


;**********************************************************
; Hauptprogrammschleife

Main
;Eingangsspannung wandeln
	BSF	ADCON0, 2	; ADC starten
loop
	BTFSC	ADCON0, 2	; ist der ADC fertig?
	GOTO	loop		; nein, weiter warten

; Wert nach PortB schreiben
	movfw	ADRESH		; obere 8 Bit auslesen
	movwf	PORTB		; obere 8-Bit nach PortB

; Warten, damit der ADC sich erholen kann
	clrf	wait
warten
	DECFSZ	wait, f
	goto	warten

	goto	Main

	end

;**********************************************************
