unit usb;

// benutzt Informationen von
// http://www.sixca.com/delphi/article/microchip_usb.html

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, usbdll;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    Button3: TButton;
    Button2: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure LEDSwitch(b:byte);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


// Die DLL-Version abfragen
procedure TForm1.Button1Click(Sender: TObject);
begin
  memo1.Lines.add('_MPUSBGetDLLVersion : '+inttohex(_MPUSBGetDLLVersion,8));
end;


//wieviele Testplatinen sind angeschlossen?
procedure TForm1.Button2Click(Sender: TObject);
begin
  memo1.Lines.add('_MPUSBGetDeviceCount : '+inttohex(_MPUSBGetDeviceCount(vid_pid),8));
end;


//Firmwareversion auslesen
procedure TForm1.Button3Click(Sender: TObject);
var
   selection   : DWORD;
   send_buf    : PBYTE;
   receive_buf : PBYTE;
   RecvLength  : DWORD;
   CurrentCMD  : BYTE;
begin
  // Read Firmware version
  //instance ist warscheinlich 0, kann aber auch einen anderen Wert haben
  selection:=0;

  // sind USB-Devices vorhanden?
  if (_MPUSBGetDeviceCount(vid_pid)=0) then
  begin
    Memo1.lines.add('- Device not connected');
    exit;
  end;

  //pipes anfordern
  //fr die instance=0
  //es kann aber passieren, dass instance<>0 !!
  //da ist noch nacharbeit ntig
  myOutPipe:= _MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
  myInPipe:= _MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
  //habe ich pipes bekommen?
  if ((myOutPipe = INVALID_HANDLE_VALUE) or (myInPipe = INVALID_HANDLE_VALUE)) then
  begin
    Memo1.lines.add('USB Error');
    exit;
  end;

  //Firmwareversion auslesen
  send_buf[0]:=READ_VERSION;    //0
  RecvLength:=4;
  if(SendReceivePacket(send_buf,1,receive_buf,RecvLength,100,100) = 1) then begin
    if(receive_buf[0] =  READ_VERSION) then begin
      Memo1.lines.add('Firmware version : '+ IntToStr(receive_buf[3])+'.'+IntToStr(receive_buf[2]));
    end;
  end
  else
  begin
    Memo1.lines.add('USB Error');
  end;

  _MPUSBClose(myOutPipe);
  _MPUSBClose(myInPipe);
  myInPipe:= INVALID_HANDLE_VALUE;
  myOutPipe:=INVALID_HANDLE_VALUE;
end; //Firmwareversion auslesen


//Potentiometer  abfragen
procedure TForm1.Button4Click(Sender: TObject);
var
   selection   : DWORD;
   send_buf    : PBYTE;
   receive_buf : PBYTE;
   RecvLength  : DWORD;
   CurrentCMD  : BYTE;
begin
  //instance ist warscheinlich 0, kann aber auch einen anderen Wert haben
  selection:=0;

  //pipes anfordern
  //fr die instance=0
  //es kann aber passieren, dass instance<>0 !!
  //da ist noch nacharbeit ntig
  myOutPipe:= _MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
  myInPipe:= _MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
  //habe ich pipes bekommen?
  if ((myOutPipe = INVALID_HANDLE_VALUE) or (myInPipe = INVALID_HANDLE_VALUE)) then
  begin
    Memo1.lines.add('USB Error, no pipes');
    exit;
  end;

  //Potentiometer
  send_buf[0]:=RD_POT;    //6
  RecvLength:=3;
  if(SendReceivePacket(send_buf,1,receive_buf,RecvLength,100,100) = 1) then begin
    if(receive_buf[0] =  RD_POT) then begin
      Memo1.lines.add('Poti : '+ IntToStr(receive_buf[2])+'.'+IntToStr(receive_buf[1]));
    end;
  end
  else
  begin
    Memo1.lines.add('USB Error');
  end;

  _MPUSBClose(myOutPipe);
  _MPUSBClose(myInPipe);
  myInPipe:= INVALID_HANDLE_VALUE;
  myOutPipe:=INVALID_HANDLE_VALUE;
end; //Potentiometer


//RESET fr USB-Device
procedure TForm1.Button5Click(Sender: TObject);
var
   selection   : DWORD;
   send_buf    : PBYTE;
   receive_buf : PBYTE;
   RecvLength  : DWORD;
   CurrentCMD  : BYTE;
begin
  //instance ist warscheinlich 0, kann aber auch einen anderen Wert haben
  selection:=0;

  //pipes anfordern
  //fr die instance=0
  //es kann aber passieren, dass instance<>0 !!
  //da ist noch nacharbeit ntig
  myOutPipe:= _MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
  myInPipe:= _MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
  //habe ich pipes bekommen?
  if ((myOutPipe = INVALID_HANDLE_VALUE) or (myInPipe = INVALID_HANDLE_VALUE)) then
  begin
    Memo1.lines.add('USB Error, no pipes');
    exit;
  end;

  //Reset
  send_buf[0]:=RESET;    //6
  RecvLength:=0;
  SendReceivePacket(send_buf,1,receive_buf,RecvLength,100,100);

  _MPUSBClose(myOutPipe);
  _MPUSBClose(myInPipe);
  myInPipe:= INVALID_HANDLE_VALUE;
  myOutPipe:=INVALID_HANDLE_VALUE;
end;  //LEDs


//Ein- und Ausschalten von LEDs
procedure TForm1.LEDSwitch(b:byte);
var
   selection   : DWORD;
   send_buf    : PBYTE;
   receive_buf : PBYTE;
   RecvLength  : DWORD;
   CurrentCMD  : BYTE;
begin
  //instance ist warscheinlich 0, kann aber auch einen anderen Wert haben
  selection:=0;

  //pipes anfordern
  //fr die instance=0
  //es kann aber passieren, dass instance<>0 !!
  //da ist noch nacharbeit ntig
  myOutPipe:= _MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
  myInPipe:= _MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
  //habe ich pipes bekommen?
  if ((myOutPipe = INVALID_HANDLE_VALUE) or (myInPipe = INVALID_HANDLE_VALUE)) then
  begin
    Memo1.lines.add('USB Error, no pipes');
    exit;
  end;

  //ID_BOARD
  send_buf[0]:=LED_ONOFF;
  send_buf[1]:=b;       
  RecvLength:=1;
  if(SendReceivePacket(send_buf,2,receive_buf,RecvLength,100,100) = 1) then begin
    if(receive_buf[0] =  RD_POT) then begin
      Memo1.lines.add('Poti : '+ IntToStr(receive_buf[2])+'.'+IntToStr(receive_buf[1]));
    end;
  end
  else
  begin
    Memo1.lines.add('USB Error');
  end;

  _MPUSBClose(myOutPipe);
  _MPUSBClose(myInPipe);
  myInPipe:= INVALID_HANDLE_VALUE;
  myOutPipe:=INVALID_HANDLE_VALUE;
end; // LED Switch


procedure TForm1.Button7Click(Sender: TObject);
begin
  LEDSwitch(0);
end;


procedure TForm1.Button6Click(Sender: TObject);
begin
  LEDSwitch(1);
end;


procedure TForm1.Button8Click(Sender: TObject);
begin
  LEDSwitch(2);
end;


procedure TForm1.Button9Click(Sender: TObject);
begin
  LEDSwitch(3);
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
  LEDSwitch(4);
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
  LEDSwitch(5);
end;

procedure TForm1.Button13Click(Sender: TObject);
begin
  LEDSwitch(6);
end;

procedure TForm1.Button14Click(Sender: TObject);
begin
  LEDSwitch(7);
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
  close;
end;

end.
