;******************************************************************************
; sprut (zero) Bredendiek 02/2006 
;
; Lauflicht am Port D
;
; Taktquelle: 20 MHz
;
;******************************************************************************
;
; Pinbelegung
;	----------------------------------	
;	PORTD:	0 LED	   
;		1 LED	    
;		2 LED	    
;		3 LED	     
;		4 LED	    
;		5 LED	    
;		6 LED	    
;		7 LED	    
;
;******************************************************************************

	LIST P=18F8720		;der Typ des Prozessors
	#include <P18F8720.INC>	;processor-spezifische Variablendefinitionen

;******************************************************************************
;Configuration bits
    CONFIG	OSC = HS	; HS 20 MHz
    CONFIG	PWRT = ON	; power up timer on
    CONFIG	BOR = OFF	; brown out detect off
    CONFIG	WDT = OFF	; watchdog off
    CONFIG	LVP = OFF	; lvp off

;******************************************************************************
;Variable definitions

		CBLOCK	0x000
		loops		
		loops2
		ENDC

;******************************************************************************
;Reset vector
; hier beginnt der Prozessor beim Reset

		ORG	0x0000
		goto	Main		;go to start of main code

;******************************************************************************
;Start of main program

Main:
; Port D kmnfigurieren
; alle Pins sind output
	clrf	TRISD
	clrf	PORTD		; alle LEDs ausschalten

; 1. LED einschalten 
	bsf	PORTD,0		; LED an RD0 einschalten

; Lauflicht
Loop
	call	Wait		; Wartezeit
	rlncf	PORTD,f		; laufen zur nchsten LED
	goto	Loop	

;******************************************************************************
; Warteschleife 250 ms
; 20 MHZ
; 20 Zyklen pro loop
; 249 loops

Wait
	movlw	D'250'		; 250 ms Pause
	movwf	loops	

Wai
	movlw   .249           ; Zeitkonstante fr 1ms
        movwf   loops2
Wai2    nop
	nop
	nop
	nop
	nop
	nop	
	nop
	nop
	nop
	nop
	nop
        nop             
        nop
        nop
        nop
        nop
        nop
        decfsz  loops2, F      ; 1 ms vorbei?
        goto    Wai2           ; nein, noch nicht
                               ;
        decfsz  loops, F       ; 250 ms vorbei?
        goto    Wai            ; nein, noch nicht
        retlw   0              ; das Warten hat ein Ende

;******************************************************************************
;End of program

		END
